/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeCommandLineOwner;
import com.intellij.javascript.nodejs.execution.NodeBaseRunProfileState;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptionsKt;
import com.intellij.javascript.nodejs.execution.runConfiguration.NodeRunConfigurationCompositeLaunchSession;
import com.intellij.javascript.nodejs.execution.runConfiguration.NodeRunConfigurationExtensionsManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.buildTools.TypeScriptErrorConsoleFilter;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u001a\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0017\u001a\u00020\u0015H\u0014J\u0012\u0010\u0018\u001a\u00020\u000f2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState;", "Lcom/intellij/javascript/nodejs/execution/NodeBaseRunProfileState;", "Lcom/intellij/javascript/nodejs/debug/NodeCommandLineOwner;", "configuration", "Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "launchSession", "Lcom/intellij/javascript/nodejs/execution/runConfiguration/NodeRunConfigurationCompositeLaunchSession;", "runSettings", "Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings;", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "cwd", "Ljava/io/File;", "createExecutionResult", "Lcom/intellij/execution/ExecutionResult;", "foldCommandLine", "", "consoleView", "onNpmPackageBecomeValid", "startProcess", "configurator", "Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNpmRunProfileState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NpmRunProfileState.kt\ncom/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,137:1\n37#2,2:138\n*S KotlinDebug\n*F\n+ 1 NpmRunProfileState.kt\ncom/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState\n*L\n67#1:138,2\n*E\n"})
public class NpmRunProfileState
implements NodeBaseRunProfileState,
NodeCommandLineOwner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NpmRunConfiguration configuration;
    @NotNull
    private final ExecutionEnvironment environment;
    @NotNull
    private final NpmRunSettings runSettings;
    @NotNull
    private final NodeRunConfigurationCompositeLaunchSession launchSession;

    public NpmRunProfileState(@NotNull NpmRunConfiguration configuration, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        this.configuration = configuration;
        this.environment = environment;
        NpmRunSettings npmRunSettings = this.configuration.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)npmRunSettings, (String)"getRunSettings(...)");
        this.runSettings = npmRunSettings;
        this.launchSession = NodeRunConfigurationExtensionsManager.Companion.getInstance().createLaunchSession(this.configuration, this.environment);
    }

    private final ConsoleView createConsole(ProcessHandler processHandler, File cwd) {
        ConsoleView consoleView = NodeCommandLineUtil.createConsole(processHandler, this.environment.getProject(), false);
        Intrinsics.checkNotNullExpressionValue((Object)consoleView, (String)"createConsole(...)");
        ConsoleView console = consoleView;
        console.addMessageFilter((Filter)new NodeStackTraceFilter(this.environment.getProject(), cwd));
        console.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.environment.getProject(), cwd));
        console.addMessageFilter((Filter)new TypeScriptErrorConsoleFilter(this.environment.getProject(), cwd));
        return console;
    }

    @Override
    @NotNull
    public ProcessHandler startProcess(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
        ProcessHandler processHandler;
        NodeJsInterpreter nodeJsInterpreter = this.runSettings.getInterpreterRef().resolveNotNull(this.environment.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"resolveNotNull(...)");
        NodeJsInterpreter nodeInterpreter = nodeJsInterpreter;
        Project project = this.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        NodeTargetRun targetRun = new NodeTargetRun(nodeInterpreter, project, configurator, NodeTargetRunOptionsKt.targetRunOptions$default(null, (RunConfigurationBase)this.configuration, null, 4, null), null, 16, null);
        NpmRunProfileState.Companion.configureNodeTargetRun(targetRun, this.runSettings, this.environment, () -> NpmRunProfileState.startProcess$lambda$0(this));
        this.launchSession.addNodeOptionsTo(targetRun);
        ProcessHandler it = processHandler = targetRun.startProcess();
        boolean bl = false;
        this.launchSession.onProcessCreated(it);
        return processHandler;
    }

    @Override
    @NotNull
    public ExecutionResult createExecutionResult(@NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        ConsoleView console = this.createConsole(processHandler, new File(this.runSettings.getPackageJsonSystemDependentPath()).getParentFile());
        console.attachToProcess(processHandler);
        this.foldCommandLine(console, processHandler);
        if (this.runSettings.getCommand() == NpmCommand.INSTALL) {
            ConsoleProgress.install(console, processHandler);
        }
        Collection $this$toTypedArray$iv = this.launchSession.getRunDebugActions();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        AnAction[] anActionArray = thisCollection$iv.toArray(new AnAction[0]);
        return (ExecutionResult)new DefaultExecutionResult((ExecutionConsole)console, processHandler, Arrays.copyOf(anActionArray, anActionArray.length));
    }

    protected void onNpmPackageBecomeValid() {
        Project project = this.environment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        ExecutionManager.Companion.getInstance(project).restartRunProfile(this.environment);
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        NodePackageRef nodePackageRef = NpmUtil.DESCRIPTOR.dereferenceIfProjectRef(this.environment.getProject(), this.runSettings.getPackageManagerPackageRef());
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"dereferenceIfProjectRef(...)");
        NodePackageRef npmRef = nodePackageRef;
        String[] stringArray = new String[]{NpmManager.getNpmPackagePresentableName(npmRef)};
        ConsoleCommandLineFolder folder = new ConsoleCommandLineFolder(stringArray);
        NpmCommand command = NpmRunProfileState.Companion.getExecutionCommand(this.runSettings);
        folder.addPlaceholderText(command.getCliOption(NpmUtil.isYarnAlikePackageRef(npmRef)));
        if (command == NpmCommand.RUN_SCRIPT) {
            folder.addPlaceholderTexts(this.runSettings.getScriptNames());
        }
        String string = this.runSettings.getArguments();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getArguments(...)");
        List list2 = ParametersListUtil.parse((String)((Object)StringsKt.trim((CharSequence)string)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parse(...)");
        List arguments = list2;
        if (!arguments.isEmpty()) {
            folder.addPlaceholderText(ParametersListUtil.join((List)arguments));
        }
        folder.foldCommandLine(consoleView, processHandler);
    }

    private static final void startProcess$lambda$0(NpmRunProfileState this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onNpmPackageBecomeValid();
    }

    @JvmStatic
    @JvmOverloads
    public static final void configureCommandLine(@NotNull NodeTargetRun targetRun, @NotNull String nodeOptions, @NotNull NodePackageRef npmPackageRef, @NotNull String packageJsonPath, @NotNull NpmCommand command, @NotNull List<String> scriptNames, @NotNull String scriptArguments, @NotNull EnvironmentVariablesData envData, @Nullable Runnable onNpmPackageRefResolved, @Nullable ExecutionEnvironment executionEnvironment) throws ExecutionException {
        Companion.configureCommandLine(targetRun, nodeOptions, npmPackageRef, packageJsonPath, command, scriptNames, scriptArguments, envData, onNpmPackageRefResolved, executionEnvironment);
    }

    @JvmStatic
    @JvmOverloads
    public static final void configureCommandLine(@NotNull NodeTargetRun targetRun, @NotNull String nodeOptions, @NotNull NodePackageRef npmPackageRef, @NotNull String packageJsonPath, @NotNull NpmCommand command, @NotNull List<String> scriptNames, @NotNull String scriptArguments, @NotNull EnvironmentVariablesData envData, @Nullable Runnable onNpmPackageRefResolved) throws ExecutionException {
        Companion.configureCommandLine(targetRun, nodeOptions, npmPackageRef, packageJsonPath, command, scriptNames, scriptArguments, envData, onNpmPackageRefResolved);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jd\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0007J*\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00010\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmRunProfileState$Companion;", "", "()V", "configureCommandLine", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "nodeOptions", "", "npmPackageRef", "Lcom/intellij/javascript/nodejs/util/NodePackageRef;", "packageJsonPath", "command", "Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmCommand;", "scriptNames", "", "scriptArguments", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "onNpmPackageRefResolved", "Ljava/lang/Runnable;", "executionEnvironment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "configureNodeTargetRun", "runSettings", "Lcom/intellij/lang/javascript/buildTools/npm/rc/NpmRunSettings;", "runWhenNpmPackageIsValid", "getExecutionCommand", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        private final NpmCommand getExecutionCommand(NpmRunSettings runSettings) {
            if (runSettings.getCommand() == NpmCommand.RUN_SCRIPT) {
                List<String> list2 = runSettings.getScriptNames();
                Intrinsics.checkNotNullExpressionValue(list2, (String)"getScriptNames(...)");
                List<String> scripts = list2;
                if (scripts.size() == 1 && Intrinsics.areEqual((Object)"test", (Object)CollectionsKt.firstOrNull(scripts))) {
                    return NpmCommand.TEST;
                }
            }
            NpmCommand npmCommand = runSettings.getCommand();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)npmCommand), (String)"getCommand(...)");
            return npmCommand;
        }

        private final void configureNodeTargetRun(NodeTargetRun targetRun, NpmRunSettings runSettings, ExecutionEnvironment executionEnvironment, Runnable runWhenNpmPackageIsValid) throws ExecutionException {
            String string = runSettings.getNodeOptions();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNodeOptions(...)");
            NodePackageRef nodePackageRef = runSettings.getPackageManagerPackageRef();
            Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageManagerPackageRef(...)");
            String string2 = runSettings.getPackageJsonSystemDependentPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPackageJsonSystemDependentPath(...)");
            NpmCommand npmCommand = this.getExecutionCommand(runSettings);
            List<String> list2 = runSettings.getScriptNames();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getScriptNames(...)");
            String string3 = runSettings.getArguments();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getArguments(...)");
            EnvironmentVariablesData environmentVariablesData = runSettings.getEnvData();
            Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getEnvData(...)");
            this.configureCommandLine(targetRun, string, nodePackageRef, string2, npmCommand, list2, string3, environmentVariablesData, runWhenNpmPackageIsValid, executionEnvironment);
        }

        @JvmStatic
        @JvmOverloads
        public final void configureCommandLine(@NotNull NodeTargetRun targetRun, @NotNull String nodeOptions, @NotNull NodePackageRef npmPackageRef, @NotNull String packageJsonPath, @NotNull NpmCommand command, @NotNull List<String> scriptNames, @NotNull String scriptArguments, @NotNull EnvironmentVariablesData envData, @Nullable Runnable onNpmPackageRefResolved, @Nullable ExecutionEnvironment executionEnvironment) throws ExecutionException {
            Path path2;
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            Intrinsics.checkNotNullParameter((Object)nodeOptions, (String)"nodeOptions");
            Intrinsics.checkNotNullParameter((Object)npmPackageRef, (String)"npmPackageRef");
            Intrinsics.checkNotNullParameter((Object)packageJsonPath, (String)"packageJsonPath");
            Intrinsics.checkNotNullParameter((Object)((Object)command), (String)"command");
            Intrinsics.checkNotNullParameter(scriptNames, (String)"scriptNames");
            Intrinsics.checkNotNullParameter((Object)scriptArguments, (String)"scriptArguments");
            Intrinsics.checkNotNullParameter((Object)envData, (String)"envData");
            try {
                path2 = Path.of(packageJsonPath, new String[0]);
                Intrinsics.checkNotNull((Object)path2);
            }
            catch (InvalidPathException e) {
                throw new ExecutionException((Throwable)e);
            }
            Path packageJsonFile = path2;
            targetRun.setEnvData(envData);
            targetRun.addNodeOptionsWithExpandedMacros(false, nodeOptions);
            List list2 = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)scriptArguments);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expandMacrosAndParseParameters(...)");
            List arguments = list2;
            List args = command == NpmCommand.RUN_SCRIPT ? CollectionsKt.plus((Collection)scriptNames, (Iterable)arguments) : arguments;
            NpmUtil.configureNpmCommand(targetRun, npmPackageRef, packageJsonFile.getParent(), command, args, onNpmPackageRefResolved);
        }

        public static /* synthetic */ void configureCommandLine$default(Companion companion, NodeTargetRun nodeTargetRun, String string, NodePackageRef nodePackageRef, String string2, NpmCommand npmCommand, List list2, String string3, EnvironmentVariablesData environmentVariablesData, Runnable runnable, ExecutionEnvironment executionEnvironment, int n, Object object) throws ExecutionException {
            if ((n & 0x200) != 0) {
                executionEnvironment = null;
            }
            companion.configureCommandLine(nodeTargetRun, string, nodePackageRef, string2, npmCommand, list2, string3, environmentVariablesData, runnable, executionEnvironment);
        }

        @JvmStatic
        @JvmOverloads
        public final void configureCommandLine(@NotNull NodeTargetRun targetRun, @NotNull String nodeOptions, @NotNull NodePackageRef npmPackageRef, @NotNull String packageJsonPath, @NotNull NpmCommand command, @NotNull List<String> scriptNames, @NotNull String scriptArguments, @NotNull EnvironmentVariablesData envData, @Nullable Runnable onNpmPackageRefResolved) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)targetRun, (String)"targetRun");
            Intrinsics.checkNotNullParameter((Object)nodeOptions, (String)"nodeOptions");
            Intrinsics.checkNotNullParameter((Object)npmPackageRef, (String)"npmPackageRef");
            Intrinsics.checkNotNullParameter((Object)packageJsonPath, (String)"packageJsonPath");
            Intrinsics.checkNotNullParameter((Object)((Object)command), (String)"command");
            Intrinsics.checkNotNullParameter(scriptNames, (String)"scriptNames");
            Intrinsics.checkNotNullParameter((Object)scriptArguments, (String)"scriptArguments");
            Intrinsics.checkNotNullParameter((Object)envData, (String)"envData");
            com.intellij.lang.javascript.buildTools.npm.rc.NpmRunProfileState$Companion.configureCommandLine$default(this, targetRun, nodeOptions, npmPackageRef, packageJsonPath, command, scriptNames, scriptArguments, envData, onNpmPackageRefResolved, null, 512, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

