/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.activity.RunAnythingAnActionProvider;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.NpmRunAnythingProvider;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmConfigurationType;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfiguration;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationProducer;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmCommandRunAnythingProvider
extends RunAnythingAnActionProvider<NpmCommandAction> {
    private static final List<NpmCommand> NPM_PREFERRED_COMMANDS = Arrays.asList(NpmCommand.INSTALL, NpmCommand.CI, NpmCommand.UPDATE, NpmCommand.TEST, NpmCommand.PUBLISH);
    private static final List<NpmCommand> YARN_PREFERRED_COMMANDS = Arrays.asList(NpmCommand.INSTALL, NpmCommand.ADD, NpmCommand.TEST, NpmCommand.CONFIG, NpmCommand.LINK);
    @Nls
    private final String myPackageManagerName;

    NpmCommandRunAnythingProvider(@NotNull @Nls String packageManagerName) {
        if (packageManagerName == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(0);
        }
        this.myPackageManagerName = packageManagerName;
    }

    @NotNull
    public Collection<NpmCommandAction> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        Project project;
        if (dataContext == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(1);
        }
        if (pattern == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(2);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null) {
            List<NpmCommandAction> list2 = Collections.emptyList();
            if (list2 == null) {
                NpmCommandRunAnythingProvider.$$$reportNull$$$0(3);
            }
            return list2;
        }
        if (!NpmRunAnythingProvider.hasPackageNamePrefix(pattern, this.myPackageManagerName)) {
            List<NpmCommandAction> list3 = Collections.emptyList();
            if (list3 == null) {
                NpmCommandRunAnythingProvider.$$$reportNull$$$0(4);
            }
            return list3;
        }
        VirtualFile packageJson2 = NpmRunAnythingProvider.getPackageJson(project, dataContext);
        if (packageJson2 == null) {
            List<NpmCommandAction> list4 = Collections.emptyList();
            if (list4 == null) {
                NpmCommandRunAnythingProvider.$$$reportNull$$$0(5);
            }
            return list4;
        }
        NodePackageRef npmPkgRef = NpmRunAnythingProvider.getPackageRef(project, this.myPackageManagerName);
        boolean yarn = this.isYarn();
        ArrayList<NpmCommand> commands = new ArrayList<NpmCommand>(yarn ? YARN_PREFERRED_COMMANDS : NPM_PREFERRED_COMMANDS);
        commands.addAll(NpmCommand.getCommands(yarn));
        commands.remove((Object)NpmCommand.RUN_SCRIPT);
        LinkedHashMap<String, NpmCommandAction> result2 = new LinkedHashMap<String, NpmCommandAction>();
        for (NpmCommand command : commands) {
            String cliOption = command.getCliOption(yarn);
            if (result2.containsKey(cliOption) && !StringUtil.toLowerCase((String)command.name()).equals(cliOption)) continue;
            NpmCommandAction commandAction = new NpmCommandAction(command, npmPkgRef);
            String commandString = this.getCommand(commandAction);
            if (pattern.startsWith(commandString + " ")) {
                commandAction.setArguments(pattern.substring(commandString.length() + 1));
            }
            result2.put(cliOption, commandAction);
        }
        Collection<NpmCommandAction> collection = result2.values();
        if (collection == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(6);
        }
        return collection;
    }

    @NotNull
    public String getCommand(@NotNull NpmCommandAction value) {
        if (value == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(7);
        }
        String string = NpmManager.getNpmCommandPresentableText(NodePackageRef.create(this.myPackageManagerName), value.myCommand, value.myArguments);
        if (string == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(8);
        }
        return string;
    }

    @NotNull
    public String getCompletionGroupTitle() {
        String string = this.myPackageManagerName;
        if (string == null) {
            NpmCommandRunAnythingProvider.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Nullable
    public String getHelpGroupTitle() {
        return null;
    }

    @Nullable
    public Icon getHelpIcon() {
        return null;
    }

    private boolean isYarn() {
        return NpmRunAnythingProvider.isYarn(this.myPackageManagerName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/NpmCommandRunAnythingProvider";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmCommandRunAnythingProvider";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionGroupTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 8, 9 -> new IllegalStateException(string);
        };
    }

    final class NpmCommandAction
    extends DumbAwareAction {
        private final NpmCommand myCommand;
        private final NodePackageRef myNpmPkgRef;
        private String myArguments;

        private NpmCommandAction(@NotNull NpmCommand command, NodePackageRef npmPkgRef) {
            if (command == null) {
                NpmCommandAction.$$$reportNull$$$0(0);
            }
            if (npmPkgRef == null) {
                NpmCommandAction.$$$reportNull$$$0(1);
            }
            super(NpmRunAnythingProvider.getIcon(NpmCommandRunAnythingProvider.this.isYarn()));
            this.myArguments = "";
            this.myCommand = command;
            this.myNpmPkgRef = npmPkgRef;
        }

        void setArguments(String arguments) {
            this.myArguments = arguments;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                NpmCommandAction.$$$reportNull$$$0(2);
            }
            Executor executor = (Executor)e.getDataContext().getData(RunAnythingAction.EXECUTOR_KEY);
            executor = (Executor)ObjectUtils.notNull((Object)executor, (Object)DefaultRunExecutor.getRunExecutorInstance());
            Project project = e.getProject();
            if (project == null) {
                return;
            }
            RunManager runManager = RunManager.getInstance((Project)project);
            RunnerAndConfigurationSettings configuration = runManager.createConfiguration("", (ConfigurationFactory)NpmConfigurationType.getInstance());
            NpmRunConfiguration runConfiguration = (NpmRunConfiguration)ObjectUtils.tryCast((Object)configuration.getConfiguration(), NpmRunConfiguration.class);
            if (runConfiguration == null) {
                return;
            }
            VirtualFile packageJson2 = NpmRunAnythingProvider.getPackageJson(project, e.getDataContext());
            if (packageJson2 == null) {
                return;
            }
            NpmRunConfigurationProducer.setupConfigurationFromSettings(runConfiguration, runConfiguration.getRunSettings().toBuilder().setPackageJsonPath(packageJson2.getPath()).setPackageManagerPackageRef(this.myNpmPkgRef).setCommand(this.myCommand).setArguments(this.myArguments).build());
            runManager.setUniqueNameIfNeeded(configuration);
            ExecutionEnvironmentBuilder builder2 = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)configuration);
            if (builder2 != null) {
                ExecutionManager.getInstance((Project)project).restartRunProfile(builder2.build());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "npmPkgRef";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/NpmCommandRunAnythingProvider$NpmCommandAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

