/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.GulpTask;
import com.intellij.lang.javascript.buildTools.gulp.GulpfileStructure;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="JsGulpfileManager", storages={@Storage(value="$CACHE_FILE$")})
public final class GulpfileManager
extends JsbtFileManager
implements PersistentStateComponent<ManagerState> {
    @NotNull
    public static GulpfileManager getInstance(@NotNull Project project) {
        if (project == null) {
            GulpfileManager.$$$reportNull$$$0(0);
        }
        GulpfileManager gulpfileManager = (GulpfileManager)project.getService(GulpfileManager.class);
        if (gulpfileManager == null) {
            GulpfileManager.$$$reportNull$$$0(1);
        }
        return gulpfileManager;
    }

    public GulpfileManager(@NotNull Project project) {
        if (project == null) {
            GulpfileManager.$$$reportNull$$$0(2);
        }
        super(project, GulpService.getInstance(project));
    }

    @Override
    @Nullable
    public GulpfileStructure getCachedStructure(@NotNull VirtualFile gulpfile) {
        if (gulpfile == null) {
            GulpfileManager.$$$reportNull$$$0(3);
        }
        return (GulpfileStructure)super.getCachedStructure(gulpfile);
    }

    @NotNull
    public ManagerState getState() {
        ArrayList<GulpfileState> gulpfileStates = new ArrayList<GulpfileState>();
        for (VirtualFile gulpfile : this.getBuildfiles()) {
            if (!gulpfile.isValid() || gulpfile.isDirectory()) continue;
            GulpfileState gulpfileState = GulpfileManager.toGulpfileState(gulpfile, this.getCachedStructure(gulpfile));
            gulpfileStates.add(gulpfileState);
        }
        ManagerState state = new ManagerState();
        state.setGulpfileStates(gulpfileStates);
        state.setDetectionDone(this.isDetectionDone());
        state.mySortingMode = this.getSortingMode();
        ManagerState managerState = state;
        if (managerState == null) {
            GulpfileManager.$$$reportNull$$$0(4);
        }
        return managerState;
    }

    @NotNull
    private static GulpfileState toGulpfileState(@NotNull VirtualFile gulpfile, @Nullable GulpfileStructure structure) {
        if (gulpfile == null) {
            GulpfileManager.$$$reportNull$$$0(5);
        }
        GulpfileState state = new GulpfileState();
        state.setPath(gulpfile.getPath());
        if (structure != null) {
            List taskStates = ContainerUtil.map(structure.getTasks(), task -> {
                GulpTaskState taskState = new GulpTaskState();
                taskState.setName(task.getName());
                taskState.setDependencies(task.getDependencies());
                return taskState;
            });
            state.setTasks(taskStates);
        }
        GulpfileState gulpfileState = state;
        if (gulpfileState == null) {
            GulpfileManager.$$$reportNull$$$0(6);
        }
        return gulpfileState;
    }

    public void loadState(@NotNull ManagerState state) {
        if (state == null) {
            GulpfileManager.$$$reportNull$$$0(7);
        }
        this.clearAllBuildfiles();
        for (GulpfileState gulpfileState : state.getGulpfileStates()) {
            VirtualFile gulpfile = LocalFileSystem.getInstance().findFileByPath(gulpfileState.getPath());
            if (gulpfile == null || !gulpfile.isValid() || gulpfile.isDirectory()) continue;
            GulpfileStructure structure = new GulpfileStructure(gulpfile);
            List tasks = ContainerUtil.map(gulpfileState.getTasks(), state1 -> new GulpTask(structure, state1.getName(), state1.getDependencies()));
            structure.setTasks(tasks);
            this.addBuildfileStructure(structure);
        }
        if (state.isDetectionDone()) {
            this.setDetectionDone();
        }
        this.setSortingMode((JsbtSortingMode)((Object)ObjectUtils.notNull((Object)((Object)state.mySortingMode), (Object)((Object)JsbtSortingMode.DEFINITION_ORDER))));
    }

    @NotNull
    private static <E> List<E> notNullList(@Nullable List<E> list2) {
        if (list2 != null) {
            List<E> list3 = list2;
            if (list3 == null) {
                GulpfileManager.$$$reportNull$$$0(8);
            }
            return list3;
        }
        return new ArrayList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 4, 6, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gulpfile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/GulpfileManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toGulpfileState";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCachedStructure";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toGulpfileState";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 4, 6, 8 -> new IllegalStateException(string);
        };
    }

    public static class GulpfileState {
        private String myPath;
        private List<GulpTaskState> myTasks = new ArrayList<GulpTaskState>();

        @Tag(value="gulpfile-path")
        public String getPath() {
            return this.myPath;
        }

        public void setPath(String path2) {
            this.myPath = path2;
        }

        @XCollection(elementName="task", style=XCollection.Style.v2)
        public List<GulpTaskState> getTasks() {
            return this.myTasks;
        }

        public void setTasks(List<GulpTaskState> tasks) {
            this.myTasks = GulpfileManager.notNullList(tasks);
        }
    }

    public static class ManagerState {
        private List<GulpfileState> myGulpfileStates = new ArrayList<GulpfileState>();
        private boolean myDetectionDone = false;
        @Tag(value="sorting")
        public JsbtSortingMode mySortingMode;

        @XCollection(propertyElementName="gulpfiles", elementName="gulpfile")
        public List<GulpfileState> getGulpfileStates() {
            return this.myGulpfileStates;
        }

        public void setGulpfileStates(List<GulpfileState> gulpfileStates) {
            this.myGulpfileStates = GulpfileManager.notNullList(gulpfileStates);
        }

        @Tag(value="detection-done")
        public boolean isDetectionDone() {
            return this.myDetectionDone;
        }

        public void setDetectionDone(boolean detectionDone) {
            this.myDetectionDone = detectionDone;
        }
    }

    public static class GulpTaskState {
        private String myName;
        private List<String> myDependencies = new ArrayList<String>();

        @Tag(value="task-name")
        public String getName() {
            return this.myName;
        }

        public void setName(String name) {
            this.myName = name;
        }

        @XCollection(style=XCollection.Style.v2, elementName="dependency")
        public List<String> getDependencies() {
            return this.myDependencies;
        }

        public void setDependencies(List<String> dependencies) {
            this.myDependencies = GulpfileManager.notNullList(dependencies);
        }
    }
}

