/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.rc;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.execution.ParametersListUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntRunSettings {
    private static final String TAG_NODE_INTERPRETER = "node-interpreter";
    private static final String TAG_NODE_OPTIONS = "node-options";
    private static final String TAG_GRUNTFILE = "gruntfile";
    private static final String TAG_TASKS = "tasks";
    private static final String TAG_TASK = "task";
    private static final String TAG_ARGUMENTS = "arguments";
    private static final String TAG_FORCE_EXECUTION = "force";
    private static final String TAG_VERBOSE_MODE = "verbose";
    private static final String TAG_PASS_PARENT_ENV_VARS = "pass-parent-env-vars";
    private final NodeJsInterpreterRef myInterpreterRef;
    private final String myNodeOptions;
    private final String myGruntfilePath;
    private final String myGruntfileSystemIndependentPath;
    private final List<String> myTasks;
    private final String myArguments;
    private final EnvironmentVariablesData myEnvData;
    private final boolean myNewEnvFormat;

    public GruntRunSettings(@NotNull Builder builder2) {
        if (builder2 == null) {
            GruntRunSettings.$$$reportNull$$$0(0);
        }
        this.myInterpreterRef = builder2.myInterpreterRef;
        this.myNodeOptions = builder2.myNodeOptions;
        this.myGruntfilePath = FileUtil.toSystemDependentName((String)builder2.myGruntfilePath);
        this.myGruntfileSystemIndependentPath = FileUtil.toSystemIndependentName((String)this.myGruntfilePath);
        this.myTasks = List.copyOf(builder2.myTasks);
        this.myArguments = builder2.myArguments;
        this.myEnvData = builder2.myEnvData;
        this.myNewEnvFormat = builder2.myNewEnvFormat;
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.myInterpreterRef;
        if (nodeJsInterpreterRef == null) {
            GruntRunSettings.$$$reportNull$$$0(1);
        }
        return nodeJsInterpreterRef;
    }

    @NotNull
    public String getNodeOptions() {
        String string = this.myNodeOptions;
        if (string == null) {
            GruntRunSettings.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getGruntfilePath() {
        String string = this.myGruntfilePath;
        if (string == null) {
            GruntRunSettings.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public VirtualFile getGruntfile() {
        return LocalFileSystem.getInstance().findFileByPath(this.myGruntfileSystemIndependentPath);
    }

    @NotNull
    public String getGruntfileSystemIndependentPath() {
        String string = this.myGruntfileSystemIndependentPath;
        if (string == null) {
            GruntRunSettings.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public List<String> getTasks() {
        List<String> list2 = this.myTasks;
        if (list2 == null) {
            GruntRunSettings.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @NotNull
    public String getArguments() {
        String string = this.myArguments;
        if (string == null) {
            GruntRunSettings.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            GruntRunSettings.$$$reportNull$$$0(7);
        }
        return environmentVariablesData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GruntRunSettings that = (GruntRunSettings)o;
        return this.myNodeOptions.equals(that.myNodeOptions) && this.myGruntfilePath.equals(that.myGruntfilePath) && this.myTasks.equals(that.myTasks) && this.myArguments.equals(that.myArguments) && this.myEnvData.equals((Object)that.myEnvData);
    }

    public int hashCode() {
        int result2 = this.myGruntfilePath.hashCode();
        result2 = 31 * result2 + this.myNodeOptions.hashCode();
        result2 = 31 * result2 + this.myTasks.hashCode();
        result2 = 31 * result2 + this.myArguments.hashCode();
        result2 = 31 * result2 + this.myEnvData.hashCode();
        return result2;
    }

    public void writeToXml(@NotNull Element parent) {
        if (parent == null) {
            GruntRunSettings.$$$reportNull$$$0(8);
        }
        JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_NODE_INTERPRETER, (String)this.myInterpreterRef.getReferenceName());
        if (!this.myNodeOptions.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_NODE_OPTIONS, (String)this.myNodeOptions);
        }
        if (!this.myGruntfilePath.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_GRUNTFILE, (String)FileUtil.toSystemIndependentName((String)this.myGruntfilePath));
        }
        this.writeTasks(parent);
        if (!this.myArguments.isEmpty()) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_ARGUMENTS, (String)this.myArguments);
        }
        if (this.myNewEnvFormat) {
            this.myEnvData.writeExternal(parent);
        } else {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_PASS_PARENT_ENV_VARS, (String)Boolean.toString(this.myEnvData.isPassParentEnvs()));
            EnvironmentVariablesComponent.writeExternal((Element)parent, (Map)this.myEnvData.getEnvs());
        }
        List args = ParametersListUtil.parse((String)this.myArguments);
        if (args.contains("--force")) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_FORCE_EXECUTION, (String)Boolean.TRUE.toString());
        }
        if (args.contains("--verbose")) {
            JDOMExternalizerUtil.writeCustomField((Element)parent, (String)TAG_VERBOSE_MODE, (String)Boolean.TRUE.toString());
        }
    }

    private void writeTasks(@NotNull Element parent) {
        if (parent == null) {
            GruntRunSettings.$$$reportNull$$$0(9);
        }
        if (this.myTasks.isEmpty()) {
            return;
        }
        Element tasksElement = new Element(TAG_TASKS);
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)tasksElement, (String)TAG_TASK, this.myTasks);
        parent.addContent(tasksElement);
    }

    @NotNull
    public static GruntRunSettings readFromXml(@Nullable Element parent) {
        EnvironmentVariablesData envData;
        Builder builder2 = new Builder();
        if (parent == null) {
            GruntRunSettings gruntRunSettings = builder2.build();
            if (gruntRunSettings == null) {
                GruntRunSettings.$$$reportNull$$$0(10);
            }
            return gruntRunSettings;
        }
        String interpreterRefName = JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_NODE_INTERPRETER);
        NodeJsInterpreterRef interpreterRef = GruntRunSettings.createInterpreterRef(interpreterRefName);
        builder2.setInterpreterRef(interpreterRef);
        builder2.setNodeOptions(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_NODE_OPTIONS)));
        builder2.setGruntfilePath(StringUtil.notNullize((String)JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_GRUNTFILE)));
        builder2.setTasks(GruntRunSettings.readTasks(parent));
        boolean forceExecution = GruntRunSettings.readBoolean(parent, TAG_FORCE_EXECUTION, false);
        boolean verboseMode = GruntRunSettings.readBoolean(parent, TAG_VERBOSE_MODE, false);
        Object readArgs = JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_ARGUMENTS);
        if (readArgs == null && (forceExecution || verboseMode)) {
            if (forceExecution) {
                readArgs = "--force";
            }
            if (verboseMode) {
                readArgs = readArgs == null ? "--verbose" : (String)readArgs + " --verbose";
            }
        }
        builder2.setArguments(StringUtil.notNullize((String)readArgs));
        String oldPassParentEnvsStr = JDOMExternalizerUtil.readCustomField((Element)parent, (String)TAG_PASS_PARENT_ENV_VARS);
        if (oldPassParentEnvsStr == null) {
            envData = EnvironmentVariablesData.readExternal((Element)parent);
        } else {
            LinkedHashMap envVars = new LinkedHashMap();
            EnvironmentVariablesComponent.readExternal((Element)parent, envVars);
            envData = EnvironmentVariablesData.create(envVars, (boolean)GruntRunSettings.readBoolean(parent, TAG_PASS_PARENT_ENV_VARS, true));
        }
        builder2.myNewEnvFormat = oldPassParentEnvsStr == null;
        builder2.setEnvData(envData);
        GruntRunSettings gruntRunSettings = builder2.build();
        if (gruntRunSettings == null) {
            GruntRunSettings.$$$reportNull$$$0(11);
        }
        return gruntRunSettings;
    }

    private static NodeJsInterpreterRef createInterpreterRef(@Nullable String interpreterRefName) {
        if (interpreterRefName != null) {
            return NodeJsInterpreterRef.create(interpreterRefName);
        }
        return NodeJsInterpreterRef.createProjectRef();
    }

    private static boolean readBoolean(@NotNull Element parent, @NotNull String childTag, boolean defaultValue) {
        if (parent == null) {
            GruntRunSettings.$$$reportNull$$$0(12);
        }
        if (childTag == null) {
            GruntRunSettings.$$$reportNull$$$0(13);
        }
        String value = JDOMExternalizerUtil.readCustomField((Element)parent, (String)childTag);
        if (Boolean.toString(true).equals(value)) {
            return true;
        }
        if (Boolean.toString(false).equals(value)) {
            return false;
        }
        return defaultValue;
    }

    @NotNull
    private static List<String> readTasks(@NotNull Element parent) {
        Element tasksElement;
        if (parent == null) {
            GruntRunSettings.$$$reportNull$$$0(14);
        }
        if ((tasksElement = parent.getChild(TAG_TASKS)) != null) {
            List list2 = JDOMExternalizerUtil.getChildrenValueAttributes((Element)tasksElement, (String)TAG_TASK);
            if (list2 == null) {
                GruntRunSettings.$$$reportNull$$$0(15);
            }
            return list2;
        }
        List<String> list3 = Collections.emptyList();
        if (list3 == null) {
            GruntRunSettings.$$$reportNull$$$0(16);
        }
        return list3;
    }

    @NotNull
    public static Builder builder(@NotNull GruntRunSettings settings2) {
        if (settings2 == null) {
            GruntRunSettings.$$$reportNull$$$0(17);
        }
        return new Builder(settings2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 7, 10, 11, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings";
                break;
            }
            case 8: 
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTag";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeOptions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getGruntfilePath";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGruntfileSystemIndependentPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTasks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromXml";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeToXml";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "writeTasks";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readBoolean";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readTasks";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "builder";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 7, 10, 11, 15, 16 -> new IllegalStateException(string);
        };
    }

    public static class Builder {
        private NodeJsInterpreterRef myInterpreterRef;
        private String myNodeOptions;
        private String myGruntfilePath;
        private List<String> myTasks;
        private String myArguments;
        private EnvironmentVariablesData myEnvData;
        private boolean myNewEnvFormat;

        public Builder() {
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGruntfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myArguments = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
        }

        public Builder(@NotNull GruntRunSettings settings2) {
            if (settings2 == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myInterpreterRef = NodeJsInterpreterRef.createProjectRef();
            this.myNodeOptions = "";
            this.myGruntfilePath = "";
            this.myTasks = Collections.emptyList();
            this.myArguments = "";
            this.myEnvData = EnvironmentVariablesData.DEFAULT;
            this.myNewEnvFormat = true;
            this.myNodeOptions = settings2.getNodeOptions();
            this.myGruntfilePath = settings2.getGruntfilePath();
            this.myTasks = List.copyOf(settings2.getTasks());
            this.myEnvData = settings2.getEnvData();
            this.myNewEnvFormat = settings2.myNewEnvFormat;
        }

        @NotNull
        public Builder setInterpreterRef(@NotNull NodeJsInterpreterRef interpreterRef) {
            if (interpreterRef == null) {
                Builder.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreterRef;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(2);
            }
            return builder2;
        }

        @NotNull
        public Builder setNodeOptions(@Nullable String nodeOptions) {
            this.myNodeOptions = StringUtil.notNullize((String)nodeOptions);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return builder2;
        }

        @NotNull
        public Builder setGruntfilePath(@Nullable String gruntfilePath) {
            this.myGruntfilePath = StringUtil.notNullize((String)gruntfilePath);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(4);
            }
            return builder2;
        }

        @NotNull
        public Builder setTasks(@NotNull List<String> tasks) {
            if (tasks == null) {
                Builder.$$$reportNull$$$0(5);
            }
            this.myTasks = List.copyOf(tasks);
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(6);
            }
            return builder2;
        }

        @NotNull
        public Builder setArguments(@NotNull String arguments) {
            if (arguments == null) {
                Builder.$$$reportNull$$$0(7);
            }
            this.myArguments = arguments;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(8);
            }
            return builder2;
        }

        @NotNull
        public Builder setEnvData(@NotNull EnvironmentVariablesData envData) {
            if (envData == null) {
                Builder.$$$reportNull$$$0(9);
            }
            this.myEnvData = envData;
            Builder builder2 = this;
            if (builder2 == null) {
                Builder.$$$reportNull$$$0(10);
            }
            return builder2;
        }

        @NotNull
        public GruntRunSettings build() {
            return new GruntRunSettings(this);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 6, 8, 10 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreterRef";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = GruntRunSettings.TAG_TASKS;
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = GruntRunSettings.TAG_ARGUMENTS;
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "envData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/rc/GruntRunSettings$Builder";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setInterpreterRef";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNodeOptions";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setGruntfilePath";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setTasks";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setArguments";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setEnvData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setInterpreterRef";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 10: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setTasks";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "setArguments";
                    break;
                }
                case 9: {
                    objectArray = objectArray;
                    objectArray[2] = "setEnvData";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 6, 8, 10 -> new IllegalStateException(string);
            };
        }
    }
}

