/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base.actions;

import com.intellij.icons.AllIcons;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.buildTools.base.actions.JsbtShowPopupAction;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsbtAddBuildfileAction
extends DefaultActionGroup
implements DumbAware {
    private final JsbtApplicationService myService;

    public JsbtAddBuildfileAction(@NotNull JsbtApplicationService service2) {
        if (service2 == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(0);
        }
        super(JavaScriptBundle.messagePointer("buildTools.JsbtAddBuildfileAction.text", service2.getBuildfileCommonName()), true);
        this.myService = service2;
        this.getTemplatePresentation().setIcon(AllIcons.General.Add);
        this.getTemplatePresentation().setPerformGroup(true);
        this.setShortcutSet(CommonShortcuts.getNewForDialogs());
    }

    @Nullable
    public static Shortcut getKeyboardShortcut() {
        Object[] shortcuts = CommonShortcuts.getNewForDialogs().getShortcuts();
        return (Shortcut)ContainerUtil.findInstance((Object[])shortcuts, KeyboardShortcut.class);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(1);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(2);
        }
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(3);
        }
        if ((project = e.getProject()) == null) {
            return;
        }
        ReadAction.nonBlocking(() -> {
            JsbtService jsbtService = this.myService.getProjectService(project);
            List<VirtualFile> allBuildfiles = jsbtService.detectAllBuildfiles();
            JsbtFileManager jsbtFileManager = jsbtService.getFileManager();
            return ContainerUtil.mapNotNull(allBuildfiles, file -> {
                if (jsbtFileManager.containsBuildfile((VirtualFile)file)) {
                    return null;
                }
                return new PopupItem((VirtualFile)file, JsbtUtil.getRelativePath(project, file));
            });
        }).finishOnUiThread(ModalityState.defaultModalityState(), popupItems -> {
            Component component;
            InputEvent inputEvent = e.getInputEvent();
            Component component2 = component = inputEvent != null ? inputEvent.getComponent() : null;
            if (component == null) {
                return;
            }
            ListPopup popup = JsbtAddBuildfileAction.createPopup(project, this.myService, popupItems);
            if (inputEvent instanceof MouseEvent) {
                popup.show(new RelativePoint(component, ((MouseEvent)inputEvent).getPoint()));
            } else {
                popup.showInCenterOf(component);
            }
        }).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    @NotNull
    private static ListPopup createPopup(final @NotNull Project project, final @NotNull JsbtApplicationService service2, @NotNull List<PopupItem> items) {
        if (project == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(4);
        }
        if (service2 == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(5);
        }
        if (items == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(6);
        }
        ArrayList<PopupItem> values = new ArrayList<PopupItem>(items);
        values.add(null);
        BaseListPopupStep<PopupItem> step = new BaseListPopupStep<PopupItem>(null, values){

            @NotNull
            public String getTextFor(@Nullable PopupItem value) {
                if (value != null) {
                    String string = value.getPresentableText();
                    if (string == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                String string = JavaScriptBundle.message("buildTools.choose_buildfile.text", service2.getBuildfileCommonName()) + "...";
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            public Icon getIconFor(@Nullable PopupItem value) {
                return value != null ? value.getBuildfile().getFileType().getIcon() : null;
            }

            public PopupStep<?> onChosen(@Nullable PopupItem selectedValue, boolean finalChoice) {
                JsbtFileManager fileManager = service2.getProjectService(project).getFileManager();
                if (selectedValue != null) {
                    fileManager.addBuildfile(selectedValue.getBuildfile());
                } else {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor();
                        fileChooserDescriptor.setTitle(JavaScriptBundle.message("buildTools.choose_buildfile.text", service2.getBuildfileCommonName()));
                        boolean popupShown = JsbtShowPopupAction.hidePopup(project);
                        FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)project, null, files1 -> {
                            VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem((List)files1);
                            if (file != null) {
                                fileManager.addBuildfile(file);
                            }
                        });
                        if (popupShown) {
                            new Alarm().addRequest(() -> JsbtShowPopupAction.showPopup(project), 50);
                        }
                    });
                }
                return FINAL_CHOICE;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$1", "getTextFor"));
            }
        };
        ListPopup listPopup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        if (listPopup == null) {
            JsbtAddBuildfileAction.$$$reportNull$$$0(7);
        }
        return listPopup;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createPopup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createPopup";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7 -> new IllegalStateException(string);
        };
    }

    private static class PopupItem {
        private final VirtualFile myBuildfile;
        @NotNull
        private final @NlsContexts.ListItem String myPresentableText;

        private PopupItem(@NotNull VirtualFile buildfile, @NotNull @NlsContexts.ListItem String presentableText) {
            if (buildfile == null) {
                PopupItem.$$$reportNull$$$0(0);
            }
            if (presentableText == null) {
                PopupItem.$$$reportNull$$$0(1);
            }
            this.myBuildfile = buildfile;
            this.myPresentableText = presentableText;
        }

        @NotNull
        private VirtualFile getBuildfile() {
            VirtualFile virtualFile = this.myBuildfile;
            if (virtualFile == null) {
                PopupItem.$$$reportNull$$$0(2);
            }
            return virtualFile;
        }

        @NotNull
        @NlsContexts.ListItem
        private String getPresentableText() {
            String string = this.myPresentableText;
            if (string == null) {
                PopupItem.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "buildfile";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentableText";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$PopupItem";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/actions/JsbtAddBuildfileAction$PopupItem";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getBuildfile";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPresentableText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

