/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.impl.RunConfigurationBeforeRunProvider;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManagerProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtInvalidSetting;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonBuildFileManager;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.components.fields.ExpandableTextField;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Toolkit;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JTextField;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public final class JsbtUtil {
    private static final Logger LOG = Logger.getInstance(JsbtUtil.class);
    private static final char BELL = '\u0007';
    private static final char EIGHTH_NOTE = '\u266a';
    @PropertyKey(resourceBundle="messages.JavaScriptBundle")
    public static final @PropertyKey(resourceBundle="messages.JavaScriptBundle") String NO_TASKS_FOUND_KEY = "buildTools.no.tasks.found";

    private JsbtUtil() {
    }

    public static void iterateOverContentRoots(@NotNull Project project, boolean webModulesOnly, @NotNull Consumer<? super VirtualFile> contentRootConsumer) {
        if (project == null) {
            JsbtUtil.$$$reportNull$$$0(0);
        }
        if (contentRootConsumer == null) {
            JsbtUtil.$$$reportNull$$$0(1);
        }
        for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
            if (webModulesOnly && !ModuleTypeWithWebFeatures.isAvailable((Module)module)) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Iterating over content roots for module " + module.getName());
            }
            for (VirtualFile contentRoot : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Detecting in content root " + contentRoot.getPath());
                }
                contentRootConsumer.consume((Object)contentRoot);
            }
        }
    }

    @NotNull
    public static List<VirtualFile> detectAllBuildfilesInContentRoots(@NotNull Project project, boolean webModulesOnly, @NotNull String filenamePrefix, String @NotNull [] filenameExtensions, boolean includeDirs) {
        if (project == null) {
            JsbtUtil.$$$reportNull$$$0(2);
        }
        if (filenamePrefix == null) {
            JsbtUtil.$$$reportNull$$$0(3);
        }
        if (filenameExtensions == null) {
            JsbtUtil.$$$reportNull$$$0(4);
        }
        SmartList buildfiles = new SmartList();
        JsbtUtil.iterateOverContentRoots(project, webModulesOnly, (Consumer<? super VirtualFile>)((Consumer)arg_0 -> JsbtUtil.lambda$detectAllBuildfilesInContentRoots$0(filenamePrefix, filenameExtensions, includeDirs, (List)buildfiles, arg_0)));
        SmartList smartList = buildfiles;
        if (smartList == null) {
            JsbtUtil.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @Nullable
    private static VirtualFile detectBuildfile(@NotNull VirtualFile dir, @NotNull String filenamePrefix, String @NotNull [] filenameExtensions, boolean includeDirs) {
        if (dir == null) {
            JsbtUtil.$$$reportNull$$$0(6);
        }
        if (filenamePrefix == null) {
            JsbtUtil.$$$reportNull$$$0(7);
        }
        if (filenameExtensions == null) {
            JsbtUtil.$$$reportNull$$$0(8);
        }
        Object result2 = null;
        Object[] children = (VirtualFile[])ObjectUtils.notNull((Object)dir.getChildren(), (Object)VirtualFile.EMPTY_ARRAY);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Detecting by children: " + Arrays.toString(children));
        }
        for (Object child : children) {
            if (!child.isValid() || !includeDirs && child.isDirectory() || !JsbtUtil.isFilenameMatched(child.getNameSequence(), filenamePrefix, filenameExtensions)) continue;
            if (result2 == null) {
                result2 = child;
                continue;
            }
            if (JsbtUtil.compareExt((VirtualFile)child, (VirtualFile)result2, filenameExtensions) >= 0) continue;
            result2 = child;
        }
        return result2;
    }

    private static int compareExt(@NotNull VirtualFile file1, @NotNull VirtualFile file2, String @NotNull [] extensions) {
        if (file1 == null) {
            JsbtUtil.$$$reportNull$$$0(9);
        }
        if (file2 == null) {
            JsbtUtil.$$$reportNull$$$0(10);
        }
        if (extensions == null) {
            JsbtUtil.$$$reportNull$$$0(11);
        }
        int ind1 = ArrayUtil.find((Object[])extensions, (Object)file1.getExtension());
        int ind2 = ArrayUtil.find((Object[])extensions, (Object)file2.getExtension());
        if (ind1 < 0) {
            ind1 = extensions.length;
        }
        if (ind2 < 0) {
            ind2 = extensions.length;
        }
        return ind1 - ind2;
    }

    public static boolean isFilenameMatched(@NotNull CharSequence fileName, @NotNull String filenamePrefix, String @NotNull [] filenameExtensions) {
        if (fileName == null) {
            JsbtUtil.$$$reportNull$$$0(12);
        }
        if (filenamePrefix == null) {
            JsbtUtil.$$$reportNull$$$0(13);
        }
        if (filenameExtensions == null) {
            JsbtUtil.$$$reportNull$$$0(14);
        }
        if (JsbtUtil.startsWithIgnoreCase(fileName, filenamePrefix)) {
            for (String ext : filenameExtensions) {
                if (!StringUtilRt.endsWithIgnoreCase((CharSequence)fileName, (CharSequence)ext)) continue;
                return ext.length() < fileName.length() && '.' == fileName.charAt(fileName.length() - ext.length() - 1);
            }
        }
        return false;
    }

    @Contract(pure=true)
    public static boolean startsWithIgnoreCase(@NonNls @NotNull CharSequence text2, @NonNls @NotNull CharSequence prefix) {
        if (text2 == null) {
            JsbtUtil.$$$reportNull$$$0(15);
        }
        if (prefix == null) {
            JsbtUtil.$$$reportNull$$$0(16);
        }
        int prefixLength = prefix.length();
        if (text2.length() < prefixLength) {
            return false;
        }
        for (int i = 0; i < prefixLength; ++i) {
            if (StringUtil.charsEqualIgnoreCase((char)text2.charAt(i), (char)prefix.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public static List<VirtualFile> detectAllBuildfiles(@NotNull Project project, @NotNull String filenamePrefix, String @NotNull [] filenamesWithoutExt, String @NotNull [] extensions) {
        if (project == null) {
            JsbtUtil.$$$reportNull$$$0(17);
        }
        if (filenamePrefix == null) {
            JsbtUtil.$$$reportNull$$$0(18);
        }
        if (filenamesWithoutExt == null) {
            JsbtUtil.$$$reportNull$$$0(19);
        }
        if (extensions == null) {
            JsbtUtil.$$$reportNull$$$0(20);
        }
        HashSet<VirtualFile> result2 = new HashSet<VirtualFile>(JsbtUtil.detectAllBuildfilesInContentRoots(project, false, filenamePrefix, extensions, false));
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            GlobalSearchScope scope2 = JSLibraryUtil.getContentScopeWithoutLibraries(project);
            for (String nameWithoutExt : filenamesWithoutExt) {
                for (String ext : extensions) {
                    result2.addAll(FilenameIndex.getVirtualFilesByName((Project)project, (String)(nameWithoutExt + "." + ext), (boolean)false, (GlobalSearchScope)scope2));
                }
            }
        });
        return new ArrayList<VirtualFile>(result2);
    }

    @NlsSafe
    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JsbtUtil.$$$reportNull$$$0(21);
        }
        if (file == null) {
            JsbtUtil.$$$reportNull$$$0(22);
        }
        return JsbtUtil.getRelativePath(project, file, true);
    }

    @NlsSafe
    @NotNull
    public static String getRelativePath(@NotNull Project project, @NotNull VirtualFile file, boolean prependContentRootName) {
        VirtualFile root;
        if (project == null) {
            JsbtUtil.$$$reportNull$$$0(23);
        }
        if (file == null) {
            JsbtUtil.$$$reportNull$$$0(24);
        }
        if (!project.isDisposed() && (root = JSLibraryUtil.getContentRootForFile(project, file)) != null) {
            String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root, (char)File.separatorChar);
            if (StringUtil.isEmpty((String)relativePath)) {
                String string = root.getName();
                if (string == null) {
                    JsbtUtil.$$$reportNull$$$0(25);
                }
                return string;
            }
            if (prependContentRootName) {
                String string = root.getName() + File.separatorChar + relativePath;
                if (string == null) {
                    JsbtUtil.$$$reportNull$$$0(26);
                }
                return string;
            }
            String string = relativePath;
            if (string == null) {
                JsbtUtil.$$$reportNull$$$0(27);
            }
            return string;
        }
        String string = FileUtil.getLocationRelativeToUserHome((String)file.getPresentableUrl());
        if (string == null) {
            JsbtUtil.$$$reportNull$$$0(28);
        }
        return string;
    }

    public static void foldCommandLine(@NotNull ConsoleView consoleView, final @NotNull ProcessHandler processHandler, final @NotNull String foldedCommandLineText) {
        BaseOSProcessHandler osProcessHandler;
        String commandLine;
        if (consoleView == null) {
            JsbtUtil.$$$reportNull$$$0(29);
        }
        if (processHandler == null) {
            JsbtUtil.$$$reportNull$$$0(30);
        }
        if (foldedCommandLineText == null) {
            JsbtUtil.$$$reportNull$$$0(31);
        }
        String string = commandLine = (osProcessHandler = (BaseOSProcessHandler)ObjectUtils.tryCast((Object)processHandler, BaseOSProcessHandler.class)) != null ? osProcessHandler.getCommandLine() : null;
        if (commandLine == null) {
            return;
        }
        final ConsoleViewImpl consoleViewImpl = JsbtUtil.getConsoleViewImpl(consoleView);
        if (consoleViewImpl == null) {
            return;
        }
        if (consoleView instanceof SMTRunnerConsoleView) {
            JsbtUtil.doFoldForTestConsole(consoleViewImpl, 0, commandLine, foldedCommandLineText);
        } else if (processHandler.isStartNotified()) {
            JsbtUtil.doFoldForRegularConsole(consoleViewImpl, 0, commandLine, foldedCommandLineText);
        } else {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    processHandler.removeProcessListener((ProcessListener)this);
                    JsbtUtil.doFoldForRegularConsole(consoleViewImpl, 0, commandLine, foldedCommandLineText);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$1", "startNotified"));
                }
            });
        }
    }

    public static void foldMatchingTextAtOffset(@NotNull ConsoleView consoleView, int matchingTextDocumentStartOffset, @NotNull String matchingText, @NotNull String foldedText) {
        ConsoleViewImpl consoleViewImpl;
        if (consoleView == null) {
            JsbtUtil.$$$reportNull$$$0(32);
        }
        if (matchingText == null) {
            JsbtUtil.$$$reportNull$$$0(33);
        }
        if (foldedText == null) {
            JsbtUtil.$$$reportNull$$$0(34);
        }
        if ((consoleViewImpl = JsbtUtil.getConsoleViewImpl(consoleView)) == null) {
            return;
        }
        if (consoleView instanceof SMTRunnerConsoleView) {
            JsbtUtil.doFoldForTestConsole(consoleViewImpl, matchingTextDocumentStartOffset, matchingText, foldedText);
        } else {
            JsbtUtil.doFoldForRegularConsole(consoleViewImpl, matchingTextDocumentStartOffset, matchingText, foldedText);
        }
    }

    private static void doFoldForTestConsole(@NotNull ConsoleViewImpl consoleView, final int matchingTextDocumentStartOffset, final @NotNull String matchingText, final @NotNull String foldedText) {
        if (consoleView == null) {
            JsbtUtil.$$$reportNull$$$0(35);
        }
        if (matchingText == null) {
            JsbtUtil.$$$reportNull$$$0(36);
        }
        if (foldedText == null) {
            JsbtUtil.$$$reportNull$$$0(37);
        }
        final Editor editor = consoleView.getEditor();
        final Document doc = editor.getDocument();
        doc.addDocumentListener(new DocumentListener(){
            private boolean myTryAddFolding = true;

            public void documentChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (doc.getTextLength() == 0) {
                    this.myTryAddFolding = true;
                } else if (this.myTryAddFolding && doc.getTextLength() >= matchingTextDocumentStartOffset + matchingText.length()) {
                    this.myTryAddFolding = false;
                    if (CharArrayUtil.regionMatches((CharSequence)doc.getCharsSequence(), (int)matchingTextDocumentStartOffset, (CharSequence)matchingText)) {
                        EditorUtil.runBatchFoldingOperationOutsideOfBulkUpdate((Editor)editor, () -> {
                            FoldingModel foldingModel = editor.getFoldingModel();
                            FoldRegion region = foldingModel.addFoldRegion(matchingTextDocumentStartOffset, matchingTextDocumentStartOffset + matchingText.length(), foldedText);
                            if (region != null) {
                                region.setExpanded(false);
                            }
                        });
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/lang/javascript/buildTools/base/JsbtUtil$2", "documentChanged"));
            }
        });
    }

    private static void doFoldForRegularConsole(@NotNull ConsoleViewImpl consoleView, int matchingTextDocumentStartOffset, @NotNull String matchingText, @NotNull String foldedText) {
        if (consoleView == null) {
            JsbtUtil.$$$reportNull$$$0(38);
        }
        if (matchingText == null) {
            JsbtUtil.$$$reportNull$$$0(39);
        }
        if (foldedText == null) {
            JsbtUtil.$$$reportNull$$$0(40);
        }
        consoleView.flushDeferredText();
        consoleView.performWhenNoDeferredOutput(() -> {
            ThreadingAssertions.assertEventDispatchThread();
            Document document2 = consoleView.getEditor().getDocument();
            if (CharArrayUtil.regionMatches((CharSequence)document2.getCharsSequence(), (int)matchingTextDocumentStartOffset, (CharSequence)matchingText)) {
                FoldingModel foldingModel = consoleView.getEditor().getFoldingModel();
                foldingModel.runBatchFoldingOperation(() -> {
                    FoldRegion region = foldingModel.addFoldRegion(matchingTextDocumentStartOffset, matchingTextDocumentStartOffset + matchingText.length(), foldedText);
                    if (region != null) {
                        region.setExpanded(false);
                    }
                });
            }
        });
    }

    private static ConsoleViewImpl getConsoleViewImpl(@NotNull ConsoleView consoleView) {
        SMTRunnerConsoleView smtConsoleView;
        ConsoleViewImpl consoleViewImpl;
        if (consoleView == null) {
            JsbtUtil.$$$reportNull$$$0(41);
        }
        if ((consoleViewImpl = (ConsoleViewImpl)ObjectUtils.tryCast((Object)consoleView, ConsoleViewImpl.class)) == null && (smtConsoleView = (SMTRunnerConsoleView)ObjectUtils.tryCast((Object)consoleView, SMTRunnerConsoleView.class)) != null) {
            consoleViewImpl = (ConsoleViewImpl)ObjectUtils.tryCast((Object)smtConsoleView.getConsole(), ConsoleViewImpl.class);
        }
        return consoleViewImpl;
    }

    public static boolean equalsOrderless(@NotNull List<String> a, @NotNull List<String> b) {
        if (a == null) {
            JsbtUtil.$$$reportNull$$$0(42);
        }
        if (b == null) {
            JsbtUtil.$$$reportNull$$$0(43);
        }
        if (a.size() <= 1 || b.size() <= 1) {
            return a.equals(b);
        }
        List<String> as = JsbtUtil.sort(a);
        List<String> bs = JsbtUtil.sort(b);
        return as.equals(bs);
    }

    @NotNull
    private static List<String> sort(@NotNull List<String> list2) {
        if (list2 == null) {
            JsbtUtil.$$$reportNull$$$0(44);
        }
        Object[] array = ArrayUtilRt.toStringArray(list2);
        Arrays.sort(array);
        List<Object> list3 = Arrays.asList(array);
        if (list3 == null) {
            JsbtUtil.$$$reportNull$$$0(45);
        }
        return list3;
    }

    @Nullable
    public static JsbtInvalidSetting validatePackageDir(@NotNull NodePackage pkg, @NotNull String name, @NotNull String packageName) {
        String error;
        if (pkg == null) {
            JsbtUtil.$$$reportNull$$$0(46);
        }
        if (name == null) {
            JsbtUtil.$$$reportNull$$$0(47);
        }
        if (packageName == null) {
            JsbtUtil.$$$reportNull$$$0(48);
        }
        if ((error = pkg.getErrorMessage(packageName)) != null) {
            return new JsbtInvalidSetting(name, pkg.getSystemDependentPath(), error);
        }
        return null;
    }

    public static void installBeepSupport(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            JsbtUtil.$$$reportNull$$$0(49);
        }
        processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            private boolean myPreviousBellChar = false;

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    3.$$$reportNull$$$0(1);
                }
                String text2 = event.getText();
                if (ProcessOutputType.isStdout((Key)outputType) && text2 != null) {
                    for (int i = 0; i < text2.length(); ++i) {
                        char ch = text2.charAt(i);
                        if (this.myPreviousBellChar && ch == '\u266a') {
                            UIUtil.invokeLaterIfNeeded(() -> Toolkit.getDefaultToolkit().beep());
                        }
                        this.myPreviousBellChar = ch == '\u0007';
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/buildTools/base/JsbtUtil$3";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static List<String> encodeNames(@NotNull List<String> rawNames) {
        if (rawNames == null) {
            JsbtUtil.$$$reportNull$$$0(50);
        }
        return ContainerUtil.map(rawNames, name -> ParametersListUtil.join(Collections.singletonList(name)));
    }

    public static boolean hasBuildTool(@NotNull Project project) {
        if (project == null) {
            JsbtUtil.$$$reportNull$$$0(51);
        }
        for (JsbtFileManagerProvider fileManagerProvider : JsbtFileManagerProvider.EP_NAME.getExtensionList()) {
            JsbtFileManager fileManager = fileManagerProvider.getFileManager(project);
            if (!fileManager.hasBuildfiles()) continue;
            return true;
        }
        return JsbtUtil.hasNpmBuildTask(project);
    }

    private static boolean hasNpmBuildTask(@NotNull Project project) {
        if (project == null) {
            JsbtUtil.$$$reportNull$$$0(52);
        }
        PackageJsonBuildFileManager manager = PackageJsonBuildFileManager.getInstance(project);
        for (VirtualFile file : manager.getBuildfiles()) {
            NpmScriptsStructure structure = manager.getCachedStructure(file);
            if (structure == null || !structure.getTaskNames().contains("build")) continue;
            return true;
        }
        return false;
    }

    public static void enableExpandingWithLazyHistoryLoading(@NotNull TextFieldWithHistory field) {
        if (field == null) {
            JsbtUtil.$$$reportNull$$$0(53);
        }
        field.setHistory(Collections.singletonList(""));
    }

    public static boolean executeBeforeRunTask(@NotNull ExecutionEnvironment env, @NotNull RunnerAndConfigurationSettings settings2) {
        if (env == null) {
            JsbtUtil.$$$reportNull$$$0(54);
        }
        if (settings2 == null) {
            JsbtUtil.$$$reportNull$$$0(55);
        }
        ExecutionEnvironment taskEnv = new ExecutionEnvironmentBuilder(env).executor(DefaultRunExecutor.getRunExecutorInstance()).build();
        return RunConfigurationBeforeRunProvider.doExecuteTask((ExecutionEnvironment)taskEnv, (RunnerAndConfigurationSettings)settings2, null);
    }

    public static void resetFontToDefault(@NotNull RawCommandLineEditor editor) {
        JTextField field;
        if (editor == null) {
            JsbtUtil.$$$reportNull$$$0(56);
        }
        if ((field = editor.getTextField()) instanceof ExpandableTextField) {
            ((ExpandableTextField)field).setMonospaced(false);
        }
    }

    private static /* synthetic */ void lambda$detectAllBuildfilesInContentRoots$0(String filenamePrefix, String[] filenameExtensions, boolean includeDirs, List buildfiles, VirtualFile contentRoot) {
        VirtualFile buildfile = JsbtUtil.detectBuildfile(contentRoot, filenamePrefix, filenameExtensions, includeDirs);
        if (buildfile != null) {
            buildfiles.add(buildfile);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 25, 26, 27, 28, 45 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRootConsumer";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filenamePrefix";
                break;
            }
            case 4: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filenameExtensions";
                break;
            }
            case 5: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file2";
                break;
            }
            case 11: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filenamesWithoutExt";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 29: 
            case 32: 
            case 35: 
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 30: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldedCommandLineText";
                break;
            }
            case 33: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchingText";
                break;
            }
            case 34: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foldedText";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawNames";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "sort";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverContentRoots";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfilesInContentRoots";
                break;
            }
            case 5: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 45: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detectBuildfile";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "compareExt";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFilenameMatched";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "startsWithIgnoreCase";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "detectAllBuildfiles";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "foldMatchingTextAtOffset";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "doFoldForTestConsole";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "doFoldForRegularConsole";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getConsoleViewImpl";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "equalsOrderless";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "sort";
                break;
            }
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "validatePackageDir";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "installBeepSupport";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "encodeNames";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "hasBuildTool";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "hasNpmBuildTask";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "enableExpandingWithLazyHistoryLoading";
                break;
            }
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "executeBeforeRunTask";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "resetFontToDefault";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 25, 26, 27, 28, 45 -> new IllegalStateException(string);
        };
    }
}

