/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskRunAction;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JsbtTopHitProvider
implements SearchTopHitProvider {
    private static final String PATTERN_PREFIX = "run ";

    JsbtTopHitProvider() {
    }

    public void consumeTopHits(@NotNull String pattern, @NotNull Consumer<Object> collector, @Nullable Project activeProject) {
        if (pattern == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(0);
        }
        if (collector == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(1);
        }
        if (activeProject == null) {
            return;
        }
        for (JsbtApplicationService applicationService : JsbtApplicationService.getAllServices()) {
            JsbtService service2 = applicationService.getProjectService(activeProject);
            JsbtFileManager fileManager = service2.getFileManager();
            for (VirtualFile buildfile : fileManager.getBuildfiles()) {
                JsbtFileStructure structure = fileManager.getCachedStructure(buildfile);
                if (structure == null) continue;
                for (String taskName : structure.getTaskNames()) {
                    JsbtTopHitProvider.consumeTaskName(activeProject, applicationService, structure, taskName, pattern, collector);
                }
            }
        }
    }

    private static void consumeTaskName(@NotNull Project project, @NotNull JsbtApplicationService service2, @NotNull JsbtFileStructure structure, @NotNull String taskName, @NotNull String pattern, @NotNull Consumer<Object> collector) {
        if (project == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(2);
        }
        if (service2 == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(3);
        }
        if (structure == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(4);
        }
        if (taskName == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(5);
        }
        if (pattern == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(6);
        }
        if (collector == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(7);
        }
        if (JsbtTopHitProvider.match(pattern, taskName)) {
            collector.accept((Object)new JsbtTaskRunAction(project, service2, new JsbtTaskSet(structure, Collections.singletonList(taskName))));
        }
    }

    private static boolean match(@NotNull String pattern, @NotNull String taskName) {
        String subPattern;
        if (pattern == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(8);
        }
        if (taskName == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(9);
        }
        if (StringUtil.startsWithIgnoreCase((String)pattern, (String)PATTERN_PREFIX) && StringUtil.startsWithIgnoreCase((String)taskName, (String)(subPattern = pattern.substring(PATTERN_PREFIX.length())))) {
            return true;
        }
        return StringUtil.startsWith((CharSequence)taskName, (CharSequence)pattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeTopHits";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeTaskName";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

