/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskListFetchFail;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsbtTaskListingFailUtil {
    private JsbtTaskListingFailUtil() {
    }

    public static void showError(@NotNull Project project, @NotNull JsbtTaskListFetchFail fetchFail) {
        if (project == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(0);
        }
        if (fetchFail == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(1);
        }
        RunContentManager runContentManager = RunContentManager.getInstance((Project)project);
        RunContentDescriptor descriptor = JsbtTaskListingFailUtil.findDescriptor(runContentManager, fetchFail);
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        if (descriptor != null) {
            runContentManager.toFrontRunContent(executor, descriptor);
        } else {
            descriptor = JsbtTaskListingFailUtil.createDescriptor(project, fetchFail, executor);
            runContentManager.showRunContent(executor, descriptor);
            fetchFail.associateWith(descriptor);
        }
    }

    public static void hideError(@NotNull Project project, @NotNull JsbtTaskFetchException e) {
        JsbtTaskListFetchFail fetchFail;
        if (project == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(2);
        }
        if (e == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(3);
        }
        if ((fetchFail = e.getFetchFail()) == null) {
            return;
        }
        RunContentManager runContentManager = RunContentManager.getInstance((Project)project);
        RunContentDescriptor descriptor = JsbtTaskListingFailUtil.findDescriptor(runContentManager, fetchFail);
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        if (descriptor != null) {
            runContentManager.removeRunContent(executor, descriptor);
        }
    }

    @NotNull
    private static RunContentDescriptor createDescriptor(@NotNull Project project, @NotNull JsbtTaskListFetchFail fetchFail, @NotNull Executor executor) {
        if (project == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(4);
        }
        if (fetchFail == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(5);
        }
        if (executor == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(6);
        }
        ConsoleView consoleView = JsbtTaskListingFailUtil.createConsoleView(project);
        ProcessHandler processHandler = fetchFail.getProcessHandler();
        RunContentDescriptor descriptor = JsbtTaskListingFailUtil.createDescriptor(project, executor, consoleView, processHandler, fetchFail);
        if (processHandler != null && !processHandler.isProcessTerminated()) {
            consoleView.attachToProcess(processHandler);
            ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        }
        JsbtTaskListingFailUtil.printFetchFail(project, consoleView, fetchFail);
        RunContentDescriptor runContentDescriptor = descriptor;
        if (runContentDescriptor == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(7);
        }
        return runContentDescriptor;
    }

    private static RunContentDescriptor createDescriptor(@NotNull Project project, @NotNull Executor executor, @NotNull ConsoleView consoleView, @Nullable ProcessHandler processHandler, @NotNull JsbtTaskListFetchFail fetchFail) {
        if (project == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(8);
        }
        if (executor == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(9);
        }
        if (consoleView == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(10);
        }
        if (fetchFail == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(11);
        }
        DefaultActionGroup actions = new DefaultActionGroup();
        JPanel consoleComponent = JsbtTaskListingFailUtil.createConsoleComponent(consoleView, actions);
        AnAction stopAction = ActionManager.getInstance().getAction("Stop");
        if (stopAction != null) {
            actions.add(stopAction);
        }
        actions.addAll(consoleView.createConsoleActions());
        JsbtRunContentDescriptor descriptor = new JsbtRunContentDescriptor(consoleView, processHandler, consoleComponent, fetchFail);
        actions.add((AnAction)new CloseAction(executor, (RunContentDescriptor)descriptor, project));
        return descriptor;
    }

    @Nullable
    private static RunContentDescriptor findDescriptor(@NotNull RunContentManager runContentManager, @NotNull JsbtTaskListFetchFail fetchFail) {
        if (runContentManager == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(12);
        }
        if (fetchFail == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(13);
        }
        for (RunContentDescriptor descriptor : runContentManager.getAllDescriptors()) {
            if (!fetchFail.isAssociatedWith(descriptor)) continue;
            return descriptor;
        }
        return null;
    }

    private static void printFetchFail(@NotNull Project project, @NotNull ConsoleView view, @NotNull JsbtTaskListFetchFail fetchFail) {
        if (project == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(14);
        }
        if (view == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(15);
        }
        if (fetchFail == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(16);
        }
        view.print("Failed to list " + fetchFail.getBuildToolName() + " tasks in ", ConsoleViewContentType.NORMAL_OUTPUT);
        VirtualFile file = fetchFail.getBuildfile();
        if (file.isValid()) {
            view.printHyperlink(JsbtUtil.getRelativePath(project, file), (HyperlinkInfo)new OpenFileHyperlinkInfo(project, file, -1, -1));
        } else {
            view.print(FileUtil.toSystemDependentName((String)fetchFail.getBuildfile().getPath()), ConsoleViewContentType.NORMAL_OUTPUT);
        }
        view.print(": ", ConsoleViewContentType.NORMAL_OUTPUT);
        view.print(fetchFail.getMessage() + "\n", ConsoleViewContentType.ERROR_OUTPUT);
        view.print(" * ", ConsoleViewContentType.NORMAL_OUTPUT);
        view.printHyperlink("Edit settings", JsbtTaskListingFailUtil.createEditSettingsHyperlink(fetchFail));
        view.print("\n\n", ConsoleViewContentType.ERROR_OUTPUT);
        GeneralCommandLine commandLine = fetchFail.getCommandLine();
        if (commandLine != null) {
            String commandLineText = commandLine.getCommandLineString();
            view.print("$ ", ConsoleViewContentType.SYSTEM_OUTPUT);
            int commandLineStartOffset = view.getContentSize();
            view.print(commandLineText, ConsoleViewContentType.SYSTEM_OUTPUT);
            if (fetchFail.getCommandLineFoldedText() != null) {
                JsbtUtil.foldMatchingTextAtOffset(view, commandLineStartOffset, commandLineText, fetchFail.getCommandLineFoldedText());
            }
        }
        view.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        ProcessOutput output = fetchFail.getProcessOutput();
        if (output != null) {
            String stdout = output.getStdout();
            String stderr = output.getStderr();
            view.print(stdout, ConsoleViewContentType.NORMAL_OUTPUT);
            if (!(stdout.isEmpty() || stderr.isEmpty() || stdout.endsWith("\n"))) {
                view.print("\n", ConsoleViewContentType.NORMAL_OUTPUT);
            }
            view.print(stderr, ConsoleViewContentType.ERROR_OUTPUT);
            ProcessHandler processHandler = fetchFail.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated()) {
                view.print("\nProcess finished with exit code " + output.getExitCode() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }
    }

    @NotNull
    private static HyperlinkInfo createEditSettingsHyperlink(final @NotNull JsbtTaskListFetchFail fetchFail) {
        if (fetchFail == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(17);
        }
        return new HyperlinkInfo(){

            public void navigate(@NotNull Project project) {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                fetchFail.getService(project).showTaskListingSettingsDialog(fetchFail.getBuildfile());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil$1", "navigate"));
            }
        };
    }

    @NotNull
    private static ConsoleView createConsoleView(@NotNull Project project) {
        if (project == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(18);
        }
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project);
        consoleBuilder.filters(new Filter[]{new NodeConsoleAdditionalFilter(project, (String)null), new UrlFilter()});
        ConsoleView consoleView = consoleBuilder.getConsole();
        if (consoleView == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(19);
        }
        return consoleView;
    }

    @NotNull
    private static JPanel createConsoleComponent(@NotNull ConsoleView consoleView, @NotNull DefaultActionGroup actions) {
        if (consoleView == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(20);
        }
        if (actions == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(21);
        }
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)consoleView.getComponent(), "Center");
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("JsbtConsole", (ActionGroup)actions, false);
        panel2.add((Component)actionToolbar.getComponent(), "West");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            JsbtTaskListingFailUtil.$$$reportNull$$$0(22);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 19, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 11: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fetchFail";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 7: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil";
                break;
            }
            case 10: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runContentManager";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleView";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hideError";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptor";
                break;
            }
            case 7: 
            case 19: 
            case 22: {
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findDescriptor";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "printFetchFail";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createEditSettingsHyperlink";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleView";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createConsoleComponent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 19, 22 -> new IllegalStateException(string);
        };
    }

    private static class JsbtRunContentDescriptor
    extends RunContentDescriptor {
        JsbtRunContentDescriptor(@NotNull ConsoleView view, @Nullable ProcessHandler handler, @NotNull JPanel component, @NotNull JsbtTaskListFetchFail fetchFail) {
            if (view == null) {
                JsbtRunContentDescriptor.$$$reportNull$$$0(0);
            }
            if (component == null) {
                JsbtRunContentDescriptor.$$$reportNull$$$0(1);
            }
            if (fetchFail == null) {
                JsbtRunContentDescriptor.$$$reportNull$$$0(2);
            }
            super((ExecutionConsole)view, handler, (JComponent)component, JavaScriptBundle.message("build.event.title.failed.to.list.tasks", fetchFail.getBuildToolName()), fetchFail.getIcon());
        }

        public boolean isContentReuseProhibited() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "view";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "component";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "fetchFail";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTaskListingFailUtil$JsbtRunContentDescriptor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

