/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.buildTools.base.JsbtApplicationService;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class JsbtStartupActivity
implements StartupActivity.DumbAware {
    private static final Logger LOG = Logger.getInstance(JsbtStartupActivity.class);

    JsbtStartupActivity() {
    }

    public void runActivity(@NotNull Project project) {
        if (project == null) {
            JsbtStartupActivity.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        SmartList servicesForDetection = new SmartList();
        for (JsbtApplicationService applicationService : JsbtApplicationService.getAllServices()) {
            JsbtService service2 = applicationService.getProjectService(project);
            JsbtFileManager fileManager = service2.getFileManager();
            if (fileManager.hasBuildfiles()) {
                JsbtStartupActivity.setAvailable(project, service2, Collections.emptyList());
                continue;
            }
            if (fileManager.isDetectionDone()) continue;
            fileManager.setDetectionDone();
            servicesForDetection.add(service2);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Detecting buildfiles for " + fileManager.getClass().getName());
        }
        if (!servicesForDetection.isEmpty()) {
            JsbtStartupActivity.scheduleDetection(project, (List<JsbtService>)servicesForDetection);
        }
    }

    private static void scheduleDetection(@NotNull Project project, @NotNull List<JsbtService> servicesForDetection) {
        if (project == null) {
            JsbtStartupActivity.$$$reportNull$$$0(1);
        }
        if (servicesForDetection == null) {
            JsbtStartupActivity.$$$reportNull$$$0(2);
        }
        ApplicationManager.getApplication().invokeLater(() -> RefreshQueue.getInstance().refresh(true, true, () -> ApplicationManager.getApplication().executeOnPooledThread(() -> JsbtStartupActivity.doDetect(project, servicesForDetection)), ManagingFS.getInstance().getRoots((NewVirtualFileSystem)LocalFileSystem.getInstance())), ModalityState.nonModal(), project.getDisposed());
    }

    private static void doDetect(@NotNull Project project, @NotNull List<JsbtService> servicesForDetection) {
        if (project == null) {
            JsbtStartupActivity.$$$reportNull$$$0(3);
        }
        if (servicesForDetection == null) {
            JsbtStartupActivity.$$$reportNull$$$0(4);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            if (project.isDisposed()) {
                return;
            }
            for (JsbtService service2 : servicesForDetection) {
                List<VirtualFile> buildfiles = service2.detectAllBuildfilesInContentRoots(true, true);
                if (!buildfiles.isEmpty()) {
                    LOG.info("Found " + buildfiles + " for " + service2.getClass().getName());
                }
                if (buildfiles.isEmpty() || !NodeJsInterpreterManager.getInstance(project).isInterpreterAvailable()) continue;
                JsbtStartupActivity.setAvailable(project, service2, buildfiles);
            }
        });
    }

    private static void setAvailable(@NotNull Project project, @NotNull JsbtService service2, @NotNull List<VirtualFile> buildfilesToAdd) {
        if (project == null) {
            JsbtStartupActivity.$$$reportNull$$$0(5);
        }
        if (service2 == null) {
            JsbtStartupActivity.$$$reportNull$$$0(6);
        }
        if (buildfilesToAdd == null) {
            JsbtStartupActivity.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (VirtualFile buildfile : buildfilesToAdd) {
                service2.getFileManager().addBuildfile(buildfile);
            }
            service2.getToolWindowManager().setAvailable();
        }, project.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "servicesForDetection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildfilesToAdd";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtStartupActivity";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "runActivity";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "scheduleDetection";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "doDetect";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "setAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

