/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.codeInsight.daemon.quickFix.CreateFilePathFix;
import com.intellij.codeInsight.daemon.quickFix.FileReferenceQuickFixProvider;
import com.intellij.codeInsight.daemon.quickFix.NewFileLocation;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSPsiReferenceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.typescript.psi.TypeScriptExternalModuleReference;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceHelper;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFileFromImportsHelper
extends FileReferenceHelper {
    private static final Iterable<String> acceptedExtensions = ContainerUtil.map(List.of("ts", "tsx", "jsx", "js.flow", "js"), s -> "." + s);

    public boolean isMine(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(0);
        }
        if (file == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(1);
        }
        return false;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getContexts(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(2);
        }
        if (file == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(3);
        }
        List list2 = ContainerUtil.emptyList();
        if (list2 == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public @NotNull List<? extends @NotNull LocalQuickFix> registerFixes(@NotNull FileReference reference) {
        String fileNameToCreate;
        if (reference == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(5);
        }
        if (!ContainerUtil.or(acceptedExtensions, arg_0 -> JSFileFromImportsHelper.lambda$registerFixes$1(fileNameToCreate = reference.getFileNameToCreate(), arg_0)) || !PathUtil.isValidFileName((String)fileNameToCreate, (boolean)true)) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSFileFromImportsHelper.$$$reportNull$$$0(6);
            }
            return list2;
        }
        List<Symbol> symbols = JSFileFromImportsHelper.getSymbolsToGenerate(reference);
        if (symbols.isEmpty()) {
            List list3 = ContainerUtil.emptyList();
            if (list3 == null) {
                JSFileFromImportsHelper.$$$reportNull$$$0(7);
            }
            return list3;
        }
        NewFileLocation location = FileReferenceQuickFixProvider.getNewFileLocation((FileReference)reference, (String)fileNameToCreate, (boolean)false);
        if (location == null) {
            List list4 = ContainerUtil.emptyList();
            if (list4 == null) {
                JSFileFromImportsHelper.$$$reportNull$$$0(8);
            }
            return list4;
        }
        List<CreateFileWithExportedSymbolsFix> list5 = Collections.singletonList(new CreateFileWithExportedSymbolsFix(reference.getElement(), location, symbols, fileNameToCreate));
        if (list5 == null) {
            JSFileFromImportsHelper.$$$reportNull$$$0(9);
        }
        return list5;
    }

    private static List<Symbol> getSymbolsToGenerate(FileReference reference) {
        ES6ImportDeclaration es6ImportDeclaration;
        JSElement referenceParent = (JSElement)PsiTreeUtil.getNonStrictParentOfType((PsiElement)reference.getElement(), (Class[])new Class[]{ES6ImportDeclaration.class, TypeScriptExternalModuleReference.class});
        if (referenceParent == null) {
            return ContainerUtil.emptyList();
        }
        ES6ImportDeclaration eS6ImportDeclaration = es6ImportDeclaration = referenceParent instanceof ES6ImportDeclaration ? (ES6ImportDeclaration)referenceParent : null;
        if (es6ImportDeclaration != null) {
            Object[] bindings = es6ImportDeclaration.getImportedBindings();
            if (ContainerUtil.or((Object[])bindings, ES6ImportedBinding::isNamespaceImport)) {
                return ContainerUtil.emptyList();
            }
            Stream<Symbol> defaultImport = Arrays.stream(bindings).map(NavigationItem::getName).filter(i -> i != null).map(name -> new Symbol((String)name, ExportedSymbolType.Default));
            Stream<Symbol> namedImports = Arrays.stream(es6ImportDeclaration.getImportSpecifiers()).filter(el -> {
                PsiElement identifier = el.getReferenceNameElement();
                return identifier != null && JSKeywordSets.JS_IDENTIFIER_TOKENS_SET.contains(identifier.getNode().getElementType());
            }).map(JSPsiReferenceElement::getReferenceName).filter(i -> i != null).map(name -> new Symbol((String)name, ExportedSymbolType.Standard));
            return Stream.concat(defaultImport, namedImports).collect(Collectors.toList());
        }
        TypeScriptImportStatement importStatement = (TypeScriptImportStatement)PsiTreeUtil.getParentOfType((PsiElement)referenceParent, TypeScriptImportStatement.class);
        if (importStatement != null) {
            return Collections.singletonList(new Symbol(importStatement.getName(), ExportedSymbolType.TypescriptLegacy));
        }
        return ContainerUtil.emptyList();
    }

    private static /* synthetic */ boolean lambda$registerFixes$1(String fileNameToCreate, String extension) {
        return fileNameToCreate.endsWith(extension);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/actions/JSFileFromImportsHelper";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/actions/JSFileFromImportsHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getContexts";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "registerFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMine";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getContexts";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "registerFixes";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 6, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    private static class CreateFileWithExportedSymbolsFix
    extends CreateFilePathFix {
        private final List<? extends Symbol> symbols;
        private final String myNewFileName;

        CreateFileWithExportedSymbolsFix(@NotNull PsiElement psiElement, @NotNull NewFileLocation newFileLocation, List<? extends Symbol> symbols, String newFileName) {
            if (psiElement == null) {
                CreateFileWithExportedSymbolsFix.$$$reportNull$$$0(0);
            }
            if (newFileLocation == null) {
                CreateFileWithExportedSymbolsFix.$$$reportNull$$$0(1);
            }
            super(psiElement, newFileLocation);
            this.symbols = symbols;
            this.myNewFileName = newFileName;
        }

        @NotNull
        public String getText() {
            String functionNames;
            List functions = ContainerUtil.filter(this.symbols, t -> t.isFunction);
            List classes = ContainerUtil.filter(this.symbols, t -> !t.isFunction);
            String classNames = classes.isEmpty() ? null : JavaScriptBundle.message("class.names", classes.size(), CreateFileWithExportedSymbolsFix.getCommaSeparatedNames(classes));
            String string = functionNames = functions.isEmpty() ? null : JavaScriptBundle.message("function.names", functions.size(), CreateFileWithExportedSymbolsFix.getCommaSeparatedNames(functions));
            String string2 = classNames == null && functionNames == null ? JavaScriptBundle.message("create.file.name", this.myNewFileName) : (classNames != null && functionNames != null ? JavaScriptBundle.message("create.file.name.with.and", this.myNewFileName, classNames, functionNames) : JavaScriptBundle.message("create.file.name.with", this.myNewFileName, Objects.requireNonNullElse(classNames, functionNames)));
            if (string2 == null) {
                CreateFileWithExportedSymbolsFix.$$$reportNull$$$0(2);
            }
            return string2;
        }

        @Nullable
        protected String getFileText() {
            String symbolsText = StringUtil.join((Collection)ContainerUtil.map(this.symbols, CreateFileWithExportedSymbolsFix::getSymbolText), (String)"\n\n");
            if (this.symbols.size() == 1 && this.symbols.get((int)0).type == ExportedSymbolType.TypescriptLegacy) {
                return String.format("%s\n\nexport = %s", symbolsText, this.symbols.get((int)0).name);
            }
            return symbolsText;
        }

        private static String getSymbolText(Symbol symbol) {
            String classTemplate = "%s class %s\n{\n\n}";
            String functionTemplate = "%s function %s() {\n  \n}";
            String template = symbol.isFunction ? functionTemplate : classTemplate;
            String modifier = switch (symbol.type) {
                default -> throw new IncompatibleClassChangeError();
                case ExportedSymbolType.Default -> "export default";
                case ExportedSymbolType.Standard -> "export";
                case ExportedSymbolType.TypescriptLegacy -> "";
            };
            return String.format(template, modifier, symbol.name);
        }

        @NotNull
        private static String getCommaSeparatedNames(List<Symbol> symbols) {
            String string = StringUtil.join((Collection)ContainerUtil.map(symbols, t -> "'" + t.name + "'"), (String)", ");
            if (string == null) {
                CreateFileWithExportedSymbolsFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiElement";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newFileLocation";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/actions/JSFileFromImportsHelper$CreateFileWithExportedSymbolsFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/actions/JSFileFromImportsHelper$CreateFileWithExportedSymbolsFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getText";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCommaSeparatedNames";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class Symbol {
        public String name;
        public boolean isFunction;
        public ExportedSymbolType type;

        Symbol(String name, ExportedSymbolType type2) {
            this.name = name;
            this.isFunction = Symbol.isFunctionName(name);
            this.type = type2;
        }

        private static boolean isFunctionName(String name) {
            return name != null && name.length() > 0 && Character.isLowerCase(name.charAt(0));
        }
    }

    private static enum ExportedSymbolType {
        Standard,
        Default,
        TypescriptLegacy;

    }
}

