/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.json.psi.impl.JSStringLiteralEscaper;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSFlexAdapter;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.psi.JSLiteralExpressionKind;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.webSymbols.utils.NameCaseUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSStringUtil {
    public static final char SIMPLE_QUOTE = '\'';
    public static final char DOUBLE_QUOTE = '\"';
    public static final char BACK_QUOTE = '`';
    private static final Pattern EXT_UNICODE_CHAR = Pattern.compile("\\\\u\\{[0-9a-fA-F]+}");
    public static final Map<Condition<String>, JSLiteralExpressionKind> NUMERIC_MATCHERS = new LinkedHashMap<Condition<String>, JSLiteralExpressionKind>();

    private JSStringUtil() {
    }

    public static boolean isSingleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return value != null && value.charAt(0) == '\'' && value.charAt(value.length() - 1) == '\'';
    }

    public static boolean isDoubleQuoteStringLiteral(PsiElement expression) {
        String value = expression.getText();
        return JSStringUtil.isDoubleQuotedString(value);
    }

    public static boolean isDoubleQuotedString(@Nullable String value) {
        return value != null && value.length() > 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    @NotNull
    public static String changeQuotes(String jsStringLiteral) {
        char newQuote;
        char oldQuote;
        if (jsStringLiteral.startsWith("'")) {
            oldQuote = '\'';
            newQuote = '\"';
        } else if (jsStringLiteral.startsWith("\"")) {
            oldQuote = '\"';
            newQuote = '\'';
        } else {
            String string = jsStringLiteral;
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(0);
            }
            return string;
        }
        StringBuilder stringBuilder = JSStringUtil.changeQuotesInternal(jsStringLiteral, oldQuote, newQuote, 1, jsStringLiteral.length() - 1);
        stringBuilder.setCharAt(0, newQuote);
        stringBuilder.setCharAt(stringBuilder.length() - 1, newQuote);
        String string = stringBuilder.toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public static String changeQuotesInLiteralValue(String value, char oldQuote, char newQuote) {
        String string = JSStringUtil.changeQuotesInternal(value, oldQuote, newQuote, 0, value.length()).toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    private static StringBuilder changeQuotesInternal(String source, char oldQuote, char newQuote, int startIndex, int endIndex) {
        StringBuilder buffer = new StringBuilder(source);
        boolean screened = false;
        int bufferIndex = startIndex;
        for (int i = startIndex; i < endIndex; ++i) {
            char c2 = source.charAt(i);
            if (screened) {
                if (c2 == oldQuote) {
                    buffer.deleteCharAt(bufferIndex - 1);
                } else {
                    ++bufferIndex;
                }
                screened = false;
                continue;
            }
            if (c2 == '\\') {
                screened = true;
            } else if (c2 == newQuote) {
                buffer.insert(bufferIndex++, '\\');
            }
            ++bufferIndex;
        }
        StringBuilder stringBuilder = buffer;
        if (stringBuilder == null) {
            JSStringUtil.$$$reportNull$$$0(3);
        }
        return stringBuilder;
    }

    @NotNull
    public static String unescapeSimpleStringChars(@NotNull String chars) {
        if (chars == null) {
            JSStringUtil.$$$reportNull$$$0(4);
        }
        int index = 0;
        StringBuilder outChars = new StringBuilder(chars.length());
        while (index < chars.length()) {
            char c2 = chars.charAt(index);
            ++index;
            if (c2 != '\\') {
                outChars.append(c2);
                continue;
            }
            if (index >= chars.length()) break;
            c2 = chars.charAt(index);
            ++index;
            if (c2 == 'u' || c2 == 'x' || '0' <= c2 && c2 <= '9') {
                outChars.append('\\').append(c2);
                continue;
            }
            outChars.append(switch (c2) {
                case 'b' -> '\b';
                case 't' -> '\t';
                case '\n', 'n' -> '\n';
                case 'f' -> '\f';
                case 'r' -> '\r';
                case '\"' -> '\"';
                case '/' -> '/';
                case '\'' -> '\'';
                case '\\' -> '\\';
                default -> c2;
            });
        }
        String string = outChars.toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(5);
        }
        return string;
    }

    public static String escapeTemplateStringChars(@NotNull String source, boolean escapeSlash, boolean escapeWhitespace, @NotNull PsiElement context2) {
        if (source == null) {
            JSStringUtil.$$$reportNull$$$0(6);
        }
        if (context2 == null) {
            JSStringUtil.$$$reportNull$$$0(7);
        }
        StringBuilder result2 = new StringBuilder();
        int index = 0;
        while (index < source.length()) {
            char ch = source.charAt(index);
            if (ch == '$' && index < source.length() - 1 && source.charAt(index + 1) == '{' && (index == 0 || source.charAt(index - 1) != '/')) {
                int end = JSStringUtil.findTemplateArgumentEnd(source, index + 2, context2);
                result2.append(source, index, end);
                index = end;
                continue;
            }
            JSStringUtil.escapeSingleChar(source, '`', escapeSlash, false, escapeWhitespace, false, result2, index);
            ++index;
        }
        return result2.toString();
    }

    private static int findTemplateArgumentEnd(@NotNull String source, int startIndex, @NotNull PsiElement context2) {
        if (source == null) {
            JSStringUtil.$$$reportNull$$$0(8);
        }
        if (context2 == null) {
            JSStringUtil.$$$reportNull$$$0(9);
        }
        DialectOptionHolder dialect = (DialectOptionHolder)ObjectUtils.coalesce((Object)DialectDetector.dialectOfElement(context2), (Object)JavaScriptSupportLoader.ECMA_SCRIPT_6.getOptionHolder());
        JSFlexAdapter lexer = new JSFlexAdapter(dialect);
        lexer.start(source, startIndex, source.length());
        int depth = 0;
        while (lexer.getTokenType() != null) {
            if (lexer.getTokenType() == JSTokenTypes.DOLLAR) {
                lexer.advance();
                if (lexer.getTokenType() == JSTokenTypes.LBRACE) {
                    ++depth;
                }
            } else if (lexer.getTokenType() == JSTokenTypes.LBRACE) {
                ++depth;
            } else if (lexer.getTokenType() == JSTokenTypes.RBRACE && --depth == -1) {
                return lexer.getTokenEnd();
            }
            lexer.advance();
        }
        return source.length();
    }

    public static void escapeSimpleStringChars(@NotNull String str, char quote, boolean escapeNewlines, boolean escapeWhitespace, boolean escapeTemplateStringArg, @NotNull StringBuilder buffer) {
        if (str == null) {
            JSStringUtil.$$$reportNull$$$0(10);
        }
        if (buffer == null) {
            JSStringUtil.$$$reportNull$$$0(11);
        }
        for (int idx = 0; idx < str.length(); ++idx) {
            JSStringUtil.escapeSingleChar(str, quote, true, escapeNewlines, escapeWhitespace, escapeTemplateStringArg, buffer, idx);
        }
    }

    private static void escapeSingleChar(@NotNull String str, char quote, boolean escapeSlash, boolean escapeNewlines, boolean escapeWhitespace, boolean escapeTemplateStringArg, @NotNull StringBuilder buffer, int idx) {
        char previous;
        if (str == null) {
            JSStringUtil.$$$reportNull$$$0(12);
        }
        if (buffer == null) {
            JSStringUtil.$$$reportNull$$$0(13);
        }
        char ch = str.charAt(idx);
        char c2 = previous = idx > 0 ? str.charAt(idx - 1) : (char)'\u0000';
        if (escapeSlash && ch == '\\') {
            char afterNext;
            char next = idx < str.length() - 1 ? str.charAt(idx + 1) : (char)'\u0000';
            char c3 = afterNext = idx < str.length() - 2 ? str.charAt(idx + 2) : (char)'\u0000';
            if ((next == 'u' || next == 'x') && StringUtil.isHexDigit((char)afterNext)) {
                buffer.append('\\');
            } else {
                buffer.append("\\\\");
            }
        } else if (ch == quote) {
            if (previous != '\\') {
                buffer.append("\\");
            }
            buffer.append(ch);
        } else if (escapeTemplateStringArg && ch == '{') {
            if (previous == '$') {
                buffer.append("\\").append(ch);
            } else {
                buffer.append(ch);
            }
        } else {
            if (escapeWhitespace) {
                if (ch == '\b') {
                    buffer.append("\\b");
                    return;
                }
                if (ch == '\t') {
                    buffer.append("\\t");
                    return;
                }
                if (ch == '\f') {
                    buffer.append("\\f");
                    return;
                }
                if (ch == '\r') {
                    buffer.append("\\r");
                    return;
                }
            }
            if (escapeNewlines && ch == '\n') {
                buffer.append("\\n");
                return;
            }
            buffer.append(ch);
        }
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteAndUnescapeString(@NotNull String s) {
        if (s == null) {
            JSStringUtil.$$$reportNull$$$0(14);
        }
        return JSStringUtil.unquoteString(s, true);
    }

    @Contract(pure=true)
    @NotNull
    private static String unquoteString(@NotNull String s, boolean unescape) {
        if (s == null) {
            JSStringUtil.$$$reportNull$$$0(15);
        }
        if (StringUtil.isQuotedString((String)s)) {
            String unquotedString = s.substring(1, s.length() - 1);
            String string = unescape ? JSStringUtil.unescapeStringLiteralValue(unquotedString) : unquotedString;
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(16);
            }
            return string;
        }
        String string = unescape ? JSStringUtil.replaceUnicodeEscapeSequences(s) : s;
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteAndUnescapeStringLiteralValue(@NotNull String quotedString) {
        if (quotedString == null) {
            JSStringUtil.$$$reportNull$$$0(18);
        }
        return JSStringUtil.unquoteAndUnescapeStringLiteralValue(quotedString, true);
    }

    public static boolean isStartedWithQuote(@Nullable CharSequence text2) {
        return StringUtil.startsWithChar((CharSequence)text2, (char)'\"') || StringUtil.startsWithChar((CharSequence)text2, (char)'\'');
    }

    public static boolean isStartedWithQuoteOrBackquote(@Nullable CharSequence text2) {
        return JSStringUtil.isStartedWithQuote(text2) || StringUtil.startsWithChar((CharSequence)text2, (char)'`');
    }

    public static String replaceUnicodeEscapeSequences(@NotNull String text2) {
        if (text2 == null) {
            JSStringUtil.$$$reportNull$$$0(19);
        }
        if (!text2.contains("\\u")) {
            return text2;
        }
        text2 = StringUtil.replaceUnicodeEscapeSequences((String)text2);
        Matcher matcher = EXT_UNICODE_CHAR.matcher(text2);
        int lastEnd = 0;
        StringBuilder sb = new StringBuilder(text2.length());
        while (matcher.find()) {
            sb.append(text2, lastEnd, matcher.start());
            String item = matcher.group().substring(3);
            item = item.substring(0, item.length() - 1);
            try {
                char c2 = (char)Integer.parseInt(item, 16);
                sb.append(c2);
                lastEnd = matcher.end();
            }
            catch (NumberFormatException ex) {
                return text2;
            }
        }
        sb.append(text2.substring(lastEnd));
        return sb.toString();
    }

    @Contract(pure=true)
    @NotNull
    public static String unquoteStringLiteralValue(@NotNull String quotedString) {
        if (quotedString == null) {
            JSStringUtil.$$$reportNull$$$0(20);
        }
        return JSStringUtil.unquoteAndUnescapeStringLiteralValue(quotedString, false);
    }

    @Contract(pure=true)
    @NotNull
    private static String unquoteAndUnescapeStringLiteralValue(@NotNull String quotedString, boolean unescape) {
        char firstChar;
        if (quotedString == null) {
            JSStringUtil.$$$reportNull$$$0(21);
        }
        if (!(StringUtil.isQuotedString((String)quotedString) || quotedString.length() <= 0 || (firstChar = quotedString.charAt(0)) != '\"' && firstChar != '\'')) {
            String unquotedString = quotedString.substring(1);
            String string = unescape ? JSStringUtil.unescapeStringLiteralValue(unquotedString) : unquotedString;
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(22);
            }
            return string;
        }
        return JSStringUtil.unquoteString(quotedString, unescape);
    }

    @Contract(pure=true)
    @NotNull
    public static String unescapeStringLiteralValue(@NotNull String value) {
        String unescaped;
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(23);
        }
        if (!StringUtil.containsChar((String)(unescaped = JSStringUtil.unescapeSimpleStringChars(value)), (char)'\\')) {
            String string = unescaped;
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(24);
            }
            return string;
        }
        StringBuilder builder2 = new StringBuilder();
        JSStringLiteralEscaper.parseStringCharacters((String)value, (StringBuilder)builder2, null, (boolean)false, (boolean)false);
        String string = builder2.toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(25);
        }
        return string;
    }

    public static String unquoteWithoutUnescapingStringLiteralValue(String value) {
        int length = value.length();
        if (length < 2) {
            return value;
        }
        char firstChar = value.charAt(0);
        if (firstChar != '\'' && firstChar != '\"' && firstChar != '`') {
            return value;
        }
        if (firstChar != value.charAt(length - 1)) {
            return value;
        }
        return value.substring(1, length - 1);
    }

    @Contract(pure=true)
    @NotNull
    public static TextRange getStringLiteralOrTemplateUnquotedRange(@NotNull String quotedString) {
        char firstChar;
        if (quotedString == null) {
            JSStringUtil.$$$reportNull$$$0(26);
        }
        if (quotedString.length() > 0 && ((firstChar = quotedString.charAt(0)) == '\'' || firstChar == '\"' || firstChar == '`')) {
            char lastChar;
            if (quotedString.length() > 1 && firstChar == (lastChar = quotedString.charAt(quotedString.length() - 1))) {
                return new TextRange(1, quotedString.length() - 1);
            }
            return new TextRange(1, quotedString.length());
        }
        TextRange textRange2 = TextRange.allOf((String)quotedString);
        if (textRange2 == null) {
            JSStringUtil.$$$reportNull$$$0(27);
        }
        return textRange2;
    }

    @Nullable
    public static Double parseNumericValue(@NotNull String value) {
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(28);
        }
        return JSStringUtil.parseNumericValue(value, 0, false);
    }

    @NotNull
    public static String wrapQualifiedNameComponent(@NotNull String name) {
        if (name == null) {
            JSStringUtil.$$$reportNull$$$0(29);
        }
        StringBuilder builder2 = new StringBuilder(name.length() + 2);
        JSStringUtil.appendWrappedQualifiedNameComponent(builder2, name);
        String string = builder2.toString();
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(30);
        }
        return string;
    }

    public static void appendWrappedQualifiedNameComponent(@NotNull StringBuilder builder2, @NotNull String name) {
        int i;
        if (builder2 == null) {
            JSStringUtil.$$$reportNull$$$0(31);
        }
        if (name == null) {
            JSStringUtil.$$$reportNull$$$0(32);
        }
        boolean hasUnquotedDot = false;
        char quote = '\u0000';
        boolean isEscaped = false;
        for (i = 0; i < name.length(); ++i) {
            if (isEscaped) continue;
            char c2 = name.charAt(i);
            if (quote == '\u0000') {
                if (!(c2 != '\"' && c2 != '\'' || i != 0 && name.charAt(i - 1) == '\\')) {
                    quote = c2;
                    continue;
                }
                if (c2 != '.') continue;
                hasUnquotedDot = true;
                break;
            }
            if (c2 == '\\') {
                isEscaped = true;
                continue;
            }
            if (c2 != '\"' && c2 != '\'' || quote != c2) continue;
            quote = '\u0000';
        }
        if (hasUnquotedDot || quote != '\u0000') {
            builder2.append('\"');
            for (i = 0; i < name.length(); ++i) {
                char ch = name.charAt(i);
                if (ch == '\\' || ch == '\"') {
                    builder2.append('\\');
                }
                builder2.append(ch);
            }
            builder2.append('\"');
        } else {
            builder2.append(name);
        }
    }

    @NotNull
    public static String unwrapQualifiedNameComponent(@NotNull String s) {
        if (s == null) {
            JSStringUtil.$$$reportNull$$$0(33);
        }
        if (s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            String body2 = s.substring(1, s.length() - 1);
            body2 = StringUtil.unescapeChar((String)body2, (char)'\"');
            String string = body2 = StringUtil.unescapeChar((String)body2, (char)'\\');
            if (string == null) {
                JSStringUtil.$$$reportNull$$$0(34);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            JSStringUtil.$$$reportNull$$$0(35);
        }
        return string;
    }

    @Nullable
    public static Double parseNumericValue(@NotNull String value, int startOffset, boolean allowPlus) {
        boolean signed;
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(36);
        }
        int offset = startOffset;
        int totalLength = value.length();
        if (totalLength == 0) {
            return null;
        }
        if (offset >= totalLength) {
            return null;
        }
        char sign = value.charAt(offset);
        boolean bl = signed = sign == '-' || allowPlus && sign == '+';
        if (signed && ++offset >= totalLength) {
            return null;
        }
        char ch0 = value.charAt(offset);
        if (Character.isDigit(ch0) || ch0 == '.') {
            char ch = ch0;
            StringBuilder builder2 = new StringBuilder();
            if (signed) {
                builder2.append(sign);
            }
            if (ch == '0') {
                if (++offset >= totalLength) {
                    return 0.0;
                }
                ch = value.charAt(offset);
                if (ch == '.') {
                    builder2.append("0");
                } else {
                    int radix;
                    switch (ch) {
                        case 'B': 
                        case 'b': {
                            radix = 2;
                            break;
                        }
                        case 'O': 
                        case 'o': {
                            radix = 8;
                            break;
                        }
                        case 'X': 
                        case 'x': {
                            radix = 16;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            radix = 8;
                            --offset;
                            break;
                        }
                        default: {
                            return 0.0;
                        }
                    }
                    ++offset;
                    double result2 = 0.0;
                    while (offset < totalLength) {
                        int digitValue;
                        if ((ch = value.charAt(offset++)) == '_') continue;
                        int n = '0' <= ch && ch <= '9' ? ch - 48 : ('a' <= ch && ch <= 'f' ? 10 + ch - 97 : (digitValue = 'A' <= ch && ch <= 'F' ? 10 + ch - 65 : -1));
                        if (digitValue < 0 || digitValue >= radix) break;
                        result2 = result2 * (double)radix + (double)digitValue;
                    }
                    if (sign == '-') {
                        result2 = -result2;
                    }
                    return result2;
                }
            }
            if (ch == '.') {
                if (++offset < totalLength) {
                    builder2.append(ch);
                    ch = value.charAt(offset);
                } else if (totalLength == 1) {
                    return null;
                }
            }
            boolean hadDot = false;
            boolean hadExp = false;
            while (Character.isDigit(ch)) {
                builder2.append(ch);
                if (++offset >= totalLength) break;
                ch = value.charAt(offset);
                if (ch == '_') {
                    if (++offset >= totalLength) break;
                    ch = value.charAt(offset);
                }
                if (!hadDot && ch == '.') {
                    builder2.append(ch);
                    if (++offset >= totalLength) break;
                    ch = value.charAt(offset);
                    hadDot = true;
                }
                if (hadExp || ch != 'e' && ch != 'E') continue;
                if (++offset >= totalLength) {
                    return JSStringUtil.parseDoubleSafely(builder2);
                }
                ch = value.charAt(offset);
                hadDot = true;
                hadExp = true;
                Character signChar = null;
                if (ch == '+' || ch == '-') {
                    signChar = Character.valueOf(ch);
                    if (++offset >= totalLength) break;
                    ch = value.charAt(offset);
                }
                if (!Character.isDigit(ch)) {
                    return JSStringUtil.parseDoubleSafely(builder2);
                }
                builder2.append("e");
                if (signChar == null) continue;
                builder2.append(signChar);
            }
            return JSStringUtil.parseDoubleSafely(builder2);
        }
        return null;
    }

    @Nullable
    public static Double parseDoubleSafely(CharSequence doubleStr) {
        String s = doubleStr.toString();
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static boolean isNumericValueStart(@NotNull String value, boolean allowPlus) {
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(37);
        }
        return JSStringUtil.isNumericValueStart(value, allowPlus, 0);
    }

    public static boolean isNumericValueStart(@NotNull String value, boolean allowPlus, int offset) {
        int length;
        if (value == null) {
            JSStringUtil.$$$reportNull$$$0(38);
        }
        if ((length = value.length()) <= offset) {
            return false;
        }
        int shift = offset;
        char ch0 = value.charAt(shift);
        if (ch0 == '-' || allowPlus && ch0 == '+') {
            if (length < shift + 2) {
                return false;
            }
            ch0 = value.charAt(shift + 1);
            ++shift;
        }
        if (Character.isDigit(ch0)) {
            return true;
        }
        if (length <= shift + 1) {
            return false;
        }
        char ch1 = value.charAt(shift + 1);
        return ch0 == '.' && Character.isDigit(ch1);
    }

    private static boolean numberMatchesByPrefix(String text2, String prefix1, String prefix2, boolean allowE) {
        if (StringUtil.containsChar((String)text2, (char)'.')) {
            return false;
        }
        if (!allowE && (StringUtil.containsChar((String)text2, (char)'e') || StringUtil.containsChar((String)text2, (char)'E'))) {
            return false;
        }
        return StringUtil.startsWith((CharSequence)text2, (CharSequence)prefix1) || StringUtil.startsWith((CharSequence)text2, (CharSequence)prefix2);
    }

    public static String toPascalCase(String str) {
        return NameCaseUtils.toPascalCase((String)str);
    }

    public static String toPascalCase(String str, boolean preserveConsecutiveUppercase) {
        return NameCaseUtils.toPascalCase((String)str, (boolean)preserveConsecutiveUppercase);
    }

    public static String toCamelCase(String str) {
        return NameCaseUtils.toCamelCase((String)str);
    }

    public static String toCamelCase(String str, boolean preserveConsecutiveUppercase) {
        return NameCaseUtils.toCamelCase((String)str, (boolean)preserveConsecutiveUppercase);
    }

    public static String toKebabCase(String str) {
        return NameCaseUtils.toKebabCase((String)str);
    }

    public static String toKebabCase(String str, boolean noHyphenBeforeDigit, boolean noHyphenBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        return NameCaseUtils.toKebabCase((String)str, (boolean)noHyphenBeforeDigit, (boolean)noHyphenBetweenDigitAndLowercase, (boolean)splitConsecutiveUppercase);
    }

    public static String toSnakeCase(String str) {
        return NameCaseUtils.toSnakeCase((String)str);
    }

    public static String toSnakeCase(String str, boolean noUnderscoreBeforeDigit, boolean noUnderscoreBetweenDigitAndLowercase, boolean splitConsecutiveUppercase) {
        return NameCaseUtils.toSnakeCase((String)str, (boolean)noUnderscoreBeforeDigit, (boolean)noUnderscoreBetweenDigitAndLowercase, (boolean)splitConsecutiveUppercase);
    }

    static {
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> "0".equals(s)), JSLiteralExpressionKind.DEC);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> "0n".equals(s)), JSLiteralExpressionKind.DEC_BIGINT);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> JSStringUtil.numberMatchesByPrefix(s, "0x", "0X", true)), JSLiteralExpressionKind.HEX);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> JSStringUtil.numberMatchesByPrefix(s, "0b", "0B", false)), JSLiteralExpressionKind.BIN);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> JSStringUtil.numberMatchesByPrefix(s, "0o", "0O", false)), JSLiteralExpressionKind.OCT);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> s.length() > 1 && s.charAt(0) == '0' && s.charAt(1) != '.'), JSLiteralExpressionKind.OBSOLETE_OCT);
        NUMERIC_MATCHERS.put((Condition<String>)((Condition)s -> !StringUtil.containsAnyChar((String)s, (String)".eE")), JSLiteralExpressionKind.DEC);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 23, 26, 28, 29, 31, 32, 33, 36, 37, 38 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSStringUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chars";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 14: 
            case 15: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotedString";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: 
            case 28: 
            case 36: 
            case 37: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotesInLiteralValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "changeQuotesInternal";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSStringUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeSimpleStringChars";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteString";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "unquoteAndUnescapeStringLiteralValue";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "unescapeStringLiteralValue";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getStringLiteralOrTemplateUnquotedRange";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapQualifiedNameComponent";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapQualifiedNameComponent";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unescapeSimpleStringChars";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "escapeTemplateStringChars";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findTemplateArgumentEnd";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "escapeSimpleStringChars";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "escapeSingleChar";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "unquoteAndUnescapeString";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "unquoteString";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "unquoteAndUnescapeStringLiteralValue";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "replaceUnicodeEscapeSequences";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "unquoteStringLiteralValue";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "unescapeStringLiteralValue";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getStringLiteralOrTemplateUnquotedRange";
                break;
            }
            case 28: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "parseNumericValue";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "wrapQualifiedNameComponent";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "appendWrappedQualifiedNameComponent";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "unwrapQualifiedNameComponent";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isNumericValueStart";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 18, 19, 20, 21, 23, 26, 28, 29, 31, 32, 33, 36, 37, 38 -> new IllegalArgumentException(string);
        };
    }
}

