/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.actionscript.ActionScriptStubElementTypes;
import com.intellij.lang.ecmascript6.ES6StubElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSEqualElementType;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.FlowJSStubElementTypes;
import com.intellij.lang.javascript.types.JSArgumentListElementType;
import com.intellij.lang.javascript.types.JSBlockStatementElementType;
import com.intellij.lang.javascript.types.JSBlockStatementElementTypeFactory;
import com.intellij.lang.javascript.types.JSCaseClauseElementType;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSDestructuringElementElementType;
import com.intellij.lang.javascript.types.JSDestructuringParameterElementType;
import com.intellij.lang.javascript.types.JSEmbeddedBlockElementType;
import com.intellij.lang.javascript.types.JSExpressionElementType;
import com.intellij.lang.javascript.types.JSFunctionPropertyElementType;
import com.intellij.lang.javascript.types.JSParameterElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.javascript.types.JSVariableElementType;
import com.intellij.lang.javascript.types.JSWhiteSpaceTokenType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.lang.typescript.TypeScriptStubElementTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;

public final class JSExtendedLanguagesTokenSetProvider {
    public static final TokenSet OUR_STUBBED_FILTER = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{ActionScriptStubElementTypes.ACTIONSCRIPT_CLASS, ActionScriptStubElementTypes.ACTIONSCRIPT_FUNCTION, JSStubElementTypes.ATTRIBUTE_LIST, ActionScriptStubElementTypes.ACTIONSCRIPT_ATTRIBUTE_LIST, ActionScriptStubElementTypes.INCLUDE_DIRECTIVE, JSStubElementTypes.ATTRIBUTE, JSStubElementTypes.PACKAGE_STATEMENT}), JSExtendedLanguagesTokenSetProvider.getClassTokenSet(), JSElementTypes.VAR_STATEMENTS});
    public static final TokenSet BLOCK_STATEMENTS = JSExtendedLanguagesTokenSetProvider.getBlockStatementsTokenSet();
    public static final TokenSet STATEMENTS = JSExtendedLanguagesTokenSetProvider.getStatementsTokenSet();
    public static final TokenSet CLASSES = JSExtendedLanguagesTokenSetProvider.getClassTokenSet();
    public static final TokenSet TYPESCRIPT_MODULES = TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.TYPESCRIPT_MODULE, TypeScriptStubElementTypes.IMPLICIT_MODULE});
    public static final TokenSet MODULES = TokenSet.orSet((TokenSet[])new TokenSet[]{TYPESCRIPT_MODULES, TokenSet.create((IElementType[])new IElementType[]{FlowJSStubElementTypes.FLOW_MODULE})});
    public static final TokenSet ES6_MODULE_IMPORTS_AND_EXPORTS = TokenSet.create((IElementType[])new IElementType[]{ES6StubElementTypes.EXPORT_DECLARATION, ES6StubElementTypes.IMPORT_DECLARATION, ES6StubElementTypes.EXPORT_DEFAULT_ASSIGNMENT, FlowJSStubElementTypes.DECLARE_EXPORT_DECLARATION});
    public static final TokenSet SOURCE_ELEMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{STATEMENTS, JSElementTypes.FUNCTION_DECLARATIONS, CLASSES, MODULES, ES6_MODULE_IMPORTS_AND_EXPORTS, TokenSet.create((IElementType[])new IElementType[]{ActionScriptStubElementTypes.NAMESPACE_DECLARATION, ActionScriptStubElementTypes.INCLUDE_DIRECTIVE, ActionScriptStubElementTypes.USE_NAMESPACE_DIRECTIVE, TypeScriptStubElementTypes.EXPORT_ASSIGNMENT, JSStubElementTypes.TYPESCRIPT_TYPE_ALIAS, ES6StubElementTypes.STATIC_BLOCK})});
    public static final TokenSet SCOPE_ELEMENTS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSElementTypes.FUNCTIONS, CLASSES, MODULES, TokenSet.create((IElementType[])new IElementType[]{TypeScriptStubElementTypes.OBJECT_TYPE, TypeScriptStubElementTypes.FUNCTION_TYPE, FlowJSStubElementTypes.FLOW_FUNCTION_TYPE})});
    public static final TokenSet ASSIGNMENT_OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.ASSIGNMENT_OPERATIONS, JSExtendedLanguagesTokenSetProvider.getEqualSignTokenSet()});
    public static final TokenSet OPERATIONS = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.OPERATIONS, JSExtendedLanguagesTokenSetProvider.getEqualSignTokenSet()});
    public static final TokenSet CASE_CLAUSES = JSExtendedLanguagesTokenSetProvider.getCaseClauseTokenSet();
    public static final TokenSet PROPERTIES = JSExtendedLanguagesTokenSetProvider.getPropertyTokenSet();
    public static final TokenSet PARAMETERS = JSExtendedLanguagesTokenSetProvider.getParametersTokenSet();
    public static final TokenSet VARIABLES = JSExtendedLanguagesTokenSetProvider.getVariablesTokenSet();
    public static final TokenSet ARGUMENT_LISTS = JSExtendedLanguagesTokenSetProvider.getArgumentListTokenSet();
    public static final TokenSet EXPRESSIONS = JSExtendedLanguagesTokenSetProvider.getExpressionsTokenSet();
    public static final TokenSet WHITE_SPACES = JSExtendedLanguagesTokenSetProvider.getWhiteSpacesTokenSet();
    public static final TokenSet MODULE_EMBEDDED_CONTENTS = TokenSet.forAllMatching(el -> {
        JSEmbeddedBlockElementType block;
        return el instanceof JSEmbeddedBlockElementType && (block = (JSEmbeddedBlockElementType)el).isModule();
    });
    public static final TokenSet EMBEDDED_CONTENTS = TokenSet.forAllMatching(el -> el instanceof JSEmbeddedBlockElementType);
    public static final TokenSet DESTRUCTURING_ELEMENTS = JSExtendedLanguagesTokenSetProvider.getDestructuringElementsTokenSet();
    public static final TokenSet INITIALIZER_OWNERS = TokenSet.orSet((TokenSet[])new TokenSet[]{VARIABLES, DESTRUCTURING_ELEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.EMPTY_EXPRESSION})});

    private static TokenSet getDestructuringElementsTokenSet() {
        return TokenSet.forAllMatching(t -> t instanceof JSDestructuringElementElementType || t instanceof JSDestructuringParameterElementType);
    }

    private static TokenSet getExpressionsTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.forAllMatching(t -> t instanceof JSExpressionElementType), JSElementTypes.EXPRESSIONS});
    }

    private static TokenSet getWhiteSpacesTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.PARSER_WHITE_SPACE_TOKENS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.XML_TAG_WHITE_SPACE, XmlTokenType.XML_REAL_WHITE_SPACE}), TokenSet.forAllMatching(type2 -> type2 instanceof JSWhiteSpaceTokenType)});
    }

    private static TokenSet getPropertyTokenSet() {
        return TokenSet.forAllMatching(type2 -> type2 instanceof JSPropertyElementType || type2 instanceof JSFunctionPropertyElementType);
    }

    private static TokenSet getClassTokenSet() {
        return TokenSet.forAllMatching(type2 -> type2 instanceof JSClassElementTypeBase || type2 == JSStubElementTypes.TYPESCRIPT_INTERFACE || type2 == JSStubElementTypes.TYPESCRIPT_ENUM);
    }

    private static TokenSet getCaseClauseTokenSet() {
        return TokenSet.forAllMatching(type2 -> type2 instanceof JSCaseClauseElementType);
    }

    private static TokenSet getParametersTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.forAllMatching(type2 -> type2 instanceof JSParameterElementType), TokenSet.create((IElementType[])new IElementType[]{JSStubElementTypes.DESTRUCTURING_PARAMETER, ActionScriptStubElementTypes.ACTIONSCRIPT_PARAMETER})});
    }

    private static TokenSet getVariablesTokenSet() {
        TokenSet extendedVariables = TokenSet.forAllMatching(type2 -> type2 instanceof JSVariableElementType);
        return TokenSet.orSet((TokenSet[])new TokenSet[]{extendedVariables, JSElementTypes.BODY_VARIABLES, PARAMETERS});
    }

    private static TokenSet getEqualSignTokenSet() {
        return TokenSet.forAllMatching(type2 -> type2 instanceof JSEqualElementType);
    }

    private static TokenSet getArgumentListTokenSet() {
        return TokenSet.forAllMatching(type2 -> type2 instanceof JSArgumentListElementType);
    }

    private static TokenSet getBlockStatementsTokenSet() {
        JSBlockStatementElementTypeFactory.INSTANCE.registerAll();
        return TokenSet.forAllMatching(type2 -> type2 instanceof JSBlockStatementElementType);
    }

    private static TokenSet getStatementsTokenSet() {
        return TokenSet.orSet((TokenSet[])new TokenSet[]{BLOCK_STATEMENTS, TokenSet.create((IElementType[])new IElementType[]{JSElementTypes.LABELED_STATEMENT, JSElementTypes.EMPTY_STATEMENT, JSElementTypes.IF_STATEMENT, JSElementTypes.CONTINUE_STATEMENT, JSElementTypes.BREAK_STATEMENT, JSElementTypes.WITH_STATEMENT, JSStubElementTypes.RETURN_STATEMENT, JSElementTypes.THROW_STATEMENT, JSElementTypes.TRY_STATEMENT, JSElementTypes.SWITCH_STATEMENT, JSElementTypes.FOR_IN_STATEMENT, JSElementTypes.FOR_STATEMENT, JSElementTypes.WHILE_STATEMENT, JSElementTypes.DOWHILE_STATEMENT, JSElementTypes.EXPRESSION_STATEMENT, JSStubElementTypes.IMPORT_STATEMENT, JSStubElementTypes.PACKAGE_STATEMENT, ActionScriptStubElementTypes.USE_NAMESPACE_DIRECTIVE, JSElementTypes.DEBUGGER_STATEMENT, TypeScriptElementTypes.IMPORT_STATEMENT}), JSElementTypes.VAR_STATEMENTS});
    }
}

