/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.resolve;

import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.ecmascript6.resolve.ES6ModuleExportsProvider;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSModuleElementsProcessor;
import com.intellij.lang.ecmascript6.resolve.JSModuleExportsProvider;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J \u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\bH\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/lang/ecmascript6/resolve/ES6ModuleExportsProvider;", "Lcom/intellij/lang/ecmascript6/resolve/JSModuleExportsProvider;", "()V", "getAdditionalScopes", "", "Lcom/intellij/psi/PsiElement;", "scope", "isModuleLike", "", "processExports", "processor", "Lcom/intellij/lang/ecmascript6/resolve/JSModuleElementsProcessor;", "weak", "intellij.javascript.psi.impl"})
final class ES6ModuleExportsProvider
implements JSModuleExportsProvider {
    @Override
    public boolean processExports(@NotNull PsiElement scope2, @NotNull JSModuleElementsProcessor processor, boolean weak) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        if (scope2 instanceof JSClass && DialectDetector.isTypeScript(scope2)) {
            return JSStubBasedPsiTreeUtil.processDeclarationsInScope(scope2, processor, false);
        }
        if (!this.isModuleLike(scope2)) {
            return true;
        }
        ES6PsiUtil.ES6ExportedElementsProcessor exportedElementsProcessor = new ES6PsiUtil.ES6ExportedElementsProcessor(processor);
        boolean processingResult = JSStubBasedPsiTreeUtil.processDeclarationsInScope(scope2, exportedElementsProcessor, false);
        Collection<JSElement> collection = ES6PsiUtil.findDefaultExports(scope2);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"findDefaultExports(...)");
        Collection<JSElement> defaults = collection;
        for (JSElement defaultExport : defaults) {
            if (!(defaultExport instanceof ES6ExportDefaultAssignment) || processor.execute((PsiElement)defaultExport, ResolveState.initial())) continue;
            processingResult = false;
        }
        return processingResult;
    }

    private final boolean isModuleLike(PsiElement scope2) {
        return scope2 instanceof TypeScriptModule || ES6PsiUtil.isEmbeddedModule(scope2) || scope2 instanceof JSFile;
    }

    @Override
    @NotNull
    public Collection<PsiElement> getAdditionalScopes(@NotNull PsiElement scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        if (!ES6PsiUtil.isExternalModule(scope2) || !(scope2 instanceof JSElement)) {
            return CollectionsKt.emptyList();
        }
        Object[] children = JSStubBasedPsiTreeUtil.getChildrenByType(scope2, ES6PsiUtil.DECLARATIONS);
        Intrinsics.checkNotNull((Object)children);
        return SequencesKt.toList((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])children), (Function1)getAdditionalScopes.1.INSTANCE)));
    }
}

