/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.lang.ecmascript6.actions.JSImportDescriptorBuilder;
import com.intellij.lang.ecmascript6.psi.ES6FromClause;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSCrossLocalPackageImports;
import com.intellij.lang.ecmascript6.psi.impl.JSDefaultImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.JSImportDescriptorProcessor;
import com.intellij.lang.ecmascript6.psi.impl.JSImportPathConfiguration;
import com.intellij.lang.ecmascript6.psi.impl.JSLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.JSReferenceProject;
import com.intellij.lang.ecmascript6.psi.impl.JSSymlinkLinkedProject;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSStringUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.config.JSConfig;
import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.graph.JSImportGraph;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSDirectorySearchProcessor;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathMappings;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitution;
import com.intellij.lang.javascript.frameworks.modules.JSModulePathSubstitutionImpl;
import com.intellij.lang.javascript.frameworks.modules.JSModulePattern;
import com.intellij.lang.javascript.frameworks.modules.JSPathMappingsUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.JSModuleDescriptorFactory;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.modules.JSNodeModuleStructure;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.lang.javascript.modules.imports.JSImportDescriptor;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.JSImportedElementDescriptor;
import com.intellij.lang.javascript.modules.imports.JSModuleDescriptor;
import com.intellij.lang.javascript.modules.imports.JSSimpleImportDescriptor;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptNodeSearchProcessor;
import com.intellij.lang.typescript.modules.TypeScriptTypingsMapper;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsFactory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.io.File;
import java.nio.file.InvalidPathException;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public abstract class JSImportPathBuilder {
    private static final Logger LOGGER = Logger.getInstance(JSImportPathBuilder.class);
    @NotNull
    private final NodeModuleDirectorySearchProcessor mySearchProcessor;
    @NotNull
    protected final PsiElement myElementToImport;
    @NotNull
    protected final PsiElement myPlaceModule;
    @NotNull
    protected final VirtualFile myPlaceModuleFile;
    @NotNull
    protected final VirtualFile myFileToImport;
    @NotNull
    protected final Project myProject;
    @Nullable
    protected final JSConfig myConfigFile;
    @NotNull
    private final @NotNull String @NotNull [] myExtensions;
    @NotNull
    protected final JSImportPathConfiguration myConfiguration;
    @NotNull
    private final JSImportExportType myImportType;
    @Nullable
    private final String myImportedName;
    @NotNull
    private final ES6ImportExportDeclaration.ImportExportPrefixKind myImportPrefix;

    protected JSImportPathBuilder(@NotNull JSImportPathConfiguration configuration) {
        if (configuration == null) {
            JSImportPathBuilder.$$$reportNull$$$0(0);
        }
        this.myConfiguration = configuration;
        PsiElement place = this.myConfiguration.getPlace();
        this.myProject = place.getProject();
        String[] extensions = (String[])ArrayUtil.copyOf((Object[])configuration.extensions());
        Arrays.sort(extensions, Comparator.comparing(el -> -el.length()));
        this.myExtensions = extensions;
        PsiFile originalFile = place.getContainingFile().getOriginalFile();
        PsiElement originalElement = CompletionUtil.getOriginalElement((PsiElement)place);
        if (originalElement == null) {
            originalElement = originalFile;
        }
        this.myPlaceModule = ES6PsiUtil.isExternalModule(originalElement) ? originalElement : (PsiElement)ObjectUtils.coalesce((Object)((PsiElement)ObjectUtils.doIfNotNull((Object)ES6PsiUtil.findExternalModule(place), CompletionUtil::getOriginalElement)), (Object)originalFile);
        this.myPlaceModuleFile = this.myPlaceModule.getContainingFile().getVirtualFile();
        this.myFileToImport = configuration.getFileToImport();
        this.myElementToImport = configuration.getElementToImport();
        JSImportExportType candidateType = JSImportDescriptorBuilder.getImportType(this.myElementToImport, this.myPlaceModule);
        this.myImportType = (JSImportExportType)ObjectUtils.coalesce((Object)candidateType, (Object)ES6ImportPsiUtil.ImportExportType.BARE);
        this.myImportedName = configuration.getImportedName();
        this.mySearchProcessor = DialectDetector.isTypeScript(this.myPlaceModule) ? new TypeScriptNodeSearchProcessor(extensions) : new NodeModuleDirectorySearchProcessor(extensions);
        this.myConfigFile = configuration.getConfig();
        this.myImportPrefix = JSImportDescriptorBuilder.detectPrefixKind(this.myElementToImport, place);
    }

    @NotNull
    public static JSImportPathBuilder createBuilder(@NotNull JSImportPathConfiguration configuration) {
        if (configuration == null) {
            JSImportPathBuilder.$$$reportNull$$$0(1);
        }
        PsiElement place = configuration.getPlace();
        PsiElement toImport = configuration.getElementToImport();
        if (DialectDetector.isTypeScript(place) || DialectDetector.isTypeScript(toImport)) {
            return new TypeScriptImportPathBuilder(configuration);
        }
        return new JSDefaultImportPathBuilder(configuration);
    }

    protected boolean processRootPaths(@NotNull JSImportedElementDescriptor importedDescriptor, @NotNull JSImportDescriptorProcessor processor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        String rootPath;
        if (importedDescriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(3);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(4);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(5);
        }
        if ((rootPath = this.getPathRelativeToRoots(moduleFileOrDirectory)) != null) {
            JSModuleDescriptor moduleDescriptor = this.createModuleDescriptor(rootPath, moduleFileOrDirectory, resolvedModuleFile);
            return this.processDescriptorAndContributors(processor, new JSSimpleImportDescriptor(moduleDescriptor, importedDescriptor));
        }
        return true;
    }

    @NotNull
    protected final JSModuleDescriptor createModuleDescriptor(@NotNull String rootPath, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        if (rootPath == null) {
            JSImportPathBuilder.$$$reportNull$$$0(6);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(7);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(8);
        }
        return this.createModuleDescriptor(rootPath, moduleFileOrDirectory, resolvedModuleFile, this.myConfiguration.getPathSettings());
    }

    @NotNull
    protected final JSModuleDescriptor createModuleDescriptor(@NotNull String rootPath, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile, @NotNull JSModuleNameInfo.ExtensionSettings settings2) {
        if (rootPath == null) {
            JSImportPathBuilder.$$$reportNull$$$0(9);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(10);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(11);
        }
        if (settings2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(12);
        }
        JSModuleDescriptor jSModuleDescriptor = JSModuleDescriptorFactory.createModuleDescriptor(rootPath, moduleFileOrDirectory, resolvedModuleFile, this.myPlaceModule, this.myExtensions, settings2);
        if (jSModuleDescriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(13);
        }
        return jSModuleDescriptor;
    }

    public final void processDirectModuleNames(boolean checkDirectoryImports, @NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(14);
        }
        this.processDirectImportDescriptors(checkDirectoryImports, JSImportDescriptorProcessor.createModuleInfoProcessor(processor, this.myImportType));
    }

    protected final boolean processDirectImportDescriptors(boolean checkDirectoryImports, @NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(15);
        }
        if (checkDirectoryImports) {
            if (!this.processForRelatedProjects(processor)) {
                return false;
            }
            if (!this.processModuleFileUsingParentDirectories(processor)) {
                return false;
            }
        }
        return this.processForModuleFile(processor, this.getInfoElementToImport(), this.myFileToImport, this.myFileToImport);
    }

    protected boolean processForRelatedProjects(@NotNull JSImportDescriptorProcessor processor) {
        String pathFromImportRoot;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(16);
        }
        if (this.myFileToImport.isDirectory() || NodeModuleUtil.hasNodeModulesDirInPath(this.myFileToImport, ProjectUtil.guessProjectDir((Project)this.myProject))) {
            return true;
        }
        VirtualFile placeRoot = this.myConfiguration.getPlaceRoot();
        if (placeRoot == null) {
            return true;
        }
        VirtualFile importRoot = this.myConfiguration.getImportedFileRoot();
        if (importRoot == null || placeRoot.equals(importRoot)) {
            return true;
        }
        VirtualFile importPackageJson = PackageJsonUtil.findChildPackageJsonFile(importRoot);
        if (importPackageJson == null) {
            return true;
        }
        VirtualFile commonParent = VfsUtilCore.getCommonAncestor((VirtualFile)placeRoot, (VirtualFile)importRoot);
        if (commonParent == null || importRoot.equals(commonParent)) {
            return true;
        }
        PackageJsonData importData = PackageJsonData.getOrCreate(importPackageJson);
        String importPackageName = importData.getName();
        if (importPackageName == null) {
            importPackageName = importRoot.getName();
        }
        if ((pathFromImportRoot = VfsUtilCore.getRelativePath((VirtualFile)this.myFileToImport, (VirtualFile)importRoot)) == null) {
            return true;
        }
        VirtualFile placeRootPackageJson = placeRoot.findChild("package.json");
        JSLinkedProject project = this.getLinkedProject(importRoot, placeRootPackageJson, importPackageName);
        return this.processLinkedProject(processor, project);
    }

    private boolean processLinkedProject(@NotNull JSImportDescriptorProcessor processor, @Nullable JSLinkedProject linkedProject) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(17);
        }
        if (linkedProject == null) {
            return true;
        }
        VirtualFile importRoot = linkedProject.getSourceRoot();
        if (!this.processLinkedProjectRoot(processor, linkedProject, importRoot)) {
            return false;
        }
        return this.processHierarchy(importRoot, (candidate, resolvedFile, descriptor) -> {
            String path2 = linkedProject.getLinkedPath(candidate);
            if (path2 == null) {
                return true;
            }
            return this.processDescriptorAndContributors(processor, new JSSimpleImportDescriptor(this.createModuleDescriptor(path2, candidate, resolvedFile), descriptor));
        });
    }

    private boolean processLinkedProjectRoot(@NotNull JSImportDescriptorProcessor processor, @NotNull JSLinkedProject linkedProject, @NotNull VirtualFile importRoot) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(18);
        }
        if (linkedProject == null) {
            JSImportPathBuilder.$$$reportNull$$$0(19);
        }
        if (importRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(20);
        }
        for (VirtualFile packageResolveFile : this.resolveFileAsNpmPackage(linkedProject.getLinkedPackageRoot())) {
            ResolvedElement resolved;
            VirtualFile sourceFile;
            if (packageResolveFile == null || (sourceFile = linkedProject.getSourceFileByLinkedFile(packageResolveFile)) == null || (resolved = this.checkSymbolIn(sourceFile)) == null) continue;
            JSModuleDescriptor info2 = this.createModuleDescriptor(linkedProject.getPackageName(), importRoot, sourceFile);
            for (JSImportedElementDescriptor descriptor : resolved.importedDescriptors) {
                if (this.processDescriptorAndContributors(processor, new JSSimpleImportDescriptor(info2, descriptor))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processModuleFileUsingParentDirectories(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(21);
        }
        VirtualFile importDirectory = this.myFileToImport.getParent();
        VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)this.myProject).getContentRootForFile(importDirectory);
        if (VfsUtilCore.isAncestor((VirtualFile)importDirectory, (VirtualFile)this.myPlaceModuleFile, (boolean)true)) {
            return true;
        }
        VirtualFile placeDirectory = this.myPlaceModuleFile.getParent();
        if (placeDirectory == null) {
            return true;
        }
        return this.iterateParentDirectories(processor, importDirectory, placeDirectory, sourceRoot);
    }

    private boolean iterateParentDirectories(@NotNull JSImportDescriptorProcessor processor, @NotNull VirtualFile toIterateDirectory, @NotNull VirtualFile placeDirectory, @Nullable VirtualFile stopDir) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(22);
        }
        if (toIterateDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(23);
        }
        if (placeDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(24);
        }
        List<VirtualFile> parent = JSImportPathBuilder.getParentsNoOverlapInHierarchy(toIterateDirectory, placeDirectory, stopDir);
        return this.processElements(ContainerUtil.reverse(parent), (candidate, resolved, descriptor) -> this.processForModuleFile(processor, descriptor, candidate, resolved));
    }

    @NotNull
    private static List<VirtualFile> getParentsNoOverlapInHierarchy(VirtualFile toIterateDirectory, @NotNull VirtualFile placeDirectory, @Nullable VirtualFile stopDir) {
        if (placeDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(25);
        }
        SmartList parent = new SmartList();
        while (!(toIterateDirectory == null || stopDir != null && stopDir.equals(toIterateDirectory) || VfsUtilCore.isAncestor((VirtualFile)toIterateDirectory, (VirtualFile)placeDirectory, (boolean)false))) {
            parent.add(toIterateDirectory);
            toIterateDirectory = toIterateDirectory.getParent();
        }
        SmartList smartList = parent;
        if (smartList == null) {
            JSImportPathBuilder.$$$reportNull$$$0(26);
        }
        return smartList;
    }

    private boolean processForModuleFile(@NotNull JSImportDescriptorProcessor processor, @NotNull JSImportedElementDescriptor importedDescriptor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        Set<VirtualFile> roots;
        VirtualFile commonParent;
        JSModuleDescriptor info2;
        JSSimpleImportDescriptor descriptor;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(27);
        }
        if (importedDescriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(28);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(29);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(30);
        }
        if (!this.processWithContributors(processor, descriptor = new JSSimpleImportDescriptor(info2 = this.buildInfoForModuleFile(moduleFileOrDirectory, resolvedModuleFile), importedDescriptor))) {
            return false;
        }
        if (this.myConfiguration.isProcessRootPaths() && !this.processRootPaths(importedDescriptor, processor, moduleFileOrDirectory, resolvedModuleFile)) {
            return false;
        }
        VirtualFile importedRoot = this.myConfiguration.getImportedFileRoot();
        VirtualFile placeRoot = this.myConfiguration.getPlaceRoot();
        if (!(importedRoot == null || placeRoot == null || placeRoot.equals(commonParent = VfsUtilCore.getCommonAncestor((VirtualFile)importedRoot, (VirtualFile)placeRoot)) || importedRoot.equals(commonParent) || (roots = JSCrossLocalPackageImports.Companion.detectRelatedRoots(this.myProject, placeRoot)).contains(importedRoot))) {
            return true;
        }
        return processor.processDescriptor(descriptor);
    }

    @NotNull
    private JSModuleDescriptor buildInfoForModuleFile(VirtualFile moduleFileOrDirectory, VirtualFile resolvedModuleFile) {
        Object externalModuleName = VfsUtilCore.findRelativePath((VirtualFile)this.myPlaceModuleFile, (VirtualFile)moduleFileOrDirectory, (char)'/');
        if (externalModuleName == null) {
            externalModuleName = VfsUtilCore.findRelativePath((VirtualFile)this.myPlaceModuleFile, (VirtualFile)this.myFileToImport, (char)'/');
            if (externalModuleName == null) {
                externalModuleName = this.myFileToImport.getName();
            }
            moduleFileOrDirectory = this.myFileToImport;
            resolvedModuleFile = this.myFileToImport;
        }
        if (!((String)externalModuleName).startsWith(".") && !((String)externalModuleName).startsWith(File.separator)) {
            externalModuleName = "./" + (String)externalModuleName;
        }
        return this.createModuleDescriptor((String)externalModuleName, moduleFileOrDirectory, resolvedModuleFile);
    }

    protected final boolean processWithContributors(@NotNull JSImportDescriptorProcessor processor, @NotNull JSImportDescriptor descriptor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(31);
        }
        if (descriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(32);
        }
        for (JSModuleReferenceContributor contributor : JSModuleReferenceContributor.getSortedExtensions()) {
            ProgressManager.checkCanceled();
            if (!contributor.isApplicable(this.myPlaceModule)) continue;
            List<JSImportDescriptor> candidates = contributor.getAdditionalDescriptors(this.myConfiguration, descriptor);
            for (JSImportDescriptor candidate : candidates) {
                if (candidate.equals(descriptor) || processor.processDescriptor(candidate)) continue;
                return false;
            }
        }
        return this.processTypingsVersion(processor, descriptor);
    }

    protected final boolean processTypingsVersion(@NotNull JSImportDescriptorProcessor processor, @NotNull JSImportDescriptor descriptor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(33);
        }
        if (descriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(34);
        }
        if (JSFileReferencesUtil.isRelative(descriptor.getModuleName()) || !TypeScriptUtil.isDefinitionFile(this.myFileToImport)) {
            return true;
        }
        VirtualFile importedRoot = this.myConfiguration.getImportedFileRoot();
        if (importedRoot == null || importedRoot.equals(this.myConfiguration.getPlaceRoot())) {
            return true;
        }
        VirtualFile packageJsonFile = PackageJsonUtil.findChildPackageJsonFile(importedRoot);
        if (packageJsonFile == null) {
            return true;
        }
        PackageJsonData data = PackageJsonData.getOrCreate(packageJsonFile);
        if (!data.hasTypings()) {
            return true;
        }
        Map<String, JSModulePathMappings<JSModulePathSubstitution>> typingsMappings = data.getTypingsVersionMappings();
        if (typingsMappings.isEmpty()) {
            return true;
        }
        String currentName = data.getName();
        if (currentName == null) {
            return true;
        }
        String name = ES6CreateImportUtil.convertAtTypesToOriginalName(currentName);
        SemVer tsVersion = TypeScriptTypingsMapper.detectTypeScriptVersion(importedRoot, true);
        boolean hasMatched = false;
        for (Map.Entry<String, JSModulePathMappings<JSModulePathSubstitution>> entry : typingsMappings.entrySet()) {
            String key2 = entry.getKey();
            JSModulePathMappings<JSModulePathSubstitution> pathsMappings = entry.getValue();
            boolean lowPriority = true;
            if (!hasMatched && tsVersion != null && new TypeScriptTypingsMapper.TypeScriptRange(key2).isMatched(tsVersion)) {
                hasMatched = true;
                lowPriority = false;
            }
            List newSubstitutions = ContainerUtil.flatMap(pathsMappings.getSubstitutions(), sub -> {
                String pattern = sub.getPattern();
                Collection<String> mappings = sub.getMappings();
                ArrayList<JSModulePathSubstitutionImpl> result2 = new ArrayList<JSModulePathSubstitutionImpl>();
                if (pattern.equals("*")) {
                    List newMappings = ContainerUtil.map(mappings, el -> el.replace("*", ""));
                    result2.add(new JSModulePathSubstitutionImpl(name, newMappings));
                }
                if (!sub.isExact()) {
                    result2.add(new JSModulePathSubstitutionImpl(name + "/" + pattern, mappings));
                }
                return result2;
            });
            for (JSImportDescriptor candidate : this.getMappingsForBaseUrl(importedRoot, JSModulePathMappings.build(newSubstitutions))) {
                if (candidate.equals(descriptor) || processor.processDescriptor(candidate = !lowPriority ? candidate : new JSSimpleImportDescriptor(candidate.getModuleDescriptor(), (JSImportedElementDescriptor)candidate){

                    @Override
                    public int getPriority() {
                        return 0;
                    }
                })) continue;
                return false;
            }
        }
        return JSImportPathBuilder.processDefaultTypingsField(processor, descriptor, importedRoot, data, name, hasMatched);
    }

    private static boolean processDefaultTypingsField(@NotNull JSImportDescriptorProcessor processor, @NotNull JSImportDescriptor descriptor, VirtualFile importedRoot, PackageJsonData data, String name, final boolean hasMatched) {
        String defaultTypings;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(35);
        }
        if (descriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(36);
        }
        if ((defaultTypings = data.getTypings()) != null) {
            VirtualFile candidate = importedRoot.findFileByRelativePath(defaultTypings);
            JSModuleDescriptor moduleDescriptor = descriptor.getModuleDescriptor();
            if (moduleDescriptor instanceof JSModuleNameInfo && candidate != null && candidate.equals(((JSModuleNameInfo)moduleDescriptor).getResolvedFile())) {
                return processor.processDescriptor(new JSSimpleImportDescriptor(moduleDescriptor.getModule(), name, descriptor){

                    @Override
                    public int getPriority() {
                        return hasMatched ? 0 : 1;
                    }
                });
            }
        }
        return true;
    }

    protected final boolean processDescriptorAndContributors(@NotNull JSImportDescriptorProcessor processor, @NotNull JSImportDescriptor descriptor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(37);
        }
        if (descriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(38);
        }
        if (!this.processWithContributors(processor, descriptor)) {
            return false;
        }
        return processor.processDescriptor(descriptor);
    }

    public final void processDescriptorsWithModuleName(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(39);
        }
        this.processDescriptors(JSImportDescriptorProcessor.createModuleInfoProcessor(processor, this.myImportType));
    }

    public final void processModuleNames(@NotNull Processor<? super JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(40);
        }
        this.processDescriptors(JSImportDescriptorProcessor.moduleInfoWrapper(processor, this.myImportType));
    }

    public final void processDescriptors(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(41);
        }
        if (this.myElementToImport instanceof TypeScriptModule && ((TypeScriptModule)this.myElementToImport).isExternal()) {
            return;
        }
        if (!this.processExistingImports(processor)) {
            return;
        }
        if (!this.processModuleNameUsingPathMappings(processor)) {
            return;
        }
        this.processModuleNamesWithoutExistingImports(processor);
    }

    protected boolean processModuleNamesWithoutExistingImports(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(42);
        }
        if (!this.processModuleNameUsingNodeModules(processor)) {
            return false;
        }
        return this.processDirectImportDescriptors(true, processor);
    }

    protected boolean processExistingImports(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(43);
        }
        if (!this.myConfiguration.useExistingImports() || !(this.myElementToImport instanceof JSElement)) {
            return true;
        }
        VirtualFile elementToExportFile = this.myElementToImport.getContainingFile().getVirtualFile();
        boolean isLibraryFile = JSLibraryUtil.isProbableLibraryFile(elementToExportFile, this.myProject);
        List<ES6ImportDeclaration> declarations = ES6ImportPsiUtil.getImportDeclarations(this.myPlaceModule);
        HashSet<PsiElement> visitedModules = new HashSet<PsiElement>();
        block0: for (ES6ImportDeclaration declaration : declarations) {
            PsiElement object;
            ES6FromClause clause = declaration.getFromClause();
            Collection<Object> objects = clause == null ? Collections.emptyList() : clause.resolveReferencedElements();
            Iterator<Object> iterator = objects.iterator();
            while (iterator.hasNext() && visitedModules.add(object = (PsiElement)iterator.next())) {
                JSFile jsFile;
                VirtualFile virtualFile;
                if (!(object instanceof JSFile) || (virtualFile = (jsFile = (JSFile)object).getVirtualFile()) == null) continue;
                if (JSLibraryUtil.isProbableLibraryFile(virtualFile, this.myProject) != isLibraryFile) continue block0;
                Collection<JSImportedElementDescriptor> results = ES6CreateImportUtil.resolveSymbolInModule(this.myElementToImport, this.myPlaceModule, jsFile);
                String path2 = JSStringUtil.unquoteStringLiteralValue(StringUtil.notNullize((String)clause.getReferenceText()));
                for (JSImportedElementDescriptor descriptor : results) {
                    descriptor = this.normalizeNameForImportDescriptor(descriptor);
                    JSModuleDescriptor info2 = this.createModuleDescriptor(path2, virtualFile, virtualFile, JSModuleNameInfo.ExtensionSettings.EXACT);
                    JSSimpleImportDescriptor fixedDescriptor = new JSSimpleImportDescriptor(info2, descriptor);
                    if (processor.processDescriptor(fixedDescriptor)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @NotNull
    public static JSImportDescriptorProcessor createSearchProcessor(@NotNull Ref<? super JSImportDescriptor> ref, String @NotNull [] excludedNames) {
        if (ref == null) {
            JSImportPathBuilder.$$$reportNull$$$0(44);
        }
        if (excludedNames == null) {
            JSImportPathBuilder.$$$reportNull$$$0(45);
        }
        boolean hasExcludedNames = excludedNames.length > 0;
        HashSet<String> excludedNamesSet = hasExcludedNames ? new HashSet<String>() : Collections.emptySet();
        SmartList excludePatterns = hasExcludedNames ? new SmartList() : Collections.emptyList();
        for (String name : excludedNames) {
            excludedNamesSet.add(name);
            if (!name.contains("*")) continue;
            excludePatterns.add(name);
        }
        PathMatcher matcher = TypeScriptConfigUtil.getPathMatcher((Collection<String>)excludePatterns);
        JSImportDescriptorProcessor jSImportDescriptorProcessor = info2 -> {
            JSModuleDescriptor descriptor = info2.getModuleDescriptor();
            if (!hasExcludedNames || !JSImportPathBuilder.isExcludedName(excludedNamesSet, matcher, descriptor)) {
                if (ref.get() != null) {
                    LOGGER.error("Processor wasn't stop properly. Please make sure that all places use the returned value for stop");
                    return false;
                }
                ref.set((Object)info2);
                return false;
            }
            return true;
        };
        if (jSImportDescriptorProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(46);
        }
        return jSImportDescriptorProcessor;
    }

    @NotNull
    public static JSImportDescriptorProcessor createDefaultSearchProcessor(@NotNull Ref<JSImportDescriptor> ref, @NotNull JSImportPathBuilder builder2) {
        if (ref == null) {
            JSImportPathBuilder.$$$reportNull$$$0(47);
        }
        if (builder2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(48);
        }
        String[] excludedNames = JSCodeStyleSettings.getSettings(builder2.myPlaceModule).getBlacklistImports();
        return JSImportPathBuilder.createSearchProcessor(ref, excludedNames);
    }

    public static boolean isExcludedName(@NotNull Set<String> excludedNames, @Nullable PathMatcher matcher, @NotNull JSModuleDescriptor info2) {
        String path2;
        if (excludedNames == null) {
            JSImportPathBuilder.$$$reportNull$$$0(49);
        }
        if (info2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(50);
        }
        if (excludedNames.contains(path2 = info2.getModuleName())) {
            return true;
        }
        if (matcher == null || path2.contains("*") || path2.contains(":")) {
            return false;
        }
        try {
            return matcher.matches(Paths.get(path2, new String[0]));
        }
        catch (InvalidPathException e) {
            LOGGER.warn((Throwable)e);
            return false;
        }
    }

    @Nullable
    protected final ResolvedElement checkSymbolIn(@NotNull VirtualFile moduleFileOrDirectory) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(51);
        }
        if (moduleFileOrDirectory.equals(this.myFileToImport)) {
            return new ResolvedElement(moduleFileOrDirectory, moduleFileOrDirectory, Collections.singleton(this.getInfoElementToImport()));
        }
        Collection<VirtualFile> resolvedFiles = Collections.singleton(moduleFileOrDirectory);
        if (moduleFileOrDirectory.isDirectory()) {
            resolvedFiles = this.resolveFileAsNpmPackage(moduleFileOrDirectory);
        }
        if (resolvedFiles.isEmpty()) {
            return null;
        }
        VirtualFile candidate = (VirtualFile)ContainerUtil.find(resolvedFiles, el -> el.equals(this.myFileToImport));
        if (candidate != null) {
            if (!this.isDirectoryImportAvailable(candidate)) {
                moduleFileOrDirectory = candidate;
            }
            return new ResolvedElement(moduleFileOrDirectory, candidate, Collections.singleton(this.getInfoElementToImport()));
        }
        for (VirtualFile resolvedFile : resolvedFiles) {
            Collection<JSImportedElementDescriptor> descriptors = ES6CreateImportUtil.resolveSymbolInFile(this.myProject, resolvedFile, this.myElementToImport, this.myPlaceModule, this.myImportType != ES6ImportPsiUtil.ImportExportType.BARE);
            if (descriptors.isEmpty()) continue;
            if (!this.isDirectoryImportAvailable(resolvedFile)) {
                moduleFileOrDirectory = resolvedFile;
            }
            return new ResolvedElement(moduleFileOrDirectory, resolvedFile, ContainerUtil.map(descriptors, this::normalizeNameForImportDescriptor));
        }
        return null;
    }

    private boolean isDirectoryImportAvailable(@NotNull VirtualFile resolveCandidate) {
        String extension;
        if (resolveCandidate == null) {
            JSImportPathBuilder.$$$reportNull$$$0(52);
        }
        if ((extension = JSFileReferencesUtil.findExtension(resolveCandidate.getName(), this.myConfiguration.extensions())) == null) {
            return false;
        }
        return JSModuleDescriptorFactory.isDirectoryImportAvailable(this.myPlaceModule, extension);
    }

    @NotNull
    protected JSImportedElementDescriptor normalizeNameForImportDescriptor(@NotNull JSImportedElementDescriptor descriptor) {
        String name;
        if (descriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(53);
        }
        if (Objects.equals(name = descriptor.getImportedName(), this.myImportedName)) {
            JSImportedElementDescriptor jSImportedElementDescriptor = descriptor;
            if (jSImportedElementDescriptor == null) {
                JSImportPathBuilder.$$$reportNull$$$0(54);
            }
            return jSImportedElementDescriptor;
        }
        return new ES6ImportPsiUtil.CreateImportExportInfo(descriptor.getExportedName(), this.myImportedName, descriptor.getImportType(), descriptor.getImportExportPrefixKind());
    }

    @NotNull
    protected Collection<VirtualFile> resolveFileAsNpmPackage(@NotNull VirtualFile moduleFileOrDirectory) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(55);
        }
        List list2 = ContainerUtil.createMaybeSingletonList((Object)this.resolveAsNpmPackage(moduleFileOrDirectory));
        if (list2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(56);
        }
        return list2;
    }

    @Nullable
    private VirtualFile resolveAsNpmPackage(@NotNull VirtualFile pathFile) {
        if (pathFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(57);
        }
        return JSExactFileReference.resolveForNpmPackages(pathFile, (JSDirectorySearchProcessor)this.mySearchProcessor);
    }

    @Nullable
    private String getPathRelativeToRoots(@NotNull VirtualFile moduleFile) {
        String path2;
        ModuleRootManager rootManager;
        VirtualFile[] sourceRoots;
        String path3;
        VirtualFile url;
        JSConfig config;
        if (moduleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(58);
        }
        if ((config = (JSConfig)ObjectUtils.coalesce((Object)this.myConfiguration.getConfig(), (Object)TypeScriptConfigUtil.getConfigForPsiFile(this.myPlaceModule.getContainingFile(), true))) != null && (url = this.getRootFromConfig(config)) != null && (path3 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, Collections.singleton(url), false)) != null) {
            return path3;
        }
        WebResourcesPathsConfiguration pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)this.myProject);
        if (pathsConfiguration != null && (path3 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, pathsConfiguration.getResourceDirectories(), false)) != null) {
            return path3;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPlaceModule);
        if (module != null && (sourceRoots = (rootManager = ModuleRootManager.getInstance((Module)module)).getSourceRoots()).length > 0 && (path2 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, List.of(sourceRoots), false)) != null) {
            return path2;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myPlaceModuleFile);
        return contentRoot != null ? VfsUtilCore.findRelativePath((VirtualFile)contentRoot, (VirtualFile)moduleFile, (char)'/') : null;
    }

    @Nullable
    protected VirtualFile getRootFromConfig(@Nullable JSConfig config) {
        if (config == null) {
            return null;
        }
        return config.getMappingRoot();
    }

    @Nullable
    protected final JSNodeModuleStructure getNodeModuleStructureForImportedFile() {
        return JSNodeModuleStructure.getStructure(this.myProject, this.myFileToImport);
    }

    @NotNull
    protected JSModuleDescriptor createNodeModuleDescriptor(@NotNull JSNodeModuleStructure structure, @NotNull VirtualFile moduleOrFileToImport, @NotNull VirtualFile resolvedFile) {
        if (structure == null) {
            JSImportPathBuilder.$$$reportNull$$$0(59);
        }
        if (moduleOrFileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(60);
        }
        if (resolvedFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(61);
        }
        String path2 = structure.getNodeModulePath(moduleOrFileToImport);
        return this.createModuleDescriptor(path2, moduleOrFileToImport, resolvedFile);
    }

    @NotNull
    protected Collection<JSImportDescriptor> getImportDescriptorsForMapping(@NotNull VirtualFile baseUrl, @NotNull JSModulePathSubstitution substitution, @NotNull String mapping) {
        String pattern;
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(62);
        }
        if (substitution == null) {
            JSImportPathBuilder.$$$reportNull$$$0(63);
        }
        if (mapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(64);
        }
        if (StringUtil.isEmpty((String)(pattern = substitution.getPattern()))) {
            List<JSImportDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(65);
            }
            return list2;
        }
        if ("*".equals(pattern) && ("*".equals(mapping) || "./*".equals(mapping))) {
            List<JSImportDescriptor> list3 = Collections.emptyList();
            if (list3 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(66);
            }
            return list3;
        }
        if ((mapping = FileUtil.toSystemIndependentName((String)mapping)).isEmpty()) {
            List<JSImportDescriptor> list4 = Collections.emptyList();
            if (list4 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(67);
            }
            return list4;
        }
        VirtualFile placeDirectory = this.myPlaceModuleFile.getParent();
        if (substitution.isExact() || !substitution.includeExactMapping()) {
            VirtualFile pathFile = this.getPossibleFileWithExtension(baseUrl, mapping);
            if (pathFile != null) {
                ResolvedElement resolved;
                VirtualFile file;
                if (!JSImportPathBuilder.isFromNestedDirectory(pathFile, this.myFileToImport)) {
                    List<JSImportDescriptor> list5 = Collections.emptyList();
                    if (list5 == null) {
                        JSImportPathBuilder.$$$reportNull$$$0(68);
                    }
                    return list5;
                }
                if (!pathFile.isDirectory() && JSImportPathBuilder.isIndexFile(pathFile)) {
                    VirtualFile parent = pathFile.getParent();
                    if (this.myConfiguration.relativeForSamePathMappings() && this.isPlaceFromSamePaths(parent)) {
                        List<JSImportDescriptor> list6 = Collections.emptyList();
                        if (list6 == null) {
                            JSImportPathBuilder.$$$reportNull$$$0(69);
                        }
                        return list6;
                    }
                }
                VirtualFile virtualFile = file = (resolved = this.checkSymbolIn(pathFile)) != null ? resolved.resolvedFile : null;
                if (file != null) {
                    if (Objects.equals(placeDirectory, file.getParent()) && JSImportPathBuilder.isIndexFile(file)) {
                        List<JSImportDescriptor> list7 = Collections.emptyList();
                        if (list7 == null) {
                            JSImportPathBuilder.$$$reportNull$$$0(70);
                        }
                        return list7;
                    }
                    if (this.checkCircularDependency(file)) {
                        List<JSImportDescriptor> list8 = Collections.emptyList();
                        if (list8 == null) {
                            JSImportPathBuilder.$$$reportNull$$$0(71);
                        }
                        return list8;
                    }
                    JSModuleDescriptor info2 = this.createModuleDescriptor(pattern, pathFile, file, JSModuleNameInfo.ExtensionSettings.EXACT);
                    List list9 = ContainerUtil.map(resolved.importedDescriptors, el -> new JSSimpleImportDescriptor(info2, (JSImportedElementDescriptor)el));
                    if (list9 == null) {
                        JSImportPathBuilder.$$$reportNull$$$0(72);
                    }
                    return list9;
                }
            }
            if (substitution.isExact()) {
                List<JSImportDescriptor> list10 = Collections.emptyList();
                if (list10 == null) {
                    JSImportPathBuilder.$$$reportNull$$$0(73);
                }
                return list10;
            }
        }
        VirtualFile startDirectory = baseUrl;
        String pathPrefix = substitution.getPathPrefix(mapping);
        if (pathPrefix != null) {
            startDirectory = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(startDirectory, pathPrefix);
        }
        if (startDirectory == null) {
            List<JSImportDescriptor> list11 = Collections.emptyList();
            if (list11 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(74);
            }
            return list11;
        }
        List<VirtualFile> parents2 = JSImportPathBuilder.collectParents(this.myFileToImport, startDirectory);
        if (parents2.isEmpty()) {
            List<JSImportDescriptor> list12 = Collections.emptyList();
            if (list12 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(75);
            }
            return list12;
        }
        if (this.myConfiguration.relativeForSamePathMappings() && this.isPlaceFromSamePaths(startDirectory)) {
            List<JSImportDescriptor> list13 = Collections.emptyList();
            if (list13 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(76);
            }
            return list13;
        }
        String partOfString = substitution.getMappedString(mapping);
        for (VirtualFile pathFile : ContainerUtil.reverse(parents2)) {
            VirtualFile module;
            String stringToCheckPattern;
            if (pathFile.equals(placeDirectory) && !this.myFileToImport.isDirectory()) continue;
            if (NodeModuleUtil.isTypesDir(pathFile) && NodeModuleUtil.isNodeModules(pathFile.getParent()) && !pattern.contains("@types/")) {
                List<JSImportDescriptor> list14 = Collections.emptyList();
                if (list14 == null) {
                    JSImportPathBuilder.$$$reportNull$$$0(77);
                }
                return list14;
            }
            ResolvedElement resolved = this.checkSymbolIn(pathFile);
            if (resolved == null || StringUtil.isEmpty((String)(stringToCheckPattern = VfsUtilCore.findRelativePath((VirtualFile)startDirectory, (VirtualFile)(module = resolved.moduleFileOrDirectory), (char)'/')))) continue;
            JSModulePattern pathSubstitution = JSPathMappingsUtil.createPatternForString(partOfString, substitution.canStartWith());
            Pair matchedStar = JSPathMappingsUtil.findMaxElementByPaths((pathPrefix != null ? "/" : "") + stringToCheckPattern, ContainerUtil.createMaybeSingletonList((Object)pathSubstitution));
            if (matchedStar == null) continue;
            JSModuleDescriptor info3 = this.createModuleDescriptor(substitution.applyPattern((String)matchedStar.second), module, resolved.resolvedFile, this.myConfiguration.getPathSettings());
            List list15 = ContainerUtil.map(resolved.importedDescriptors, el -> new JSSimpleImportDescriptor(info3, (JSImportedElementDescriptor)el));
            if (list15 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(78);
            }
            return list15;
        }
        List list16 = ContainerUtil.emptyList();
        if (list16 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(79);
        }
        return list16;
    }

    private boolean checkCircularDependency(@NotNull VirtualFile resolvedModuleFile) {
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(80);
        }
        JSFileImports exports = TypeScriptFileImportsFactory.createFileExports(this.myProject, this.myConfiguration.getConfig(), resolvedModuleFile);
        return new JSImportGraph(exports).containsFile(this.myPlaceModuleFile);
    }

    private static boolean isIndexFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSImportPathBuilder.$$$reportNull$$$0(81);
        }
        return file.getName().startsWith("index.");
    }

    private boolean isPlaceFromSamePaths(@NotNull VirtualFile startDirectory) {
        if (startDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(82);
        }
        return VfsUtilCore.isAncestor((VirtualFile)startDirectory, (VirtualFile)this.myPlaceModuleFile, (boolean)true);
    }

    @Nullable
    private VirtualFile getPossibleFileWithExtension(@NotNull VirtualFile baseUrl, @NotNull String mapping) {
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(83);
        }
        if (mapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(84);
        }
        if (JSFileReferencesUtil.findExtension(mapping, this.myExtensions) != null) {
            return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
        }
        for (String extension : this.myExtensions) {
            VirtualFile possibleFile = JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping + extension);
            if (possibleFile == null) continue;
            return possibleFile;
        }
        return JSPathMappingsUtil.getPathRelativeBaseUrlOrSelfIfAbsolute(baseUrl, mapping);
    }

    private static boolean isFromNestedDirectory(VirtualFile parentFile, VirtualFile dstFile) {
        if (parentFile.equals(dstFile)) {
            return true;
        }
        if (!parentFile.isDirectory()) {
            parentFile = parentFile.getParent();
        }
        return VfsUtilCore.isAncestor((VirtualFile)parentFile, (VirtualFile)dstFile, (boolean)false);
    }

    protected final boolean processModuleNameUsingNodeModules(@NotNull JSImportDescriptorProcessor processor) {
        JSNodeModuleStructure nodeModuleStructure;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(85);
        }
        if ((nodeModuleStructure = this.getNodeModuleStructureForImportedFile()) == null) {
            return true;
        }
        if (!this.processModuleUsingNodeModules(processor, nodeModuleStructure)) {
            return false;
        }
        return NodeModuleUtil.hasNodeModulesDirInPath(this.myPlaceModuleFile, null);
    }

    protected boolean processModuleUsingNodeModules(@NotNull JSImportDescriptorProcessor processor, @NotNull JSNodeModuleStructure nodeModuleStructure) {
        HashSet visited;
        VirtualFile moduleDirectory;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(86);
        }
        if (nodeModuleStructure == null) {
            JSImportPathBuilder.$$$reportNull$$$0(87);
        }
        if (!this.processForNodeModuleCandidate(processor, nodeModuleStructure, moduleDirectory = nodeModuleStructure.moduleDirectory, visited = new HashSet())) {
            return false;
        }
        if (!moduleDirectory.equals(this.myFileToImport.getParent())) {
            Object[] files2 = moduleDirectory.getChildren();
            ContainerUtil.sort((Object[])files2, Comparator.comparing(VirtualFile::isDirectory).thenComparing(VirtualFile::getName));
            for (Object candidate2 : files2) {
                if (!candidate2.isDirectory() && !TypeScriptUtil.isDefinitionFile((VirtualFile)candidate2) || this.processForNodeModuleCandidate(processor, nodeModuleStructure, (VirtualFile)candidate2, visited)) continue;
                return false;
            }
        }
        return this.processHierarchy(moduleDirectory, (candidate, resolved, descriptor) -> {
            if (!visited.add(resolved)) {
                return true;
            }
            return this.processForResolvedNodeModuleCandidate(processor, nodeModuleStructure, descriptor, candidate, resolved);
        });
    }

    protected boolean processForNodeModuleCandidate(@NotNull JSImportDescriptorProcessor processor, @NotNull JSNodeModuleStructure structure, @NotNull VirtualFile moduleCandidate, @NotNull Set<? super VirtualFile> visited) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(88);
        }
        if (structure == null) {
            JSImportPathBuilder.$$$reportNull$$$0(89);
        }
        if (moduleCandidate == null) {
            JSImportPathBuilder.$$$reportNull$$$0(90);
        }
        if (visited == null) {
            JSImportPathBuilder.$$$reportNull$$$0(91);
        }
        if (moduleCandidate.equals(this.myFileToImport)) {
            return true;
        }
        ResolvedElement resolved = this.checkSymbolIn(moduleCandidate);
        if (resolved == null || !visited.add((VirtualFile)resolved.resolvedFile)) {
            return true;
        }
        for (JSImportedElementDescriptor descriptor : resolved.importedDescriptors) {
            if (this.processForResolvedNodeModuleCandidate(processor, structure, descriptor, moduleCandidate, resolved.resolvedFile)) continue;
            return false;
        }
        return true;
    }

    protected boolean processForResolvedNodeModuleCandidate(@NotNull JSImportDescriptorProcessor processor, @NotNull JSNodeModuleStructure structure, @NotNull JSImportedElementDescriptor elementDescriptor, @NotNull VirtualFile moduleCandidate, @NotNull VirtualFile resolvedCandidate) {
        JSModuleDescriptor info2;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(92);
        }
        if (structure == null) {
            JSImportPathBuilder.$$$reportNull$$$0(93);
        }
        if (elementDescriptor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(94);
        }
        if (moduleCandidate == null) {
            JSImportPathBuilder.$$$reportNull$$$0(95);
        }
        if (resolvedCandidate == null) {
            JSImportPathBuilder.$$$reportNull$$$0(96);
        }
        return this.processDescriptorAndContributors(processor, new JSSimpleImportDescriptor(info2 = this.createNodeModuleDescriptor(structure, moduleCandidate, resolvedCandidate), elementDescriptor));
    }

    protected final boolean processHierarchy(@NotNull VirtualFile parentToStop, @NotNull HierarchyProcessor parentFileProcessor) {
        if (parentToStop == null) {
            JSImportPathBuilder.$$$reportNull$$$0(97);
        }
        if (parentFileProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(98);
        }
        return this.processElements(ContainerUtil.reverse(JSImportPathBuilder.collectParents(this.myFileToImport, parentToStop)), parentFileProcessor);
    }

    protected final boolean processElements(@NotNull List<VirtualFile> elementsToProcess, @NotNull HierarchyProcessor fileProcessor) {
        if (elementsToProcess == null) {
            JSImportPathBuilder.$$$reportNull$$$0(99);
        }
        if (fileProcessor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(100);
        }
        for (VirtualFile moduleFileOrDirectory : elementsToProcess) {
            ProgressManager.checkCanceled();
            ResolvedElement resolved = this.checkSymbolIn(moduleFileOrDirectory);
            if (resolved == null) continue;
            for (JSImportedElementDescriptor descriptor : resolved.importedDescriptors) {
                if (fileProcessor.process(resolved.moduleFileOrDirectory, resolved.resolvedFile, descriptor)) continue;
                return false;
            }
        }
        return true;
    }

    @NotNull
    protected static List<VirtualFile> collectParents(@NotNull VirtualFile dstFile, @NotNull VirtualFile parentToStop) {
        if (dstFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(101);
        }
        if (parentToStop == null) {
            JSImportPathBuilder.$$$reportNull$$$0(102);
        }
        SmartList parents2 = new SmartList((Object)dstFile);
        boolean hasParent = false;
        for (VirtualFile parent = dstFile.getParent(); parent != null; parent = parent.getParent()) {
            ProgressManager.checkCanceled();
            if (parentToStop.equals(parent)) {
                hasParent = true;
                break;
            }
            parents2.add(parent);
        }
        if (!hasParent) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(103);
            }
            return list2;
        }
        SmartList smartList = parents2;
        if (smartList == null) {
            JSImportPathBuilder.$$$reportNull$$$0(104);
        }
        return smartList;
    }

    @Nullable
    protected JSLinkedProject getLinkedProject(@NotNull VirtualFile referencedRoot, @Nullable VirtualFile placePackageJson, @Nullable String importPackageName) {
        VirtualFile commonPackageJson;
        VirtualFile rootLinkedPackage;
        if (referencedRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(105);
        }
        if (importPackageName == null || placePackageJson == null) {
            return null;
        }
        VirtualFile linkedPackage = JSImportPathBuilder.getNodeModulesLinkedPackage(referencedRoot, placePackageJson, importPackageName);
        if (linkedPackage != null) {
            return new JSSymlinkLinkedProject(referencedRoot, linkedPackage, importPackageName);
        }
        VirtualFile commonParent = VfsUtilCore.getCommonAncestor((VirtualFile)referencedRoot, (VirtualFile)placePackageJson.getParent());
        VirtualFile rootProject = NodeModuleUtil.findMainModuleRoot(this.myProject, commonParent);
        if (rootProject != null && (rootLinkedPackage = JSImportPathBuilder.getNodeModulesLinkedPackage(referencedRoot, commonPackageJson = rootProject.findChild("package.json"), importPackageName)) != null) {
            return new JSSymlinkLinkedProject(referencedRoot, rootLinkedPackage, importPackageName);
        }
        VirtualFile dir = YarnPnpManager.getInstance(this.myProject).findInstalledPackageDir(placePackageJson, importPackageName);
        if (referencedRoot.equals(dir)) {
            return new JSReferenceProject(referencedRoot, importPackageName);
        }
        return null;
    }

    @NotNull
    public final List<JSImportDescriptor> getMappingsForBaseUrl(@NotNull VirtualFile baseUrl, @NotNull JSModulePathMappings<? extends JSModulePathSubstitution> mappings) {
        if (baseUrl == null) {
            JSImportPathBuilder.$$$reportNull$$$0(106);
        }
        if (mappings == null) {
            JSImportPathBuilder.$$$reportNull$$$0(107);
        }
        return this.getMappingsForBaseUrl(Collections.singleton(baseUrl), mappings);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    public final List<JSImportDescriptor> getMappingsForBaseUrl(@NotNull Collection<VirtualFile> baseUrls, @NotNull JSModulePathMappings<? extends JSModulePathSubstitution> mappings) {
        if (baseUrls == null) {
            JSImportPathBuilder.$$$reportNull$$$0(108);
        }
        if (mappings == null) {
            JSImportPathBuilder.$$$reportNull$$$0(109);
        }
        if (!this.myConfiguration.usePathMappings()) {
            List<JSImportDescriptor> list2 = Collections.emptyList();
            if (list2 == null) {
                JSImportPathBuilder.$$$reportNull$$$0(110);
            }
            return list2;
        }
        @NotNull @NotNull SmartList candidates = new SmartList();
        for (JSModulePathSubstitution jSModulePathSubstitution : mappings.getSubstitutions()) {
            ProgressManager.checkCanceled();
            for (String mapping : jSModulePathSubstitution.getMappings()) {
                if (StringUtil.isEmpty((String)mapping)) continue;
                for (VirtualFile baseUrl : baseUrls) {
                    Collection<JSImportDescriptor> currentCandidates = this.getImportDescriptorsForMapping(baseUrl, jSModulePathSubstitution, mapping);
                    for (JSImportDescriptor candidate : currentCandidates) {
                        candidates.add(Pair.create((Object)candidate, (Object)mapping));
                    }
                }
            }
        }
        Collections.sort(candidates, (el, el2) -> JSImportPathBuilder.compareMappings(((JSImportDescriptor)el.first).getModuleDescriptor(), (String)el.second, ((JSImportDescriptor)el2.first).getModuleDescriptor(), (String)el2.second));
        List list3 = ContainerUtil.map((Collection)candidates, el -> (JSImportDescriptor)el.first);
        if (list3 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(111);
        }
        return list3;
    }

    private static int compareMappings(@Nullable JSModuleDescriptor oldInfo, @Nullable String oldMapping, @NotNull JSModuleDescriptor newInfo, @NotNull String newMapping) {
        if (newInfo == null) {
            JSImportPathBuilder.$$$reportNull$$$0(112);
        }
        if (newMapping == null) {
            JSImportPathBuilder.$$$reportNull$$$0(113);
        }
        if (oldInfo == null || oldMapping == null) {
            return 1;
        }
        String oldInfoPath = oldInfo.getModuleName();
        String newInfoPath = newInfo.getModuleName();
        if (!oldMapping.equals(newMapping)) {
            if (newInfoPath.startsWith(oldInfoPath + "/")) {
                return -1;
            }
            if (oldInfoPath.startsWith(newInfoPath + "/")) {
                return 1;
            }
            if (oldMapping.startsWith(newMapping)) {
                return -1;
            }
            if (newMapping.startsWith(oldMapping)) {
                return 1;
            }
        }
        return oldInfoPath.length() - newInfoPath.length();
    }

    protected final boolean processWithModuleDescriptor(@NotNull JSImportDescriptorProcessor processor, @NotNull JSModuleDescriptor info2) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(114);
        }
        if (info2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(115);
        }
        return this.processDescriptorAndContributors(processor, this.createSimpleDescriptor(info2));
    }

    @NotNull
    protected JSImportDescriptor createSimpleDescriptor(@NotNull JSModuleDescriptor info2) {
        if (info2 == null) {
            JSImportPathBuilder.$$$reportNull$$$0(116);
        }
        return new JSSimpleImportDescriptor(info2, this.getInfoElementToImport());
    }

    @NotNull
    protected JSImportedElementDescriptor getInfoElementToImport() {
        String elementName;
        if (this.myImportType == ES6ImportPsiUtil.ImportExportType.BARE) {
            ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = ES6ImportPsiUtil.BARE_INFO;
            if (createImportExportInfo == null) {
                JSImportPathBuilder.$$$reportNull$$$0(117);
            }
            return createImportExportInfo;
        }
        String string = elementName = this.myElementToImport instanceof JSElement ? ES6ImportPsiUtil.getExportedElementName(this.myElementToImport) : null;
        if (elementName == null && this.myImportedName == null) {
            ES6ImportPsiUtil.CreateImportExportInfo createImportExportInfo = ES6ImportPsiUtil.BARE_INFO;
            if (createImportExportInfo == null) {
                JSImportPathBuilder.$$$reportNull$$$0(118);
            }
            return createImportExportInfo;
        }
        return new ES6ImportPsiUtil.CreateImportExportInfo(elementName, this.myImportedName, this.myImportType, this.myImportPrefix);
    }

    @Nullable
    protected static VirtualFile getNodeModulesLinkedPackage(@NotNull VirtualFile referencedRoot, @Nullable VirtualFile placePackageJson, @Nullable String packageName) {
        if (referencedRoot == null) {
            JSImportPathBuilder.$$$reportNull$$$0(119);
        }
        if (packageName == null || placePackageJson == null) {
            return null;
        }
        VirtualFile parent = placePackageJson.getParent();
        VirtualFile nodeModules = parent.findChild("node_modules");
        if (nodeModules == null) {
            return null;
        }
        VirtualFile linkedPackage = nodeModules.findFileByRelativePath(packageName);
        if (linkedPackage == null || referencedRoot.equals(linkedPackage)) {
            return null;
        }
        if (!Objects.equals(linkedPackage.getCanonicalFile(), referencedRoot)) {
            return null;
        }
        return linkedPackage;
    }

    private boolean processModuleNameUsingPathMappings(@NotNull JSImportDescriptorProcessor processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(120);
        }
        if (this.myConfigFile == null) {
            return true;
        }
        VirtualFile baseUrl = this.getRootFromConfig(this.myConfigFile);
        if (baseUrl == null) {
            return true;
        }
        @NotNull JSModulePathMappings<JSModulePathSubstitution> mappings = this.myConfigFile.getPathMappings();
        for (JSImportDescriptor descriptor : this.getMappingsForBaseUrl(baseUrl, mappings)) {
            if (processor.processDescriptor(descriptor)) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 26, 46, 54, 56, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 103, 104, 110, 111, 117, 118 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedDescriptor";
                break;
            }
            case 3: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 21: 
            case 22: 
            case 27: 
            case 31: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 85: 
            case 86: 
            case 88: 
            case 92: 
            case 114: 
            case 120: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 29: 
            case 51: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 5: 
            case 8: 
            case 11: 
            case 30: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootPath";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 13: 
            case 26: 
            case 46: 
            case 54: 
            case 56: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 103: 
            case 104: 
            case 110: 
            case 111: 
            case 117: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProject";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importRoot";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toIterateDirectory";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeDirectory";
                break;
            }
            case 32: 
            case 34: 
            case 36: 
            case 38: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 44: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 45: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedNames";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 50: 
            case 115: 
            case 116: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveCandidate";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFile";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 59: 
            case 89: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleOrFileToImport";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedFile";
                break;
            }
            case 62: 
            case 83: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrl";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 64: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startDirectory";
                break;
            }
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModuleStructure";
                break;
            }
            case 90: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleCandidate";
                break;
            }
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementDescriptor";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedCandidate";
                break;
            }
            case 97: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentToStop";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentFileProcessor";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToProcess";
                break;
            }
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileProcessor";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 105: 
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referencedRoot";
                break;
            }
            case 107: 
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mappings";
                break;
            }
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseUrls";
                break;
            }
            case 112: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newInfo";
                break;
            }
            case 113: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleDescriptor";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentsNoOverlapInHierarchy";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchProcessor";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "normalizeNameForImportDescriptor";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveFileAsNpmPackage";
                break;
            }
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportDescriptorsForMapping";
                break;
            }
            case 103: 
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "collectParents";
                break;
            }
            case 110: 
            case 111: {
                objectArray = objectArray2;
                objectArray2[1] = "getMappingsForBaseUrl";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfoElementToImport";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processRootPaths";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createModuleDescriptor";
                break;
            }
            case 13: 
            case 26: 
            case 46: 
            case 54: 
            case 56: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 103: 
            case 104: 
            case 110: 
            case 111: 
            case 117: 
            case 118: {
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "processDirectModuleNames";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processDirectImportDescriptors";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "processForRelatedProjects";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "processLinkedProject";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "processLinkedProjectRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processModuleFileUsingParentDirectories";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "iterateParentDirectories";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getParentsNoOverlapInHierarchy";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "processForModuleFile";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processWithContributors";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "processTypingsVersion";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "processDefaultTypingsField";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processDescriptorAndContributors";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "processDescriptorsWithModuleName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNames";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processDescriptors";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNamesWithoutExistingImports";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "processExistingImports";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "createSearchProcessor";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultSearchProcessor";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isExcludedName";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "checkSymbolIn";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isDirectoryImportAvailable";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "normalizeNameForImportDescriptor";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "resolveFileAsNpmPackage";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsNpmPackage";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToRoots";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createNodeModuleDescriptor";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getImportDescriptorsForMapping";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "checkCircularDependency";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "isIndexFile";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isPlaceFromSamePaths";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getPossibleFileWithExtension";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameUsingNodeModules";
                break;
            }
            case 86: 
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "processModuleUsingNodeModules";
                break;
            }
            case 88: 
            case 89: 
            case 90: 
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "processForNodeModuleCandidate";
                break;
            }
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "processForResolvedNodeModuleCandidate";
                break;
            }
            case 97: 
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 99: 
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "collectParents";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedProject";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "getMappingsForBaseUrl";
                break;
            }
            case 112: 
            case 113: {
                objectArray = objectArray;
                objectArray[2] = "compareMappings";
                break;
            }
            case 114: 
            case 115: {
                objectArray = objectArray;
                objectArray[2] = "processWithModuleDescriptor";
                break;
            }
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "createSimpleDescriptor";
                break;
            }
            case 119: {
                objectArray = objectArray;
                objectArray[2] = "getNodeModulesLinkedPackage";
                break;
            }
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNameUsingPathMappings";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 26, 46, 54, 56, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 103, 104, 110, 111, 117, 118 -> new IllegalStateException(string);
        };
    }

    protected static interface HierarchyProcessor {
        public boolean process(@NotNull VirtualFile var1, @NotNull VirtualFile var2, @NotNull JSImportedElementDescriptor var3);
    }

    public static final class ResolvedElement {
        final VirtualFile moduleFileOrDirectory;
        final VirtualFile resolvedFile;
        final Collection<JSImportedElementDescriptor> importedDescriptors;

        public ResolvedElement(@Nullable VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedFile, @NotNull Collection<JSImportedElementDescriptor> descriptors) {
            if (resolvedFile == null) {
                ResolvedElement.$$$reportNull$$$0(0);
            }
            if (descriptors == null) {
                ResolvedElement.$$$reportNull$$$0(1);
            }
            this.moduleFileOrDirectory = moduleFileOrDirectory;
            this.resolvedFile = resolvedFile;
            this.importedDescriptors = descriptors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "resolvedFile";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptors";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder$ResolvedElement";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

