/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.testing.JsTestConfigurationUtil;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.VitestRunSettings;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\bH\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ0\u0010\u001d\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u000b\u0010 \u001a\u00070\b\u00a2\u0006\u0002\b!2\u000b\u0010\"\u001a\u00070\b\u00a2\u0006\u0002\b#2\u0006\u0010$\u001a\u00020%J\u000e\u0010&\u001a\u00020\u00162\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020\u00102\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0015\u001a\u00020\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestUtil;", "", "()V", "PKG_DESCRIPTOR", "Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "getPKG_DESCRIPTOR", "()Lcom/intellij/javascript/nodejs/util/NodePackageDescriptor;", "TAG__CONFIG_FILE", "", "TAG__NODE_INTERPRETER", "TAG__NODE_OPTIONS", "TAG__VITEST_OPTIONS", "TAG__VITEST_PACKAGE", "TAG__WORKING_DIR", "VITEST_PACKAGE_NAME", "checkRunConfiguration", "", "configuration", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "findContextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "settings", "Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "findFile", "path", "getVitestMainJsFile", "Ljava/nio/file/Path;", "pkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "notify", "project", "Lcom/intellij/openapi/project/Project;", "title", "Lcom/intellij/openapi/util/NlsContexts$NotificationTitle;", "content", "Lcom/intellij/openapi/util/NlsContexts$NotificationContent;", "notificationType", "Lcom/intellij/notification/NotificationType;", "readXml", "element", "Lorg/jdom/Element;", "writeXml", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nVitestUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestUtil.kt\ncom/intellij/javascript/testing/vitest/VitestUtil\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,112:1\n13#2:113\n*S KotlinDebug\n*F\n+ 1 VitestUtil.kt\ncom/intellij/javascript/testing/vitest/VitestUtil\n*L\n99#1:113\n*E\n"})
public final class VitestUtil {
    @NotNull
    public static final VitestUtil INSTANCE = new VitestUtil();
    @NotNull
    private static final String VITEST_PACKAGE_NAME = "vitest";
    @NotNull
    private static final NodePackageDescriptor PKG_DESCRIPTOR = new NodePackageDescriptor("vitest");
    @NotNull
    private static final String TAG__CONFIG_FILE = "config";
    @NotNull
    private static final String TAG__NODE_INTERPRETER = "node-interpreter";
    @NotNull
    private static final String TAG__NODE_OPTIONS = "node-options";
    @NotNull
    private static final String TAG__VITEST_PACKAGE = "vitest-package";
    @NotNull
    private static final String TAG__WORKING_DIR = "working-dir";
    @NotNull
    private static final String TAG__VITEST_OPTIONS = "vitest-options";

    private VitestUtil() {
    }

    @NotNull
    public final NodePackageDescriptor getPKG_DESCRIPTOR() {
        return PKG_DESCRIPTOR;
    }

    @Nullable
    public final VirtualFile findContextFile(@NotNull VitestRunSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        VirtualFile virtualFile = this.findFile(settings2.getConfigFilePath());
        if (virtualFile == null) {
            virtualFile = this.findFile(settings2.getWorkingDir());
        }
        return virtualFile;
    }

    private final VirtualFile findFile(String path2) {
        return FileUtil.isAbsolute((String)path2) ? LocalFileSystem.getInstance().findFileByPath(path2) : null;
    }

    public final void writeXml(@NotNull Element element, @NotNull VitestRunSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
        if (((CharSequence)settings2.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__CONFIG_FILE, FileUtil.toSystemIndependentName((String)settings2.getConfigFilePath()));
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__NODE_INTERPRETER, settings2.getInterpreterRef().getReferenceName());
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__NODE_OPTIONS, settings2.getNodeOptions());
        NodePackage nodePackage = settings2.getVitestPackage();
        if (nodePackage != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__VITEST_PACKAGE, it.getSystemIndependentPath());
        }
        JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__WORKING_DIR, FileUtil.toSystemIndependentName((String)settings2.getWorkingDir()));
        if (((CharSequence)settings2.getVitestOptions()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.writeValue(element, TAG__VITEST_OPTIONS, settings2.getVitestOptions());
        }
        settings2.getEnvData().writeExternal(element);
        settings2.getScope().writeExternal(element);
    }

    @NotNull
    public final VitestRunSettings readXml(@NotNull Element element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        VitestRunSettings.Builder builder2 = new VitestRunSettings.Builder(null, null, null, null, null, null, null, null, 255, null);
        String string2 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__CONFIG_FILE);
        if (string2 == null) {
            string2 = "";
        }
        builder2.setConfigFilePath(string2);
        NodeJsInterpreterRef nodeJsInterpreterRef = NodeJsInterpreterRef.create(JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__NODE_INTERPRETER));
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"create(...)");
        builder2.setInterpreterRef(nodeJsInterpreterRef);
        String string3 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__NODE_OPTIONS);
        if (string3 == null) {
            string3 = "";
        }
        builder2.setNodeOptions(string3);
        String string4 = JDOMExternalizerUtil.readCustomField((Element)element, (String)TAG__VITEST_PACKAGE);
        if (string4 != null) {
            String it = string4;
            boolean bl = false;
            builder2.setVitestPackage(PKG_DESCRIPTOR.createPackage(it));
        }
        if ((string = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__WORKING_DIR)) == null) {
            string = "";
        }
        builder2.setWorkingDir(string);
        String string5 = JsTestConfigurationUtil.INSTANCE.readValue(element, TAG__VITEST_OPTIONS);
        if (string5 == null) {
            string5 = "";
        }
        builder2.setVitestOptions(string5);
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.readExternal((Element)element);
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"readExternal(...)");
        builder2.setEnvData(environmentVariablesData);
        builder2.setScope(JsTestRunScope.Companion.readExternal(element));
        return builder2.build();
    }

    public final void checkRunConfiguration(@NotNull VitestRunConfiguration configuration) throws RuntimeConfigurationException {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        VitestRunSettings settings2 = configuration.getSettings();
        if (((CharSequence)settings2.getConfigFilePath()).length() > 0) {
            JsTestConfigurationUtil.INSTANCE.validatePath(false, "configuration file", settings2.getConfigFilePath());
        }
        JsTestConfigurationUtil.INSTANCE.validatePath(true, "working directory", settings2.getWorkingDir());
        NodeInterpreterUtil.checkForRunConfiguration(settings2.getInterpreterRef().resolve(configuration.getProject()));
        configuration.getOrDetectVitestPackage().validateForRunConfiguration(VITEST_PACKAGE_NAME);
        settings2.getScope().validateForRunConfiguration(false);
    }

    @NotNull
    public final Path getVitestMainJsFile(@NotNull NodePackage pkg) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        String string = PackageJsonUtil.guessDefaultBinaryNameOfDependency(pkg);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guessDefaultBinaryNameOfDependency(...)");
        String binaryName = string;
        File file = pkg.findBinFile(binaryName, "./vitest.mjs");
        if (file != null) {
            File it = file;
            boolean bl = false;
            Path path2 = it.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            return path2;
        }
        Object[] objectArray = new Object[]{pkg.getName()};
        throw new ExecutionException(JavaScriptBundle.message("node.package.cannot.find.bin.file.dialog.message", objectArray));
    }

    public final void notify(@NotNull Project project, @NotNull String title, @NotNull String content, @NotNull NotificationType notificationType) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)notificationType, (String)"notificationType");
        NotificationGroup vitestNotificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Vitest test runner");
        if (vitestNotificationGroup == null) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(VitestUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error("Cannot find \"Vitest test runner\" notification group");
            return;
        }
        vitestNotificationGroup.createNotification(title, content, notificationType).notify(project);
    }
}

