/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.coverage.CoverageExecutor;
import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.UrlFilter;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptionsKt;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.testing.JSTestNamePatternComponentJoiner;
import com.intellij.javascript.testing.runConfiguration.AbstractJSTestRunProfileState;
import com.intellij.javascript.testing.runConfiguration.JSTestLocation;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.javascript.testing.vitest.VitestConsoleProperties;
import com.intellij.javascript.testing.vitest.VitestRerunFailedTestAction;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.VitestRunSettings;
import com.intellij.javascript.testing.vitest.VitestUtil;
import com.intellij.javascript.testing.vitest.VitestWatchProvider;
import com.intellij.javascript.testing.vitest.coverage.VitestInstallMissingDependencyFilter;
import com.intellij.javascript.testing.watch.JsTestWatchToggleAction;
import com.intellij.lang.javascript.ConsoleCommandLineFolder;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 42\u00020\u0001:\u00014B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0007H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u001a\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010%\u001a\u00020&H\u0016J\u0014\u0010'\u001a\u0004\u0018\u00010(2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\u0018\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.H\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001a002\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0012\u00101\u001a\u00020\u001e2\b\u00102\u001a\u0004\u0018\u000103H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u00065"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunProfileState;", "Lcom/intellij/javascript/testing/runConfiguration/AbstractJSTestRunProfileState;", "configuration", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "failedTests", "", "Lcom/intellij/javascript/testing/runConfiguration/JSTestLocation;", "(Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;Lcom/intellij/execution/runners/ExecutionEnvironment;Ljava/util/List;)V", "getConfiguration", "()Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "folder", "Lcom/intellij/lang/javascript/ConsoleCommandLineFolder;", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "getSettings", "()Lcom/intellij/javascript/testing/vitest/VitestRunSettings;", "configureCommandLine", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "configureCoverage", "vitestOptions", "", "createExecutionResult", "Lcom/intellij/execution/ExecutionResult;", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "createSmtRunnerConsoleView", "Lcom/intellij/execution/testframework/ui/BaseTestsOutputConsoleView;", "workingDirectory", "Ljava/io/File;", "consoleProperties", "Lcom/intellij/javascript/testing/vitest/VitestConsoleProperties;", "createTestNamePatternComponentJoiner", "Lcom/intellij/javascript/testing/JSTestNamePatternComponentJoiner;", "findPackageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "foldCommandLine", "consoleView", "Lcom/intellij/execution/ui/ConsoleView;", "getScopeType", "kind", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;", "reporterPathTargetValue", "Lcom/intellij/execution/target/value/TargetValue;", "startProcess", "configurator", "Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;", "Companion", "intellij.javascript.impl"})
public final class VitestRunProfileState
extends AbstractJSTestRunProfileState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final VitestRunConfiguration configuration;
    @NotNull
    private final ExecutionEnvironment environment;
    @NotNull
    private final VitestRunSettings settings;
    @NotNull
    private final Project project;
    @NotNull
    private final ConsoleCommandLineFolder folder;
    @NotNull
    private static final String REPORTER = "vitest-intellij/node_modules/vitest-intellij-reporter-safe.js";
    @NotNull
    private static final String REPORTER_ABSOLUTE_PATH_ENV = "_JETBRAINS_VITEST_REPORTER_ABSOLUTE_PATH";
    @NotNull
    private static final String RUN_SCOPE_TYPE = "_JETBRAINS_VITEST_RUN_SCOPE_TYPE";
    @NotNull
    private static final String RUN_WITH_COVERAGE = "_JETBRAINS_VITEST_RUN_WITH_COVERAGE";
    @NotNull
    private static final String COVERAGE_FLAG = "--coverage";
    @NotNull
    private static final String THREADS_FLAG = "--threads";

    public VitestRunProfileState(@NotNull VitestRunConfiguration configuration, @NotNull ExecutionEnvironment environment, @NotNull List<JSTestLocation> failedTests) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter(failedTests, (String)"failedTests");
        super(failedTests);
        this.configuration = configuration;
        this.environment = environment;
        this.settings = this.configuration.getSettings();
        Project project = this.configuration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.folder = new ConsoleCommandLineFolder(new String[0]);
    }

    @NotNull
    public final VitestRunConfiguration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public final VitestRunSettings getSettings() {
        return this.settings;
    }

    @Override
    @NotNull
    public ProcessHandler startProcess(@Nullable CommandLineDebugConfigurator configurator) throws ExecutionException {
        NodeJsInterpreter nodeJsInterpreter = this.settings.getInterpreterRef().resolveNotNull(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"resolveNotNull(...)");
        NodeJsInterpreter interpreter2 = nodeJsInterpreter;
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, this.project, configurator, NodeTargetRunOptionsKt.targetRunOptions$default(NodeTargetRunOptions.Companion.shouldUsePtyForTestRunners(), (RunConfigurationBase)this.configuration, null, 4, null), null, 16, null);
        this.configureCommandLine(targetRun);
        return targetRun.startProcess();
    }

    private final void configureCommandLine(NodeTargetRun targetRun) throws ExecutionException {
        TargetedCommandLineBuilder commandLine = targetRun.getCommandLineBuilder();
        String it = FileUtil.toSystemDependentName((String)this.settings.getWorkingDir());
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it);
        commandLine.setWorkingDirectory(targetRun.path(it));
        Path helpersDir = HelperFilesLocator.resolvePathOrThrowExecutionExecution(".");
        targetRun.path(helpersDir);
        targetRun.addNodeOptionsWithExpandedMacros(false, this.settings.getNodeOptions());
        NodePackage vitestPackage = this.configuration.getOrDetectVitestPackage();
        if (vitestPackage instanceof YarnPnpNodePackage) {
            ((YarnPnpNodePackage)vitestPackage).addYarnRunToCommandLine(targetRun, null, true);
        } else {
            commandLine.addParameter(targetRun.path(((Object)VitestUtil.INSTANCE.getVitestMainJsFile(vitestPackage)).toString()));
        }
        this.folder.addPlaceholderText(PackageJsonUtil.guessDefaultBinaryNameOfDependency(vitestPackage));
        targetRun.setEnvData(this.settings.getEnvData());
        if (!StringsKt.isBlank((CharSequence)this.settings.getConfigFilePath())) {
            commandLine.addParameter("--config");
            commandLine.addParameter(targetRun.path(this.settings.getConfigFilePath()));
            String[] bl2 = new String[]{"--config=" + PathUtil.getFileName((String)this.settings.getConfigFilePath())};
            this.folder.addPlaceholderTexts(bl2);
        }
        List list2 = ParametersListUtil.parse((String)this.settings.getVitestOptions(), (boolean)false, (boolean)true, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parse(...)");
        List vitestOptions = list2;
        if (!((Collection)this.getFailedTests()).isEmpty()) {
            vitestOptions = VitestWatchProvider.Util.INSTANCE.configureWatchMode(vitestOptions, false, true);
        }
        if (this.environment.getExecutor() instanceof DefaultDebugExecutor) {
            SemVer version2 = vitestPackage.getVersion(this.project);
            if (version2 != null && version2.getMajor() == 0) {
                if (!vitestOptions.contains(THREADS_FLAG)) {
                    var7_9 = new String[]{THREADS_FLAG, "false"};
                    vitestOptions = CollectionsKt.plus((Collection)vitestOptions, (Iterable)CollectionsKt.listOf((Object[])var7_9));
                }
            } else {
                var7_9 = new String[]{"--poolOptions.threads.maxThreads=1", "--poolOptions.threads.minThreads=1", "--poolOptions.forks.maxForks=1", "--poolOptions.forks.minForks=1", "--poolOptions.vmThreads.maxThreads=1", "--poolOptions.vmThreads.minThreads=1"};
                vitestOptions = CollectionsKt.plus((Collection)vitestOptions, (Iterable)CollectionsKt.listOf((Object[])var7_9));
            }
        }
        commandLine.addParameters(vitestOptions);
        this.folder.addPlaceholderTexts(vitestOptions);
        if (this.configuration.isOptionUpdateSnapshot()) {
            commandLine.addParameter("--update");
            this.folder.addPlaceholderText("--update");
            this.configuration.clearOptionUpdateSnapshot();
        }
        this.configureCoverage(targetRun, vitestOptions);
        targetRun.getCommandLineBuilder().addParameter("--reporter");
        targetRun.getCommandLineBuilder().addParameter(this.reporterPathTargetValue(targetRun));
        JsTestRunScope scope2 = this.settings.getScope();
        commandLine.addEnvironmentVariable(RUN_SCOPE_TYPE, TargetValue.fixed((Object)this.getScopeType(scope2.getKind())));
        String testNamePattern2 = this.getTestNamePattern(this.project, scope2);
        if (testNamePattern2 != null) {
            commandLine.addParameter("--testNamePattern=" + testNamePattern2);
            String[] stringArray = new String[]{"--testNamePattern=" + this.getTestNamePatternForFolding(scope2)};
            this.folder.addPlaceholderTexts(stringArray);
        }
        List<TargetValue<String>> testFilePaths = this.getTestFilePaths(scope2, targetRun);
        for (TargetValue<String> path2 : testFilePaths) {
            commandLine.addParameter(path2);
        }
        this.folder.addPlaceholderText(this.getFoldingPlaceholderForTestPaths(testFilePaths, scope2.getKind()));
    }

    private final void configureCoverage(NodeTargetRun targetRun, List<String> vitestOptions) {
        if (this.environment.getExecutor() instanceof CoverageExecutor) {
            if (!vitestOptions.contains(COVERAGE_FLAG)) {
                targetRun.getCommandLineBuilder().addParameter(COVERAGE_FLAG);
            }
            targetRun.getCommandLineBuilder().addEnvironmentVariable(RUN_WITH_COVERAGE, "true");
        }
    }

    private final TargetValue<String> reporterPathTargetValue(NodeTargetRun targetRun) {
        Object object;
        String localReporterAbsolutePath = HelperFilesLocator.resolvePathForExecution(REPORTER);
        if (targetRun.getInterpreter() instanceof NodeJsLocalInterpreter && (object = FileUtil.getRelativePath((String)FileUtil.toSystemDependentName((String)this.settings.getWorkingDir()), (String)FileUtil.toSystemDependentName((String)localReporterAbsolutePath), (char)File.separatorChar)) != null) {
            Object it = object;
            boolean bl = false;
            TargetValue targetValue = TargetValue.fixed(it);
            Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"fixed(...)");
            return targetValue;
        }
        TargetValue<String> it = object = targetRun.path(localReporterAbsolutePath);
        boolean bl = false;
        targetRun.getCommandLineBuilder().addEnvironmentVariable(REPORTER_ABSOLUTE_PATH_ENV, it);
        return object;
    }

    private final String getScopeType(JsTestRunScopeKind kind) {
        String string;
        if (!((Collection)this.getFailedTests()).isEmpty()) {
            string = "selected_tests";
        } else {
            String string2 = kind.name().toLowerCase(Locale.ROOT);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        }
        return string;
    }

    @Override
    @NotNull
    public JSTestNamePatternComponentJoiner createTestNamePatternComponentJoiner() {
        return new JSTestNamePatternComponentJoiner(){

            @NotNull
            public String join(@NotNull List<String> testNamePatternComponents, boolean suite) {
                Intrinsics.checkNotNullParameter(testNamePatternComponents, (String)"testNamePatternComponents");
                return " ?" + super.join(testNamePatternComponents, suite);
            }
        };
    }

    @Override
    @NotNull
    public ExecutionResult createExecutionResult(@NotNull ProcessHandler processHandler) {
        DefaultExecutionResult defaultExecutionResult;
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        Executor executor = this.environment.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        VitestConsoleProperties consoleProperties = this.configuration.createTestConsoleProperties(executor, NodeCommandLineUtil.shouldUseTerminalConsole(processHandler), NodeTargetRun.Companion.getTargetRun(processHandler));
        BaseTestsOutputConsoleView consoleView = this.createSmtRunnerConsoleView(new File(this.settings.getWorkingDir()), consoleProperties);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess(processHandler);
        this.foldCommandLine((ConsoleView)consoleView, processHandler);
        DefaultExecutionResult it = defaultExecutionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
        boolean bl = false;
        AnAction[] anActionArray = new AnAction[1];
        Intrinsics.checkNotNull((Object)consoleView, (String)"null cannot be cast to non-null type com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView");
        anActionArray[0] = new VitestRerunFailedTestAction((SMTRunnerConsoleView)consoleView, consoleProperties);
        it.setRestartActions(anActionArray);
        anActionArray = new AnAction[]{new JsTestWatchToggleAction()};
        it.setActions(anActionArray);
        return (ExecutionResult)defaultExecutionResult;
    }

    private final BaseTestsOutputConsoleView createSmtRunnerConsoleView(File workingDirectory, VitestConsoleProperties consoleProperties) {
        BaseTestsOutputConsoleView consoleView;
        block1: {
            BaseTestsOutputConsoleView baseTestsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((String)consoleProperties.getTestFrameworkName(), (TestConsoleProperties)((TestConsoleProperties)consoleProperties));
            Intrinsics.checkNotNullExpressionValue((Object)baseTestsOutputConsoleView, (String)"createConsole(...)");
            consoleView = baseTestsOutputConsoleView;
            consoleProperties.addStackTraceFilter((Filter)new NodeStackTraceFilter(this.project, workingDirectory, consoleProperties.getTargetRun()));
            for (Filter filter : consoleProperties.getStackTrackFilters()) {
                consoleView.addMessageFilter(filter);
            }
            consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.project, workingDirectory));
            consoleView.addMessageFilter((Filter)new UrlFilter(this.project));
            VirtualFile virtualFile = this.findPackageJson(workingDirectory);
            if (virtualFile == null) break block1;
            VirtualFile it = virtualFile;
            boolean bl = false;
            consoleView.addMessageFilter((Filter)new VitestInstallMissingDependencyFilter(it, this.environment));
        }
        return consoleView;
    }

    private final VirtualFile findPackageJson(File workingDirectory) {
        VirtualFile virtualWorkingDirectory;
        if (workingDirectory != null && (virtualWorkingDirectory = LocalFileSystem.getInstance().findFileByIoFile(workingDirectory)) != null) {
            return PackageJsonUtil.findUpPackageJson(virtualWorkingDirectory);
        }
        return null;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
        this.folder.foldCommandLine(consoleView, processHandler);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunProfileState$Companion;", "", "()V", "COVERAGE_FLAG", "", "REPORTER", "REPORTER_ABSOLUTE_PATH_ENV", "RUN_SCOPE_TYPE", "RUN_WITH_COVERAGE", "THREADS_FLAG", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

