/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.packages.NodePackagesKt;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.testing.runScope.JsTestRunScopeComponent;
import com.intellij.javascript.testing.vitest.VitestCliOptionsCompletionProvider;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.VitestRunSettings;
import com.intellij.javascript.testing.vitest.VitestUtil;
import com.intellij.javascript.testing.vitest.config.VitestConfig;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.util.textCompletion.TextCompletionProvider;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configPathTextFieldWithBrowseButton", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "interpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "nodeOptionsEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "panel", "Ljavax/swing/JPanel;", "scopeComponent", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeComponent;", "vitestOptionsEditor", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "vitestPackageField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "workingDirComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "applyEditorTo", "", "runConfiguration", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "Companion", "intellij.javascript.impl"})
public final class VitestRunConfigurationEditor
extends SettingsEditor<VitestRunConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextFieldWithHistoryWithBrowseButton configPathTextFieldWithBrowseButton;
    @NotNull
    private final NodeJsInterpreterField interpreterField;
    @NotNull
    private final RawCommandLineEditor nodeOptionsEditor;
    @NotNull
    private final NodePackageField vitestPackageField;
    @NotNull
    private final TextFieldWithBrowseButton workingDirComponent;
    @NotNull
    private final TextFieldWithCompletion vitestOptionsEditor;
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;
    @NotNull
    private final JsTestRunScopeComponent scopeComponent;
    @NotNull
    private final JPanel panel;

    public VitestRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.interpreterField = new NodeJsInterpreterField(project);
        RawCommandLineEditor rawCommandLineEditor = new RawCommandLineEditor().withMonospaced(false);
        Intrinsics.checkNotNullExpressionValue((Object)rawCommandLineEditor, (String)"withMonospaced(...)");
        this.nodeOptionsEditor = rawCommandLineEditor;
        this.workingDirComponent = VitestRunConfigurationEditor.Companion.createWorkingDirComponent(project);
        this.configPathTextFieldWithBrowseButton = VitestRunConfigurationEditor.Companion.createConfigurationFileTextField(project);
        this.vitestPackageField = new NodePackageField(this.interpreterField, VitestUtil.INSTANCE.getPKG_DESCRIPTOR(), () -> VitestRunConfigurationEditor._init_$lambda$0(this));
        this.vitestOptionsEditor = VitestRunConfigurationEditor.Companion.createVitestOptionsEditor(project);
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        int longestLabelWidth = new JLabel((String)UIUtil.removeMnemonic((String)JavaScriptBundle.message((String)"rc.environmentVariables.label", (Object[])new Object[0]))).getPreferredSize().width;
        this.scopeComponent = new JsTestRunScopeComponent(project, longestLabelWidth, true);
        JPanel jPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent(JavaScriptBundle.message("vitest.rc.configurationFile.label", new Object[0]), (JComponent)this.configPathTextFieldWithBrowseButton).addSeparator(8).addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.interpreterField), 8).addLabeledComponent(JavaScriptBundle.message("rc.nodeOptions.label", new Object[0]), (JComponent)this.nodeOptionsEditor).addLabeledComponent(JavaScriptBundle.message("vitest.rc.vitestPackageField.label", new Object[0]), (JComponent)((Object)this.vitestPackageField)).addLabeledComponent(JavaScriptBundle.message("rc.workingDirectory.label", new Object[0]), (JComponent)this.workingDirComponent).addLabeledComponent(JavaScriptBundle.message("vitest.rc.vitestOptions.label", new Object[0]), (JComponent)this.vitestOptionsEditor).addLabeledComponent(JavaScriptBundle.message("rc.environmentVariables.label", new Object[0]), (JComponent)this.envVarsComponent).addSeparator(8).addComponent(this.scopeComponent.getComponent()).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        this.panel = jPanel;
    }

    protected void resetEditorFrom(@NotNull VitestRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        VitestRunSettings settings2 = runConfiguration.getSettings();
        this.configPathTextFieldWithBrowseButton.setTextAndAddToHistory(FileUtil.toSystemDependentName((String)settings2.getConfigFilePath()));
        this.interpreterField.setInterpreterRef(settings2.getInterpreterRef());
        this.nodeOptionsEditor.setText(settings2.getNodeOptions());
        this.vitestPackageField.setSelected(runConfiguration.getOrDetectVitestPackage());
        this.workingDirComponent.setText(FileUtil.toSystemDependentName((String)settings2.getWorkingDir()));
        this.vitestOptionsEditor.setText(settings2.getVitestOptions());
        this.envVarsComponent.setData(settings2.getEnvData());
        this.scopeComponent.resetEditorFrom(settings2.getScope());
    }

    protected void applyEditorTo(@NotNull VitestRunConfiguration runConfiguration) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        VitestRunSettings.Builder builder2 = new VitestRunSettings.Builder(null, null, null, null, null, null, null, null, 255, null);
        String string = PathShortener.getAbsolutePath((JTextField)((TextFieldWithHistory)this.configPathTextFieldWithBrowseButton.getChildComponent()).getTextEditor());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        builder2.setConfigFilePath(string);
        NodeJsInterpreterRef nodeJsInterpreterRef = this.interpreterField.getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        builder2.setInterpreterRef(nodeJsInterpreterRef);
        String string2 = this.nodeOptionsEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        builder2.setNodeOptions(string2);
        builder2.setVitestPackage(NodePackagesKt.nullize$default(this.vitestPackageField.getSelected(), false, 1, null));
        String string3 = PathShortener.getAbsolutePath((JTextField)this.workingDirComponent.getTextField());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        builder2.setWorkingDir(string3);
        String string4 = this.vitestOptionsEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        builder2.setVitestOptions(string4);
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getData(...)");
        builder2.setEnvData(environmentVariablesData);
        builder2.setScope(this.scopeComponent.getScope());
        runConfiguration.setSettings(builder2.build());
    }

    @NotNull
    protected JComponent createEditor() {
        return this.panel;
    }

    private static final VirtualFile _init_$lambda$0(VitestRunConfigurationEditor this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        String string = PathShortener.getAbsolutePath((JTextField)this$0.workingDirComponent.getTextField());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String text2 = string;
        return !(((CharSequence)text2).length() == 0) ? LocalFileSystem.getInstance().findFileByPath(text2) : null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor$Companion;", "", "()V", "createConfigurationFileTextField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "project", "Lcom/intellij/openapi/project/Project;", "createVitestOptionsEditor", "Lcom/intellij/util/textCompletion/TextFieldWithCompletion;", "createWorkingDirComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nVitestRunConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestRunConfigurationEditor.kt\ncom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n1549#2:134\n1620#2,3:135\n*S KotlinDebug\n*F\n+ 1 VitestRunConfigurationEditor.kt\ncom/intellij/javascript/testing/vitest/VitestRunConfigurationEditor$Companion\n*L\n108#1:134\n108#1:135,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final TextFieldWithCompletion createVitestOptionsEditor(Project project) {
            VitestCliOptionsCompletionProvider provider = new VitestCliOptionsCompletionProvider();
            TextFieldWithCompletion editor = new TextFieldWithCompletion(project, (TextCompletionProvider)provider, "", true, false, false);
            editor.setPlaceholder((CharSequence)JavaScriptBundle.message("vitest.rc.vitestOptions.emptyText", new Object[0]));
            return editor;
        }

        private final TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(Project project) {
            TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
            PathShortener.enablePathShortening((JTextField)((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).getTextEditor(), null);
            JComponent jComponent = textFieldWithHistoryWithBrowseButton.getChildComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
            TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)jComponent;
            textFieldWithHistory.setHistorySize(-1);
            textFieldWithHistory.setMinimumAndPreferredWidth(0);
            PathShortener.enablePathShortening((JTextField)textFieldWithHistory.getTextEditor(), null);
            SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> Companion.createConfigurationFileTextField$lambda$1(project));
            SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)JavaScriptBundle.message("vitest.rc.configurationFile.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            return textFieldWithHistoryWithBrowseButton;
        }

        private final TextFieldWithBrowseButton createWorkingDirComponent(Project project) {
            TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            PathShortener.enablePathShortening((JTextField)textFieldWithBrowseButton.getTextField(), null);
            SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)JavaScriptBundle.message("rc.workingDirectory.browseDialogTitle", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
            return textFieldWithBrowseButton;
        }

        /*
         * WARNING - void declaration
         */
        private static final List createConfigurationFileTextField$lambda$1(Project $project) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            Iterable $this$map$iv = VitestConfig.INSTANCE.listPossibleConfigFilesInProject($project);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)it.getPath()), (boolean)false));
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

