/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest;

import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.javascript.testing.JsTestConsoleProperties;
import com.intellij.javascript.testing.vitest.VitestRunConfiguration;
import com.intellij.javascript.testing.vitest.coverage.VitestCoverageConfig;
import com.intellij.javascript.testing.vitest.coverage.VitestCoverageConfigListener;
import com.intellij.javascript.testing.vitest.coverage.VitestInstallMissingDependencyFilter;
import com.intellij.javascript.testing.vitest.snapshot.VitestSnapshotEventsListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.terminal.TerminalExecutionConsole;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.messages.Topic;
import java.text.ParseException;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001d\u001eB/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestConsoleProperties;", "Lcom/intellij/javascript/testing/JsTestConsoleProperties;", "configuration", "Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;", "executor", "Lcom/intellij/execution/Executor;", "withTerminalConsole", "", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "addInstallMissingDependencyLink", "(Lcom/intellij/javascript/testing/vitest/VitestRunConfiguration;Lcom/intellij/execution/Executor;ZLcom/intellij/javascript/nodejs/execution/NodeTargetRun;Z)V", "locator", "Lcom/intellij/javascript/testFramework/navigation/JSTestLocationProvider;", "textModifier", "Lcom/intellij/javascript/testing/vitest/coverage/VitestInstallMissingDependencyFilter$TextModifier;", "getTextModifier", "()Lcom/intellij/javascript/testing/vitest/coverage/VitestInstallMissingDependencyFilter$TextModifier;", "createConsole", "Lcom/intellij/execution/ui/ConsoleView;", "createTestEventsConverter", "Lcom/intellij/execution/testframework/sm/runner/OutputToGeneralTestEventsConverter;", "testFrameworkName", "", "consoleProperties", "Lcom/intellij/execution/testframework/TestConsoleProperties;", "getConfiguration", "getTestLocator", "Lcom/intellij/execution/testframework/sm/runner/SMTestLocator;", "Companion", "VitestTestEventsConverter", "intellij.javascript.impl"})
public final class VitestConsoleProperties
extends JsTestConsoleProperties {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean withTerminalConsole;
    @Nullable
    private final NodeTargetRun targetRun;
    private final boolean addInstallMissingDependencyLink;
    @NotNull
    private final JSTestLocationProvider locator;
    @NotNull
    private final VitestInstallMissingDependencyFilter.TextModifier textModifier;
    @Topic.ProjectLevel
    @NotNull
    private static final Topic<VitestCoverageConfigListener> COVERAGE_CONFIG_TOPIC = new Topic("Vitest coverage config parsed", VitestCoverageConfigListener.class, Topic.BroadcastDirection.NONE);

    public VitestConsoleProperties(@NotNull VitestRunConfiguration configuration, @NotNull Executor executor, boolean withTerminalConsole, @Nullable NodeTargetRun targetRun, boolean addInstallMissingDependencyLink) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        super((RunConfiguration)configuration, "VitestJavaScriptTestRunner", executor, targetRun);
        this.withTerminalConsole = withTerminalConsole;
        this.targetRun = targetRun;
        this.addInstallMissingDependencyLink = addInstallMissingDependencyLink;
        this.locator = new JSTestLocationProvider(true);
        this.textModifier = new VitestInstallMissingDependencyFilter.TextModifier();
        this.setUsePredefinedMessageFilter(false);
        this.setIfUndefined((AbstractProperty)JsTestConsoleProperties.HIDE_PASSED_TESTS, false);
        this.setIfUndefined((AbstractProperty)JsTestConsoleProperties.HIDE_IGNORED_TEST, true);
        this.setIfUndefined((AbstractProperty)JsTestConsoleProperties.SCROLL_TO_SOURCE, true);
        this.setIfUndefined((AbstractProperty)JsTestConsoleProperties.SELECT_FIRST_DEFECT, true);
        this.setIdBasedTestTree(true);
        this.setPrintTestingStartedTime(false);
    }

    @NotNull
    public final VitestInstallMissingDependencyFilter.TextModifier getTextModifier() {
        return this.textModifier;
    }

    @NotNull
    public SMTestLocator getTestLocator() {
        return this.locator;
    }

    @NotNull
    public VitestRunConfiguration getConfiguration() {
        RunProfile runProfile = super.getConfiguration();
        Intrinsics.checkNotNull((Object)runProfile, (String)"null cannot be cast to non-null type com.intellij.javascript.testing.vitest.VitestRunConfiguration");
        return (VitestRunConfiguration)runProfile;
    }

    @NotNull
    public ConsoleView createConsole() {
        ConsoleView consoleView;
        if (this.withTerminalConsole) {
            Project project = this.getProject();
            consoleView = (ConsoleView)new TerminalExecutionConsole(project){

                public void attachToProcess(@NotNull ProcessHandler processHandler) {
                    Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
                    super.attachToProcess(processHandler, false);
                }
            };
        } else {
            ConsoleView consoleView2 = super.createConsole();
            consoleView = consoleView2;
            Intrinsics.checkNotNullExpressionValue((Object)consoleView2, (String)"createConsole(...)");
        }
        return consoleView;
    }

    @Override
    @NotNull
    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        Intrinsics.checkNotNullParameter((Object)testFrameworkName, (String)"testFrameworkName");
        Intrinsics.checkNotNullParameter((Object)consoleProperties, (String)"consoleProperties");
        return new VitestTestEventsConverter(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestConsoleProperties$Companion;", "", "()V", "COVERAGE_CONFIG_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/javascript/testing/vitest/coverage/VitestCoverageConfigListener;", "kotlin.jvm.PlatformType", "getCOVERAGE_CONFIG_TOPIC", "()Lcom/intellij/util/messages/Topic;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<VitestCoverageConfigListener> getCOVERAGE_CONFIG_TOPIC() {
            return COVERAGE_CONFIG_TOPIC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0014J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u0012\u0010\u0012\u001a\u00020\b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/testing/vitest/VitestConsoleProperties$VitestTestEventsConverter;", "Lcom/intellij/javascript/testing/JsTestConsoleProperties$JSTestEventsConverter;", "consoleProperties", "Lcom/intellij/javascript/testing/vitest/VitestConsoleProperties;", "(Lcom/intellij/javascript/testing/vitest/VitestConsoleProperties;)V", "getConsoleProperties", "()Lcom/intellij/javascript/testing/vitest/VitestConsoleProperties;", "processConsistentText", "", "text", "", "outputType", "Lcom/intellij/openapi/util/Key;", "processServiceMessage", "message", "Ljetbrains/buildServer/messages/serviceMessages/ServiceMessage;", "visitor", "Ljetbrains/buildServer/messages/serviceMessages/ServiceMessageVisitor;", "setProcessor", "processor", "Lcom/intellij/execution/testframework/sm/runner/GeneralTestEventsProcessor;", "intellij.javascript.impl"})
    private static final class VitestTestEventsConverter
    extends JsTestConsoleProperties.JSTestEventsConverter {
        @NotNull
        private final VitestConsoleProperties consoleProperties;

        public VitestTestEventsConverter(@NotNull VitestConsoleProperties consoleProperties) {
            Intrinsics.checkNotNullParameter((Object)((Object)consoleProperties), (String)"consoleProperties");
            super(consoleProperties);
            this.consoleProperties = consoleProperties;
        }

        @NotNull
        public final VitestConsoleProperties getConsoleProperties() {
            return this.consoleProperties;
        }

        @Override
        public void setProcessor(@Nullable GeneralTestEventsProcessor processor) {
            GeneralTestEventsProcessor generalTestEventsProcessor = processor;
            if (generalTestEventsProcessor != null) {
                generalTestEventsProcessor.addEventsListener((SMTRunnerEventsListener)new VitestSnapshotEventsListener(this.consoleProperties.targetRun));
            }
            super.setProcessor(processor);
        }

        protected void processServiceMessage(@NotNull ServiceMessage message, @NotNull ServiceMessageVisitor visitor) throws ParseException {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
            if (Intrinsics.areEqual((Object)message.getMessageName(), (Object)"vitest-coverage-config")) {
                String coverageDirectory = (String)message.getAttributes().get("coverageDirectory");
                if (coverageDirectory != null) {
                    ((VitestCoverageConfigListener)this.consoleProperties.getProject().getMessageBus().syncPublisher(Companion.getCOVERAGE_CONFIG_TOPIC())).onVitestConfigReceived(this.consoleProperties.getConfiguration(), new VitestCoverageConfig(coverageDirectory));
                }
            } else {
                super.processServiceMessage(message, visitor);
            }
        }

        protected void processConsistentText(@NotNull String text2, @NotNull Key<?> outputType) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
            String newText = this.consoleProperties.addInstallMissingDependencyLink ? this.consoleProperties.getTextModifier().processText(text2, outputType) : text2;
            super.processConsistentText(newText, outputType);
        }
    }
}

