/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.snapshot;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.jest.snapshot.JestSnapshotEventsListener;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import icons.JavaScriptLanguageIcons;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class JSTestingSnapshotReferenceLineMarkerProvider
extends RelatedItemLineMarkerProvider {
    JSTestingSnapshotReferenceLineMarkerProvider() {
    }

    protected void collectNavigationMarkers(@NotNull PsiElement element, @NotNull Collection<? super RelatedItemLineMarkerInfo<?>> result2) {
        RelatedItemLineMarkerInfo<PsiElement> info2;
        JSReferenceExpression parentReferenceExpression;
        PsiElement parent;
        LeafPsiElement leaf;
        if (element == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result2 == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(1);
        }
        if (element.isValid() && element instanceof LeafPsiElement && (leaf = (LeafPsiElement)element).getElementType() == JSTokenTypes.IDENTIFIER && JSTestingSnapshotReferenceLineMarkerProvider.textMatches(leaf) && (parent = leaf.getParent()) instanceof JSReferenceExpression && (parentReferenceExpression = (JSReferenceExpression)parent).getQualifier() != null && parentReferenceExpression.getReferenceNameElement() == element && (info2 = JSTestingSnapshotReferenceLineMarkerProvider.createNavigationMarkerIfNeeded(element)) != null) {
            result2.add(info2);
        }
    }

    private static boolean textMatches(@NotNull LeafPsiElement element) {
        if (element == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(2);
        }
        CharSequence elementText = element.getChars();
        return ContainerUtil.exists(JestSnapshotEventsListener.EXTERNAL_SNAPSHOT_METHOD_NAMES, name -> StringUtil.equals((CharSequence)name, (CharSequence)elementText));
    }

    @Nullable
    private static RelatedItemLineMarkerInfo<PsiElement> createNavigationMarkerIfNeeded(@NotNull PsiElement element) {
        PsiFile snapshotPsiFile;
        JSFile testFile;
        if (element == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(3);
        }
        if ((testFile = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class)) == null || !testFile.isTestFile()) {
            return null;
        }
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(testFile);
        JsTestElementPath path2 = jasmineStructure.findTestElementPath(element.getTextRange());
        if (path2 == null) {
            return null;
        }
        VirtualFile snapshotFile = JSTestingSnapshotReferenceLineMarkerProvider.findSnapshotFile(testFile.getVirtualFile());
        PsiFile psiFile2 = snapshotPsiFile = snapshotFile != null ? element.getManager().findFile(snapshotFile) : null;
        if (snapshotPsiFile == null) {
            return null;
        }
        final GutterIconNavigationHandler<PsiElement> navigationHandler = JSTestingSnapshotReferenceLineMarkerProvider.createNavigationHandler(element.getProject(), snapshotFile, path2);
        return new RelatedItemLineMarkerInfo(element, element.getTextRange(), JavaScriptLanguageIcons.Jest.SnapshotGutter, (Function)new ConstantFunction((Object)JavaScriptBundle.message("jest.go.to.snapshot.text", StringUtil.join(path2.getAllNames(), (String)" "))), navigationHandler, GutterIconRenderer.Alignment.RIGHT, () -> Collections.singletonList(new GotoRelatedItem((PsiElement)snapshotPsiFile, JavaScriptBundle.message("jest.snapshot.label", new Object[0])){

            public void navigate() {
                navigationHandler.navigate(null, (PsiElement)snapshotPsiFile);
            }
        }));
    }

    @NotNull
    private static GutterIconNavigationHandler<PsiElement> createNavigationHandler(@NotNull Project project, @NotNull VirtualFile snapshotFile, @NotNull JsTestElementPath path2) {
        if (project == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(4);
        }
        if (snapshotFile == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(5);
        }
        if (path2 == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(6);
        }
        GutterIconNavigationHandler gutterIconNavigationHandler = (e, elt) -> {
            Document document2 = FileDocumentManager.getInstance().getDocument(snapshotFile);
            int offset = -1;
            if (document2 != null) {
                offset = document2.getTextLength();
                String prefix = "exports[`";
                int ind = StringUtil.indexOf((CharSequence)document2.getCharsSequence(), (CharSequence)(prefix + StringUtil.join(path2.getAllNames(), (String)" ")));
                if (ind != -1) {
                    offset = ind + prefix.length();
                }
            }
            PsiNavigationSupport.getInstance().createNavigatable(project, snapshotFile, offset).navigate(true);
        };
        if (gutterIconNavigationHandler == null) {
            JSTestingSnapshotReferenceLineMarkerProvider.$$$reportNull$$$0(7);
        }
        return gutterIconNavigationHandler;
    }

    @Nullable
    private static VirtualFile findSnapshotFile(@Nullable VirtualFile testFile) {
        if (testFile == null) {
            return null;
        }
        VirtualFile dir = testFile.getParent();
        if (dir == null) {
            return null;
        }
        VirtualFile snapshotDir = dir.findChild("__snapshots__");
        if (snapshotDir != null) {
            return snapshotDir.findChild(testFile.getName() + ".snap");
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotFile";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/snapshot/JSTestingSnapshotReferenceLineMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/snapshot/JSTestingSnapshotReferenceLineMarkerProvider";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createNavigationHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "textMatches";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationMarkerIfNeeded";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createNavigationHandler";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

