/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.runScope;

import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.javascript.testing.runScope.JsTestRunScopeView;
import com.intellij.openapi.project.Project;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0015\u001a\u00020\u0014H\u0002J\u0006\u0010\u0016\u001a\u00020\u0017J\n\u0010\u0018\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0017J\u0018\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00120\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/javascript/testing/runScope/JsTestRunScopeComponent;", "", "project", "Lcom/intellij/openapi/project/Project;", "longestLabelWidth", "", "withDirectory", "", "(Lcom/intellij/openapi/project/Project;IZ)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "radioButtonMap", "", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeKind;", "Ljavax/swing/JRadioButton;", "scopeKindViewMap", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeView;", "selectedScopeKindPanel", "Ljavax/swing/JPanel;", "createScopeKindRadioButtonPanel", "getScope", "Lcom/intellij/javascript/testing/runScope/JsTestRunScope;", "getScopeKind", "getScopeKindView", "scopeKind", "resetEditorFrom", "", "scope", "setCenterBorderLayoutComponent", "panel", "child", "Ljava/awt/Component;", "setScopeKind", "intellij.javascript.impl"})
public final class JsTestRunScopeComponent {
    @NotNull
    private final Project project;
    private final int longestLabelWidth;
    private final boolean withDirectory;
    @NotNull
    private final Map<JsTestRunScopeKind, JRadioButton> radioButtonMap;
    @NotNull
    private final Map<JsTestRunScopeKind, JsTestRunScopeView> scopeKindViewMap;
    @NotNull
    private final JPanel selectedScopeKindPanel;
    @NotNull
    private final JComponent component;

    public JsTestRunScopeComponent(@NotNull Project project, int longestLabelWidth, boolean withDirectory) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.longestLabelWidth = longestLabelWidth;
        this.withDirectory = withDirectory;
        this.radioButtonMap = new EnumMap(JsTestRunScopeKind.class);
        this.scopeKindViewMap = new EnumMap(JsTestRunScopeKind.class);
        this.selectedScopeKindPanel = new JPanel(new BorderLayout());
        JPanel scopeKindPanel = this.createScopeKindRadioButtonPanel();
        JPanel jPanel = new FormBuilder().addComponent((JComponent)scopeKindPanel).addComponent((JComponent)this.selectedScopeKindPanel).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        this.component = jPanel;
    }

    @NotNull
    public final JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public final JsTestRunScope getScope() {
        JsTestRunScope.Builder builder2 = new JsTestRunScope.Builder(null, null, null, null, 15, null);
        JsTestRunScopeKind scopeKind = this.getScopeKind();
        if (scopeKind != null) {
            builder2.setKind(scopeKind);
            this.getScopeKindView(scopeKind).applyTo(builder2);
        }
        return builder2.build();
    }

    public final void resetEditorFrom(@NotNull JsTestRunScope scope2) {
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        this.setScopeKind(scope2.getKind());
        for (JsTestRunScopeKind value : JsTestRunScopeKind.values()) {
            this.getScopeKindView(value).resetFrom(scope2);
        }
    }

    private final JPanel createScopeKindRadioButtonPanel() {
        JPanel testKindPanel = new JPanel(new FlowLayout(1, JBUIScale.scale((int)40), 0));
        testKindPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)10));
        ButtonGroup buttonGroup = new ButtonGroup();
        for (JsTestRunScopeKind scopeKind : JsTestRunScopeKind.values()) {
            if (scopeKind == JsTestRunScopeKind.DIRECTORY && !this.withDirectory) continue;
            JRadioButton radioButton = new JRadioButton(UIUtil.replaceMnemonicAmpersand((String)scopeKind.getDisplayName()));
            radioButton.addActionListener(arg_0 -> JsTestRunScopeComponent.createScopeKindRadioButtonPanel$lambda$0(this, scopeKind, arg_0));
            this.radioButtonMap.put(scopeKind, radioButton);
            testKindPanel.add(radioButton);
            buttonGroup.add(radioButton);
        }
        return testKindPanel;
    }

    private final void setScopeKind(JsTestRunScopeKind scopeKind) {
        JsTestRunScopeKind selectedScopeKind = this.getScopeKind();
        if (selectedScopeKind != scopeKind) {
            JRadioButton jRadioButton = this.radioButtonMap.get((Object)scopeKind);
            Intrinsics.checkNotNull((Object)jRadioButton);
            jRadioButton.setSelected(true);
        }
        JsTestRunScopeView view = this.getScopeKindView(scopeKind);
        this.setCenterBorderLayoutComponent(this.selectedScopeKindPanel, view.getComponent());
    }

    private final JsTestRunScopeKind getScopeKind() {
        for (Map.Entry<JsTestRunScopeKind, JRadioButton> entry : this.radioButtonMap.entrySet()) {
            if (!entry.getValue().isSelected()) continue;
            return entry.getKey();
        }
        return null;
    }

    private final JsTestRunScopeView getScopeKindView(JsTestRunScopeKind scopeKind) {
        JsTestRunScopeView view = this.scopeKindViewMap.get((Object)scopeKind);
        if (view == null) {
            view = scopeKind.createView(this.project);
            this.scopeKindViewMap.put(scopeKind, view);
            JComponent component = view.getComponent();
            if (component.getLayout() instanceof GridBagLayout) {
                component.add(Box.createHorizontalStrut(this.longestLabelWidth), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 13, 0, (Insets)JBUI.insets((int)0, (int)0, (int)0, (int)10), 0, 0));
            }
        }
        return view;
    }

    private final void setCenterBorderLayoutComponent(JPanel panel2, Component child) {
        LayoutManager layoutManager = panel2.getLayout();
        Intrinsics.checkNotNull((Object)layoutManager, (String)"null cannot be cast to non-null type java.awt.BorderLayout");
        Component prevChild = ((BorderLayout)layoutManager).getLayoutComponent("Center");
        if (prevChild != null) {
            panel2.remove(prevChild);
        }
        panel2.add(child, "Center");
        panel2.revalidate();
        panel2.repaint();
    }

    private static final void createScopeKindRadioButtonPanel$lambda$0(JsTestRunScopeComponent this$0, JsTestRunScopeKind $scopeKind, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)((Object)$scopeKind), (String)"$scopeKind");
        this$0.setScopeKind($scopeKind);
    }
}

