/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.runConfiguration;

import com.intellij.execution.configurations.LocatableConfiguration;
import com.intellij.execution.testframework.TestRunnerBundle;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoManager;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoNameUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.javascript.testing.runScope.JsTestRunScope;
import com.intellij.javascript.testing.runScope.JsTestRunScopeKind;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.File;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\r\u0010\u0006\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u0005H\u0002J:\u0010\u0007\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000eJ;\u0010\u0010\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f2\r\u0010\u0006\u001a\t\u0018\u00010\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005H\u0002J2\u0010\u0012\u001a\u00070\u0004\u00a2\u0006\u0002\b\u00052\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u000b\u0010\f\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a8\u0006\u0016"}, d2={"Lcom/intellij/javascript/testing/runConfiguration/JsTestRunConfigurationUtil;", "", "()V", "getAllTestsName", "", "Lorg/jetbrains/annotations/Nls;", "packageName", "getRunConfigurationActionName", "runConfiguration", "Lcom/intellij/execution/configurations/LocatableConfiguration;", "scope", "Lcom/intellij/javascript/testing/runScope/JsTestRunScope;", "configFilePath", "contextFileProvider", "Lkotlin/Function0;", "Lcom/intellij/openapi/vfs/VirtualFile;", "suggestName", "packageRoot", "suggestRunConfigurationName", "project", "Lcom/intellij/openapi/project/Project;", "contextFileOrDir", "intellij.javascript.impl"})
public final class JsTestRunConfigurationUtil {
    @NotNull
    public static final JsTestRunConfigurationUtil INSTANCE = new JsTestRunConfigurationUtil();

    private JsTestRunConfigurationUtil() {
    }

    @NotNull
    public final String suggestRunConfigurationName(@NotNull Project project, @Nullable VirtualFile contextFileOrDir, @NotNull JsTestRunScope scope2, @NotNull String configFilePath) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        VirtualFile packageRoot = JSMonorepoManager.Companion.getInstance(project).guessContextPackageRoot(contextFileOrDir);
        return this.suggestName(packageRoot, JSMonorepoNameUtils.getPackageName(packageRoot), scope2, configFilePath);
    }

    @Nullable
    public final String getRunConfigurationActionName(@NotNull LocatableConfiguration runConfiguration, @NotNull JsTestRunScope scope2, @NotNull String configFilePath, @NotNull Function0<? extends VirtualFile> contextFileProvider) {
        String string;
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)configFilePath, (String)"configFilePath");
        Intrinsics.checkNotNullParameter(contextFileProvider, (String)"contextFileProvider");
        if ((scope2.getKind() == JsTestRunScopeKind.SUITE || scope2.getKind() == JsTestRunScopeKind.TEST) && (string = (String)CollectionsKt.lastOrNull(scope2.getTestNames())) != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (runConfiguration.isGeneratedName()) {
            VirtualFile virtualFile;
            if (scope2.getKind() == JsTestRunScopeKind.DIRECTORY) {
                Project project = runConfiguration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                virtualFile = JSMonorepoManager.Companion.getInstance(project).guessContextPackageRoot((VirtualFile)contextFileProvider.invoke());
            } else {
                virtualFile = null;
            }
            VirtualFile packageRoot = virtualFile;
            return this.suggestName(packageRoot, null, scope2, configFilePath);
        }
        return null;
    }

    private final String suggestName(VirtualFile packageRoot, String packageName, JsTestRunScope scope2, String configFilePath) {
        if (scope2.getKind() == JsTestRunScopeKind.DIRECTORY) {
            VirtualFile virtualFile = packageRoot;
            if (Intrinsics.areEqual((Object)(virtualFile != null ? virtualFile.getPath() : null), (Object)FileUtil.toSystemIndependentName((String)scope2.getTestDirectoryPath()))) {
                return this.getAllTestsName(packageName);
            }
            Object[] objectArray = new Object[]{JSMonorepoNameUtils.buildContextName(packageName, PathUtil.getFileName((String)scope2.getTestDirectoryPath()) + File.separator)};
            String string = JavaScriptBundle.message("rc.testDirectory.presentable.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }
        if (scope2.getKind() == JsTestRunScopeKind.TEST_FILE) {
            String string = PathUtil.getFileName((String)scope2.getTestFilePath());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            return JSMonorepoNameUtils.buildContextName(packageName, string);
        }
        if (scope2.getKind() == JsTestRunScopeKind.SUITE || scope2.getKind() == JsTestRunScopeKind.TEST) {
            String string = JsTestFqn.getPresentableName(scope2.getTestNames());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
            return string;
        }
        if (!StringsKt.isBlank((CharSequence)configFilePath)) {
            Object[] objectArray = new Object[1];
            String string = PathUtil.getFileName((String)configFilePath);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getFileName(...)");
            objectArray[0] = JSMonorepoNameUtils.buildContextName(packageName, string);
            String string2 = JavaScriptBundle.message("rc.testConfig.presentable.name", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            return string2;
        }
        return this.getAllTestsName(packageName);
    }

    private final String getAllTestsName(String packageName) {
        String string;
        if (packageName != null) {
            Object[] objectArray = new Object[]{packageName};
            String string2 = JavaScriptBundle.message("rc.testConfig.presentable.name", objectArray);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        } else {
            String string3 = TestRunnerBundle.message((String)"all.tests.scope.presentable.text", (Object[])new Object[0]);
            Intrinsics.checkNotNull((Object)string3);
            string = string3;
        }
        return string;
    }
}

