/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.CompositeFilter;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.testing.JSTestFailedLineManager;
import com.intellij.openapi.project.Project;
import com.intellij.pom.Navigatable;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsTestConsoleProperties
extends SMTRunnerConsoleProperties
implements SMCustomMessagesParsing {
    private final CompositeFilter myStackTraceFilter;
    private final NodeTargetRun myTargetRun;

    public JsTestConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor) {
        if (config == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(0);
        }
        if (testFrameworkName == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(2);
        }
        this(config, testFrameworkName, executor, null);
    }

    public JsTestConsoleProperties(@NotNull RunConfiguration config, @NotNull String testFrameworkName, @NotNull Executor executor, @Nullable NodeTargetRun targetRun) {
        if (config == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(3);
        }
        if (testFrameworkName == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(4);
        }
        if (executor == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(5);
        }
        super(config, testFrameworkName, executor);
        this.myTargetRun = targetRun;
        this.myStackTraceFilter = new CompositeFilter(config.getProject());
    }

    public void addStackTraceFilter(@NotNull Filter filter) {
        if (filter == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(6);
        }
        this.myStackTraceFilter.addFilter(filter);
    }

    @NotNull
    public List<Filter> getStackTrackFilters() {
        List list2 = this.myStackTraceFilter.getFilters();
        if (list2 == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Nullable
    public Navigatable getErrorNavigatable(@NotNull Location<?> location, @NotNull String stacktrace) {
        if (location == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(8);
        }
        if (stacktrace == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(9);
        }
        if (this.myStackTraceFilter.isEmpty()) {
            return null;
        }
        JSTestFailedLineManager manager = JSTestFailedLineManager.getInstance(this.getProject());
        JSTestFailedLineManager.ResolveResult result2 = manager.findFailedLineForTest(location.getPsiElement());
        return result2 != null ? result2.getDescriptor() : null;
    }

    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        if (testFrameworkName == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(10);
        }
        if (consoleProperties == null) {
            JsTestConsoleProperties.$$$reportNull$$$0(11);
        }
        return new JSTestEventsConverter((JsTestConsoleProperties)consoleProperties);
    }

    @Nullable
    public NodeTargetRun getTargetRun() {
        return this.myTargetRun;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFrameworkName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/JsTestConsoleProperties";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stacktrace";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/JsTestConsoleProperties";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStackTrackFilters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addStackTraceFilter";
                break;
            }
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getErrorNavigatable";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createTestEventsConverter";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }

    public static class JSTestEventsConverter
    extends OutputToGeneralTestEventsConverter {
        private final Project myProject;
        private final Filter myStackTraceFilter;
        private JsTestConsoleProperties myConsoleProperties;

        protected JSTestEventsConverter(@NotNull JsTestConsoleProperties consoleProperties) {
            if (consoleProperties == null) {
                JSTestEventsConverter.$$$reportNull$$$0(0);
            }
            super(consoleProperties.getTestFrameworkName(), true, false, !consoleProperties.isIdBasedTestTree());
            this.myConsoleProperties = consoleProperties;
            this.myProject = consoleProperties.getProject();
            this.myStackTraceFilter = consoleProperties.myStackTraceFilter;
        }

        @Deprecated(forRemoval=true)
        public JSTestEventsConverter(String testFrameworkName, boolean stdinEnabled) {
            super(testFrameworkName, false, false, false);
            this.myProject = null;
            this.myStackTraceFilter = null;
        }

        public void setProcessor(@Nullable GeneralTestEventsProcessor processor) {
            if (processor != null && this.myProject != null && this.myStackTraceFilter != null) {
                NodeTargetRun targetRun = this.myConsoleProperties != null ? this.myConsoleProperties.getTargetRun() : null;
                JSTestFailedLineManager.getInstance(this.myProject).onTestConfigurationStarted(processor, this.myStackTraceFilter, targetRun);
            }
            super.setProcessor(processor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleProperties", "com/intellij/javascript/testing/JsTestConsoleProperties$JSTestEventsConverter", "<init>"));
        }
    }
}

