/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.intellij.lang.javascript.linter.JSLinterConfigFileUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.util.JsonUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AngularCliConfig {
    private static final Logger LOG = Logger.getInstance(AngularCliConfig.class);
    private static final String DEFAULT_PROJECT = "defaultProject";
    private final VirtualFile myConfig;

    public AngularCliConfig(@NotNull VirtualFile config) {
        if (config == null) {
            AngularCliConfig.$$$reportNull$$$0(0);
        }
        this.myConfig = config;
    }

    @Nullable
    public String getProjectContainingFileOrDefault(@Nullable VirtualFile file) {
        try {
            String value = this.doGetProjectContainingFile(file, true);
            if (value == null) {
                LOG.info("No project found in " + this.myConfig.getPath());
            }
            return value;
        }
        catch (Exception e) {
            LOG.info("Failed to find project in " + this.myConfig.getPath(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    public String getProjectContainingFile(@Nullable VirtualFile file) {
        try {
            String value = this.doGetProjectContainingFile(file, false);
            if (value == null) {
                LOG.info("No project found in " + this.myConfig.getPath());
            }
            return value;
        }
        catch (Exception e) {
            LOG.info("Failed to find project in " + this.myConfig.getPath(), (Throwable)e);
            return null;
        }
    }

    @Nullable
    private String doGetProjectContainingFile(@Nullable VirtualFile file, boolean returnDefaultProjectOnFallback) throws IOException {
        MultiMap<VirtualFile, String> projectRootToNameMap;
        VirtualFile nearestRoot;
        if (!this.myConfig.isValid()) {
            return null;
        }
        String text2 = JSLinterConfigFileUtil.loadActualText(this.myConfig);
        JsonObject rootObj = new JsonParser().parse(text2).getAsJsonObject();
        String defaultProject = JsonUtil.getChildAsString((JsonObject)rootObj, (String)DEFAULT_PROJECT);
        JsonObject projectsObj = JsonUtil.getChildAsObject((JsonObject)rootObj, (String)"projects");
        if (projectsObj != null && file != null && (nearestRoot = AngularCliConfig.findNearestRoot(file, (projectRootToNameMap = this.getProjectRootToNameMap(projectsObj)).keySet())) != null) {
            Collection projects = projectRootToNameMap.get((Object)nearestRoot);
            if (projects.contains(defaultProject) && AngularCliConfig.isSuitableProject(defaultProject)) {
                return defaultProject;
            }
            String suitable = projects.stream().filter(AngularCliConfig::isSuitableProject).findFirst().orElse(null);
            return (String)ObjectUtils.notNull((Object)suitable, (Object)Objects.requireNonNull((String)ContainerUtil.getFirstItem((Collection)projects)));
        }
        if (returnDefaultProjectOnFallback) {
            LOG.info("Cannot find project containing file, fallback to default project");
            if (defaultProject != null) {
                return defaultProject;
            }
            return projectsObj != null ? (String)ContainerUtil.getFirstItem((Collection)projectsObj.keySet()) : null;
        }
        return null;
    }

    @NotNull
    private MultiMap<VirtualFile, String> getProjectRootToNameMap(@NotNull JsonObject projectsObj) {
        if (projectsObj == null) {
            AngularCliConfig.$$$reportNull$$$0(1);
        }
        MultiMap projectRootToNameMap = MultiMap.create();
        for (Map.Entry entry : projectsObj.entrySet()) {
            JsonObject projectObj = JsonUtil.getAsObject((JsonElement)((JsonElement)entry.getValue()));
            if (projectObj == null) {
                LOG.info("Unexpected " + entry);
                continue;
            }
            VirtualFile root = this.getProjectRoot(projectObj);
            if (root == null) continue;
            projectRootToNameMap.putValue((Object)root, (Object)((String)entry.getKey()));
        }
        MultiMap multiMap = projectRootToNameMap;
        if (multiMap == null) {
            AngularCliConfig.$$$reportNull$$$0(2);
        }
        return multiMap;
    }

    @Nullable
    private VirtualFile getProjectRoot(@NotNull JsonObject projectObj) {
        if (projectObj == null) {
            AngularCliConfig.$$$reportNull$$$0(3);
        }
        String rootStr = StringUtil.notNullize((String)JsonUtil.getChildAsString((JsonObject)projectObj, (String)"root"));
        return this.myConfig.getParent().findFileByRelativePath(rootStr);
    }

    @Nullable
    private static VirtualFile findNearestRoot(@NotNull VirtualFile file, @NotNull Set<VirtualFile> roots) {
        if (file == null) {
            AngularCliConfig.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            AngularCliConfig.$$$reportNull$$$0(5);
        }
        for (VirtualFile parent = file; parent != null; parent = parent.getParent()) {
            if (!roots.contains(parent)) continue;
            return parent;
        }
        return null;
    }

    @Contract(value="null -> false")
    private static boolean isSuitableProject(@Nullable String projectName) {
        return projectName != null && !projectName.endsWith("-e2e");
    }

    @Nullable
    public static AngularCliConfig findProjectConfig(@NotNull File workingDirectory) {
        VirtualFile root;
        if (workingDirectory == null) {
            AngularCliConfig.$$$reportNull$$$0(6);
        }
        if ((root = LocalFileSystem.getInstance().findFileByIoFile(workingDirectory)) == null) {
            return null;
        }
        VirtualFile config = JSLinterConfigFileUtil.findFileUpToFileSystemRoot(root, new String[]{"angular.json", ".angular.json", "angular-cli.json", ".angular-cli.json"});
        return config != null ? new AngularCliConfig(config) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsObj";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testing/AngularCliConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectObj";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testing/AngularCliConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectRootToNameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRootToNameMap";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProjectRoot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findNearestRoot";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findProjectConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

