/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.qunit.AbstractQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.DefaultQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.javascript.testFramework.util.JsTestFqn;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QUnitFileStructure
extends AbstractTestFileStructure {
    private final List<QUnitModuleStructure> myNonDefaultModuleStructures;
    private final Map<String, QUnitModuleStructure> myNonDefaultModuleStructureByNameMap;
    private final DefaultQUnitModuleStructure myDefaultModuleStructure;
    private Map<JSCallExpression, String> myNameByPsiElementMap;

    public QUnitFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            QUnitFileStructure.$$$reportNull$$$0(0);
        }
        super(jsFile);
        this.myNonDefaultModuleStructures = new ArrayList<QUnitModuleStructure>();
        this.myNonDefaultModuleStructureByNameMap = Maps.newHashMap();
        this.myDefaultModuleStructure = new DefaultQUnitModuleStructure(this);
    }

    @Override
    public boolean isEmpty() {
        return !this.hasQUnitSymbols();
    }

    @NotNull
    public List<QUnitModuleStructure> getNonDefaultModuleStructures() {
        List<QUnitModuleStructure> list2 = this.myNonDefaultModuleStructures;
        if (list2 == null) {
            QUnitFileStructure.$$$reportNull$$$0(1);
        }
        return list2;
    }

    public int getAllModuleCount() {
        return this.myNonDefaultModuleStructures.size() + 1;
    }

    public int getNonDefaultModuleCount() {
        return this.myNonDefaultModuleStructures.size();
    }

    public void addModuleStructure(@NotNull QUnitModuleStructure moduleStructure) {
        if (moduleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(2);
        }
        this.myNonDefaultModuleStructureByNameMap.put(moduleStructure.getName(), moduleStructure);
        this.myNonDefaultModuleStructures.add(moduleStructure);
    }

    @Nullable
    public String getNameByPsiElement(@NotNull JSCallExpression psiElement) {
        if (psiElement == null) {
            QUnitFileStructure.$$$reportNull$$$0(3);
        }
        return this.myNameByPsiElementMap.get(psiElement);
    }

    @Nullable
    public AbstractQUnitModuleStructure findQUnitModuleByName(@NotNull String qunitModuleName) {
        AbstractQUnitModuleStructure moduleStructure;
        if (qunitModuleName == null) {
            QUnitFileStructure.$$$reportNull$$$0(4);
        }
        if ((moduleStructure = (AbstractQUnitModuleStructure)this.myNonDefaultModuleStructureByNameMap.get(qunitModuleName)) == null && this.myDefaultModuleStructure.getName().equals(qunitModuleName)) {
            moduleStructure = this.myDefaultModuleStructure;
        }
        return moduleStructure;
    }

    @NotNull
    public DefaultQUnitModuleStructure getDefaultModuleStructure() {
        DefaultQUnitModuleStructure defaultQUnitModuleStructure = this.myDefaultModuleStructure;
        if (defaultQUnitModuleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(5);
        }
        return defaultQUnitModuleStructure;
    }

    public boolean hasQUnitSymbols() {
        return this.myDefaultModuleStructure.getTestCount() > 0 || this.getNonDefaultModuleCount() > 0;
    }

    @Nullable
    public QUnitModuleStructure findModuleStructureContainingOffset(int offset) {
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            TextRange moduleTextRange = moduleStructure.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(moduleTextRange, offset)) continue;
            return moduleStructure;
        }
        return null;
    }

    @Nullable
    public QUnitTestMethodStructure findTestMethodStructureContainingOffset(int offset) {
        QUnitTestMethodStructure testMethodStructure = this.myDefaultModuleStructure.findTestMethodStructureContainingOffset(offset);
        if (testMethodStructure != null) {
            return testMethodStructure;
        }
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            testMethodStructure = moduleStructure.findTestMethodStructureContainingOffset(offset);
            if (testMethodStructure == null) continue;
            return testMethodStructure;
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement findPsiElement(@NotNull JsTestFqn testFqn) {
        AbstractQUnitModuleStructure qunitModuleStructure;
        if (testFqn == null) {
            QUnitFileStructure.$$$reportNull$$$0(6);
        }
        String testCaseName = (String)ContainerUtil.getFirstItem(testFqn.getNames());
        String testMethodName = (String)ContainerUtil.getOrElse(testFqn.getNames(), (int)1, null);
        if (testCaseName != null && (qunitModuleStructure = this.findQUnitModuleByName(testCaseName)) != null) {
            if (testMethodName != null) {
                QUnitTestMethodStructure test = qunitModuleStructure.getTestMethodStructureByName(testMethodName);
                if (test != null) {
                    return test.getCallExpression();
                }
            } else {
                QUnitModuleStructure nonDefault = (QUnitModuleStructure)ObjectUtils.tryCast((Object)qunitModuleStructure, QUnitModuleStructure.class);
                if (nonDefault != null) {
                    return nonDefault.getEnclosingCallExpression();
                }
            }
        }
        return null;
    }

    public List<AbstractQUnitModuleStructure> getChildren() {
        ArrayList<AbstractQUnitModuleStructure> result2 = new ArrayList<AbstractQUnitModuleStructure>(this.myNonDefaultModuleStructures);
        result2.add((QUnitModuleStructure)((Object)this.myDefaultModuleStructure));
        return result2;
    }

    void postProcess() {
        this.myNameByPsiElementMap = this.createNameByPsiElementMap();
    }

    @NotNull
    private Map<JSCallExpression, String> createNameByPsiElementMap() {
        int count = this.myDefaultModuleStructure.getTestCount();
        for (QUnitModuleStructure nonDefaultModuleStructure : this.myNonDefaultModuleStructures) {
            count += nonDefaultModuleStructure.getTestCount() + 1;
        }
        if (count == 0) {
            Map<JSCallExpression, String> map = Collections.emptyMap();
            if (map == null) {
                QUnitFileStructure.$$$reportNull$$$0(7);
            }
            return map;
        }
        IdentityHashMap<JSCallExpression, String> nameMap = new IdentityHashMap<JSCallExpression, String>(count);
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            JSCallExpression moduleElement = moduleStructure.getEnclosingCallExpression();
            nameMap.put(moduleElement, moduleStructure.getName());
            QUnitFileStructure.handleModuleStructure(moduleStructure, nameMap);
        }
        QUnitFileStructure.handleModuleStructure(this.myDefaultModuleStructure, nameMap);
        IdentityHashMap<JSCallExpression, String> identityHashMap = nameMap;
        if (identityHashMap == null) {
            QUnitFileStructure.$$$reportNull$$$0(8);
        }
        return identityHashMap;
    }

    public void forEachTest(@NotNull Consumer<QUnitTestMethodStructure> testConsumer) {
        if (testConsumer == null) {
            QUnitFileStructure.$$$reportNull$$$0(9);
        }
        this.myDefaultModuleStructure.forEachTest(testConsumer);
        for (QUnitModuleStructure module : this.myNonDefaultModuleStructures) {
            module.forEachTest(testConsumer);
        }
    }

    private static void handleModuleStructure(@NotNull AbstractQUnitModuleStructure moduleStructure, @NotNull Map<JSCallExpression, String> nameMap) {
        if (moduleStructure == null) {
            QUnitFileStructure.$$$reportNull$$$0(10);
        }
        if (nameMap == null) {
            QUnitFileStructure.$$$reportNull$$$0(11);
        }
        for (QUnitTestMethodStructure testMethodStructure : moduleStructure.getTestMethodStructures()) {
            JSCallExpression methodElement = testMethodStructure.getCallExpression();
            nameMap.put(methodElement, testMethodStructure.getName());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsFile";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructure";
                break;
            }
            case 2: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleStructure";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qunitModuleName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testFqn";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testConsumer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/testFramework/qunit/QUnitFileStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonDefaultModuleStructures";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultModuleStructure";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createNameByPsiElementMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addModuleStructure";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNameByPsiElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findQUnitModuleByName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findPsiElement";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "forEachTest";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "handleModuleStructure";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

