/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.google.common.collect.ImmutableList;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.javascript.protractor.ProtractorConfigurationType;
import com.intellij.javascript.protractor.ProtractorRunConfiguration;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.protractor.scope.ProtractorScopeKind;
import com.intellij.javascript.testFramework.JsTestElementPath;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructure;
import com.intellij.javascript.testFramework.jasmine.JasmineFileStructureBuilder;
import com.intellij.javascript.testing.JsPackageDependentTestRunConfigurationProducer;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ObjectUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunConfigurationProducer
extends JsPackageDependentTestRunConfigurationProducer<ProtractorRunConfiguration> {
    protected ProtractorRunConfigurationProducer() {
        super((List<String>)ImmutableList.of((Object)"protractor"));
    }

    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        ProtractorConfigurationType protractorConfigurationType = ProtractorConfigurationType.getInstance();
        if (protractorConfigurationType == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return protractorConfigurationType;
    }

    protected boolean setupConfigurationFromCompatibleContext(@NotNull ProtractorRunConfiguration configuration, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        PsiElement element;
        if (configuration == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context2 == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = context2.getPsiLocation()) == null || !this.isTestRunnerAvailableFor(element, context2)) {
            return false;
        }
        TestElementInfo elementRunInfo = ProtractorRunConfigurationProducer.createTestElementRunInfo(element, configuration.getRunSettings());
        if (elementRunInfo == null) {
            return false;
        }
        ProtractorRunSettings runSettings = elementRunInfo.getRunSettings();
        configuration.setRunSettings(runSettings);
        sourceElement.set((Object)elementRunInfo.getEnclosingTestElement());
        configuration.setGeneratedName();
        return true;
    }

    public boolean isConfigurationFromCompatibleContext(@NotNull ProtractorRunConfiguration configuration, @NotNull ConfigurationContext context2) {
        PsiElement location;
        if (configuration == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context2 == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context2.getPsiLocation()) == null) {
            return false;
        }
        ProtractorRunSettings confSettings = configuration.getRunSettings();
        TestElementInfo info2 = ProtractorRunConfigurationProducer.createTestElementRunInfo(location, confSettings);
        return info2 != null && confSettings.equals(info2.myRunSettings);
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        ProtractorRunConfiguration selfRc = (ProtractorRunConfiguration)ObjectUtils.tryCast((Object)self.getConfiguration(), ProtractorRunConfiguration.class);
        PsiFile psiFile2 = self.getSourceElement().getContainingFile();
        return psiFile2 != null && selfRc != null && other != null && selfRc.isPreferredOver(other.getConfiguration(), (PsiElement)psiFile2);
    }

    @Nullable
    private static TestElementInfo createTestElementRunInfo(@NotNull PsiElement element, @NotNull ProtractorRunSettings templateRunSettings) {
        VirtualFile virtualFile;
        if (element == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (templateRunSettings == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(7);
        }
        if ((virtualFile = PsiUtilCore.getVirtualFile((PsiElement)element)) == null) {
            return null;
        }
        JSFile file = (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        if (file != null && file.isTestFile()) {
            ProtractorRunSettings settings2 = ProtractorRunConfigurationProducer.guessConfigFileIfNeeded(templateRunSettings, virtualFile, element.getProject());
            if (settings2.getConfigFileSystemDependentPath().isEmpty()) {
                return null;
            }
            TestElementInfo info2 = ProtractorRunConfigurationProducer.setupAsSuiteOrTest(file, virtualFile, element, settings2);
            if (info2 != null) {
                return info2;
            }
            return new TestElementInfo(settings2.toBuilder().setScopeKind(ProtractorScopeKind.TEST_FILE).setTestFilePath(virtualFile.getPath()).build(), file);
        }
        if (file != null && ProtractorUtil.isProtractorConfigFile(virtualFile.getNameSequence())) {
            ProtractorRunSettings.Builder builder2 = templateRunSettings.toBuilder().setScopeKind(ProtractorScopeKind.ALL).setConfigFilePath(virtualFile.getPath());
            String suiteName = ProtractorRunConfigurationProducer.getSuiteName(element);
            if (suiteName != null) {
                String options;
                builder2.setProtractorOptions(options + ((options = templateRunSettings.getProtractorOptions()).isEmpty() ? "" : " ") + "--suite=" + suiteName);
            }
            return new TestElementInfo(builder2.build(), file);
        }
        return null;
    }

    static String getSuiteName(@NotNull PsiElement element) {
        JSProperty suiteProperty;
        JSObjectLiteralExpression objectLiteralExpression;
        JSProperty property;
        if (element == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(8);
        }
        if (element instanceof LeafPsiElement && (property = (JSProperty)ObjectUtils.tryCast((Object)element.getParent(), JSProperty.class)) != null && property.getNameIdentifier() == element && (objectLiteralExpression = (JSObjectLiteralExpression)ObjectUtils.tryCast((Object)property.getParent(), JSObjectLiteralExpression.class)) != null && (suiteProperty = (JSProperty)ObjectUtils.tryCast((Object)objectLiteralExpression.getParent(), JSProperty.class)) != null && "suites".equals(suiteProperty.getName())) {
            return property.getName();
        }
        return null;
    }

    @Nullable
    private static TestElementInfo setupAsSuiteOrTest(@NotNull JSFile file, @NotNull VirtualFile virtualFile, @NotNull PsiElement element, @NotNull ProtractorRunSettings templateSettings) {
        if (file == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(9);
        }
        if (virtualFile == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(10);
        }
        if (element == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(11);
        }
        if (templateSettings == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(12);
        }
        if (element instanceof PsiFileSystemItem) {
            return null;
        }
        TextRange textRange2 = element.getTextRange();
        if (textRange2 == null) {
            return null;
        }
        JasmineFileStructure jasmineStructure = (JasmineFileStructure)JasmineFileStructureBuilder.getInstance().fetchCachedTestFileStructure(file);
        JsTestElementPath path2 = jasmineStructure.findTestElementPath(textRange2);
        if (path2 != null) {
            ProtractorRunSettings.Builder builder2 = templateSettings.toBuilder();
            builder2.setTestFilePath(virtualFile.getPath());
            String testName = path2.getTestName();
            if (testName == null) {
                builder2.setScopeKind(ProtractorScopeKind.SUITE);
                builder2.setTestNames(path2.getSuiteNames());
            } else {
                builder2.setScopeKind(ProtractorScopeKind.TEST);
                builder2.setTestNames(path2.getAllNames());
            }
            return new TestElementInfo(builder2.build(), path2.getTestElement());
        }
        return null;
    }

    @NotNull
    private static ProtractorRunSettings guessConfigFileIfNeeded(@NotNull ProtractorRunSettings settings2, @NotNull VirtualFile contextFile, @NotNull Project project) {
        if (settings2 == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(13);
        }
        if (contextFile == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(14);
        }
        if (project == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(15);
        }
        if (!settings2.getConfigFileSystemDependentPath().isEmpty()) {
            ProtractorRunSettings protractorRunSettings = settings2;
            if (protractorRunSettings == null) {
                ProtractorRunConfigurationProducer.$$$reportNull$$$0(16);
            }
            return protractorRunSettings;
        }
        VirtualFile protractorConfigFile = (VirtualFile)JSProjectUtil.processDirectoriesUpToContentRootAndFindFirst(project, contextFile, dir -> {
            VirtualFile[] children;
            for (VirtualFile child : children = dir.getChildren()) {
                if (!ProtractorUtil.isProtractorConfigFile(child.getNameSequence())) continue;
                return child;
            }
            return null;
        });
        if (protractorConfigFile == null) {
            ProtractorRunSettings protractorRunSettings = settings2;
            if (protractorRunSettings == null) {
                ProtractorRunConfigurationProducer.$$$reportNull$$$0(17);
            }
            return protractorRunSettings;
        }
        ProtractorRunSettings protractorRunSettings = settings2.toBuilder().setConfigFilePath(protractorConfigFile.getPath()).build();
        if (protractorRunSettings == null) {
            ProtractorRunConfigurationProducer.$$$reportNull$$$0(18);
        }
        return protractorRunSettings;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateSettings";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "guessConfigFileIfNeeded";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromCompatibleContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromCompatibleContext";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTestElementRunInfo";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSuiteName";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setupAsSuiteOrTest";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "guessConfigFileIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalArgumentException(string);
        };
    }

    private static class TestElementInfo {
        private final ProtractorRunSettings myRunSettings;
        private final PsiElement myEnclosingTestElement;

        TestElementInfo(@NotNull ProtractorRunSettings runSettings, @NotNull PsiElement enclosingTestElement) {
            if (runSettings == null) {
                TestElementInfo.$$$reportNull$$$0(0);
            }
            if (enclosingTestElement == null) {
                TestElementInfo.$$$reportNull$$$0(1);
            }
            this.myRunSettings = runSettings;
            this.myEnclosingTestElement = enclosingTestElement;
        }

        @NotNull
        public ProtractorRunSettings getRunSettings() {
            ProtractorRunSettings protractorRunSettings = this.myRunSettings;
            if (protractorRunSettings == null) {
                TestElementInfo.$$$reportNull$$$0(2);
            }
            return protractorRunSettings;
        }

        @NotNull
        public PsiElement getEnclosingTestElement() {
            PsiElement psiElement = this.myEnclosingTestElement;
            if (psiElement == null) {
                TestElementInfo.$$$reportNull$$$0(3);
            }
            return psiElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "enclosingTestElement";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer$TestElementInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunConfigurationProducer$TestElementInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRunSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEnclosingTestElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

