/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.npm.AvailablePackageVersions;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packageJson.NodePackageBasicInfo;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.util.JsonUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomNpmRegistryService {
    private static final Logger LOG = Logger.getInstance(CustomNpmRegistryService.class);
    private static final String SCOPED_REGISTRY_KEY_SUFFIX = ":registry";
    private static final String REGISTRY_KEY = "registry";
    private static final Set<String> PUBLIC_REGISTRY_URLS = Set.of("https://registry.npmjs.org", "https://registry.npmjs.org/", "https://registry.yarnpkg.com", "https://registry.yarnpkg.com/");
    private static final int TIMEOUT = 10000;
    private final Project myProject;
    private long myLastExternalChangesCount;
    private NodeJsInterpreterRef myLastInterpreterRef;
    private NodePackageRef myLastNpmPackageRef;
    private final Map<VirtualFile, Registries> myCache;

    public CustomNpmRegistryService(@NotNull Project project) {
        if (project == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(0);
        }
        this.myCache = new ConcurrentHashMap<VirtualFile, Registries>();
        this.myProject = project;
    }

    @NotNull
    public static CustomNpmRegistryService getInstance(@NotNull Project project) {
        if (project == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(1);
        }
        CustomNpmRegistryService customNpmRegistryService = (CustomNpmRegistryService)project.getService(CustomNpmRegistryService.class);
        if (customNpmRegistryService == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(2);
        }
        return customNpmRegistryService;
    }

    @NotNull
    private static <T, E extends Exception> T executeWithoutReadAction(@NotNull ProgressIndicator indicator, @NotNull ThrowableComputable<T, E> computable) throws E {
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(3);
        }
        if (computable == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(4);
        }
        if (ApplicationManager.getApplication().isReadAccessAllowed()) {
            Object object;
            try {
                object = ApplicationUtil.runWithCheckCanceled(() -> computable.compute(), (ProgressIndicator)indicator);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                ExceptionUtil.rethrowUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
            if (object == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(5);
            }
            return (T)object;
        }
        Object object = computable.compute();
        if (object == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(6);
        }
        return (T)object;
    }

    @NotNull
    public List<NodePackageBasicInfo> findPackages(@Nullable ProgressIndicator indicator, @NotNull VirtualFile packageJson2, @NotNull String packageNamePrefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter) {
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(7);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(8);
        }
        if (filter == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(9);
        }
        return (List)CustomNpmRegistryService.executeWithoutReadAction(EmptyProgressIndicator.notNullize((ProgressIndicator)indicator), () -> this.doFindPackages(indicator, packageJson2, packageNamePrefix, limit, filter));
    }

    @NotNull
    private List<NodePackageBasicInfo> doFindPackages(@Nullable ProgressIndicator indicator, @NotNull VirtualFile packageJson2, @NotNull String packageNamePrefix, int limit, @NotNull Condition<NodePackageBasicInfo> filter) {
        List<NodePackageBasicInfo> list2;
        Registries registries;
        Registry registry;
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(10);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(11);
        }
        if (filter == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(12);
        }
        if ((registry = (registries = this.findRegistries(indicator = EmptyProgressIndicator.notNullize((ProgressIndicator)indicator), packageJson2)).findBestRegistry(packageNamePrefix)) == null) {
            List<NodePackageBasicInfo> list3 = List.of();
            if (list3 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(13);
            }
            return list3;
        }
        long startNano = System.nanoTime();
        try {
            List<NodePackageBasicInfo> result2 = this.npmSearch(indicator, registry, packageJson2, packageNamePrefix);
            LOG.info("npm search --registry=" + registry.myRegistryUrl + " '" + packageNamePrefix + "' " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson2) + ": " + ContainerUtil.map(result2, info2 -> info2.getName()));
            list2 = result2.stream().filter(info2 -> filter.value(info2) && info2.getName().startsWith(packageNamePrefix)).limit(limit).collect(Collectors.toList());
        }
        catch (ExecutionException e) {
            LOG.info("Failed to run (npm search --registry=" + registry.myRegistryUrl + " '" + packageNamePrefix + "') " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson2), (Throwable)e);
            List<NodePackageBasicInfo> list4 = List.of();
            if (list4 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(15);
            }
            return list4;
        }
        if (list2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(14);
        }
        return list2;
    }

    @NotNull
    private List<NodePackageBasicInfo> npmSearch(@NotNull ProgressIndicator indicator, final @NotNull Registry registry, final @NotNull VirtualFile packageJson2, final @NotNull String packageNamePrefix) throws ExecutionException {
        ProcessOutput output;
        List<NodePackageBasicInfo> result2;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(16);
        }
        if (registry == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(17);
        }
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(18);
        }
        if (packageNamePrefix == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(19);
        }
        if ((result2 = CustomNpmRegistryService.parsePackageInfos((output = this.run(indicator, packageJson2, NodePackageRef.create("npm"), new TargetRunConfigurer(){

            @Override
            public void configure(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (targetRun == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (npmPkg == null) {
                    1.$$$reportNull$$$0(1);
                }
                NpmUtil.configureNpmCommand(targetRun, npmPkg, CustomNpmRegistryService.getParentDirectory(packageJson2), NpmCommand.SEARCH, List.of("--json", "--registry=" + registry.myRegistryUrl, packageNamePrefix));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetRun";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "npmPkg";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$1";
                objectArray[2] = "configure";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).getStdout())) != null) {
            List<NodePackageBasicInfo> list2 = result2;
            if (list2 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(20);
            }
            return list2;
        }
        throw new ExecutionException("Failed to parse packages from " + output.getStdout());
    }

    @NotNull
    private static Path getParentDirectory(@NotNull VirtualFile file) {
        if (file == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(21);
        }
        Path path2 = Objects.requireNonNull(file.toNioPath().getParent());
        if (path2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(22);
        }
        return path2;
    }

    @Nullable
    private static List<NodePackageBasicInfo> parsePackageInfos(@NotNull String stdout) {
        JsonArray array;
        if (stdout == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(23);
        }
        try {
            array = (JsonArray)ObjectUtils.tryCast((Object)JsonParser.parseString((String)stdout), JsonArray.class);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
        if (array == null) {
            return null;
        }
        ArrayList<NodePackageBasicInfo> result2 = new ArrayList<NodePackageBasicInfo>();
        for (JsonElement element : array) {
            JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)element, JsonObject.class);
            if (obj == null) continue;
            String name = JsonUtil.getChildAsString((JsonObject)obj, (String)"name");
            String description = JsonUtil.getChildAsString((JsonObject)obj, (String)"description");
            if (name == null) continue;
            result2.add(new NodePackageBasicInfo(name, description));
        }
        return array.size() > 0 && result2.isEmpty() ? null : result2;
    }

    @NotNull
    private Registries findRegistries(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson2) {
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(24);
        }
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(25);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Registries registries = Registries.EMPTY;
            if (registries == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(26);
            }
            return registries;
        }
        Registries cachedRegistries = this.myCache.get(packageJson2);
        if (cachedRegistries != null && SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount() == this.myLastExternalChangesCount && NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef().equals(this.myLastInterpreterRef) && NpmManager.getInstance(this.myProject).getPackageRef().equals(this.myLastNpmPackageRef)) {
            Registries registries = cachedRegistries;
            if (registries == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(27);
            }
            return registries;
        }
        Registries registries = this.doFindRegistries(indicator, packageJson2);
        if (registries != null) {
            this.myCache.put(packageJson2, registries);
            this.myLastExternalChangesCount = SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
            this.myLastInterpreterRef = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterRef();
            this.myLastNpmPackageRef = NpmManager.getInstance(this.myProject).getPackageRef();
            Registries registries2 = registries;
            if (registries2 == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(28);
            }
            return registries2;
        }
        Registries registries3 = Objects.requireNonNullElse(cachedRegistries, Registries.EMPTY);
        if (registries3 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(29);
        }
        return registries3;
    }

    @Nullable
    private Registries doFindRegistries(@NotNull ProgressIndicator indicator, final @NotNull VirtualFile packageJson2) {
        NodePackage npmPkg;
        NodeJsInterpreter interpreter2;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(30);
        }
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(31);
        }
        long startNano = System.nanoTime();
        NodePackageRef npmPkgRef = NpmManager.getInstance(this.myProject).getPackageRef();
        boolean isYarn = NpmUtil.isYarnAlikePackageRef(npmPkgRef);
        try {
            interpreter2 = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterOrThrow();
            npmPkg = NpmManager.getInstance(this.myProject).getPackageOrThrow(npmPkgRef, interpreter2);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot find registries", (Throwable)e);
            return null;
        }
        try {
            ProcessOutput output = this.run(indicator, packageJson2, interpreter2, npmPkg, new TargetRunConfigurer(){

                @Override
                public void configure(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
                    if (targetRun == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (npmPkg == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    NpmUtil.configureNpmCommand(targetRun, npmPkg, CustomNpmRegistryService.getParentDirectory(packageJson2), NpmCommand.CONFIG, List.of("list", "--json"));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "targetRun";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "npmPkg";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$2";
                    objectArray[2] = "configure";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Registries registries = CustomNpmRegistryService.parseRegistriesForNpmOrYarn1(output.getStdout(), isYarn);
            if (registries != null) {
                LOG.info("Found registries (" + npmPkg.getName() + " config list --json) " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson2) + ": " + registries);
                return registries;
            }
            LOG.info("Failed to parse registries " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson2) + " from " + output.getStdout());
            return null;
        }
        catch (ExecutionException e) {
            if (isYarn) {
                try {
                    Registries registries = this.findRegistriesForYarn2(indicator, packageJson2, interpreter2, npmPkg);
                    LOG.info("Found registries (" + npmPkg.getName() + " get npmScopes --json) " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson2) + ": " + registries);
                    return registries;
                }
                catch (ExecutionException e2) {
                    LOG.info("Failed to get registries for Yarn2", (Throwable)e2);
                }
            }
            LOG.info("Failed to get registries using npm/Yarn1", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private static Registries parseRegistriesForNpmOrYarn1(@NotNull String stdout, boolean isYarn) {
        if (stdout == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(32);
        }
        JsonObject rootObj = CustomNpmRegistryService.parseAsJsonObject(stdout);
        if (isYarn && rootObj == null) {
            List<JsonObject> jsonLines = CustomNpmRegistryService.parseOutputAsJsonLinesFromYarn1(stdout);
            if (jsonLines == null) {
                return null;
            }
            return new Registries(jsonLines.stream().flatMap(json -> CustomNpmRegistryService.toRegistries(json).stream()).collect(Collectors.toList()));
        }
        return rootObj == null ? null : new Registries(CustomNpmRegistryService.toRegistries(rootObj));
    }

    @NotNull
    private Registries findRegistriesForYarn2(@NotNull ProgressIndicator indicator, final @NotNull VirtualFile packageJson2, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPkg) throws ExecutionException {
        ProcessOutput output;
        JsonObject rootObj;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(33);
        }
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(34);
        }
        if (interpreter2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(35);
        }
        if (npmPkg == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(36);
        }
        if ((rootObj = CustomNpmRegistryService.parseAsJsonObject((output = this.run(indicator, packageJson2, interpreter2, npmPkg, new TargetRunConfigurer(){

            @Override
            public void configure(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (targetRun == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (npmPkg == null) {
                    3.$$$reportNull$$$0(1);
                }
                NpmUtil.configureNpmCommand(targetRun, npmPkg, CustomNpmRegistryService.getParentDirectory(packageJson2), NpmCommand.CONFIG, List.of("get", "npmScopes", "--json"));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetRun";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "npmPkg";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$3";
                objectArray[2] = "configure";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).getStdout())) == null) {
            throw new ExecutionException("Failed to parse output of `yarn config get npmScopes`; " + output.getStdout());
        }
        ArrayList<Registry> registries = new ArrayList<Registry>();
        for (Map.Entry entry : rootObj.entrySet()) {
            String registryUrl;
            String scope2 = (String)entry.getKey();
            JsonObject scopeObj = (JsonObject)ObjectUtils.tryCast(entry.getValue(), JsonObject.class);
            if (scopeObj == null || (registryUrl = JsonUtil.getChildAsString((JsonObject)scopeObj, (String)"npmRegistryServer")) == null) continue;
            registries.add(new Registry(scope2, registryUrl, true));
        }
        return new Registries(registries);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    private static String getContextDebugInfo(long startNano, @NotNull VirtualFile virtualFile) {
        void packageJson2;
        VirtualFile vDir;
        if (virtualFile == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(37);
        }
        Object path2 = (vDir = packageJson2.getParent()) != null ? vDir.getPath() : "";
        String userHome = SystemProperties.getUserHome();
        if (StringUtil.isNotEmpty((String)userHome) && ((String)path2).startsWith(userHome + "/")) {
            path2 = "~" + ((String)path2).substring(userHome.length());
        }
        String string = "(" + TimeoutUtil.getDurationMillis((long)startNano) + " ms, " + (String)path2 + ")";
        if (string == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(38);
        }
        return string;
    }

    @Nullable
    private static List<JsonObject> parseOutputAsJsonLinesFromYarn1(@NotNull String stdout) {
        String[] lines;
        if (stdout == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(39);
        }
        ArrayList<JsonObject> result2 = new ArrayList<JsonObject>();
        for (String line : lines = StringUtil.splitByLines((String)stdout, (boolean)true)) {
            JsonObject rootObj = CustomNpmRegistryService.parseAsJsonObject(line);
            if (rootObj == null) {
                return null;
            }
            JsonObject dataObj = CustomNpmRegistryService.unwrapYarn1JsonData(rootObj);
            if (dataObj == null) continue;
            result2.add(dataObj);
        }
        return result2;
    }

    @Nullable
    private static JsonObject unwrapYarn1JsonData(@NotNull JsonObject root) {
        JsonObject dataObj;
        if (root == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(40);
        }
        if ("inspect".equals(JsonUtil.getChildAsString((JsonObject)root, (String)"type")) && (dataObj = JsonUtil.getChildAsObject((JsonObject)root, (String)"data")) != null) {
            return dataObj;
        }
        return null;
    }

    @NotNull
    private static List<Registry> toRegistries(@NotNull JsonObject rootObj) {
        if (rootObj == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(41);
        }
        ArrayList<Registry> registries = new ArrayList<Registry>();
        Set entries = rootObj.entrySet();
        for (Map.Entry entry : entries) {
            String url;
            String key2 = (String)entry.getKey();
            if (!key2.endsWith(SCOPED_REGISTRY_KEY_SUFFIX) && !key2.equals(REGISTRY_KEY) || (url = JsonUtil.getString((JsonElement)((JsonElement)entry.getValue()))) == null) continue;
            String scope2 = StringUtil.trimEnd((String)key2, (String)SCOPED_REGISTRY_KEY_SUFFIX);
            registries.add(new Registry(key2.equals(scope2) ? null : scope2, url, false));
        }
        ArrayList<Registry> arrayList = registries;
        if (arrayList == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(42);
        }
        return arrayList;
    }

    @Nullable
    private static JsonObject parseAsJsonObject(@NotNull String json) {
        if (json == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(43);
        }
        try {
            return (JsonObject)ObjectUtils.tryCast((Object)JsonParser.parseString((String)json), JsonObject.class);
        }
        catch (JsonSyntaxException e) {
            return null;
        }
    }

    @Nullable
    public AvailablePackageVersions getPackageVersions(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson2, @NotNull String packageName) {
        Registries registries;
        Registry registry;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(44);
        }
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(45);
        }
        if (packageName == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(46);
        }
        if ((registry = (registries = this.findRegistries(indicator, packageJson2)).findBestRegistry(packageName)) == null) {
            return null;
        }
        long startNano = System.nanoTime();
        NodePackageRef npmPkgRef = NpmManager.getInstance(this.myProject).getPackageRef();
        try {
            AvailablePackageVersions versions2 = this.npmInfo(indicator, packageJson2, npmPkgRef, registry, packageName);
            LOG.info("Found versions of " + packageName + " " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson2) + ": " + versions2.getVersions());
            return versions2;
        }
        catch (ExecutionException | IOException e) {
            LOG.info("Failed to get versions of " + packageName + " " + CustomNpmRegistryService.getContextDebugInfo(startNano, packageJson2), e);
            return AvailablePackageVersions.createEmpty();
        }
    }

    @NotNull
    private AvailablePackageVersions npmInfo(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson2, @NotNull NodePackageRef npmPkgRef, final @NotNull Registry registry, @NotNull String packageName) throws IOException, ExecutionException {
        boolean isYarnPkg;
        ProcessOutput output;
        JsonObject rootObject;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(47);
        }
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(48);
        }
        if (npmPkgRef == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(49);
        }
        if (registry == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(50);
        }
        if (packageName == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(51);
        }
        if ((rootObject = CustomNpmRegistryService.parseAsJsonObject((output = this.run(indicator, packageJson2, npmPkgRef, new TargetRunConfigurer(){
            final /* synthetic */ boolean val$isYarnPkg;
            final /* synthetic */ VirtualFile val$packageJson;
            final /* synthetic */ String val$packageName;
            {
                this.val$isYarnPkg = bl;
                this.val$packageJson = virtualFile;
                this.val$packageName = string;
            }

            @Override
            public void configure(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPkg) throws ExecutionException {
                if (targetRun == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (npmPkg == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (registry.isYarn2() && this.val$isYarnPkg) {
                    NpmUtil.configureNpmCommand(targetRun, npmPkg, CustomNpmRegistryService.getParentDirectory(this.val$packageJson), NpmCommand.NPM, List.of("info", "--json", this.val$packageName));
                } else {
                    NpmUtil.configureNpmCommand(targetRun, npmPkg, CustomNpmRegistryService.getParentDirectory(this.val$packageJson), NpmCommand.INFO, List.of("--json", this.val$packageName));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "targetRun";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "npmPkg";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$4";
                objectArray[2] = "configure";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        })).getStdout())) != null) {
            if (isYarnPkg) {
                rootObject = Objects.requireNonNullElse(CustomNpmRegistryService.unwrapYarn1JsonData(rootObject), rootObject);
            }
            AvailablePackageVersions availablePackageVersions = AvailablePackageVersions.parseFromPackageMetadata(rootObject);
            if (availablePackageVersions == null) {
                CustomNpmRegistryService.$$$reportNull$$$0(52);
            }
            return availablePackageVersions;
        }
        AvailablePackageVersions availablePackageVersions = AvailablePackageVersions.createEmpty();
        if (availablePackageVersions == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(53);
        }
        return availablePackageVersions;
    }

    @NotNull
    private ProcessOutput run(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson2, @NotNull NodePackageRef npmPkgRef, @NotNull TargetRunConfigurer targetRunConfigurer) throws ExecutionException {
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(54);
        }
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(55);
        }
        if (npmPkgRef == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(56);
        }
        if (targetRunConfigurer == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(57);
        }
        NodeJsInterpreter interpreter2 = NodeJsInterpreterManager.getInstance(this.myProject).getInterpreterOrThrow();
        NodePackage npmPkg = NpmManager.getInstance(this.myProject).getPackageOrThrow(npmPkgRef, interpreter2);
        return this.run(indicator, packageJson2, interpreter2, npmPkg, targetRunConfigurer);
    }

    @NotNull
    private ProcessOutput run(@NotNull ProgressIndicator indicator, @NotNull VirtualFile packageJson2, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPkg, @NotNull TargetRunConfigurer targetRunConfigurer) throws ExecutionException {
        ProcessOutput output;
        VirtualFile dir;
        if (indicator == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(58);
        }
        if (packageJson2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(59);
        }
        if (interpreter2 == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(60);
        }
        if (npmPkg == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(61);
        }
        if (targetRunConfigurer == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(62);
        }
        if ((dir = packageJson2.getParent()) == null) {
            throw new ExecutionException("No parent directory for " + packageJson2);
        }
        NodeTargetRun targetRun = new NodeTargetRun(interpreter2, this.myProject, null, NodeTargetRunOptions.of(false));
        targetRun.getCommandLineBuilder().setWorkingDirectory(targetRun.path(dir.getPath()));
        targetRunConfigurer.configure(targetRun, npmPkg);
        ProcessWithCmdLine processWithCmdLine = targetRun.startProcessEx();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Running " + processWithCmdLine.getCommandLinePresentation());
        }
        if ((output = new CapturingProcessRunner((BaseProcessHandler)processWithCmdLine.getProcessHandler()).runProcess(indicator, 10000)).isCancelled() || output.isTimeout() || output.getExitCode() != 0) {
            throw new ExecutionException("Failed to run " + processWithCmdLine.getCommandLinePresentation() + ": " + output);
        }
        ProcessOutput processOutput = output;
        if (processOutput == null) {
            CustomNpmRegistryService.$$$reportNull$$$0(63);
        }
        return processOutput;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5, 6, 13, 14, 15, 20, 22, 26, 27, 28, 29, 38, 42, 52, 53, 63 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 42: 
            case 52: 
            case 53: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService";
                break;
            }
            case 3: 
            case 16: 
            case 24: 
            case 30: 
            case 33: 
            case 44: 
            case 47: 
            case 54: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computable";
                break;
            }
            case 7: 
            case 10: 
            case 18: 
            case 25: 
            case 31: 
            case 34: 
            case 37: 
            case 45: 
            case 48: 
            case 55: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 8: 
            case 11: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageNamePrefix";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 17: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = REGISTRY_KEY;
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 23: 
            case 32: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stdout";
                break;
            }
            case 35: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 36: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootObj";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "json";
                break;
            }
            case 46: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkgRef";
                break;
            }
            case 57: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRunConfigurer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "executeWithoutReadAction";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "doFindPackages";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "npmSearch";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getParentDirectory";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "findRegistries";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextDebugInfo";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "toRegistries";
                break;
            }
            case 52: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "npmInfo";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "run";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 13: 
            case 14: 
            case 15: 
            case 20: 
            case 22: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 38: 
            case 42: 
            case 52: 
            case 53: 
            case 63: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "executeWithoutReadAction";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findPackages";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doFindPackages";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "npmSearch";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getParentDirectory";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "parsePackageInfos";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findRegistries";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doFindRegistries";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "parseRegistriesForNpmOrYarn1";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findRegistriesForYarn2";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getContextDebugInfo";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "parseOutputAsJsonLinesFromYarn1";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "unwrapYarn1JsonData";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "toRegistries";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "parseAsJsonObject";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getPackageVersions";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "npmInfo";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5, 6, 13, 14, 15, 20, 22, 26, 27, 28, 29, 38, 42, 52, 53, 63 -> new IllegalStateException(string);
        };
    }

    private static class Registries {
        private static final Registries EMPTY = new Registries(List.of());
        private final List<Registry> myRegistries;

        private Registries(@NotNull List<Registry> registries) {
            if (registries == null) {
                Registries.$$$reportNull$$$0(0);
            }
            this.myRegistries = List.copyOf(registries);
        }

        @NotNull
        private List<Registry> filterRegistriesByScope(@NotNull String packageNamePrefix) {
            String scope2;
            if (packageNamePrefix == null) {
                Registries.$$$reportNull$$$0(1);
            }
            if ((scope2 = NodeModuleSearchUtil.getScopeByPackageName(packageNamePrefix)) != null || !packageNamePrefix.startsWith("@")) {
                List list2 = ContainerUtil.filter(this.myRegistries, registry -> Objects.equals(registry.myScope, scope2));
                if (list2 == null) {
                    Registries.$$$reportNull$$$0(2);
                }
                return list2;
            }
            List list3 = ContainerUtil.filter(this.myRegistries, registry -> {
                String registryScope = registry.myScope;
                return registryScope != null && registryScope.startsWith(packageNamePrefix);
            });
            if (list3 == null) {
                Registries.$$$reportNull$$$0(3);
            }
            return list3;
        }

        @Nullable
        private Registry findBestRegistry(@NotNull String packageNamePrefix) {
            if (packageNamePrefix == null) {
                Registries.$$$reportNull$$$0(4);
            }
            List<Registry> registries = this.filterRegistriesByScope(packageNamePrefix);
            List customRegistries = ContainerUtil.filter(registries, registry -> !PUBLIC_REGISTRY_URLS.contains(registry.myRegistryUrl));
            return (Registry)ContainerUtil.getFirstItem((List)customRegistries);
        }

        public String toString() {
            return this.myRegistries.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "registries";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packageNamePrefix";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registries";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registries";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "filterRegistriesByScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "filterRegistriesByScope";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "findBestRegistry";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class Registry {
        @Nullable
        private final String myScope;
        @NotNull
        private final String myRegistryUrl;
        private final boolean myYarn2;

        private Registry(@Nullable String scope2, @NotNull String registryUrl, boolean yarn2) {
            if (registryUrl == null) {
                Registry.$$$reportNull$$$0(0);
            }
            if (scope2 != null && !((String)scope2).startsWith("@")) {
                scope2 = "@" + (String)scope2;
            }
            this.myScope = scope2;
            this.myRegistryUrl = registryUrl;
            this.myYarn2 = yarn2;
        }

        private boolean isYarn2() {
            return this.myYarn2;
        }

        public String toString() {
            return "(" + this.myScope + ", " + this.myRegistryUrl + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registryUrl", "com/intellij/javascript/nodejs/npm/registry/CustomNpmRegistryService$Registry", "<init>"));
        }
    }

    private static interface TargetRunConfigurer {
        public void configure(@NotNull NodeTargetRun var1, @NotNull NodePackage var2) throws ExecutionException;
    }
}

