/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.npm;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.wsl.WslPath;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmPackageDescriptor;
import com.intellij.javascript.nodejs.npm.NpmPackageRefResolver;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.javascript.nodejs.util.NodePackageRefResolver;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NpmUtil {
    @NlsSafe
    public static final String NPM_PACKAGE_NAME = "npm";
    @NlsSafe
    public static final String YARN_PACKAGE_NAME = "yarn";
    @NlsSafe
    public static final String PNPM_PACKAGE_NAME = "pnpm";
    @NlsSafe
    public static final String BUN_PACKAGE_NAME = "bun";
    @NlsSafe
    public static final String YARN_LOCK_FILENAME = "yarn.lock";
    public static final String PACKAGE_LOCK_JSON_FILENAME = "package-lock.json";
    public static final String PNPM_LOCK_FILENAME = "pnpm-lock.yaml";
    public static final String PROJECT_PACKAGE_MANAGER_REFERENCE_NAME = "Project";
    public static final NodePackageDescriptor DESCRIPTOR = new NpmPackageDescriptor(false);
    private static final String NPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "npm-cli.js";
    private static final String YARN_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "yarn.js";
    private static final String PNPM_CLI_JS_RELATIVE_PATH = "bin" + File.separator + "pnpm.cjs";
    private static final NpmPackageRefResolver RESOLVER = new NpmPackageRefResolver(null, DESCRIPTOR, null);

    private NpmUtil() {
    }

    @NotNull
    public static NodePackageRef createProjectPackageManagerPackageRef() {
        NodePackageRef nodePackageRef = NodePackageRef.create(PROJECT_PACKAGE_MANAGER_REFERENCE_NAME);
        if (nodePackageRef == null) {
            NpmUtil.$$$reportNull$$$0(0);
        }
        return nodePackageRef;
    }

    public static boolean isProjectPackageManagerPackageRef(@NotNull NodePackageRef packageRef) {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(1);
        }
        return PROJECT_PACKAGE_MANAGER_REFERENCE_NAME.equals(packageRef.getReferenceName());
    }

    @NotNull
    @NlsContexts.Label
    public static String getPackageManagerPackageFieldLabelText() {
        String string = JavaScriptBundle.message("node.package.manager.label", new Object[0]);
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static NodePackageField createPackageManagerPackageField(@NotNull NodeJsInterpreterField interpreterField, boolean projectField) {
        if (interpreterField == null) {
            NpmUtil.$$$reportNull$$$0(3);
        }
        NpmPackageDescriptor descriptor = new NpmPackageDescriptor(projectField);
        NpmPackageRefResolver resolver = new NpmPackageRefResolver(interpreterField.getProject(), descriptor, interpreterField::getInterpreter);
        return new NodePackageField(interpreterField, (NodePackageDescriptor)descriptor, null, (NodePackageRefResolver)resolver);
    }

    @Deprecated
    @NotNull
    public static String getValidNpmCliJsFilePath(@NotNull NodePackage packageManagerPkg) throws ExecutionException {
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(4);
        }
        return NpmUtil.getValidNpmCliJsFilePath(packageManagerPkg, null);
    }

    @NotNull
    public static String getValidNpmCliJsFilePath(@NotNull NodePackage packageManagerPkg, @Nullable NodeJsInterpreter interpreter2) throws ExecutionException {
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(5);
        }
        if (packageManagerPkg.isEmptyPath()) {
            throw new ExecutionException(JavaScriptBundle.message("node.npm.specify_npm_or_yarn_package.dialog.message", new Object[0]));
        }
        if (interpreter2 instanceof WslNodeInterpreter) {
            String string = NpmUtil.getWslLinuxPath((WslNodeInterpreter)interpreter2, packageManagerPkg) + "/" + FileUtil.toSystemIndependentName((String)NpmUtil.getStaticMainJsRelativePath(packageManagerPkg));
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(6);
            }
            return string;
        }
        if (interpreter2 instanceof NodeJsRemoteInterpreter) {
            String string = packageManagerPkg.getSystemIndependentPath() + "/" + FileUtil.toSystemIndependentName((String)NpmUtil.getStaticMainJsRelativePath(packageManagerPkg));
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        if (!packageManagerPkg.isValid(null, interpreter2)) {
            throw new ExecutionException(JavaScriptBundle.message("node.npm.correct_path_to_npm_or_yarn_package.dialog.message", packageManagerPkg.getSystemDependentPath()));
        }
        return NpmUtil.findBinCliFile(packageManagerPkg, interpreter2);
    }

    @NotNull
    public static String getWslLinuxPath(@NotNull WslNodeInterpreter interpreter2, @NotNull NodePackage pkg) {
        String linuxPath;
        WslPath wslPath;
        if (interpreter2 == null) {
            NpmUtil.$$$reportNull$$$0(8);
        }
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(9);
        }
        if ((wslPath = WslPath.parseWindowsUncPath((String)(linuxPath = pkg.getSystemIndependentPath()))) != null && wslPath.getDistribution().equals((Object)interpreter2.getDistribution())) {
            linuxPath = wslPath.getLinuxPath();
        }
        String string = linuxPath;
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(10);
        }
        return string;
    }

    @NotNull
    private static String getStaticMainJsRelativePath(@NotNull NodePackage npmPkg) {
        if (npmPkg == null) {
            NpmUtil.$$$reportNull$$$0(11);
        }
        if (NpmUtil.isYarnAlikePackage(npmPkg)) {
            String string = YARN_CLI_JS_RELATIVE_PATH;
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(12);
            }
            return string;
        }
        if (NpmUtil.isPnpmPackage(npmPkg)) {
            String string = PNPM_CLI_JS_RELATIVE_PATH;
            if (string == null) {
                NpmUtil.$$$reportNull$$$0(13);
            }
            return string;
        }
        String string = NPM_CLI_JS_RELATIVE_PATH;
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(14);
        }
        return string;
    }

    public static boolean isYarnAlikePackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NpmUtil.$$$reportNull$$$0(15);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return NpmUtil.isYarnAlikePackage(pkg);
        }
        return StringUtil.containsIgnoreCase((String)Objects.requireNonNull(packageManagerPkgRef.getReferenceName()), (String)YARN_PACKAGE_NAME);
    }

    public static boolean isPnpmPackageRef(@NotNull NodePackageRef packageManagerPkgRef) {
        NodePackage pkg;
        if (packageManagerPkgRef == null) {
            NpmUtil.$$$reportNull$$$0(16);
        }
        if ((pkg = packageManagerPkgRef.getConstantPackage()) != null) {
            return PNPM_PACKAGE_NAME.equals(pkg.getName());
        }
        return PNPM_PACKAGE_NAME.equals(packageManagerPkgRef.getReferenceName());
    }

    public static boolean isYarnAlikePackage(@NotNull NodePackage packageManagerPkg) {
        String packageName;
        if (packageManagerPkg == null) {
            NpmUtil.$$$reportNull$$$0(17);
        }
        if (StringUtil.containsIgnoreCase((String)(packageName = packageManagerPkg.getName()), (String)YARN_PACKAGE_NAME)) {
            return true;
        }
        String path2 = packageManagerPkg.getSystemIndependentPath();
        if (!packageName.contains(NPM_PACKAGE_NAME) && path2.contains("/yarn/")) {
            return true;
        }
        return (path2.contains("/.yvm/") || path2.contains("/yvm/")) && !packageName.contains(NPM_PACKAGE_NAME);
    }

    public static boolean isPnpmPackage(@NotNull NodePackage pkg) {
        String packageName;
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(18);
        }
        if (StringUtil.containsIgnoreCase((String)(packageName = pkg.getName()), (String)PNPM_PACKAGE_NAME)) {
            return true;
        }
        String path2 = pkg.getSystemIndependentPath();
        return path2.contains("/pnpm/");
    }

    @NotNull
    private static String findBinCliFile(@NotNull NodePackage pkg, @Nullable NodeJsInterpreter interpreter2) throws ExecutionException {
        File binFile;
        if (pkg == null) {
            NpmUtil.$$$reportNull$$$0(19);
        }
        if ((binFile = pkg.findBinFile(pkg.getName(), NpmUtil.getStaticMainJsRelativePath(pkg), interpreter2)) == null) {
            throw new ExecutionException(JavaScriptBundle.message("node.npm.invalid_package_manager.binary_file_not_found.dialog.message", pkg.getSystemDependentPath()));
        }
        String string = binFile.getAbsolutePath();
        if (string == null) {
            NpmUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @Nullable
    public static NodePackage resolveRef(@NotNull NodePackageRef ref, @NotNull Project project, @Nullable NodeJsInterpreter interpreter2) {
        if (ref == null) {
            NpmUtil.$$$reportNull$$$0(21);
        }
        if (project == null) {
            NpmUtil.$$$reportNull$$$0(22);
        }
        return RESOLVER.resolve(DESCRIPTOR.dereferenceIfProjectRef(project, ref), interpreter2);
    }

    @NotNull
    public static NodePackage resolvePackageRefOrThrow(@NotNull NodePackageRef packageRef, @Nullable Project project, @Nullable NodeJsInterpreter interpreter2) throws ExecutionException {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(23);
        }
        if (project != null) {
            packageRef = DESCRIPTOR.dereferenceIfProjectRef(project, packageRef);
        } else if (NpmUtil.isProjectPackageManagerPackageRef(packageRef)) {
            throw new ExecutionException(JavaScriptBundle.message("node.npm.project_package_manager_disallowed_here.dialog.message", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)packageRef.getIdentifier())) {
            throw new ExecutionException(JavaScriptBundle.message("node.npm.unspecified_package_manager.dialog.message", new Object[0]));
        }
        NodePackage npmPkg = RESOLVER.resolve(packageRef, interpreter2);
        if (npmPkg == null) {
            throw new ExecutionException(JavaScriptBundle.message("node.npm.cannot_resolve_package_manager.dialog.message", packageRef.getIdentifier()));
        }
        NodePackage nodePackage = npmPkg;
        if (nodePackage == null) {
            NpmUtil.$$$reportNull$$$0(24);
        }
        return nodePackage;
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@NotNull Project project, @Nullable File workingDir2, @NotNull NodeJsInterpreter interpreter2, @NotNull NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (project == null) {
            NpmUtil.$$$reportNull$$$0(25);
        }
        if (interpreter2 == null) {
            NpmUtil.$$$reportNull$$$0(26);
        }
        if (command == null) {
            NpmUtil.$$$reportNull$$$0(27);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(28);
        }
        NodePackage pkg = NpmManager.getInstance(project).getPackageOrThrow(interpreter2);
        return NpmUtil.createNpmCommandLine(workingDir2, interpreter2, pkg, command, arguments);
    }

    @NotNull
    public static GeneralCommandLine createNpmCommandLine(@Nullable File workingDir2, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPackage, @Nullable NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (interpreter2 == null) {
            NpmUtil.$$$reportNull$$$0(29);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(30);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(31);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        NpmUtil.configureNpmCommandLine(commandLine, workingDir2, interpreter2, npmPackage, command, arguments);
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            NpmUtil.$$$reportNull$$$0(32);
        }
        return generalCommandLine;
    }

    public static void configureNpmCommandLine(@NotNull GeneralCommandLine commandLine, @Nullable File workingDir2, @NotNull NodeJsInterpreter interpreter2, @NotNull NodePackage npmPackage, @Nullable NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (commandLine == null) {
            NpmUtil.$$$reportNull$$$0(33);
        }
        if (interpreter2 == null) {
            NpmUtil.$$$reportNull$$$0(34);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(35);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(36);
        }
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.withCharset(StandardCharsets.UTF_8);
        if (workingDir2 != null) {
            commandLine.withWorkDirectory(workingDir2);
        }
        String cliJsFilePath = NpmUtil.getValidNpmCliJsFilePath(npmPackage, interpreter2);
        commandLine.addParameter(cliJsFilePath);
        if (command != null) {
            boolean yarn = NpmUtil.isYarnAlikePackage(npmPackage);
            commandLine.addParameter(command.getCliOption(yarn));
            if ((command == NpmCommand.RUN_SCRIPT || command == NpmCommand.TEST || command == NpmCommand.INSTALL || command == NpmCommand.UPDATE) && npmPackage.getName().equals(NPM_PACKAGE_NAME)) {
                commandLine.addParameter("--scripts-prepend-node-path=auto");
            }
            NodeCommandLineUtil.prependNodeDirToPATH(commandLine, interpreter2);
        }
        commandLine.addParameters(arguments);
        NodeCommandLineConfigurator.find(interpreter2).configure(commandLine);
    }

    @Nullable
    @NlsSafe
    public static String getInstallSaveOption(@NotNull NodePackageRef packageRef, boolean asDevDependency) {
        if (packageRef == null) {
            NpmUtil.$$$reportNull$$$0(37);
        }
        boolean yarn = NpmUtil.isYarnAlikePackageRef(packageRef);
        if (asDevDependency) {
            return yarn ? "--dev" : "--save-dev";
        }
        return yarn ? null : "--save";
    }

    public static void configureNpmCommand(@NotNull NodeTargetRun targetRun, @NotNull NodePackageRef npmPackageRef, @Nullable Path workingDirectory, @Nullable NpmCommand command, @NotNull List<String> arguments, @Nullable Runnable onNpmPackageRefResolved) throws ExecutionException {
        NodePackage npmPkg;
        if (targetRun == null) {
            NpmUtil.$$$reportNull$$$0(38);
        }
        if (npmPackageRef == null) {
            NpmUtil.$$$reportNull$$$0(39);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(40);
        }
        if ((npmPkg = NpmUtil.resolveRef(npmPackageRef, targetRun.getProject(), targetRun.getInterpreter())) == null) {
            if (NpmUtil.isProjectPackageManagerPackageRef(npmPackageRef)) {
                String message = JavaScriptBundle.message("npm.dialog.message.cannot.resolve.package.manager", NpmManager.getInstance(targetRun.getProject()).getPackageRef().getIdentifier());
                throw new NpmManager.InvalidNpmPackageException(targetRun.getProject(), new HtmlBuilder().append(message).append((HtmlChunk)HtmlChunk.br()).appendRaw(JavaScriptBundle.message("please.specify.package.manager", new Object[0])).toString(), onNpmPackageRefResolved);
            }
            throw new ExecutionException(JavaScriptBundle.message("npm.dialog.message.cannot.resolve.package.manager", npmPackageRef.getIdentifier()));
        }
        NpmUtil.configureNpmCommand(targetRun, npmPkg, workingDirectory, command, arguments);
    }

    public static void configureNpmCommand(@NotNull NodeTargetRun targetRun, @NotNull NodePackage npmPackage, @Nullable Path workingDirectory, @Nullable NpmCommand command, @NotNull List<String> arguments) throws ExecutionException {
        if (targetRun == null) {
            NpmUtil.$$$reportNull$$$0(41);
        }
        if (npmPackage == null) {
            NpmUtil.$$$reportNull$$$0(42);
        }
        if (arguments == null) {
            NpmUtil.$$$reportNull$$$0(43);
        }
        TargetedCommandLineBuilder commandLineBuilder = targetRun.getCommandLineBuilder();
        if (workingDirectory != null) {
            commandLineBuilder.setWorkingDirectory(targetRun.path(workingDirectory.toString()));
        }
        targetRun.setEnableWrappingWithYarnNode(false);
        NpmNodePackage.configureNpmPackage(targetRun, npmPackage, new String[0]);
        if (command != null) {
            boolean yarn = NpmUtil.isYarnAlikePackage(npmPackage);
            if (command == NpmCommand.PUBLISH && yarn) {
                commandLineBuilder.addParameters(new String[]{NPM_PACKAGE_NAME, "publish"});
            } else {
                commandLineBuilder.addParameter(command.getCliOption(yarn));
            }
        }
        commandLineBuilder.addParameters(arguments);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 3, 4, 5, 8, 9, 11, 15, 16, 17, 18, 19, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/npm/NpmUtil";
                break;
            }
            case 1: 
            case 23: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageRef";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterField";
                break;
            }
            case 4: 
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkg";
                break;
            }
            case 8: 
            case 26: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPkg";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageManagerPkgRef";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 22: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 28: 
            case 31: 
            case 36: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 30: 
            case 35: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackage";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 38: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRun";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "npmPackageRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createProjectPackageManagerPackageRef";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 11: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/npm/NpmUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageManagerPackageFieldLabelText";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValidNpmCliJsFilePath";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getWslLinuxPath";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticMainJsRelativePath";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "findBinCliFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "resolvePackageRefOrThrow";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "createNpmCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isProjectPackageManagerPackageRef";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createPackageManagerPackageField";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getValidNpmCliJsFilePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getWslLinuxPath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getStaticMainJsRelativePath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackageRef";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isPnpmPackageRef";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isYarnAlikePackage";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isPnpmPackage";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findBinCliFile";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolveRef";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "resolvePackageRefOrThrow";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "createNpmCommandLine";
                break;
            }
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "configureNpmCommandLine";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getInstallSaveOption";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "configureNpmCommand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 3, 4, 5, 8, 9, 11, 15, 16, 17, 18, 19, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43 -> new IllegalArgumentException(string);
        };
    }
}

