/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.monorepo;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.monorepo.JSMonorepoManager;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u00102\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0010\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "workspaceMonorepoCached", "Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$CachedResult;", "calcIsWorkspaceMonorepo", "", "dispose", "", "getModuleName", "", "Lorg/jetbrains/annotations/Nullable;", "it", "getRelatedProjects", "", "context", "Lcom/intellij/psi/PsiElement;", "getRoots", "guessContextPackageRoot", "file", "hasPackageJsonWithWorkspaces", "root", "isWorkspaceMonorepo", "CachedResult", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nJSMonorepoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSMonorepoManager.kt\ncom/intellij/javascript/nodejs/monorepo/JSMonorepoManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,107:1\n1#2:108\n1#2:119\n1603#3,9:109\n1855#3:118\n1856#3:120\n1612#3:121\n*S KotlinDebug\n*F\n+ 1 JSMonorepoManager.kt\ncom/intellij/javascript/nodejs/monorepo/JSMonorepoManager\n*L\n70#1:119\n70#1:109,9\n70#1:118\n70#1:120\n70#1:121\n*E\n"})
public final class JSMonorepoManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private volatile CachedResult workspaceMonorepoCached;
    @Nullable
    private Set<? extends VirtualFile> roots;

    public JSMonorepoManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic<PackageJsonFileManager.PackageJsonChangesListener> topic = PackageJsonFileManager.CHANGES_TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"CHANGES_TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> JSMonorepoManager._init_$lambda$0(this, arg_0));
    }

    @Nullable
    public final VirtualFile guessContextPackageRoot(@Nullable VirtualFile file) {
        Object object;
        VirtualFile foundRoot2;
        if (file == null) {
            return null;
        }
        if (!JSMonorepoManager.Companion.isEnabled()) {
            return null;
        }
        if (!this.isWorkspaceMonorepo()) {
            return null;
        }
        Set<VirtualFile> roots = this.getRoots();
        if (roots.isEmpty()) {
            return null;
        }
        VirtualFile virtualFile = foundRoot2 = JSProjectUtil.traverseUpAndFindFirst(file, arg_0 -> JSMonorepoManager.guessContextPackageRoot$lambda$1((Function1)new Function1<VirtualFile, VirtualFile>(roots){
            final /* synthetic */ Set<VirtualFile> $roots;
            {
                this.$roots = $roots;
                super(1);
            }

            @Nullable
            public final VirtualFile invoke(VirtualFile it) {
                return this.$roots.contains(it) ? it : null;
            }
        }, arg_0));
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile it = virtualFile2 = virtualFile;
            boolean bl = false;
            object = !Intrinsics.areEqual((Object)it, (Object)ProjectUtil.guessProjectDir((Project)this.project)) ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final VirtualFile guessContextPackageRoot(PsiElement context2) {
        if (context2 == null) return null;
        PsiElement it = context2;
        boolean bl = false;
        VirtualFile virtualFile = InjectedLanguageManager.getInstance((Project)this.project).getTopLevelFile(it).getOriginalFile().getVirtualFile();
        if (virtualFile == null) return null;
        it = virtualFile;
        boolean bl2 = false;
        VirtualFile virtualFile2 = this.guessContextPackageRoot((VirtualFile)it);
        return virtualFile2;
    }

    @NotNull
    public final Collection<VirtualFile> getRelatedProjects(@NotNull PsiElement context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        VirtualFile virtualFile = this.guessContextPackageRoot(context2);
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile root = virtualFile;
        VirtualFile virtualFile2 = PackageJsonUtil.findChildPackageJsonFile(root);
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile packageJson2 = virtualFile2;
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson2);
        Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
        PackageJsonData packageJsonData2 = packageJsonData;
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        VirtualFile projectDir = ProjectUtil.guessProjectDir((Project)project);
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.getRoots()), (Function1)((Function1)new Function1<VirtualFile, Boolean>(projectDir, root){
            final /* synthetic */ VirtualFile $projectDir;
            final /* synthetic */ VirtualFile $root;
            {
                this.$projectDir = $projectDir;
                this.$root = $root;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return !Intrinsics.areEqual((Object)it, (Object)this.$projectDir) && !Intrinsics.areEqual((Object)it, (Object)this.$root);
            }
        })), (Function1)getRelatedProjects.2.INSTANCE), (Function1)((Function1)new Function1<VirtualFile, Boolean>(packageJsonData2, this){
            final /* synthetic */ PackageJsonData $packageJsonData;
            final /* synthetic */ JSMonorepoManager this$0;
            {
                this.$packageJsonData = $packageJsonData;
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull VirtualFile it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$packageJsonData.isDependencyOfAnyType(JSMonorepoManager.access$getModuleName(this.this$0, it));
            }
        })));
    }

    private final String getModuleName(VirtualFile it) {
        String string = PackageJsonData.getOrCreate(it).getName();
        if (string == null) {
            string = it.getName();
        }
        String string2 = string;
        Intrinsics.checkNotNull((Object)string2);
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<VirtualFile> getRoots() {
        Set result2 = this.roots;
        if (result2 == null) {
            void $this$mapNotNullTo$iv$iv;
            Set<VirtualFile> set = PackageJsonFileManager.getInstance(this.project).getValidPackageJsonFiles();
            Intrinsics.checkNotNullExpressionValue(set, (String)"getValidPackageJsonFiles(...)");
            Iterable $this$mapNotNull$iv = set;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                VirtualFile it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                VirtualFile it = (VirtualFile)element$iv$iv;
                boolean bl2 = false;
                if (it.getParent() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            this.roots = result2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        }
        return result2;
    }

    private final boolean isWorkspaceMonorepo() {
        long vfsModCount = VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS.getModificationCount();
        CachedResult result2 = this.workspaceMonorepoCached;
        if (result2 == null || result2.getVfsModCount() != vfsModCount) {
            this.workspaceMonorepoCached = result2 = new CachedResult(vfsModCount, this.calcIsWorkspaceMonorepo());
        }
        return result2.isWorkspaceMonorepo();
    }

    private final boolean calcIsWorkspaceMonorepo() {
        VirtualFile virtualFile = ProjectUtil.guessProjectDir((Project)this.project);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile root = virtualFile;
        return root.findChild("pnpm-workspace.yaml") != null || this.hasPackageJsonWithWorkspaces(root);
    }

    private final boolean hasPackageJsonWithWorkspaces(VirtualFile root) {
        VirtualFile virtualFile = PackageJsonUtil.findChildPackageJsonFile(root);
        if (virtualFile == null) {
            return false;
        }
        VirtualFile packageJson2 = virtualFile;
        PackageJsonData packageJsonData = PackageJsonData.getOrCreate(packageJson2);
        Intrinsics.checkNotNullExpressionValue((Object)packageJsonData, (String)"getOrCreate(...)");
        PackageJsonData data = packageJsonData;
        List<String> list2 = data.getWorkspaces();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getWorkspaces(...)");
        return !((Collection)list2).isEmpty();
    }

    public void dispose() {
    }

    private static final void _init_$lambda$0(JSMonorepoManager this$0, List it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.workspaceMonorepoCached = null;
        this$0.roots = null;
    }

    private static final VirtualFile guessContextPackageRoot$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (VirtualFile)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final JSMonorepoManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ String access$getModuleName(JSMonorepoManager $this, VirtualFile it) {
        return $this.getModuleName(it);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$CachedResult;", "", "vfsModCount", "", "isWorkspaceMonorepo", "", "(JZ)V", "()Z", "getVfsModCount", "()J", "intellij.javascript.impl"})
    private static final class CachedResult {
        private final long vfsModCount;
        private final boolean isWorkspaceMonorepo;

        public CachedResult(long vfsModCount, boolean isWorkspaceMonorepo) {
            this.vfsModCount = vfsModCount;
            this.isWorkspaceMonorepo = isWorkspaceMonorepo;
        }

        public final long getVfsModCount() {
            return this.vfsModCount;
        }

        public final boolean isWorkspaceMonorepo() {
            return this.isWorkspaceMonorepo;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\b\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$Companion;", "", "()V", "getInstance", "Lcom/intellij/javascript/nodejs/monorepo/JSMonorepoManager;", "project", "Lcom/intellij/openapi/project/Project;", "isEnabled", "", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJSMonorepoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSMonorepoManager.kt\ncom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,107:1\n31#2,2:108\n*S KotlinDebug\n*F\n+ 1 JSMonorepoManager.kt\ncom/intellij/javascript/nodejs/monorepo/JSMonorepoManager$Companion\n*L\n103#1:108,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final JSMonorepoManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JSMonorepoManager> serviceClass$iv = JSMonorepoManager.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (JSMonorepoManager)object;
        }

        private final boolean isEnabled() {
            return Registry.is((String)"js.show.package_name.in.run.configuration", (boolean)true);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

