/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp.workspaceModel;

import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.ExternalLibrariesWorkspaceModelNodesProvider;
import com.intellij.ide.projectView.impl.nodes.SyntheticLibraryElementNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpSyntheticLibrary;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList;
import com.intellij.javascript.nodejs.library.yarn.pnp.workspaceModel.YarnPnpWorkspaceLibraryEntity;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.backend.workspace.VirtualFileUrls;
import com.intellij.platform.workspace.storage.url.VirtualFileUrl;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\"\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u0002H\u0002J\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/workspaceModel/YarnPnpExternalLibraryNodeProvider;", "Lcom/intellij/ide/projectView/impl/nodes/ExternalLibrariesWorkspaceModelNodesProvider;", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/workspaceModel/YarnPnpWorkspaceLibraryEntity;", "()V", "createNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "entity", "project", "Lcom/intellij/openapi/project/Project;", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "getOrCreateSyntheticLibrary", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpSyntheticLibrary;", "yarnPnpFile", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpFile;", "pnpJsFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getWorkspaceClass", "Ljava/lang/Class;", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nYarnPnpExternalLibraryNodeProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpExternalLibraryNodeProvider.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/workspaceModel/YarnPnpExternalLibraryNodeProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,55:1\n13#2:56\n*S KotlinDebug\n*F\n+ 1 YarnPnpExternalLibraryNodeProvider.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/workspaceModel/YarnPnpExternalLibraryNodeProvider\n*L\n53#1:56\n*E\n"})
public final class YarnPnpExternalLibraryNodeProvider
implements ExternalLibrariesWorkspaceModelNodesProvider<YarnPnpWorkspaceLibraryEntity> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;

    @NotNull
    public Class<YarnPnpWorkspaceLibraryEntity> getWorkspaceClass() {
        return YarnPnpWorkspaceLibraryEntity.class;
    }

    @Nullable
    public AbstractTreeNode<?> createNode(@NotNull YarnPnpWorkspaceLibraryEntity entity, @NotNull Project project, @Nullable ViewSettings settings2) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!YarnPnpManager.shouldUseWorkspaceModel()) {
            return null;
        }
        VirtualFile virtualFile = VirtualFileUrls.getVirtualFile((VirtualFileUrl)entity.getPnpJsFileUrl());
        if (virtualFile == null) {
            YarnPnpExternalLibraryNodeProvider $this$createNode_u24lambda_u240 = this;
            boolean bl = false;
            LOG.warn("Cannot find virtual file by " + entity.getPnpJsFileUrl());
            return null;
        }
        VirtualFile pnpJsFile = virtualFile;
        YarnPnpFile yarnPnpFile = YarnPnpManager.getInstance(project).findPnpFile(pnpJsFile);
        if (yarnPnpFile == null) {
            YarnPnpExternalLibraryNodeProvider $this$createNode_u24lambda_u241 = this;
            boolean bl = false;
            LOG.warn("Cannot find YarnPnpFile by " + pnpJsFile);
            return null;
        }
        YarnPnpFile yarnPnpFile2 = yarnPnpFile;
        YarnPnpSyntheticLibrary library = this.getOrCreateSyntheticLibrary(yarnPnpFile2, pnpJsFile, entity);
        if (library == null) {
            return null;
        }
        return (AbstractTreeNode)new SyntheticLibraryElementNode(project, (SyntheticLibrary)library, (ItemPresentation)library, settings2);
    }

    private final YarnPnpSyntheticLibrary getOrCreateSyntheticLibrary(YarnPnpFile yarnPnpFile, VirtualFile pnpJsFile, YarnPnpWorkspaceLibraryEntity entity) {
        YarnPnpSyntheticLibrary yarnPnpSyntheticLibrary = yarnPnpFile.findSyntheticLibrary(entity.getWorkspaceLocation());
        if (yarnPnpSyntheticLibrary != null) {
            YarnPnpSyntheticLibrary it = yarnPnpSyntheticLibrary;
            boolean bl = false;
            return it;
        }
        YarnPnpWorkspaceList yarnPnpWorkspaceList = yarnPnpFile.getWorkspaceList();
        if (yarnPnpWorkspaceList == null) {
            YarnPnpExternalLibraryNodeProvider $this$getOrCreateSyntheticLibrary_u24lambda_u243 = this;
            boolean bl = false;
            LOG.warn("Yarn PnP workspaces are not loaded for " + pnpJsFile);
            return null;
        }
        YarnPnpWorkspaceList workspaceList = yarnPnpWorkspaceList;
        YarnPnpWorkspace yarnPnpWorkspace = workspaceList.findWorkspaceByLocation(entity.getWorkspaceLocation());
        if (yarnPnpWorkspace == null) {
            YarnPnpExternalLibraryNodeProvider $this$getOrCreateSyntheticLibrary_u24lambda_u244 = this;
            boolean bl = false;
            LOG.warn("Cannot find Yarn PnP workspace by " + entity.getWorkspaceLocation());
            return null;
        }
        YarnPnpWorkspace workspace = yarnPnpWorkspace;
        return new YarnPnpSyntheticLibrary(workspace, workspace.getLibraryName(), CollectionsKt.emptyList(), SetsKt.emptySet());
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(YarnPnpExternalLibraryNodeProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/workspaceModel/YarnPnpExternalLibraryNodeProvider$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

