/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp.model;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesIndexingRulesProvider;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpSyntheticLibrary;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002J\u001e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\rH\u0002J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpSyntheticLibraryBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "workspace", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspace;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspace;)V", "indexingRulesProvider", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesIndexingRulesProvider;", "build", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpSyntheticLibrary;", "buildDirectAndIndirectTypingsDependencies", "", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "buildExcludedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "dependency", "dependencyRoot", "isDependencyIndexed", "", "shouldBeAddedAsLibraryRoot", "dependencyLocationFile", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nYarnPnpSyntheticLibraryBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpSyntheticLibraryBuilder.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpSyntheticLibraryBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,89:1\n1603#2,9:90\n1855#2:99\n1856#2:101\n1612#2:102\n766#2:103\n857#2,2:104\n1#3:100\n*S KotlinDebug\n*F\n+ 1 YarnPnpSyntheticLibraryBuilder.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/model/YarnPnpSyntheticLibraryBuilder\n*L\n35#1:90,9\n35#1:99\n35#1:101\n35#1:102\n42#1:103\n42#1:104,2\n35#1:100\n*E\n"})
public final class YarnPnpSyntheticLibraryBuilder {
    @NotNull
    private final Project project;
    @NotNull
    private final YarnPnpWorkspace workspace;
    @NotNull
    private final NodeModulesIndexingRulesProvider indexingRulesProvider;

    public YarnPnpSyntheticLibraryBuilder(@NotNull Project project, @NotNull YarnPnpWorkspace workspace) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        this.project = project;
        this.workspace = workspace;
        this.indexingRulesProvider = NodeModulesIndexingRulesProvider.Companion.getInstance(this.project);
    }

    @Nullable
    public final YarnPnpSyntheticLibrary build() {
        Set<YarnPnpDependency> dependenciesToIndex = this.buildDirectAndIndirectTypingsDependencies();
        List roots = new ArrayList();
        Set excludedRoots = new HashSet();
        for (YarnPnpDependency dependency : dependenciesToIndex) {
            VirtualFile dependencyRoot;
            if (!this.isDependencyIndexed(this.indexingRulesProvider, dependency) || (dependencyRoot = dependency.resolveLocation()) == null || !this.shouldBeAddedAsLibraryRoot(dependencyRoot, this.project)) continue;
            roots.add(dependencyRoot);
            excludedRoots.addAll(this.buildExcludedRoots(dependency, dependencyRoot));
        }
        return !((Collection)dependenciesToIndex).isEmpty() ? new YarnPnpSyntheticLibrary(this.workspace, this.workspace.getLibraryName(), roots, excludedRoots) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<VirtualFile> buildExcludedRoots(YarnPnpDependency dependency, VirtualFile dependencyRoot) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = this.indexingRulesProvider.getExcludedDirs(dependency.getName());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            VirtualFile file = dependencyRoot.findFileByRelativePath(it);
            if ((file != null && file.isValid() ? file : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<YarnPnpDependency> buildDirectAndIndirectTypingsDependencies() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.workspace.getDependencies();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            YarnPnpDependency it = (YarnPnpDependency)element$iv$iv;
            boolean bl = false;
            if (!(!it.isWorkspaceLocation())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Set result2 = CollectionsKt.toMutableSet((Iterable)((List)destination$iv$iv));
        Set visited = new HashSet(this.workspace.getDependencies());
        Queue queue = new ArrayDeque(this.workspace.getDependencies().size() * 2);
        queue.addAll((Collection)this.workspace.getDependencies());
        while (!queue.isEmpty()) {
            YarnPnpDependency dep = (YarnPnpDependency)queue.poll();
            if (dep.isWorkspaceLocation() || this.indexingRulesProvider.isIndirectDependencyExcluded(dep.getName())) continue;
            Intrinsics.checkNotNull((Object)dep);
            result2.add(dep);
            for (YarnPnpDependency childDep : dep.getChildren()) {
                PackageJsonData data;
                PackageJsonData packageJsonData;
                if (!visited.add(childDep)) continue;
                if (childDep.findPackageJson() != null) {
                    VirtualFile it;
                    boolean bl = false;
                    packageJsonData = PackageJsonData.getOrCreateWithPreferredProject(this.project, it);
                } else {
                    packageJsonData = null;
                }
                if ((data = packageJsonData) == null || !data.hasTypings()) continue;
                queue.add(childDep);
            }
            for (String additionalDependency : this.indexingRulesProvider.getAdditionalInclusions(dep.getName())) {
                YarnPnpDependency childDependency = dep.findChildDependencyByName(dep.getName());
                if (childDependency == null || !visited.add(childDependency)) continue;
                queue.add(childDependency);
            }
        }
        return result2;
    }

    private final boolean isDependencyIndexed(NodeModulesIndexingRulesProvider indexingRulesProvider, YarnPnpDependency dependency) {
        return indexingRulesProvider.isDependencyIndexed(dependency.getName());
    }

    private final boolean shouldBeAddedAsLibraryRoot(VirtualFile dependencyLocationFile, Project project) {
        String[] stringArray = new String[]{".yarn"};
        if (JSLibraryUtil.hasDirectoryInPath(dependencyLocationFile, stringArray, null)) {
            return true;
        }
        return !NodeModulesDirectoryManager.getInstance(project).isUnderContentRoots(dependencyLocationFile);
    }
}

