/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.lang.javascript.psi.util.JSProjectUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\u00020\u0001:\u0001!B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0003H\u0002J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0019\u001a\u00020\u000eJ\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0019\u001a\u00020\u000eJ\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u0003J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0015\u0010\u001f\u001a\u00070\u0003\u00a2\u0006\u0002\b 2\u0006\u0010\u0019\u001a\u00020\u000eH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList;", "", "dependencyTreeJson", "", "workspaces", "", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspace;", "allDependencies", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpDependency;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getDependencyTreeJson", "()Ljava/lang/String;", "locationDirToWorkspaceMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "locationToDependencyNameMap", "locationToWorkspaceMap", "getWorkspaces", "()Ljava/util/List;", "equals", "", "other", "findContainingDependency", "path", "findDependencyByFile", "file", "findWorkspaceByFile", "findWorkspaceByLocation", "workspaceLocation", "hashCode", "", "toYarnPnpPath", "Lorg/jetbrains/annotations/NonNls;", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nYarnPnpWorkspaceList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YarnPnpWorkspaceList.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,96:1\n1045#2:97\n1194#2,2:98\n1222#2,4:100\n1603#2,9:104\n1855#2:113\n1856#2:115\n1612#2:116\n1194#2,2:117\n1222#2,4:119\n1#3:114\n13#4:123\n*S KotlinDebug\n*F\n+ 1 YarnPnpWorkspaceList.kt\ncom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList\n*L\n15#1:97\n25#1:98,2\n25#1:100,4\n26#1:104,9\n26#1:113\n26#1:115\n26#1:116\n33#1:117,2\n33#1:119,4\n26#1:114\n93#1:123\n*E\n"})
public final class YarnPnpWorkspaceList {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String dependencyTreeJson;
    @NotNull
    private final List<YarnPnpWorkspace> workspaces;
    @NotNull
    private final Map<String, YarnPnpWorkspace> locationToWorkspaceMap;
    @NotNull
    private final Map<VirtualFile, YarnPnpWorkspace> locationDirToWorkspaceMap;
    @NotNull
    private final Map<String, YarnPnpDependency> locationToDependencyNameMap;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public YarnPnpWorkspaceList(@NotNull String dependencyTreeJson, @NotNull List<YarnPnpWorkspace> workspaces, @NotNull List<YarnPnpDependency> allDependencies2) {
        Object element$iv$iv$iv;
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv;
        void it;
        Map map;
        Object element$iv$iv2;
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv;
        Intrinsics.checkNotNullParameter((Object)dependencyTreeJson, (String)"dependencyTreeJson");
        Intrinsics.checkNotNullParameter(workspaces, (String)"workspaces");
        Intrinsics.checkNotNullParameter(allDependencies2, (String)"allDependencies");
        this.dependencyTreeJson = dependencyTreeJson;
        Object $this$sortedBy$iv = workspaces;
        boolean $i$f$sortedBy = false;
        this.workspaces = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                YarnPnpWorkspace it = (YarnPnpWorkspace)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getLocation());
                it = (YarnPnpWorkspace)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getLocation())));
            }
        });
        for (YarnPnpWorkspace workspace : workspaces) {
            workspace.setWorkspaceList(this);
        }
        $this$sortedBy$iv = workspaces;
        YarnPnpWorkspaceList yarnPnpWorkspaceList = this;
        boolean $i$f$associateBy = false;
        int capacity$iv22 = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        void var7_11 = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv22);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            YarnPnpWorkspace yarnPnpWorkspace = (YarnPnpWorkspace)element$iv$iv2;
            map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getLocation(), element$iv$iv2);
        }
        yarnPnpWorkspaceList.locationToWorkspaceMap = destination$iv$iv;
        $this$associateBy$iv = workspaces;
        yarnPnpWorkspaceList = this;
        boolean $i$f$mapNotNull = false;
        void capacity$iv22 = $this$mapNotNull$iv;
        Iterable<Pair> destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        element$iv$iv2 = $this$forEach$iv$iv$iv.iterator();
        while (element$iv$iv2.hasNext()) {
            Pair pair;
            Object element$iv$iv3 = element$iv$iv$iv = element$iv$iv2.next();
            boolean bl = false;
            YarnPnpWorkspace it2 = (YarnPnpWorkspace)element$iv$iv3;
            boolean bl2 = false;
            if (LocalFileSystem.getInstance().findFileByPath(it2.getLocation()) == null) {
                YarnPnpWorkspaceList $this$lambda_u243_u24lambda_u242 = this;
                boolean bl3 = false;
                LOG.warn("Cannot find workspace location: " + it2.getLocation());
                pair = null;
            } else {
                VirtualFile virtualFile;
                Intrinsics.checkNotNull((Object)virtualFile);
                VirtualFile location = virtualFile;
                pair = TuplesKt.to((Object)location, (Object)it2);
            }
            if (pair == null) continue;
            Pair it$iv$iv = pair;
            boolean bl4 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        yarnPnpWorkspaceList.locationDirToWorkspaceMap = MapsKt.toMap((Iterable)((List)destination$iv$iv2));
        $this$mapNotNull$iv = allDependencies2;
        yarnPnpWorkspaceList = this;
        $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        destination$iv$iv2 = $this$associateBy$iv;
        destination$iv$iv = new LinkedHashMap(capacity$iv);
        $i$f$associateByTo = false;
        for (Object element$iv$iv2 : $this$associateByTo$iv$iv) {
            String systemIndependentLocation;
            element$iv$iv$iv = (YarnPnpDependency)element$iv$iv2;
            map = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)FileUtil.toSystemIndependentName((String)it.getLocation()), (String)"toSystemIndependentName(...)");
            map.put(systemIndependentLocation.length() > 1 ? StringsKt.removeSuffix((String)systemIndependentLocation, (CharSequence)"/") : systemIndependentLocation, element$iv$iv2);
        }
        yarnPnpWorkspaceList.locationToDependencyNameMap = destination$iv$iv;
    }

    @NotNull
    public final String getDependencyTreeJson() {
        return this.dependencyTreeJson;
    }

    @NotNull
    public final List<YarnPnpWorkspace> getWorkspaces() {
        return this.workspaces;
    }

    @Nullable
    public final YarnPnpWorkspace findWorkspaceByFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.locationDirToWorkspaceMap.isEmpty()) {
            return null;
        }
        return JSProjectUtil.traverseUpAndFindFirst(file, arg_0 -> YarnPnpWorkspaceList.findWorkspaceByFile$lambda$5((Function1)new Function1<VirtualFile, YarnPnpWorkspace>(this){
            final /* synthetic */ YarnPnpWorkspaceList this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final YarnPnpWorkspace invoke(VirtualFile it) {
                return (YarnPnpWorkspace)YarnPnpWorkspaceList.access$getLocationDirToWorkspaceMap$p(this.this$0).get(it);
            }
        }, arg_0));
    }

    @Nullable
    public final YarnPnpWorkspace findWorkspaceByLocation(@NotNull String workspaceLocation) {
        Intrinsics.checkNotNullParameter((Object)workspaceLocation, (String)"workspaceLocation");
        return this.locationToWorkspaceMap.get(workspaceLocation);
    }

    @Nullable
    public final YarnPnpDependency findDependencyByFile(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        YarnPnpDependency dependency = this.findContainingDependency(this.toYarnPnpPath(file));
        return dependency != null && !dependency.isWorkspaceLocation() ? dependency : null;
    }

    private final String toYarnPnpPath(VirtualFile file) {
        int ind;
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String path2 = string;
        if (file.getFileSystem() == JarFileSystem.getInstance() && (ind = StringsKt.lastIndexOf$default((CharSequence)path2, (String)"!/", (int)0, (boolean)false, (int)6, null)) > 0) {
            String string2 = path2;
            int n = ind + 1;
            path2 = ((Object)StringsKt.removeRange((CharSequence)string2, (int)ind, (int)n)).toString();
        }
        return path2;
    }

    private final YarnPnpDependency findContainingDependency(String path2) {
        int slashInd = path2.length();
        while (slashInd > 0) {
            String string = path2.substring(0, slashInd);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            YarnPnpDependency dependency = this.locationToDependencyNameMap.get(string);
            if (dependency != null) {
                return dependency;
            }
            slashInd = StringsKt.lastIndexOf$default((CharSequence)path2, (char)'/', (int)(slashInd - 1), (boolean)false, (int)4, null);
        }
        return null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList");
        YarnPnpWorkspaceList cfr_ignored_0 = (YarnPnpWorkspaceList)other;
        return Intrinsics.areEqual(this.workspaces, ((YarnPnpWorkspaceList)other).workspaces);
    }

    public int hashCode() {
        return ((Object)this.workspaces).hashCode();
    }

    private static final YarnPnpWorkspace findWorkspaceByFile$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (YarnPnpWorkspace)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ Map access$getLocationDirToWorkspaceMap$p(YarnPnpWorkspaceList $this) {
        return $this.locationDirToWorkspaceMap;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(YarnPnpWorkspaceList.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpWorkspaceList$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

