/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.yarn.pnp;

import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpFile;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpSyntheticLibrary;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspace;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpWorkspaceList;
import com.intellij.javascript.nodejs.library.yarn.pnp.model.YarnPnpSyntheticLibraryBuilder;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsProvider;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class YarnPnpSyntheticLibraryProvider
extends AdditionalLibraryRootsProvider {
    private static final Logger LOG = Logger.getInstance(YarnPnpSyntheticLibraryProvider.class);
    private final RecursionGuard<YarnPnpSyntheticLibraryProvider> myRecursionGuard = RecursionManager.createGuard((String)((Object)((Object)this)).getClass().getName());

    @NotNull
    public Collection<SyntheticLibrary> getAdditionalProjectLibraries(@NotNull Project project) {
        if (project == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(0);
        }
        if (YarnPnpManager.shouldUseWorkspaceModel()) {
            List<SyntheticLibrary> list2 = List.of();
            if (list2 == null) {
                YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(1);
            }
            return list2;
        }
        List<YarnPnpFile> pnpFiles = YarnPnpManager.getInstance(project).getPnpFiles();
        List<YarnPnpSyntheticLibrary> libraries = YarnPnpSyntheticLibraryProvider.collectLibraries(pnpFiles);
        if (libraries.isEmpty()) {
            List<SyntheticLibrary> list3 = Collections.emptyList();
            if (list3 == null) {
                YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(2);
            }
            return list3;
        }
        List list4 = ContainerUtil.notNullize((List)((List)this.computeFileIndexExtensionPreventingRecursion(() -> {
            JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
            return ContainerUtil.mapNotNull((Collection)libraries, library -> !mappings.getMappingsByLibraryName(library.getLibraryName()).isEmpty() ? library : null);
        })));
        if (list4 == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(3);
        }
        return list4;
    }

    @NotNull
    static List<YarnPnpSyntheticLibrary> collectLibraries(@NotNull List<YarnPnpFile> pnpFiles) {
        if (pnpFiles == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(4);
        }
        if (pnpFiles.isEmpty()) {
            List<YarnPnpSyntheticLibrary> list2 = Collections.emptyList();
            if (list2 == null) {
                YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(5);
            }
            return list2;
        }
        ArrayList<YarnPnpSyntheticLibrary> result2 = new ArrayList<YarnPnpSyntheticLibrary>(pnpFiles.size());
        for (YarnPnpFile pnpFile : pnpFiles) {
            YarnPnpWorkspaceList workspaceList = pnpFile.getWorkspaceList();
            if (workspaceList == null) continue;
            for (YarnPnpWorkspace workspace : workspaceList.getWorkspaces()) {
                YarnPnpSyntheticLibrary library = new YarnPnpSyntheticLibraryBuilder(pnpFile.getProject(), workspace).build();
                ContainerUtil.addIfNotNull(result2, (Object)((Object)library));
            }
        }
        ArrayList<YarnPnpSyntheticLibrary> arrayList = result2;
        if (arrayList == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private <T> T computeFileIndexExtensionPreventingRecursion(@NotNull Computable<T> computation) {
        Object result2;
        if (computation == null) {
            YarnPnpSyntheticLibraryProvider.$$$reportNull$$$0(7);
        }
        if ((result2 = this.myRecursionGuard.doPreventingRecursion((Object)this, false, computation)) == null) {
            LOG.error(new Throwable("Recursion prevented when computing FileIndex extension"));
        }
        return (T)result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpSyntheticLibraryProvider";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pnpFiles";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpSyntheticLibraryProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalProjectLibraries";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectLibraries";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalProjectLibraries";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectLibraries";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeFileIndexExtensionPreventingRecursion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5, 6 -> new IllegalStateException(string);
        };
    }
}

