/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.node_modules;

import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesFileListener;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.JsEntityHelperKt;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.NodeModulesEntities;
import com.intellij.javascript.nodejs.packageJson.PackageJsonFileManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ContentIteratorEx;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.platform.backend.workspace.WorkspaceModel;
import com.intellij.platform.workspace.storage.EntityStorage;
import com.intellij.util.containers.TreeNodeProcessingResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0015\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\r\u0010\u001e\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u00112\u0006\u0010!\u001a\u00020\u0010J\u0010\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J,\u0010#\u001a\u00020\u001a2\u0006\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u001a0(H\u0002J\u000e\u0010)\u001a\u00020\u001a2\u0006\u0010!\u001a\u00020\u0010J\u0010\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\u0010H\u0002R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0015\u00a2\u0006\u0002\b\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesVfsEventsSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "nodeModulesDirectoryManager", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager;", "packageJsonFileManager", "Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileManager;", "listener", "Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesFileListener;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesDirectoryManager;Lcom/intellij/javascript/nodejs/packageJson/PackageJsonFileManager;Lcom/intellij/javascript/nodejs/library/node_modules/NodeModulesFileListener;)V", "directoriesToEntitiesMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/javascript/nodejs/library/node_modules/workspaceModel/NodeModulesEntities;", "getEvents", "()Ljava/util/List;", "parentFilePointerDisposable", "Lcom/intellij/openapi/Disposable;", "Lorg/jetbrains/annotations/NotNull;", "processed", "", "afterMoveEvent", "", "event", "Lcom/intellij/openapi/vfs/newvfs/events/VFileMoveEvent;", "afterMoveEvent$intellij_javascript_impl", "dispose", "dispose$intellij_javascript_impl", "getEntitiesUnderDirectoryBeforeVfsEvent", "directory", "listenToEarlyVfsEvent", "processWhenAvailable", "parent", "newChildName", "", "processor", "Lkotlin/Function1;", "storeEntitiesUnderDirectory", "traverseDirectory", "dir", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeModulesVfsEventsSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeModulesVfsEventsSession.kt\ncom/intellij/javascript/nodejs/library/node_modules/NodeModulesVfsEventsSession\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,138:1\n766#2:139\n857#2,2:140\n*S KotlinDebug\n*F\n+ 1 NodeModulesVfsEventsSession.kt\ncom/intellij/javascript/nodejs/library/node_modules/NodeModulesVfsEventsSession\n*L\n128#1:139\n128#1:140,2\n*E\n"})
public final class NodeModulesVfsEventsSession {
    @NotNull
    private final Project project;
    @NotNull
    private final List<VFileEvent> events;
    @NotNull
    private final NodeModulesDirectoryManager nodeModulesDirectoryManager;
    @NotNull
    private final PackageJsonFileManager packageJsonFileManager;
    @NotNull
    private final NodeModulesFileListener listener;
    @NotNull
    private Disposable parentFilePointerDisposable;
    @NotNull
    private final Set<VFileEvent> processed;
    @NotNull
    private final Map<VirtualFile, NodeModulesEntities> directoriesToEntitiesMap;

    public NodeModulesVfsEventsSession(@NotNull Project project, @NotNull List<? extends VFileEvent> events, @NotNull NodeModulesDirectoryManager nodeModulesDirectoryManager, @NotNull PackageJsonFileManager packageJsonFileManager, @NotNull NodeModulesFileListener listener2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(events, (String)"events");
        Intrinsics.checkNotNullParameter((Object)nodeModulesDirectoryManager, (String)"nodeModulesDirectoryManager");
        Intrinsics.checkNotNullParameter((Object)packageJsonFileManager, (String)"packageJsonFileManager");
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.project = project;
        this.events = events;
        this.nodeModulesDirectoryManager = nodeModulesDirectoryManager;
        this.packageJsonFileManager = packageJsonFileManager;
        this.listener = listener2;
        Disposable disposable = Disposer.newDisposable((Disposable)this.nodeModulesDirectoryManager, (String)"node_modules file pointers");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.parentFilePointerDisposable = disposable;
        this.processed = new HashSet();
        this.directoriesToEntitiesMap = new LinkedHashMap();
        for (VFileEvent event : this.events) {
            this.listenToEarlyVfsEvent(event);
        }
    }

    @NotNull
    public final List<VFileEvent> getEvents() {
        return this.events;
    }

    private final void listenToEarlyVfsEvent(VFileEvent event) {
        if (event instanceof VFileCreateEvent && ((VFileCreateEvent)event).isDirectory()) {
            VirtualFile virtualFile = ((VFileCreateEvent)event).getParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getParent(...)");
            String string = ((VFileCreateEvent)event).getChildName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getChildName(...)");
            this.processWhenAvailable(virtualFile, string, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this){
                final /* synthetic */ NodeModulesVfsEventsSession this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    NodeModulesVfsEventsSession.access$traverseDirectory(this.this$0, it);
                }
            }));
        } else if (event instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)event).getFile().isDirectory()) {
            String newName;
            VirtualFile parent = ((VFilePropertyChangeEvent)event).getFile().getParent();
            Object object = ((VFilePropertyChangeEvent)event).getNewValue();
            String string = newName = object instanceof String ? (String)object : null;
            if (parent != null && newName != null) {
                this.processWhenAvailable(parent, newName, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(this){
                    final /* synthetic */ NodeModulesVfsEventsSession this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull VirtualFile it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        NodeModulesVfsEventsSession.access$getListener$p(this.this$0).afterEarlyRenameEvent$intellij_javascript_impl(it, this.this$0);
                    }
                }));
            }
        } else if (event instanceof VFileMoveEvent && ((VFileMoveEvent)event).getFile().isDirectory()) {
            VirtualFile virtualFile = ((VFileMoveEvent)event).getNewParent();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getNewParent(...)");
            String string = ((VFileMoveEvent)event).getFile().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            this.processWhenAvailable(virtualFile, string, (Function1<? super VirtualFile, Unit>)((Function1)new Function1<VirtualFile, Unit>(event, this){
                final /* synthetic */ VFileEvent $event;
                final /* synthetic */ NodeModulesVfsEventsSession this$0;
                {
                    this.$event = $event;
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(@NotNull VirtualFile it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    if (Intrinsics.areEqual((Object)((VFileMoveEvent)this.$event).getFile(), (Object)it)) {
                        this.this$0.afterMoveEvent$intellij_javascript_impl((VFileMoveEvent)this.$event);
                    } else {
                        NodeModulesVfsEventsSession $this$thisLogger$iv = this.this$0;
                        boolean $i$f$thisLogger = false;
                        Logger logger = Logger.getInstance(NodeModulesVfsEventsSession.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                        logger.error("Unexpected different directories: expected " + ((VFileMoveEvent)this.$event).getFile() + ", got " + it);
                    }
                }
            }));
        }
    }

    private final void processWhenAvailable(VirtualFile parent, String newChildName, Function1<? super VirtualFile, Unit> processor) {
        Disposable disposable = Disposer.newDisposable((Disposable)this.parentFilePointerDisposable);
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable disposable2 = disposable;
        String url = parent.getUrl() + "/" + newChildName;
        if (NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
            NodeModulesDirectoryManager.LOG.debug("Watching " + url);
        }
        VirtualFilePointerManager.getInstance().create(url, disposable2, new VirtualFilePointerListener(parent, disposable2, url, newChildName, processor){
            final /* synthetic */ VirtualFile $parent;
            final /* synthetic */ Disposable $disposable;
            final /* synthetic */ String $url;
            final /* synthetic */ String $newChildName;
            final /* synthetic */ Function1<VirtualFile, Unit> $processor;
            {
                this.$parent = $parent;
                this.$disposable = $disposable;
                this.$url = $url;
                this.$newChildName = $newChildName;
                this.$processor = $processor;
            }

            public void validityChanged(@NotNull VirtualFilePointer[] pointers) {
                Intrinsics.checkNotNullParameter((Object)pointers, (String)"pointers");
                if (!this.$parent.isValid()) {
                    Disposer.dispose((Disposable)this.$disposable);
                    if (NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
                        NodeModulesDirectoryManager.LOG.debug("parent of " + this.$url + " became invalid, file pointer has been removed");
                    }
                    return;
                }
                VirtualFile file = this.$parent.findChild(this.$newChildName);
                if (NodeModulesDirectoryManager.LOG.isDebugEnabled()) {
                    NodeModulesDirectoryManager.LOG.debug("validityChanged for " + this.$url + ": " + (file != null));
                }
                if (file != null) {
                    Disposer.dispose((Disposable)this.$disposable);
                    this.$processor.invoke((Object)file);
                }
            }
        });
    }

    private final void traverseDirectory(VirtualFile dir) {
        if (!dir.isDirectory()) {
            return;
        }
        ProjectFileIndex projectFileIndex = (ProjectFileIndex)ReadAction.compute(() -> NodeModulesVfsEventsSession.traverseDirectory$lambda$0(this));
        if (projectFileIndex == null) {
            return;
        }
        ProjectFileIndex fileIndex = projectFileIndex;
        List foundNodeModules = new ArrayList();
        fileIndex.iterateContentUnderDirectory(dir, (ContentIterator)((ContentIteratorEx)arg_0 -> NodeModulesVfsEventsSession.traverseDirectory$lambda$1(this, foundNodeModules, arg_0)));
        this.nodeModulesDirectoryManager.addNodeModulesDirs(foundNodeModules);
    }

    public final void dispose$intellij_javascript_impl() {
        Disposer.dispose((Disposable)this.parentFilePointerDisposable);
    }

    public final void afterMoveEvent$intellij_javascript_impl(@NotNull VFileMoveEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.processed.add((VFileEvent)event)) {
            this.listener.afterMoveEvent$intellij_javascript_impl(event, this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void storeEntitiesUnderDirectory(@NotNull VirtualFile directory) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        List<VirtualFile> list2 = this.nodeModulesDirectoryManager.getNodeModulesDirs();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getNodeModulesDirs(...)");
        Iterable $this$filter$iv = list2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!VfsUtilCore.isAncestor((VirtualFile)directory, (VirtualFile)it, (boolean)true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List under = (List)destination$iv$iv;
        NodeModulesEntities entities2 = JsEntityHelperKt.findEntities(this.project, (EntityStorage)WorkspaceModel.Companion.getInstance(this.project).getCurrentSnapshot(), under);
        this.directoriesToEntitiesMap.put(directory, entities2);
    }

    @Nullable
    public final NodeModulesEntities getEntitiesUnderDirectoryBeforeVfsEvent(@NotNull VirtualFile directory) {
        Intrinsics.checkNotNullParameter((Object)directory, (String)"directory");
        return this.directoriesToEntitiesMap.get(directory);
    }

    private static final ProjectFileIndex traverseDirectory$lambda$0(NodeModulesVfsEventsSession this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        return this$0.project.isDisposed() ? null : ProjectFileIndex.getInstance((Project)this$0.project);
    }

    private static final TreeNodeProcessingResult traverseDirectory$lambda$1(NodeModulesVfsEventsSession this$0, List $foundNodeModules, VirtualFile fileOrDir) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$foundNodeModules, (String)"$foundNodeModules");
        Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
        if (!fileOrDir.isValid()) {
            return TreeNodeProcessingResult.SKIP_CHILDREN;
        }
        if (PackageJsonUtil.isPackageJsonFile(fileOrDir)) {
            this$0.packageJsonFileManager.onPackageJsonAdded(fileOrDir);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(fileOrDir)) {
            $foundNodeModules.add(fileOrDir);
            return TreeNodeProcessingResult.SKIP_CHILDREN;
        }
        return TreeNodeProcessingResult.CONTINUE;
    }

    public static final /* synthetic */ void access$traverseDirectory(NodeModulesVfsEventsSession $this, VirtualFile dir) {
        $this.traverseDirectory(dir);
    }

    public static final /* synthetic */ NodeModulesFileListener access$getListener$p(NodeModulesVfsEventsSession $this) {
        return $this.listener;
    }
}

