/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library.core;

import com.google.common.collect.ImmutableList;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.library.core.NodeCoreModulesCatalog;
import com.intellij.javascript.nodejs.library.core.NodeCoreSourcesSnapshot;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.RootsChangeRescanningInfo;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryModelBackedBySyntheticLibrary;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
public final class NodeCoreLibraryManager
implements Disposable {
    public static final String LIBRARY_NAME = "Node.js Core";
    private static final RegistryValue USE_TYPINGS = Registry.get((String)"nodejs.core.library.use.typings");
    private final Project myProject;
    private JSLibraryMappings myMappings;
    @Nullable
    private volatile NodeCoreSourcesSnapshot mySnapshot;

    public NodeCoreLibraryManager(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(0);
        }
        this.myMappings = null;
        this.myProject = project;
        USE_TYPINGS.addListener(new RegistryValueListener(){

            public void afterValueChanged(@NotNull RegistryValue value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!ApplicationManager.getApplication().isUnitTestMode()) {
                    ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(() -> JSLibraryManager.getInstance(NodeCoreLibraryManager.this.myProject).commitChanges(RootsChangeRescanningInfo.RESCAN_DEPENDENCIES_IF_NEEDED)), NodeCoreLibraryManager.this.myProject.getDisposed());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager$1", "afterValueChanged"));
            }
        }, (Disposable)this);
        this.mySnapshot = NodeCoreLibraryManager.getInitialSnapshot(project);
    }

    public void dispose() {
    }

    @Nullable
    private static NodeCoreSourcesSnapshot getInitialSnapshot(@NotNull Project project) {
        NodeCoreLibraryConfigurator.NodeLibraryVersion version2;
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(1);
        }
        if ((version2 = NodeCoreLibraryConfigurator.getConfiguredCoreLibraryVersion(project)) == null) {
            return null;
        }
        return NodeCoreLibraryConfigurator.getSnapshot(NodeCoreLibraryConfigurator.getCoreModulesSrcDir(version2.getNodeVersion()));
    }

    @NotNull
    public static NodeCoreLibraryManager getInstance(@NotNull Project project) {
        if (project == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(2);
        }
        NodeCoreLibraryManager nodeCoreLibraryManager = (NodeCoreLibraryManager)project.getService(NodeCoreLibraryManager.class);
        if (nodeCoreLibraryManager == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(3);
        }
        return nodeCoreLibraryManager;
    }

    @Nullable
    NodeCoreSourcesSnapshot getSnapshot() {
        return this.mySnapshot;
    }

    void setSnapshot(@Nullable NodeCoreSourcesSnapshot snapshot) {
        this.mySnapshot = snapshot;
    }

    public static boolean isCoreModuleName(@NotNull String moduleName) {
        if (moduleName == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(4);
        }
        return NodeCoreModulesCatalog.INSTANCE.isPublicCoreModule(moduleName);
    }

    public boolean isCoreModuleLibraryFile(@NotNull VirtualFile virtualFile) {
        NodeCoreSourcesSnapshot snapshot;
        if (virtualFile == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(5);
        }
        return (snapshot = this.mySnapshot) != null && snapshot.isCoreModuleFile(virtualFile);
    }

    public boolean isCoreLibraryFile(@NotNull VirtualFile virtualFile) {
        SyntheticLibrary syntheticLibrary;
        ScriptingLibraryModel libraryModel;
        if (virtualFile == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(6);
        }
        return ProjectFileIndex.getInstance((Project)this.myProject).isInLibrary(virtualFile) && (libraryModel = JSLibraryManager.getInstance(this.myProject).getLibraryByName(LIBRARY_NAME)) instanceof ScriptingLibraryModelBackedBySyntheticLibrary && (syntheticLibrary = ((ScriptingLibraryModelBackedBySyntheticLibrary)libraryModel).getSyntheticLibrary()) != null && VfsUtilCore.isUnder((VirtualFile)virtualFile, new HashSet(syntheticLibrary.getAllRoots()));
    }

    @NotNull
    public Collection<String> listCoreModuleNames() {
        ImmutableList<String> immutableList = NodeCoreModulesCatalog.INSTANCE.getPublicCoreModules();
        if (immutableList == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(7);
        }
        return immutableList;
    }

    @Nullable
    public VirtualFile findCoreModuleFileByName(@NotNull String moduleName) {
        NodeCoreSourcesSnapshot snapshot;
        if (moduleName == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(8);
        }
        return (snapshot = this.mySnapshot) != null ? snapshot.getFileByModuleName(moduleName) : null;
    }

    public boolean isAssociatedWithNodeCoreLibrary(@NotNull VirtualFile file) {
        if (file == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(9);
        }
        JSLibraryMappings mappings = this.getLibraryMappings();
        return mappings.isLibraryInScopeFor(file, LIBRARY_NAME);
    }

    public boolean hasAssociatedRoots() {
        JSLibraryMappings mappings = this.getLibraryMappings();
        return !mappings.getMappingsByLibraryName(LIBRARY_NAME).isEmpty();
    }

    @NotNull
    public List<VirtualFile> getAssociatedRoots() {
        JSLibraryMappings mappings = this.getLibraryMappings();
        List list2 = mappings.getMappingsByLibraryName(LIBRARY_NAME);
        if (list2 == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(10);
        }
        return list2;
    }

    @NotNull
    private JSLibraryMappings getLibraryMappings() {
        JSLibraryMappings mappings = this.myMappings;
        if (mappings == null) {
            this.myMappings = mappings = JSLibraryMappings.getInstance(this.myProject);
        }
        JSLibraryMappings jSLibraryMappings = mappings;
        if (jSLibraryMappings == null) {
            NodeCoreLibraryManager.$$$reportNull$$$0(11);
        }
        return jSLibraryMappings;
    }

    public static boolean shouldUseNodeTypings() {
        return USE_TYPINGS.asBoolean();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/core/NodeCoreLibraryManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "listCoreModuleNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAssociatedRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryMappings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInitialSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 11: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleName";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCoreModuleLibraryFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isCoreLibraryFile";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findCoreModuleFileByName";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAssociatedWithNodeCoreLibrary";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7, 10, 11 -> new IllegalStateException(string);
        };
    }
}

