/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.wsl;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.wsl.WSLCommandLineOptions;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WSLUtil;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.javascript.nodejs.execution.NodeProgressUtil;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.wsl.WslNodeInterpreter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.SettingsCategory;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.NullableConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="WslNodeInterpreterManager", category=SettingsCategory.TOOLS, exportable=true, presentableName=NodeJsLocalInterpreterManager.PresentableNameGetter.class, storages={@Storage(value="nodejs.xml", roamingType=RoamingType.DISABLED)})
public class WslNodeInterpreterManager
implements PersistentStateComponent<Element> {
    private static final Logger LOG = Logger.getInstance(WslNodeInterpreterManager.class);
    private static final String PREFIX = "wsl://";
    private static final String INTERPRETERS_TAG_NAME = "wsl-interpreters";
    private static final String INTERPRETER_TAG_NAME = "wsl-interpreter";
    private static final String DISTRIBUTION_ATTR_NAME = "distribution";
    private static final String PATH_ATTR_NAME = "path";
    private final ExecutorService myExecutorService = Executors.newFixedThreadPool(1, ConcurrencyUtil.newNamedThreadFactory((String)"WslNodeInterpreter Pool", (boolean)true, (int)5));
    private volatile List<WslNodeInterpreter> myInterpreters;
    private final ConcurrentMap<WslNodeInterpreter, Future<SemVer>> myRunningFetches = new ConcurrentHashMap<WslNodeInterpreter, Future<SemVer>>();
    private final ConcurrentMap<WslNodeInterpreter, CachedValue> myVersionCache = new ConcurrentHashMap<WslNodeInterpreter, CachedValue>();

    @Nullable
    public Element getState() {
        List<WslNodeInterpreter> interpreters = this.myInterpreters;
        if (interpreters == null) {
            return null;
        }
        Element parent = new Element(INTERPRETERS_TAG_NAME);
        for (WslNodeInterpreter interpreter2 : interpreters) {
            Element interpreterElement = new Element(INTERPRETER_TAG_NAME);
            interpreterElement.setAttribute(DISTRIBUTION_ATTR_NAME, interpreter2.getWslDistributionId());
            interpreterElement.setAttribute(PATH_ATTR_NAME, interpreter2.getWslInterpreterPath());
            parent.addContent(interpreterElement);
        }
        return parent;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(0);
        }
        List children = state.getChildren(INTERPRETER_TAG_NAME);
        ArrayList<WslNodeInterpreter> interpreters = new ArrayList<WslNodeInterpreter>();
        for (Element interpreterElement : children) {
            String distributionId = interpreterElement.getAttributeValue(DISTRIBUTION_ATTR_NAME);
            String interpreterPath = interpreterElement.getAttributeValue(PATH_ATTR_NAME);
            if (distributionId == null || interpreterPath == null) continue;
            interpreters.add(new WslNodeInterpreter(WSLUtil.getMsId((String)distributionId), interpreterPath));
        }
        this.setInterpreters(interpreters);
    }

    public void noStateLoaded() {
        WslNodeInterpreterManager oldManager = (WslNodeInterpreterManager)ApplicationManager.getApplication().getService(OldWslNodeInterpreterManager.class);
        List<WslNodeInterpreter> interpreters = oldManager.myInterpreters;
        if (interpreters != null) {
            LOG.info("Imported from previous settings " + interpreters);
            this.setInterpreters(interpreters);
            oldManager.myInterpreters = null;
        }
    }

    public void setInterpreters(@NotNull List<WslNodeInterpreter> interpreters) {
        if (interpreters == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(1);
        }
        this.myInterpreters = interpreters;
    }

    @NotNull
    static String getReferenceName(@NotNull WslNodeInterpreter interpreter2) {
        if (interpreter2 == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(2);
        }
        String string = PREFIX + interpreter2.getWslDistributionId() + "@" + interpreter2.getWslInterpreterPath();
        if (string == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public WslNodeInterpreter findByReferenceName(@NotNull String referenceName) {
        int distInd;
        if (referenceName == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(4);
        }
        if (referenceName.startsWith(PREFIX) && (distInd = referenceName.indexOf("@", PREFIX.length())) > 0) {
            String wslId = WSLUtil.getMsId((String)referenceName.substring(PREFIX.length(), distInd));
            String path2 = referenceName.substring(distInd + 1);
            return new WslNodeInterpreter(wslId, path2);
        }
        return null;
    }

    @NotNull
    public List<WslNodeInterpreter> getInterpreters() {
        List list2 = ContainerUtil.notNullize(this.myInterpreters);
        if (list2 == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(5);
        }
        return list2;
    }

    @Nullable
    public Ref<SemVer> getCachedVersion(@NotNull WslNodeInterpreter interpreter2) {
        CachedValue value;
        if (interpreter2 == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(6);
        }
        if ((value = (CachedValue)this.myVersionCache.get(interpreter2)) != null && value.myModificationCount == CachedValue.getExternalModificationCount()) {
            return Ref.create((Object)value.myVersion);
        }
        return null;
    }

    public void fetchVersion(@NotNull WslNodeInterpreter interpreter2, @Nullable NullableConsumer<? super SemVer> consumer) {
        if (interpreter2 == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(7);
        }
        Future<SemVer> future = this.getOrCreateFetch(interpreter2);
        if (consumer != null) {
            this.myExecutorService.execute(() -> {
                SemVer version2 = null;
                try {
                    version2 = (SemVer)future.get();
                }
                catch (InterruptedException e) {
                    LOG.warn("Fetch interrupted", (Throwable)e);
                }
                catch (ExecutionException e) {
                    LOG.warn("Fetch failed", (Throwable)e);
                }
                consumer.consume((Object)version2);
            });
        }
    }

    @NotNull
    private Future<SemVer> getOrCreateFetch(@NotNull WslNodeInterpreter interpreter2) {
        FutureTask<SemVer> newFetch;
        Future running;
        if (interpreter2 == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(8);
        }
        if ((running = (Future)this.myRunningFetches.putIfAbsent(interpreter2, newFetch = new FutureTask<SemVer>(() -> (SemVer)NodeProgressUtil.withInvisibleProgress(() -> {
            SemVer version2 = null;
            try {
                version2 = WslNodeInterpreterManager.doFetchVersion(interpreter2);
            }
            catch (Throwable t) {
                LOG.warn("Failed to fetch version for " + interpreter2, t);
            }
            finally {
                this.myVersionCache.put(interpreter2, new CachedValue(version2));
                this.myRunningFetches.remove(interpreter2);
            }
            return version2;
        })))) != null) {
            Future future = running;
            if (future == null) {
                WslNodeInterpreterManager.$$$reportNull$$$0(9);
            }
            return future;
        }
        this.myExecutorService.execute(newFetch);
        FutureTask<SemVer> futureTask = newFetch;
        if (futureTask == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(10);
        }
        return futureTask;
    }

    private static SemVer doFetchVersion(@NotNull WslNodeInterpreter interpreter2) throws com.intellij.execution.ExecutionException {
        if (interpreter2 == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(11);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setWorkDirectory(NodeJsLocalInterpreterManager.getWorkingDirectory());
        commandLine.withParentEnvironmentType(GeneralCommandLine.ParentEnvironmentType.CONSOLE);
        commandLine.withCharset(StandardCharsets.UTF_8);
        commandLine.setExePath(interpreter2.getWslInterpreterPath());
        commandLine.addParameter("--version");
        WSLDistribution distribution = interpreter2.getDistribution();
        commandLine = distribution.patchCommandLine(commandLine, null, new WSLCommandLineOptions());
        CapturingProcessHandler processHandler = new CapturingProcessHandler(commandLine);
        ProcessOutput output = processHandler.runProcess(5000);
        if (output.isTimeout()) {
            LOG.info("Cannot fetch version: timed out (" + commandLine.getCommandLineString() + ")");
            return null;
        }
        if (output.getExitCode() != 0) {
            LOG.info("Cannot fetch version: non-zero exit code " + output.getExitCode() + " (" + commandLine.getCommandLineString() + "), stdout: " + output.getStdout() + ", stderr: " + output.getStderr());
            return null;
        }
        List lines = output.getStdoutLines(true);
        for (String line : lines) {
            SemVer version2 = SemVer.parseFromText((String)StringUtil.trimStart((String)line, (String)"v"));
            if (version2 == null) continue;
            return version2;
        }
        LOG.info("Cannot parse version from '" + lines + "' (" + commandLine.getCommandLineString() + ")");
        return null;
    }

    @NotNull
    public static WslNodeInterpreterManager getInstance() {
        WslNodeInterpreterManager wslNodeInterpreterManager = (WslNodeInterpreterManager)ApplicationManager.getApplication().getService(WslNodeInterpreterManager.class);
        if (wslNodeInterpreterManager == null) {
            WslNodeInterpreterManager.$$$reportNull$$$0(12);
        }
        return wslNodeInterpreterManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 9, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreterManager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/wsl/WslNodeInterpreterManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateFetch";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceName";
                break;
            }
            case 3: 
            case 5: 
            case 9: 
            case 10: 
            case 12: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getCachedVersion";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "fetchVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateFetch";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "doFetchVersion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 9, 10, 12 -> new IllegalStateException(string);
        };
    }

    @Deprecated(forRemoval=true)
    @State(name="WslNodeInterpreters", storages={@Storage(value="other.xml", roamingType=RoamingType.DISABLED)})
    @Service(value={Service.Level.APP})
    public static final class OldWslNodeInterpreterManager
    extends WslNodeInterpreterManager {
        @Override
        public void noStateLoaded() {
        }
    }

    private static class CachedValue {
        private final SemVer myVersion;
        private final long myModificationCount;

        private CachedValue(@Nullable SemVer version2) {
            this.myVersion = version2;
            this.myModificationCount = CachedValue.getExternalModificationCount();
        }

        public static long getExternalModificationCount() {
            return SaveAndSyncHandler.getInstance().getExternalChangesTracker().getModificationCount();
        }
    }
}

