/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.local;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeLocalInterpreterRefResolveResult;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeJsLocalInterpreterType
extends NodeJsInterpreterType<NodeJsLocalInterpreter> {
    private static final NodeJsLocalInterpreterType INSTANCE = new NodeJsLocalInterpreterType();
    @NonNls
    public static final String NODE_FROM_PATH = "node";

    @NotNull
    public static NodeJsLocalInterpreterType getInstance() {
        NodeJsLocalInterpreterType nodeJsLocalInterpreterType = INSTANCE;
        if (nodeJsLocalInterpreterType == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(0);
        }
        return nodeJsLocalInterpreterType;
    }

    @Override
    @NotNull
    public String getName() {
        return "local";
    }

    @Override
    @Nullable
    public NodeJsLocalInterpreter findByReferenceName(@NotNull String referenceName) {
        NodeLocalInterpreterRefResolveResult result2;
        if (referenceName == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(1);
        }
        return (result2 = this.resolveReference(null, referenceName)) != null ? (NodeJsLocalInterpreter)result2.getInterpreter() : null;
    }

    @Nullable
    protected NodeLocalInterpreterRefResolveResult resolveReference(@Nullable Project project, @NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(2);
        }
        return NodeJsLocalInterpreterManager.getInstance().resolveReference(project, referenceName);
    }

    @Override
    @NotNull
    public List<NodeJsInterpreterRef> getInterpreterRefs() {
        List<NodeJsInterpreterRef> list2 = Collections.singletonList(NodeJsLocalInterpreterType.createNodeFromPathRef());
        if (list2 == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<NodeJsLocalInterpreter> getInterpreters() {
        List<NodeJsLocalInterpreter> list2 = NodeJsLocalInterpreterManager.getInstance().getInterpreters();
        if (list2 == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @Override
    @Nullable
    public NodeJsLocalInterpreter showAddDialog(@NotNull Project project) {
        if (project == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(5);
        }
        return NodeJsLocalInterpreterType.chooseInterpreter(project, null);
    }

    @Override
    @Nullable
    public NodeJsLocalInterpreter edit(@NotNull Project project, @NotNull NodeJsLocalInterpreter interpreter2) {
        if (project == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(6);
        }
        if (interpreter2 == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(7);
        }
        return NodeJsLocalInterpreterType.chooseInterpreter(project, interpreter2);
    }

    @Nullable
    private static NodeJsLocalInterpreter chooseInterpreter(@NotNull Project project, @Nullable NodeJsLocalInterpreter interpreter2) {
        VirtualFile file;
        if (project == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(8);
        }
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withShowHiddenFiles(SystemInfo.isUnix);
        if (SystemInfo.isMac) {
            descriptor.setForcedToUseIdeaFileChooser(true);
        }
        VirtualFile initial = null;
        if (interpreter2 != null) {
            initial = LocalFileSystem.getInstance().findFileByPath(interpreter2.getInterpreterSystemIndependentPath());
        }
        if ((file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, initial)) != null) {
            return new NodeJsLocalInterpreter(file.getPath());
        }
        return null;
    }

    @Override
    public void setInterpreters(@NotNull List<NodeJsLocalInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(9);
        }
        NodeJsLocalInterpreterManager.getInstance().setInterpreters(interpreters);
    }

    public static NodeJsInterpreterRef createNodeFromPathRef() {
        return NodeJsInterpreterRef.create(NODE_FROM_PATH);
    }

    public static boolean isNodeFromPathRef(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(10);
        }
        return NodeJsLocalInterpreterType.isNodeFromPathRef(interpreterRef.getReferenceName());
    }

    public static boolean isNodeFromPathRef(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsLocalInterpreterType.$$$reportNull$$$0(11);
        }
        return NODE_FROM_PATH.equals(referenceName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 6, 7, 8, 9, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterType";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/local/NodeJsLocalInterpreterType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRefs";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveReference";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showAddDialog";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "chooseInterpreter";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isNodeFromPathRef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 6, 7, 8, 9, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

