/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.execution;

import com.intellij.execution.Platform;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.target.ContributedTypeBase;
import com.intellij.execution.target.ResolvedPortBinding;
import com.intellij.execution.target.ResolvedPortBindingKt;
import com.intellij.execution.target.TargetEnvironment;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.execution.target.TargetEnvironmentConfigurationKt;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetPlatform;
import com.intellij.execution.target.TargetProgressIndicator;
import com.intellij.execution.target.TargetProgressIndicatorAdapter;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.TargetedCommandLineBuilder;
import com.intellij.execution.target.local.LocalTargetEnvironment;
import com.intellij.execution.target.local.LocalTargetEnvironmentRequest;
import com.intellij.execution.target.value.DeferredLocalTargetValue;
import com.intellij.execution.target.value.DeferredTargetValue;
import com.intellij.execution.target.value.TargetEnvironmentFunctions;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.execution.util.ProgramParametersConfigurator;
import com.intellij.javascript.debugger.CommandLineDebugConfigurator;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptions;
import com.intellij.javascript.nodejs.execution.NodeTargetRunOptionsKt;
import com.intellij.javascript.nodejs.execution.ProcessWithCmdLine;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeTargetRunSetup;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpNodePackage;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.reference.NodePathManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.LangCoreBundle;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathMapper;
import com.intellij.util.PathUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.pty4j.PtyProcess;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.function.UnaryOperator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010&\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u009e\u00012\u00020\u0001:\b\u009e\u0001\u009f\u0001\u00a0\u0001\u00a1\u0001B3\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\u000e\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u000fJ3\u0010F\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020\u001c2\u001e\u0010H\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020K0J0I\"\b\u0012\u0004\u0012\u00020K0J\u00a2\u0006\u0002\u0010LJ$\u0010F\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020\u001c2\u0012\u0010H\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0MH\u0002J\u0016\u0010N\u001a\u00020\u001a2\u0006\u0010G\u001a\u00020\u001c2\u0006\u00108\u001a\u00020KJ\b\u0010O\u001a\u00020PH\u0002J\u0016\u0010Q\u001a\b\u0012\u0004\u0012\u00020R0M2\u0006\u0010S\u001a\u00020RH\u0002J\u0010\u0010T\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020*H\u0007J\b\u0010U\u001a\u00020\u001aH\u0002J\b\u0010V\u001a\u00020\u001aH\u0002J\b\u0010W\u001a\u00020\u001cH\u0002J\u0010\u0010X\u001a\u00020K2\u0006\u0010Y\u001a\u00020KH\u0002J\u0010\u0010Z\u001a\u00020\u00162\u0006\u0010[\u001a\u00020\u0016H\u0002J\u0014\u0010\\\u001a\b\u0012\u0004\u0012\u00020K0\u00192\u0006\u0010[\u001a\u00020KJ\u000e\u0010]\u001a\u00020K2\u0006\u0010[\u001a\u00020KJ\u0014\u0010^\u001a\b\u0012\u0004\u0012\u00020K0\u00192\u0006\u0010_\u001a\u00020KJ\u000e\u0010`\u001a\u00020K2\u0006\u0010_\u001a\u00020KJ\u0010\u0010a\u001a\u00020\u00162\u0006\u0010b\u001a\u00020\u0016H\u0002J \u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u000202H\u0002J\u001e\u0010j\u001a\u00020k2\u0006\u0010e\u001a\u00020f2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u000202J \u0010l\u001a\u00020k2\u0006\u0010e\u001a\u00020m2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u000202H\u0002J\u0010\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u00020\u0016H\u0002J>\u0010q\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u0016\u0018\u00010r2\u0006\u0010s\u001a\u00020\u00162\u001e\u0010t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160r\u0012\u0004\u0012\u00020\u00160uH\u0002J\u0012\u0010v\u001a\u0004\u0018\u00010R2\u0006\u0010s\u001a\u00020KH\u0002J\u0019\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0MH\u0000\u00a2\u0006\u0002\bxJ#\u0010w\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0M2\b\u0010G\u001a\u0004\u0018\u00010\u001cH\u0002\u00a2\u0006\u0002\u0010yJ\b\u0010z\u001a\u00020{H\u0002J\u0006\u0010|\u001a\u00020\u001cJ!\u0010}\u001a\u00020K2\u0012\u0010~\u001a\n\u0012\u0006\b\u0001\u0012\u00020K0I\"\u00020KH\u0002\u00a2\u0006\u0002\u0010\u007fJ%\u0010\u0080\u0001\u001a\u00020K2\u0007\u0010\u0081\u0001\u001a\u00020K2\u0007\u0010\u0082\u0001\u001a\u00020K2\b\u0010\u0083\u0001\u001a\u00030\u0084\u0001H\u0002J\u0018\u0010\u0085\u0001\u001a\t\u0012\u0005\u0012\u00030\u0086\u00010\u00192\b\u0010\u0087\u0001\u001a\u00030\u0088\u0001J\u0019\u0010\u0089\u0001\u001a\u00020\u001a2\u0006\u0010g\u001a\u00020h2\u0006\u0010i\u001a\u000202H\u0002J\u001d\u0010\u008a\u0001\u001a\u00020\u001a2\u0012\u00108\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0MH\u0002J\u0014\u0010s\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010[\u001a\u00020\u0016J\u0014\u0010s\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010[\u001a\u00020KJ\u0015\u0010\u008b\u0001\u001a\u000e\u0012\u0004\u0012\u00020h\u0012\u0004\u0012\u00020201H\u0002J\u001a\u0010\u008c\u0001\u001a\u00020\u001a2\u0006\u0010i\u001a\u0002022\u0007\u0010\u008d\u0001\u001a\u000203H\u0002J\u0018\u0010\u008e\u0001\u001a\b\u0012\u0004\u0012\u00020K0J2\u0007\u0010\u008f\u0001\u001a\u00020KH\u0002J\u0015\u0010\u0090\u0001\u001a\b\u0012\u0004\u0012\u00020K0J2\u0006\u0010[\u001a\u00020KJ$\u0010\u0091\u0001\u001a\u00020\u001a2\u0013\u0010\u0092\u0001\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020K0J0MH\u0000\u00a2\u0006\u0003\b\u0093\u0001J\u0011\u0010\u0094\u0001\u001a\u00020\u001c2\u0006\u0010s\u001a\u00020\u0016H\u0002J\t\u0010\u0095\u0001\u001a\u00020\u001cH\u0002J\b\u0010\u0096\u0001\u001a\u00030\u0097\u0001J\b\u0010\u0098\u0001\u001a\u00030\u0099\u0001J\u0018\u0010\u009a\u0001\u001a\t\u0012\u0005\u0012\u00030\u0088\u00010J2\b\u0010\u009b\u0001\u001a\u00030\u0088\u0001J\u0010\u0010\u009c\u0001\u001a\u00020\u001a2\u0007\u0010\u009d\u0001\u001a\u00020{R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010!\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R$\u0010\"\u001a\u00020\u001c8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020*X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R \u0010/\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002030100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00106\u001a\b\u0012\u0004\u0012\u0002070\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002090\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u000e\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0011\u0010@\u001a\u00020A\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0014\u0010D\u001a\b\u0012\u0004\u0012\u00020E0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u00a2\u0001"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "", "interpreter", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "project", "Lcom/intellij/openapi/project/Project;", "configurator", "Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;", "options", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Options;", "interpreterRunSetup", "Lcom/intellij/javascript/nodejs/interpreter/NodeTargetRunSetup;", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Options;Lcom/intellij/javascript/nodejs/interpreter/NodeTargetRunSetup;)V", "debugConfigurator", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRunOptions;", "(Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;Lcom/intellij/openapi/project/Project;Lcom/intellij/javascript/debugger/CommandLineDebugConfigurator;Lcom/intellij/javascript/nodejs/execution/NodeTargetRunOptions;Lcom/intellij/javascript/nodejs/interpreter/NodeTargetRunSetup;)V", "commandLineBuilder", "Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "getCommandLineBuilder", "()Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "copiedUploadVolumes", "", "Ljava/nio/file/Path;", "dependingOnEnvironmentPromise", "", "Lorg/jetbrains/concurrency/Promise;", "", "enableWrappingWithYarnNode", "", "getEnableWrappingWithYarnNode", "()Ljava/lang/Boolean;", "setEnableWrappingWithYarnNode", "(Ljava/lang/Boolean;)V", "Ljava/lang/Boolean;", "enableWrappingWithYarnPnpNode", "getEnableWrappingWithYarnPnpNode$annotations", "()V", "getEnableWrappingWithYarnPnpNode", "()Z", "setEnableWrappingWithYarnPnpNode", "(Z)V", "envData", "Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "getEnvData", "()Lcom/intellij/execution/configuration/EnvironmentVariablesData;", "setEnvData", "(Lcom/intellij/execution/configuration/EnvironmentVariablesData;)V", "environmentPromise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lkotlin/Pair;", "Lcom/intellij/execution/target/TargetEnvironment;", "Lcom/intellij/execution/target/TargetProgressIndicator;", "getInterpreter", "()Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreter;", "myRequiredNodePackages", "Lcom/intellij/javascript/nodejs/library/yarn/pnp/YarnPnpNodePackage;", "nodeOptions", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$NodeOptionValue;", "getOptions", "()Lcom/intellij/javascript/nodejs/execution/NodeTargetRunOptions;", "progress", "Lcom/intellij/openapi/progress/ProgressIndicator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "getRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "uploads", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Upload;", "addNodeOptions", "passThroughEnvironmentVariableOnly", "nodeOptionsToAdd", "", "Lcom/intellij/execution/target/value/TargetValue;", "", "(Z[Lcom/intellij/execution/target/value/TargetValue;)V", "", "addNodeOptionsWithExpandedMacros", "blockingReaderOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "collectNodeModulesInPathForPnpm", "Lcom/intellij/openapi/vfs/VirtualFile;", "startFile", "configureEnvironment", "configureNodePathForPnpm", "configureUserEnvironment", "configureYarnPnpNode", "convertCopiedToLocal", "copiedPath", "convertLocalPathToCopied", "localPath", "convertLocalPathToTarget", "convertLocalPathToTargetPath", "convertTargetPathToLocal", "targetPath", "convertTargetPathToLocalPath", "copyIfNeeded", "originalDir", "createKillableColoredProcessHandler", "Lcom/intellij/execution/process/KillableColoredProcessHandler;", "process", "Ljava/lang/Process;", "commandLine", "Lcom/intellij/execution/target/TargetedCommandLine;", "environment", "createProcessHandlerByDefault", "Lcom/intellij/execution/process/KillableProcessHandler;", "createTerminalProcessHandler", "Lcom/pty4j/PtyProcess;", "createUploadRoot", "Lcom/intellij/execution/target/TargetEnvironment$UploadRoot;", "localRootPath", "findCopiedVolumeEntry", "", "path", "pathSelector", "Lkotlin/Function1;", "findProjectRoot", "getNodeOptions", "getNodeOptions$intellij_javascript_impl", "(Ljava/lang/Boolean;)Ljava/util/List;", "getRequiredYarnPkg", "Lcom/intellij/javascript/nodejs/util/NodePackage;", "isExePathDefined", "joinPath", "segments", "([Ljava/lang/String;)Ljava/lang/String;", "joinPaths", "basePath", "relativePath", "platform", "Lcom/intellij/execution/Platform;", "localPortBinding", "Lcom/intellij/execution/target/ResolvedPortBinding;", "localPort", "", "logCommandDetails", "passNodeOptionsThroughEnvironmentVariable", "prepareCommandLine", "provideEnvironment", "targetProgressIndicator", "requestUploadIntoTarget", "uploadPathString", "requestUploadProjectRootAndGetPath", "setNodeOptions", "nodeOptionsToSet", "setNodeOptions$intellij_javascript_impl", "shouldCopyToTmp", "shouldWrapWithYarnNodeCommand", "startProcess", "Lcom/intellij/execution/process/ProcessHandler;", "startProcessEx", "Lcom/intellij/javascript/nodejs/execution/ProcessWithCmdLine;", "targetPortBinding", "targetPort", "withRequiredNodePackage", "requiredNodePackage", "Companion", "NodeOptionValue", "Options", "Upload", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nNodeTargetRun.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeTargetRun.kt\ncom/intellij/javascript/nodejs/execution/NodeTargetRun\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,743:1\n1549#2:744\n1620#2,3:745\n1549#2:767\n1620#2,3:768\n1549#2:771\n1620#2,3:772\n1549#2:775\n1620#2,3:776\n215#3,2:748\n215#3,2:765\n603#4:750\n1003#4:751\n1037#4,3:752\n1040#4,3:762\n372#5,7:755\n13#6:779\n*S KotlinDebug\n*F\n+ 1 NodeTargetRun.kt\ncom/intellij/javascript/nodejs/execution/NodeTargetRun\n*L\n159#1:744\n159#1:745,3\n569#1:767\n569#1:768,3\n578#1:771\n578#1:772,3\n736#1:775\n736#1:776,3\n246#1:748,2\n390#1:765,2\n388#1:750\n389#1:751\n389#1:752,3\n389#1:762,3\n389#1:755,7\n625#1:779\n*E\n"})
public final class NodeTargetRun {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NodeJsInterpreter interpreter;
    @NotNull
    private final Project project;
    @Nullable
    private final CommandLineDebugConfigurator debugConfigurator;
    @NotNull
    private final NodeTargetRunOptions options;
    @NotNull
    private final NodeTargetRunSetup interpreterRunSetup;
    @NotNull
    private final TargetEnvironmentRequest request;
    @NotNull
    private final ProgressIndicator progress;
    @NotNull
    private final TargetedCommandLineBuilder commandLineBuilder;
    @NotNull
    private final AsyncPromise<Pair<TargetEnvironment, TargetProgressIndicator>> environmentPromise;
    @NotNull
    private final List<Promise<Unit>> dependingOnEnvironmentPromise;
    @NotNull
    private final List<Upload> uploads;
    @NotNull
    private final List<YarnPnpNodePackage> myRequiredNodePackages;
    @Nullable
    private Boolean enableWrappingWithYarnNode;
    @NotNull
    private final Map<Path, Path> copiedUploadVolumes;
    @NotNull
    private final List<NodeOptionValue> nodeOptions;
    @NotNull
    private EnvironmentVariablesData envData;
    private boolean enableWrappingWithYarnPnpNode;
    @NotNull
    private static final String NODE_OPTIONS = "NODE_OPTIONS";
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<NodeTargetRun> TARGET_RUN_KEY;

    @JvmOverloads
    public NodeTargetRun(@NotNull NodeJsInterpreter interpreter2, @NotNull Project project, @Nullable CommandLineDebugConfigurator debugConfigurator, @NotNull NodeTargetRunOptions options, @NotNull NodeTargetRunSetup interpreterRunSetup) throws com.intellij.execution.ExecutionException {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)interpreterRunSetup, (String)"interpreterRunSetup");
        this.interpreter = interpreter2;
        this.project = project;
        this.debugConfigurator = debugConfigurator;
        this.options = options;
        this.interpreterRunSetup = interpreterRunSetup;
        this.request = this.interpreterRunSetup.getRequest();
        ProgressIndicator progressIndicator = EmptyProgressIndicator.notNullize((ProgressIndicator)ProgressManager.getInstance().getProgressIndicator());
        Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"notNullize(...)");
        this.progress = progressIndicator;
        this.commandLineBuilder = new TargetedCommandLineBuilder(this.request);
        this.environmentPromise = new AsyncPromise();
        this.dependingOnEnvironmentPromise = new ArrayList();
        this.uploads = new ArrayList();
        this.myRequiredNodePackages = new ArrayList();
        this.copiedUploadVolumes = new LinkedHashMap();
        this.nodeOptions = new ArrayList();
        EnvironmentVariablesData environmentVariablesData = EnvironmentVariablesData.DEFAULT;
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"DEFAULT");
        this.envData = environmentVariablesData;
        this.enableWrappingWithYarnPnpNode = true;
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        this.commandLineBuilder.setCharset(charset);
    }

    public /* synthetic */ NodeTargetRun(NodeJsInterpreter nodeJsInterpreter, Project project, CommandLineDebugConfigurator commandLineDebugConfigurator, NodeTargetRunOptions nodeTargetRunOptions, NodeTargetRunSetup nodeTargetRunSetup, int n, DefaultConstructorMarker defaultConstructorMarker) throws com.intellij.execution.ExecutionException {
        if ((n & 0x10) != 0) {
            NodeTargetRunSetup nodeTargetRunSetup2 = nodeJsInterpreter.createTargetRunSetup(project, nodeTargetRunOptions);
            Intrinsics.checkNotNullExpressionValue((Object)nodeTargetRunSetup2, (String)"createTargetRunSetup(...)");
            nodeTargetRunSetup = nodeTargetRunSetup2;
        }
        this(nodeJsInterpreter, project, commandLineDebugConfigurator, nodeTargetRunOptions, nodeTargetRunSetup);
    }

    @NotNull
    public final NodeJsInterpreter getInterpreter() {
        return this.interpreter;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final NodeTargetRunOptions getOptions() {
        return this.options;
    }

    @NotNull
    public final TargetEnvironmentRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final TargetedCommandLineBuilder getCommandLineBuilder() {
        return this.commandLineBuilder;
    }

    @Nullable
    public final Boolean getEnableWrappingWithYarnNode() {
        return this.enableWrappingWithYarnNode;
    }

    public final void setEnableWrappingWithYarnNode(@Nullable Boolean bl) {
        this.enableWrappingWithYarnNode = bl;
    }

    @NotNull
    public final EnvironmentVariablesData getEnvData() {
        return this.envData;
    }

    public final void setEnvData(@NotNull EnvironmentVariablesData environmentVariablesData) {
        Intrinsics.checkNotNullParameter((Object)environmentVariablesData, (String)"<set-?>");
        this.envData = environmentVariablesData;
    }

    public final boolean getEnableWrappingWithYarnPnpNode() {
        return this.enableWrappingWithYarnPnpNode;
    }

    public final void setEnableWrappingWithYarnPnpNode(boolean bl) {
        this.enableWrappingWithYarnPnpNode = bl;
    }

    @Deprecated(message="Use enableWrappingWithYarnNode instead", replaceWith=@ReplaceWith(expression="enableWrappingWithYarnNode ?: true", imports={}))
    public static /* synthetic */ void getEnableWrappingWithYarnPnpNode$annotations() {
    }

    @NotNull
    public final ProcessHandler startProcess() throws com.intellij.execution.ExecutionException {
        return (ProcessHandler)this.startProcessEx().getProcessHandler();
    }

    private final Pair<TargetedCommandLine, TargetEnvironment> prepareCommandLine() throws com.intellij.execution.ExecutionException {
        this.configureUserEnvironment();
        boolean yarnPnpNode = this.configureYarnPnpNode();
        CommandLineDebugConfigurator commandLineDebugConfigurator = this.debugConfigurator;
        if (commandLineDebugConfigurator != null) {
            commandLineDebugConfigurator.configure(this);
        }
        this.configureNodePathForPnpm();
        this.interpreterRunSetup.prependNodeDirToPATH(this.commandLineBuilder, this.envData);
        if (yarnPnpNode || !this.isExePathDefined()) {
            List<TargetValue<String>> nodeOptionsAsCliParameters = this.getNodeOptions(false);
            int insertIndex = yarnPnpNode ? 1 : 0;
            this.commandLineBuilder.addParametersAt(insertIndex, nodeOptionsAsCliParameters);
            this.passNodeOptionsThroughEnvironmentVariable(this.getNodeOptions(true));
        } else {
            this.passNodeOptionsThroughEnvironmentVariable(this.getNodeOptions(null));
        }
        this.interpreterRunSetup.configureCommandLine(this);
        TargetProgressIndicator targetProgressIndicator = (TargetProgressIndicator)new TargetProgressIndicatorAdapter(this.progress);
        TargetEnvironment environment = null;
        try {
            environment = this.request.prepareEnvironment(targetProgressIndicator);
            this.provideEnvironment(environment, targetProgressIndicator);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{e.getLocalizedMessage()};
            throw new com.intellij.execution.ExecutionException(JavaScriptBundle.message("node.execution.failed.to.prepare.target.environment.error", objectArray), (Throwable)e);
        }
        return new Pair((Object)this.commandLineBuilder.build(), (Object)environment);
    }

    /*
     * WARNING - void declaration
     */
    private final void configureNodePathForPnpm() {
        NodePackageRef nodePackageRef = NpmManager.getInstance(this.project).getPackageRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageRef(...)");
        NodePackageRef projectNpmPackageRef = nodePackageRef;
        if (NpmUtil.isPnpmPackageRef(projectNpmPackageRef)) {
            VirtualFile canonicalFile;
            VirtualFile file;
            String string;
            try {
                TargetValue targetValue = (TargetValue)CollectionsKt.firstOrNull((List)this.commandLineBuilder.getParameters());
                string = PathUtil.toSystemIndependentName(targetValue != null && (targetValue = targetValue.getLocalValue()) != null ? (String)targetValue.blockingGet(0) : null);
            }
            catch (Exception exception) {
                string = null;
            }
            String mainScriptPath = string;
            if (mainScriptPath != null && StringsKt.contains$default((CharSequence)mainScriptPath, (CharSequence)"/node_modules/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)mainScriptPath, (CharSequence)"/node_modules/.pnpm/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)mainScriptPath, (CharSequence)"/node_modules/.bin/", (boolean)false, (int)2, null) && (file = LocalFileSystem.getInstance().findFileByPath(mainScriptPath)) != null && (canonicalFile = file.getCanonicalFile()) != null && !Intrinsics.areEqual((Object)canonicalFile, (Object)file)) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                List<VirtualFile> nodeModulesDirs = this.collectNodeModulesInPathForPnpm(canonicalFile);
                Iterable iterable = nodeModulesDirs;
                NodeTargetRun nodeTargetRun = this;
                boolean $i$f$map = false;
                void var8_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getPath());
                }
                NodePathManager.prependNodePaths(nodeTargetRun, (List)destination$iv$iv);
            }
        }
    }

    private final List<VirtualFile> collectNodeModulesInPathForPnpm(VirtualFile startFile) {
        VirtualFile dir;
        List nodeModulesDirs = new ArrayList();
        VirtualFile virtualFile = dir = startFile.isDirectory() ? startFile : startFile.getParent();
        while (dir != null) {
            if (NodeModuleUtil.findChildNodeModulesDir(dir) != null) {
                VirtualFile it;
                boolean bl = false;
                nodeModulesDirs.add(it);
            }
            if (Intrinsics.areEqual((Object)dir.getName(), (Object)".pnpm")) {
                return nodeModulesDirs;
            }
            dir = dir.getParent();
        }
        return CollectionsKt.emptyList();
    }

    @NotNull
    public final ProcessWithCmdLine startProcessEx() throws com.intellij.execution.ExecutionException {
        Pair<TargetedCommandLine, TargetEnvironment> pair = this.prepareCommandLine();
        TargetedCommandLine commandLine = (TargetedCommandLine)pair.component1();
        TargetEnvironment environment = (TargetEnvironment)pair.component2();
        this.logCommandDetails(commandLine, environment);
        Process process = environment.createProcess(commandLine, this.progress);
        KillableProcessHandler processHandler = this.interpreterRunSetup.createProcessHandler(this, process, commandLine, environment);
        processHandler.putUserData(TARGET_RUN_KEY, (Object)this);
        return new ProcessWithCmdLine(processHandler, commandLine, environment);
    }

    private final void logCommandDetails(TargetedCommandLine commandLine, TargetEnvironment environment) {
        if (LOG.isDebugEnabled()) {
            TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.request.getConfiguration();
            ContributedTypeBase targetType = (ContributedTypeBase)(targetEnvironmentConfiguration != null ? TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)targetEnvironmentConfiguration) : null);
            Map uploadVolumes = environment.getUploadVolumes();
            Object object = targetType;
            if (object == null || (object = object.getId()) == null) {
                object = "local";
            }
            LOG.debug("[" + (String)object + "] running " + commandLine.getCommandPresentation(environment) + "\n" + uploadVolumes.size() + " upload volumes: {" + CollectionsKt.joinToString$default((Iterable)uploadVolumes.values(), null, null, null, (int)0, null, (Function1)logCommandDetails.1.INSTANCE, (int)31, null) + "}");
        }
    }

    private final boolean configureYarnPnpNode() {
        boolean bl;
        boolean it = bl = this.shouldWrapWithYarnNodeCommand();
        boolean bl2 = false;
        if (it) {
            NodePackage yarnPkg = this.getRequiredYarnPkg();
            String[] stringArray = new String[]{"node"};
            NpmNodePackage.configureNpmPackage(this, yarnPkg, stringArray);
        }
        return bl;
    }

    private final NodePackage getRequiredYarnPkg() {
        NodePackage nodePackage;
        NpmManager npmManager = NpmManager.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)npmManager, (String)"getInstance(...)");
        NpmManager npmManager2 = npmManager;
        if (NpmUtil.isYarnAlikePackageRef(npmManager2.getPackageRef()) && (nodePackage = npmManager2.getPackage(this.interpreter)) != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            return it;
        }
        throw new NpmManager.YarnPackageNotConfiguredException(this.project);
    }

    private final boolean shouldWrapWithYarnNodeCommand() {
        boolean yarn;
        block3: {
            YarnPnpNodePackage yarnPnpNodePackage;
            if (!this.enableWrappingWithYarnPnpNode) {
                return false;
            }
            Boolean bl = this.enableWrappingWithYarnNode;
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                return it;
            }
            if (this.myRequiredNodePackages.isEmpty() && YarnPnpManager.getInstance(this.project).getPnpFiles().isEmpty()) {
                return false;
            }
            NodePackageRef nodePackageRef = NpmManager.getInstance(this.project).getPackageRef();
            Intrinsics.checkNotNullExpressionValue((Object)nodePackageRef, (String)"getPackageRef(...)");
            NodePackageRef projectNpmPackageRef = nodePackageRef;
            yarn = NpmUtil.isYarnAlikePackageRef(projectNpmPackageRef);
            YarnPnpNodePackage yarnPnpNodePackage2 = yarnPnpNodePackage = (YarnPnpNodePackage)CollectionsKt.firstOrNull(this.myRequiredNodePackages);
            if (yarnPnpNodePackage2 == null) break block3;
            yarnPnpNodePackage2.requireYarnPackageManager(this.project, yarn, false);
        }
        return yarn;
    }

    public final void withRequiredNodePackage(@NotNull NodePackage requiredNodePackage) {
        Intrinsics.checkNotNullParameter((Object)requiredNodePackage, (String)"requiredNodePackage");
        if (requiredNodePackage instanceof YarnPnpNodePackage) {
            this.myRequiredNodePackages.add((YarnPnpNodePackage)requiredNodePackage);
        }
    }

    private final void configureUserEnvironment() {
        this.interpreterRunSetup.configureEnvironment(this.commandLineBuilder, this.envData);
        if (this.options.getPtyOptions() == null) {
            Map $this$forEach$iv = NodeTargetRun.Companion.nonTtyColorEnvironmentVariables();
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                String key2 = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (this.commandLineBuilder.getEnvironmentVariable(key2) != null) continue;
                this.commandLineBuilder.addEnvironmentVariable(key2, value);
            }
        }
    }

    @NotNull
    public final TargetValue<String> path(@NotNull String localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return this.requestUploadIntoTarget(localPath);
    }

    @NotNull
    public final TargetValue<String> path(@NotNull Path localPath) {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        return this.requestUploadIntoTarget(((Object)localPath).toString());
    }

    @NotNull
    public final TargetValue<String> requestUploadProjectRootAndGetPath(@NotNull String localPath) {
        block2: {
            Unit unit;
            block3: {
                Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
                if (this.request instanceof LocalTargetEnvironmentRequest) break block2;
                unit = this.findProjectRoot(localPath);
                if (unit == null) break block3;
                Unit it = unit;
                boolean bl = false;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                Unit unit2 = this.path(string);
                unit = unit2;
                if (unit2 != null) break block2;
            }
            NodeTargetRun $this$requestUploadProjectRootAndGetPath_u24lambda_u247 = this;
            boolean bl = false;
            LOG.warn("Cannot find project root by " + localPath);
            unit = Unit.INSTANCE;
        }
        return this.path(localPath);
    }

    private final VirtualFile findProjectRoot(String path2) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(path2);
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            virtualFile = (VirtualFile)ActionsKt.runReadAction((Function0)((Function0)new Function0<VirtualFile>(this, it){
                final /* synthetic */ NodeTargetRun this$0;
                final /* synthetic */ VirtualFile $it;
                {
                    this.this$0 = $receiver;
                    this.$it = $it;
                    super(0);
                }

                @Nullable
                public final VirtualFile invoke() {
                    return ProjectFileIndex.getInstance((Project)this.this$0.getProject()).getContentRootForFile(this.$it, false);
                }
            }));
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    private final TargetValue<String> requestUploadIntoTarget(String uploadPathString) {
        Path path2;
        Path uploadPath = Paths.get(FileUtil.toSystemDependentName((String)uploadPathString), new String[0]);
        Intrinsics.checkNotNull((Object)uploadPath);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean isDir = Files.isDirectory(uploadPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
        if (isDir) {
            path2 = uploadPath;
        } else {
            path2 = uploadPath.getParent();
            if (path2 == null) {
                path2 = Paths.get(".", new String[0]);
            }
        }
        Path localRootPath = path2;
        PathMapper pathMapper = this.interpreterRunSetup.getPathMapper();
        if (pathMapper != null) {
            PathMapper it = pathMapper;
            boolean bl = false;
            if (it.canReplaceLocal(((Object)uploadPath).toString())) {
                TargetValue targetValue = TargetValue.fixed((Object)it.convertToRemote(((Object)uploadPath).toString()));
                Intrinsics.checkNotNullExpressionValue((Object)targetValue, (String)"fixed(...)");
                return targetValue;
            }
        }
        Intrinsics.checkNotNull((Object)localRootPath);
        Path pathToSearchUploadRoot = this.convertLocalPathToCopied(localRootPath);
        Pair pair = TargetEnvironmentFunctions.getUploadRootForLocalPath((TargetEnvironmentRequest)this.request, (Path)pathToSearchUploadRoot);
        if (pair == null) {
            TargetEnvironment.UploadRoot uploadRoot = this.createUploadRoot(localRootPath);
            boolean bl = false;
            ((Collection)this.request.getUploadVolumes()).add(uploadRoot);
            pair = TuplesKt.to((Object)uploadRoot, (Object)".");
        }
        Pair pair2 = pair;
        TargetEnvironment.UploadRoot uploadRoot = (TargetEnvironment.UploadRoot)pair2.component1();
        String pathToRoot = (String)pair2.component2();
        DeferredTargetValue result2 = new DeferredTargetValue((Object)uploadPathString);
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> NodeTargetRun.requestUploadIntoTarget$lambda$11((Function1)new Function1<Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator>, Unit>((DeferredTargetValue<String>)result2, uploadRoot, isDir, pathToRoot, uploadPath, this){
            final /* synthetic */ DeferredTargetValue<String> $result;
            final /* synthetic */ TargetEnvironment.UploadRoot $uploadRoot;
            final /* synthetic */ boolean $isDir;
            final /* synthetic */ String $pathToRoot;
            final /* synthetic */ Path $uploadPath;
            final /* synthetic */ NodeTargetRun this$0;
            {
                this.$result = $result;
                this.$uploadRoot = $uploadRoot;
                this.$isDir = $isDir;
                this.$pathToRoot = $pathToRoot;
                this.$uploadPath = $uploadPath;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator> pair) {
                TargetEnvironment environment = (TargetEnvironment)pair.component1();
                TargetProgressIndicator targetProgressIndicator = (TargetProgressIndicator)pair.component2();
                if (targetProgressIndicator.isCanceled() || targetProgressIndicator.isStopped()) {
                    this.$result.stopProceeding();
                    return;
                }
                TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)this.$uploadRoot);
                try {
                    String string;
                    if (this.$isDir) {
                        string = this.$pathToRoot;
                    } else {
                        String string2 = ((Object)this.$uploadPath.getFileName()).toString();
                        String string3 = this.$pathToRoot;
                        NodeTargetRun nodeTargetRun = this.this$0;
                        String it = string2;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)string3, (Object)".")) {
                            string = it;
                        } else {
                            String[] stringArray = new String[]{string3, it};
                            string = NodeTargetRun.access$joinPath(nodeTargetRun, stringArray);
                        }
                    }
                    String relativePath = string;
                    String resolvedTargetPath = volume.resolveTargetPath(relativePath);
                    NodeTargetRun.access$getUploads$p(this.this$0).add(new Upload(volume, relativePath));
                    this.$result.resolve((Object)resolvedTargetPath);
                }
                catch (Throwable t) {
                    NodeTargetRun.access$getLOG$cp().warn(t);
                    Object[] objectArray = new Object[]{volume.getLocalRoot(), t.getLocalizedMessage()};
                    targetProgressIndicator.stopWithErrorMessage(LangCoreBundle.message((String)"progress.message.failed.to.resolve.0.1", (Object[])objectArray));
                    this.$result.resolveFailure(t);
                }
            }
        }, arg_0)));
        return (TargetValue)result2;
    }

    private final String joinPath(String ... segments) {
        String string = ((StringBuilder)ArraysKt.joinTo$default((Object[])segments, (Appendable)new StringBuilder(), (CharSequence)String.valueOf(this.request.getTargetPlatform().getPlatform().fileSeparator), null, null, (int)0, null, null, (int)124, null)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final TargetEnvironment.UploadRoot createUploadRoot(Path localRootPath) {
        return new TargetEnvironment.UploadRoot(this.copyIfNeeded(localRootPath), (TargetEnvironment.TargetPath)new TargetEnvironment.TargetPath.Temporary(null, null, null, 7, null), false, 4, null);
    }

    private final Path copyIfNeeded(Path originalDir) {
        if (this.shouldCopyToTmp(originalDir)) {
            char[] cArray = new char[]{'/'};
            String name = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.trimStart((String)((Object)originalDir).toString(), (char[])cArray), (char)'/', (char)'-', (boolean)false, (int)4, null), (char)'\\', (char)'-', (boolean)false, (int)4, null), (char)' ', (char)'-', (boolean)false, (int)4, null);
            File file = FileUtil.createTempDirectory((String)name, null);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempDirectory(...)");
            File tmpDir = file;
            FileUtil.copyDirContent((File)originalDir.toFile(), (File)tmpDir);
            Map<Path, Path> map = this.copiedUploadVolumes;
            Path path2 = tmpDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
            Path path3 = path2;
            map.put(originalDir, path3);
            this.commandLineBuilder.addFileToDeleteOnTermination(tmpDir);
            Path path4 = tmpDir.toPath();
            Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"toPath(...)");
            return path4;
        }
        return originalDir;
    }

    private final boolean shouldCopyToTmp(Path path2) {
        if (!SystemInfo.isMac || !StringsKt.startsWith$default((String)((Object)path2).toString(), (String)"/Applications/", (boolean)false, (int)2, null) || Registry.is((String)"nodejs.docker.mac.Applications.is.shared", (boolean)false)) {
            return false;
        }
        TargetEnvironmentConfiguration targetEnvironmentConfiguration = this.request.getConfiguration();
        String targetTypeId = targetEnvironmentConfiguration != null && (targetEnvironmentConfiguration = TargetEnvironmentConfigurationKt.getTargetType((TargetEnvironmentConfiguration)targetEnvironmentConfiguration)) != null ? targetEnvironmentConfiguration.getId() : null;
        return Intrinsics.areEqual((Object)targetTypeId, (Object)"docker") || Intrinsics.areEqual((Object)targetTypeId, (Object)"docker-compose");
    }

    @NotNull
    public final Promise<ResolvedPortBinding> localPortBinding(int localPort) {
        TargetEnvironment.LocalPortBinding localPortBinding2 = new TargetEnvironment.LocalPortBinding(localPort, null);
        this.request.getLocalPortBindings().add(localPortBinding2);
        AsyncPromise result2 = new AsyncPromise();
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> NodeTargetRun.localPortBinding$lambda$12((Function1)new Function1<Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator>, Unit>(localPortBinding2, (AsyncPromise<ResolvedPortBinding>)result2){
            final /* synthetic */ TargetEnvironment.LocalPortBinding $localPortBinding;
            final /* synthetic */ AsyncPromise<ResolvedPortBinding> $result;
            {
                this.$localPortBinding = $localPortBinding;
                this.$result = $result;
                super(1);
            }

            public final void invoke(Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator> pair) {
                TargetEnvironment environment = (TargetEnvironment)pair.component1();
                TargetProgressIndicator targetProgressIndicator = (TargetProgressIndicator)pair.component2();
                if (targetProgressIndicator.isCanceled() || targetProgressIndicator.isStopped()) {
                    return;
                }
                ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)environment.getLocalPortBindings().get(this.$localPortBinding);
                if (resolvedPortBinding != null) {
                    this.$result.setResult((Object)resolvedPortBinding);
                } else {
                    this.$result.setError(new Throwable("Local port binding \"" + this.$localPortBinding + "\" cannot be found"));
                }
            }
        }, arg_0)));
        return (Promise)result2;
    }

    @NotNull
    public final TargetValue<Integer> targetPortBinding(int targetPort) {
        TargetEnvironment.TargetPortBinding binding = new TargetEnvironment.TargetPortBinding(null, targetPort);
        this.request.getTargetPortBindings().add(binding);
        DeferredLocalTargetValue result2 = new DeferredLocalTargetValue((Object)targetPort);
        Collection collection = this.dependingOnEnvironmentPromise;
        collection.add(this.environmentPromise.then(arg_0 -> NodeTargetRun.targetPortBinding$lambda$13((Function1)new Function1<Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator>, Unit>(binding, (DeferredLocalTargetValue<Integer>)result2){
            final /* synthetic */ TargetEnvironment.TargetPortBinding $binding;
            final /* synthetic */ DeferredLocalTargetValue<Integer> $result;
            {
                this.$binding = $binding;
                this.$result = $result;
                super(1);
            }

            public final void invoke(Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator> pair) {
                TargetEnvironment environment = (TargetEnvironment)pair.component1();
                TargetProgressIndicator targetProgressIndicator = (TargetProgressIndicator)pair.component2();
                if (targetProgressIndicator.isCanceled() || targetProgressIndicator.isStopped()) {
                    return;
                }
                ResolvedPortBinding resolvedPortBinding = (ResolvedPortBinding)environment.getTargetPortBindings().get(this.$binding);
                Integer localPort = resolvedPortBinding != null ? Integer.valueOf(ResolvedPortBindingKt.getLocalPort((ResolvedPortBinding)resolvedPortBinding)) : null;
                this.$result.resolve((Object)localPort);
            }
        }, arg_0)));
        return (TargetValue)result2;
    }

    /*
     * WARNING - void declaration
     */
    private final void provideEnvironment(TargetEnvironment environment, TargetProgressIndicator targetProgressIndicator) {
        void $this$forEach$iv;
        void $this$groupByTo$iv$iv;
        Map $this$groupBy$iv;
        Sequence $this$sortedBy$iv;
        Application application = ApplicationManager.getApplication();
        LOG.assertTrue(environment instanceof LocalTargetEnvironment || this.uploads.isEmpty() || !application.isDispatchThread() || application.isUnitTestMode(), (Object)"Preparation of environment shouldn't be performed on EDT.");
        this.environmentPromise.setResult((Object)TuplesKt.to((Object)environment, (Object)targetProgressIndicator));
        Sequence sequence = CollectionsKt.asSequence((Iterable)this.uploads);
        boolean bl = false;
        $this$sortedBy$iv = SequencesKt.sortedWith((Sequence)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Upload it = (Upload)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getRelativePath().length());
                it = (Upload)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getRelativePath().length()));
            }
        });
        boolean bl2 = false;
        Iterator iterator = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            void it;
            Object object;
            Upload it2 = (Upload)element$iv$iv;
            boolean $i$a$-groupBy-NodeTargetRun$provideEnvironment$432 = false;
            TargetEnvironment.UploadableVolume key$iv$iv = it2.getVolume();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl3 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            Upload $i$a$-groupBy-NodeTargetRun$provideEnvironment$432 = (Upload)element$iv$iv;
            List list2 = list$iv$iv;
            boolean bl4 = false;
            list2.add(it.getRelativePath());
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean bl5 = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl6 = false;
            TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)entry.getKey();
            List relativePaths = (List)entry.getValue();
            volume.upload((String)CollectionsKt.first((List)relativePaths), targetProgressIndicator);
        }
        for (Promise promise : this.dependingOnEnvironmentPromise) {
            promise.blockingGet(0);
        }
    }

    @NotNull
    public final KillableProcessHandler createProcessHandlerByDefault(@NotNull Process process, @NotNull TargetedCommandLine commandLine, @NotNull TargetEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        if (process instanceof PtyProcess) {
            return this.createTerminalProcessHandler((PtyProcess)process, commandLine, environment);
        }
        return (KillableProcessHandler)this.createKillableColoredProcessHandler(process, commandLine, environment);
    }

    private final KillableProcessHandler createTerminalProcessHandler(PtyProcess process, TargetedCommandLine commandLine, TargetEnvironment environment) {
        Object object = this.debugConfigurator;
        if (object == null || (object = object.createMessagesFilter()) == null) {
            object = UnaryOperator.identity();
        }
        UnaryOperator<String> messagesFilter = object;
        String string = commandLine.getCommandPresentation(environment);
        Charset charset = commandLine.getCharset();
        Set set = this.commandLineBuilder.getFilesToDeleteOnTermination();
        return new KillableProcessHandler(process, messagesFilter, this, string, charset, set){
            final /* synthetic */ UnaryOperator<String> $messagesFilter;
            final /* synthetic */ NodeTargetRun this$0;
            {
                this.$messagesFilter = $messagesFilter;
                this.this$0 = $receiver;
                super((Process)$process, $super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void notifyTextAvailable(@NotNull String text2, @NotNull Key<?> outputType) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                    Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
                    String string = (String)this.$messagesFilter.apply(text2);
                    if (string == null) break block0;
                    String it = string;
                    boolean bl = false;
                    super.notifyTextAvailable(it, outputType);
                }
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = this.this$0.getOptions().getProcessReaderOptions();
                if (options == null) {
                    options = NodeTargetRun.access$blockingReaderOptions(this.this$0);
                }
                return options;
            }
        };
    }

    private final KillableColoredProcessHandler createKillableColoredProcessHandler(Process process, TargetedCommandLine commandLine, TargetEnvironment environment) {
        Object object = this.debugConfigurator;
        if (object == null || (object = object.createMessagesFilter()) == null) {
            object = UnaryOperator.identity();
        }
        UnaryOperator<String> messagesFilter = object;
        String string = commandLine.getCommandPresentation(environment);
        Charset charset = commandLine.getCharset();
        Set set = this.commandLineBuilder.getFilesToDeleteOnTermination();
        return new KillableColoredProcessHandler(process, messagesFilter, this, string, charset, set){
            final /* synthetic */ UnaryOperator<String> $messagesFilter;
            final /* synthetic */ NodeTargetRun this$0;
            {
                this.$messagesFilter = $messagesFilter;
                this.this$0 = $receiver;
                super($process, $super_call_param$1, $super_call_param$2, $super_call_param$3);
            }

            public void coloredTextAvailable(@NotNull String text2, @NotNull Key<?> attributes) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                    Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
                    String string = (String)this.$messagesFilter.apply(text2);
                    if (string == null) break block0;
                    String it = string;
                    boolean bl = false;
                    super.coloredTextAvailable(it, attributes);
                }
            }

            @NotNull
            protected BaseOutputReader.Options readerOptions() {
                BaseOutputReader.Options options = this.this$0.getOptions().getProcessReaderOptions();
                if (options == null) {
                    BaseOutputReader.Options options2 = BaseOutputReader.Options.forTerminalPtyProcess();
                    options = options2;
                    Intrinsics.checkNotNullExpressionValue((Object)options2, (String)"forTerminalPtyProcess(...)");
                }
                return options;
            }
        };
    }

    private final BaseOutputReader.Options blockingReaderOptions() {
        return new BaseOutputReader.Options(){

            @NotNull
            public BaseDataReader.SleepingPolicy policy() {
                BaseDataReader.SleepingPolicy sleepingPolicy = BaseDataReader.SleepingPolicy.BLOCKING;
                Intrinsics.checkNotNullExpressionValue((Object)sleepingPolicy, (String)"BLOCKING");
                return sleepingPolicy;
            }

            public boolean splitToLines() {
                return false;
            }

            public boolean withSeparators() {
                return true;
            }
        };
    }

    @NotNull
    public final Promise<String> convertLocalPathToTarget(@NotNull String localPath) {
        Path path2;
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        if (this.interpreter instanceof NodeJsLocalInterpreter) {
            Promise promise = TargetValue.fixed((Object)localPath).getTargetValue();
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
            return promise;
        }
        Ref.ObjectRef nioLocalPath = new Ref.ObjectRef();
        nioLocalPath.element = Path.of(FileUtil.toSystemDependentName((String)localPath), new String[0]);
        if (!((Path)nioLocalPath.element).isAbsolute()) {
            Promise promise = TargetValue.fixed((Object)localPath).getTargetValue();
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
            return promise;
        }
        PathMapper pathMapper = this.interpreterRunSetup.getPathMapper();
        if (pathMapper != null) {
            PathMapper it = pathMapper;
            boolean bl = false;
            if (it.canReplaceLocal(nioLocalPath.element.toString())) {
                Promise promise = TargetValue.fixed((Object)it.convertToRemote(nioLocalPath.element.toString())).getTargetValue();
                Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
                return promise;
            }
        }
        Object object = nioLocalPath.element;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"element");
        Object object2 = nioLocalPath.element = this.convertLocalPathToCopied((Path)object);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"element");
        Path path3 = (Path)object2;
        Pair pair = new Pair[]{};
        boolean isDir = Files.isDirectory(path3, Arrays.copyOf(pair, ((LinkOption[])pair).length));
        if (isDir) {
            path2 = (Path)nioLocalPath.element;
        } else {
            path2 = ((Path)nioLocalPath.element).getParent();
            if (path2 == null) {
                path2 = Paths.get(".", new String[0]);
            }
        }
        Path localRootPath = path2;
        Intrinsics.checkNotNull((Object)localRootPath);
        Pair pair2 = TargetEnvironmentFunctions.getUploadRootForLocalPath((TargetEnvironmentRequest)this.request, (Path)localRootPath);
        if (pair2 == null) {
            throw new IllegalStateException("No upload root registered for " + localRootPath);
        }
        pair = pair2;
        TargetEnvironment.UploadRoot uploadRoot = (TargetEnvironment.UploadRoot)pair.component1();
        String pathToRoot = (String)pair.component2();
        DeferredTargetValue result2 = new DeferredTargetValue((Object)localPath);
        this.environmentPromise.then(arg_0 -> NodeTargetRun.convertLocalPathToTarget$lambda$19((Function1)new Function1<Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator>, Unit>(uploadRoot, isDir, pathToRoot, (Ref.ObjectRef<Path>)nioLocalPath, (DeferredTargetValue<String>)result2, this){
            final /* synthetic */ TargetEnvironment.UploadRoot $uploadRoot;
            final /* synthetic */ boolean $isDir;
            final /* synthetic */ String $pathToRoot;
            final /* synthetic */ Ref.ObjectRef<Path> $nioLocalPath;
            final /* synthetic */ DeferredTargetValue<String> $result;
            final /* synthetic */ NodeTargetRun this$0;
            {
                this.$uploadRoot = $uploadRoot;
                this.$isDir = $isDir;
                this.$pathToRoot = $pathToRoot;
                this.$nioLocalPath = $nioLocalPath;
                this.$result = $result;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator> pair) {
                TargetEnvironment environment = (TargetEnvironment)pair.component1();
                TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)this.$uploadRoot);
                try {
                    String string;
                    if (this.$isDir) {
                        string = this.$pathToRoot;
                    } else {
                        String string2 = ((Object)((Path)this.$nioLocalPath.element).getFileName()).toString();
                        String string3 = this.$pathToRoot;
                        NodeTargetRun nodeTargetRun = this.this$0;
                        String it = string2;
                        boolean bl = false;
                        if (Intrinsics.areEqual((Object)string3, (Object)".")) {
                            string = it;
                        } else {
                            String[] stringArray = new String[]{string3, it};
                            string = NodeTargetRun.access$joinPath(nodeTargetRun, stringArray);
                        }
                    }
                    String relativePath = string;
                    this.$result.resolve((Object)volume.resolveTargetPath(relativePath));
                }
                catch (Throwable t) {
                    NodeTargetRun.access$getLOG$cp().warn(t);
                    this.$result.resolveFailure(t);
                }
            }
        }, arg_0));
        Promise promise = result2.getTargetValue();
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
        return promise;
    }

    private final Path convertLocalPathToCopied(Path localPath) {
        Map.Entry<Path, Path> entry = this.findCopiedVolumeEntry(localPath, (Function1<? super Map.Entry<? extends Path, ? extends Path>, ? extends Path>)((Function1)convertLocalPathToCopied.closestCopiedVolume.1.INSTANCE));
        if (entry == null) {
            return localPath;
        }
        Map.Entry<Path, Path> closestCopiedVolume2 = entry;
        Path path2 = closestCopiedVolume2.getValue().resolve(PathsKt.relativeTo((Path)localPath, (Path)closestCopiedVolume2.getKey()));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        return path2;
    }

    private final String convertCopiedToLocal(String copiedPath) {
        Path path2 = Path.of(copiedPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Map.Entry<Path, Path> entry = this.findCopiedVolumeEntry(path2, (Function1<? super Map.Entry<? extends Path, ? extends Path>, ? extends Path>)((Function1)convertCopiedToLocal.closestCopiedVolume.1.INSTANCE));
        if (entry == null) {
            return copiedPath;
        }
        Map.Entry<Path, Path> closestCopiedVolume2 = entry;
        Path path3 = Path.of(copiedPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"of(...)");
        return ((Object)closestCopiedVolume2.getKey().resolve(PathsKt.relativeTo((Path)path3, (Path)closestCopiedVolume2.getValue()))).toString();
    }

    private final Map.Entry<Path, Path> findCopiedVolumeEntry(Path path2, Function1<? super Map.Entry<? extends Path, ? extends Path>, ? extends Path> pathSelector) {
        Map.Entry<Path, Path> closestCopiedUploadVolume = null;
        for (Map.Entry<Path, Path> copiedUploadVolume : this.copiedUploadVolumes.entrySet()) {
            Path pathToCompare = (Path)pathSelector.invoke(copiedUploadVolume);
            if (!path2.startsWith(pathToCompare) || closestCopiedUploadVolume != null && pathSelector.invoke(closestCopiedUploadVolume).toString().length() >= ((Object)pathToCompare).toString().length()) continue;
            closestCopiedUploadVolume = copiedUploadVolume;
        }
        return closestCopiedUploadVolume;
    }

    @NotNull
    public final Promise<String> convertTargetPathToLocal(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        if (this.interpreter instanceof NodeJsLocalInterpreter) {
            Promise promise = TargetValue.fixed((Object)targetPath).getTargetValue();
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
            return promise;
        }
        if (this.request.getTargetPlatform().getPlatform() == Platform.UNIX && !StringsKt.startsWith$default((String)targetPath, (String)"/", (boolean)false, (int)2, null)) {
            Promise promise = TargetValue.fixed((Object)targetPath).getTargetValue();
            Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
            return promise;
        }
        PathMapper pathMapper = this.interpreterRunSetup.getPathMapper();
        if (pathMapper != null) {
            PathMapper it = pathMapper;
            boolean bl = false;
            if (it.canReplaceRemote(targetPath)) {
                Promise promise = TargetValue.fixed((Object)it.convertToLocal(targetPath)).getTargetValue();
                Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"getTargetValue(...)");
                return promise;
            }
        }
        AsyncPromise result2 = new AsyncPromise();
        this.environmentPromise.then(arg_0 -> NodeTargetRun.convertTargetPathToLocal$lambda$21((Function1)new Function1<Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator>, Unit>(this, targetPath, (AsyncPromise<String>)result2){
            final /* synthetic */ NodeTargetRun this$0;
            final /* synthetic */ String $targetPath;
            final /* synthetic */ AsyncPromise<String> $result;
            {
                this.this$0 = $receiver;
                this.$targetPath = $targetPath;
                this.$result = $result;
                super(1);
            }

            public final void invoke(Pair<? extends TargetEnvironment, ? extends TargetProgressIndicator> pair) {
                TargetEnvironment environment = (TargetEnvironment)pair.component1();
                for (TargetEnvironment.UploadRoot uploadVolume : this.this$0.getRequest().getUploadVolumes()) {
                    TargetEnvironment.UploadableVolume volume = (TargetEnvironment.UploadableVolume)MapsKt.getValue((Map)environment.getUploadVolumes(), (Object)uploadVolume);
                    if (!StringsKt.startsWith$default((String)this.$targetPath, (String)volume.getTargetRoot(), (boolean)false, (int)2, null)) continue;
                    String string = this.$targetPath.substring(volume.getTargetRoot().length());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    String string2 = FileUtil.toSystemDependentName((String)string);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toSystemDependentName(...)");
                    char[] cArray = new char[]{File.separatorChar};
                    String relativePath = StringsKt.trimStart((String)string2, (char[])cArray);
                    String string3 = ((Object)uploadVolume.getLocalRootPath()).toString();
                    Platform platform = TargetPlatform.CURRENT.getPlatform();
                    Intrinsics.checkNotNullExpressionValue((Object)platform, (String)"getPlatform(...)");
                    String localPath = NodeTargetRun.access$joinPaths(this.this$0, string3, relativePath, platform);
                    this.$result.setResult((Object)NodeTargetRun.access$convertCopiedToLocal(this.this$0, localPath));
                    return;
                }
                this.$result.setError(new Throwable("Cannot find upload root for target path: " + this.$targetPath));
            }
        }, arg_0));
        return (Promise)result2;
    }

    @NotNull
    public final String convertTargetPathToLocalPath(@NotNull String targetPath) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        try {
            Object object = this.convertTargetPathToLocal(targetPath).blockingGet(0);
            Intrinsics.checkNotNull((Object)object);
            return (String)object;
        }
        catch (TimeoutException e) {
            throw new IllegalArgumentException("(Unexpected timeout) Cannot covert target path '" + targetPath + "' to local", e);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Cannot covert target path '" + targetPath + "' to local", e);
        }
    }

    @NotNull
    public final String convertLocalPathToTargetPath(@NotNull String localPath) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)localPath, (String)"localPath");
        try {
            Object object = this.convertLocalPathToTarget(localPath).blockingGet(0);
            Intrinsics.checkNotNull((Object)object);
            return (String)object;
        }
        catch (TimeoutException e) {
            throw new IllegalArgumentException("(Unexpected timeout) Cannot covert local path '" + localPath + "' to target", e);
        }
        catch (ExecutionException e) {
            throw new IllegalArgumentException("Cannot covert local path '" + localPath + "' to target", e);
        }
    }

    private final String joinPaths(String basePath, String relativePath, Platform platform) {
        char fileSeparator = platform.fileSeparator;
        String string = FileUtil.toSystemDependentName((String)(StringsKt.removeSuffix((String)basePath, (CharSequence)String.valueOf(fileSeparator)) + fileSeparator + relativePath), (char)fileSeparator);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toSystemDependentName(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void addNodeOptionsWithExpandedMacros(boolean passThroughEnvironmentVariableOnly, @NotNull String nodeOptions) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)nodeOptions, (String)"nodeOptions");
        List list2 = ProgramParametersConfigurator.expandMacrosAndParseParameters((String)((Object)StringsKt.trim((CharSequence)nodeOptions)).toString());
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expandMacrosAndParseParameters(...)");
        Iterable $this$map$iv = list2;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TargetValue.fixed((Object)it));
        }
        List expanded = (List)destination$iv$iv;
        this.addNodeOptions(passThroughEnvironmentVariableOnly, expanded);
    }

    public final void addNodeOptions(boolean passThroughEnvironmentVariableOnly, TargetValue<String> ... nodeOptionsToAdd) {
        Intrinsics.checkNotNullParameter(nodeOptionsToAdd, (String)"nodeOptionsToAdd");
        this.addNodeOptions(passThroughEnvironmentVariableOnly, ArraysKt.toList((Object[])nodeOptionsToAdd));
    }

    /*
     * WARNING - void declaration
     */
    private final void addNodeOptions(boolean passThroughEnvironmentVariableOnly, List<? extends TargetValue<String>> nodeOptionsToAdd) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = nodeOptionsToAdd;
        List<NodeOptionValue> list2 = this.nodeOptions;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TargetValue targetValue = (TargetValue)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new NodeOptionValue((TargetValue<String>)it, passThroughEnvironmentVariableOnly));
        }
        list2.addAll((List)destination$iv$iv);
    }

    private final List<TargetValue<String>> getNodeOptions(Boolean passThroughEnvironmentVariableOnly) {
        return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.nodeOptions), (Function1)((Function1)new Function1<NodeOptionValue, Boolean>(passThroughEnvironmentVariableOnly){
            final /* synthetic */ Boolean $passThroughEnvironmentVariableOnly;
            {
                this.$passThroughEnvironmentVariableOnly = $passThroughEnvironmentVariableOnly;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull NodeOptionValue it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$passThroughEnvironmentVariableOnly == null || Intrinsics.areEqual((Object)it.getPassThroughEnvironmentVariableOnly(), (Object)this.$passThroughEnvironmentVariableOnly);
            }
        })), (Function1)getNodeOptions.2.INSTANCE));
    }

    @NotNull
    public final List<TargetValue<String>> getNodeOptions$intellij_javascript_impl() {
        return this.getNodeOptions(false);
    }

    public final void setNodeOptions$intellij_javascript_impl(@NotNull List<? extends TargetValue<String>> nodeOptionsToSet) {
        Intrinsics.checkNotNullParameter(nodeOptionsToSet, (String)"nodeOptionsToSet");
        this.nodeOptions.removeIf(arg_0 -> NodeTargetRun.setNodeOptions$lambda$24(setNodeOptions.1.INSTANCE, arg_0));
        this.addNodeOptions(false, nodeOptionsToSet);
    }

    private final void passNodeOptionsThroughEnvironmentVariable(List<? extends TargetValue<String>> nodeOptions) {
        if (!((Collection)nodeOptions).isEmpty()) {
            TargetValue targetValue = this.commandLineBuilder.getEnvironmentVariable(NODE_OPTIONS);
            if (targetValue == null) {
                targetValue = TargetValue.empty();
            }
            TargetValue prevNodeOptionsEnvValue = targetValue;
            this.commandLineBuilder.addEnvironmentVariable(NODE_OPTIONS, TargetValue.composite((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)prevNodeOptionsEnvValue), (Iterable)nodeOptions), arg_0 -> NodeTargetRun.passNodeOptionsThroughEnvironmentVariable$lambda$25(passNodeOptionsThroughEnvironmentVariable.1.INSTANCE, arg_0)));
        }
    }

    public final boolean isExePathDefined() {
        Promise promise = this.commandLineBuilder.getExePath().getLocalValue();
        if (promise.getState() == Promise.State.SUCCEEDED) {
            try {
                return promise.blockingGet(0) != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public NodeTargetRun(@NotNull NodeJsInterpreter interpreter2, @NotNull Project project, @Nullable CommandLineDebugConfigurator configurator, @NotNull Options options, @NotNull NodeTargetRunSetup interpreterRunSetup) throws com.intellij.execution.ExecutionException {
        Collection<TargetValue> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter((Object)interpreterRunSetup, (String)"interpreterRunSetup");
        this(interpreter2, project, configurator, NodeTargetRunOptions.Companion.toNewOptions$intellij_javascript_impl(options), interpreterRunSetup);
        Iterable iterable = options.getNodeOptions();
        boolean bl = false;
        NodeTargetRun nodeTargetRun = this;
        boolean $i$f$map = false;
        void var8_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(TargetValue.fixed((Object)it));
        }
        collection = (List)destination$iv$iv;
        nodeTargetRun.addNodeOptions(bl, (List<? extends TargetValue<String>>)collection);
    }

    public /* synthetic */ NodeTargetRun(NodeJsInterpreter nodeJsInterpreter, Project project, CommandLineDebugConfigurator commandLineDebugConfigurator, Options options, NodeTargetRunSetup nodeTargetRunSetup, int n, DefaultConstructorMarker defaultConstructorMarker) throws com.intellij.execution.ExecutionException {
        if ((n & 0x10) != 0) {
            NodeTargetRunSetup nodeTargetRunSetup2 = nodeJsInterpreter.createTargetRunSetup(project, NodeTargetRunOptions.Companion.toNewOptions$intellij_javascript_impl(options));
            Intrinsics.checkNotNullExpressionValue((Object)nodeTargetRunSetup2, (String)"createTargetRunSetup(...)");
            nodeTargetRunSetup = nodeTargetRunSetup2;
        }
        this(nodeJsInterpreter, project, commandLineDebugConfigurator, options, nodeTargetRunSetup);
    }

    @Deprecated(message="Set NodeTargetRun.envData directly", replaceWith=@ReplaceWith(expression="targetRun.envData = myEnvData", imports={}))
    public final void configureEnvironment(@NotNull EnvironmentVariablesData envData) {
        Intrinsics.checkNotNullParameter((Object)envData, (String)"envData");
        this.envData = envData;
    }

    @JvmOverloads
    public NodeTargetRun(@NotNull NodeJsInterpreter interpreter2, @NotNull Project project, @Nullable CommandLineDebugConfigurator debugConfigurator, @NotNull NodeTargetRunOptions options) throws com.intellij.execution.ExecutionException {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this(interpreter2, project, debugConfigurator, options, null, 16, null);
    }

    @JvmOverloads
    public NodeTargetRun(@NotNull NodeJsInterpreter interpreter2, @NotNull Project project, @Nullable CommandLineDebugConfigurator configurator, @NotNull Options options) throws com.intellij.execution.ExecutionException {
        Intrinsics.checkNotNullParameter((Object)interpreter2, (String)"interpreter");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this(interpreter2, project, configurator, options, null, 16, null);
    }

    private static final Unit requestUploadIntoTarget$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit localPortBinding$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit targetPortBinding$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit convertLocalPathToTarget$lambda$19(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final Unit convertTargetPathToLocal$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Unit)$tmp0.invoke(p0);
    }

    private static final boolean setNodeOptions$lambda$24(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final String passNodeOptionsThroughEnvironmentVariable$lambda$25(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (String)$tmp0.invoke(p0);
    }

    @JvmStatic
    public static final boolean shouldEnableRemoteDevelopmentUsingTargetsApi() {
        return Companion.shouldEnableRemoteDevelopmentUsingTargetsApi();
    }

    @JvmStatic
    @NotNull
    public static final NodeTargetRun getTargetRun(@NotNull ProcessHandler processHandler) {
        return Companion.getTargetRun(processHandler);
    }

    @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(shouldUsePtyForTestRunners(), runConfiguration) {  /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={"com.intellij.javascript.nodejs.execution.NodeTargetRunOptions.Companion.shouldUsePtyForTestRunners"}))
    @JvmStatic
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final Options createOptionsForTestConsole(@NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately, @NotNull RunConfigurationBase<?> runConfiguration) {
        return Companion.createOptionsForTestConsole(nodeOptions, configureNodeOptionsCliImmediately, runConfiguration);
    }

    @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(if (usePtyWithTerminalConsole == ThreeState.UNSURE) null else usePtyWithTerminalConsole.toBoolean()) { it.processReaderOptions = processReaderOptions\n it.runConfiguration = runConfiguration\n /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={}))
    @JvmStatic
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final Options createOptions(@NotNull ThreeState usePtyWithTerminalConsole, @NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately, @Nullable BaseOutputReader.Options processReaderOptions, @Nullable RunConfigurationBase<?> runConfiguration) {
        return Companion.createOptions(usePtyWithTerminalConsole, nodeOptions, configureNodeOptionsCliImmediately, processReaderOptions, runConfiguration);
    }

    @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(if (usePtyWithTerminalConsole == ThreeState.UNSURE) null else usePtyWithTerminalConsole.toBoolean()) { it.processReaderOptions = processReaderOptions\n it.runConfiguration = runConfiguration\n /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={}))
    @JvmStatic
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final Options createOptions(@NotNull ThreeState usePtyWithTerminalConsole, @NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately, @Nullable BaseOutputReader.Options processReaderOptions) {
        return Companion.createOptions(usePtyWithTerminalConsole, nodeOptions, configureNodeOptionsCliImmediately, processReaderOptions);
    }

    @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(if (usePtyWithTerminalConsole == ThreeState.UNSURE) null else usePtyWithTerminalConsole.toBoolean()) { it.processReaderOptions = processReaderOptions\n it.runConfiguration = runConfiguration\n /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={}))
    @JvmStatic
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final Options createOptions(@NotNull ThreeState usePtyWithTerminalConsole, @NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately) {
        return Companion.createOptions(usePtyWithTerminalConsole, nodeOptions, configureNodeOptionsCliImmediately);
    }

    @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(if (usePtyWithTerminalConsole == ThreeState.UNSURE) null else usePtyWithTerminalConsole.toBoolean()) { it.processReaderOptions = processReaderOptions\n it.runConfiguration = runConfiguration\n /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={}))
    @JvmStatic
    @JvmOverloads
    @ApiStatus.ScheduledForRemoval
    @NotNull
    public static final Options createOptions(@NotNull ThreeState usePtyWithTerminalConsole, @NotNull List<String> nodeOptions) {
        return Companion.createOptions(usePtyWithTerminalConsole, nodeOptions);
    }

    public static final /* synthetic */ List access$getUploads$p(NodeTargetRun $this) {
        return $this.uploads;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ String access$joinPath(NodeTargetRun $this, String ... segments) {
        return $this.joinPath(segments);
    }

    public static final /* synthetic */ BaseOutputReader.Options access$blockingReaderOptions(NodeTargetRun $this) {
        return $this.blockingReaderOptions();
    }

    public static final /* synthetic */ String access$joinPaths(NodeTargetRun $this, String basePath, String relativePath, Platform platform) {
        return $this.joinPaths(basePath, relativePath, platform);
    }

    public static final /* synthetic */ String access$convertCopiedToLocal(NodeTargetRun $this, String copiedPath) {
        return $this.convertCopiedToLocal(copiedPath);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodeTargetRun.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key2 = Key.create((String)NodeTargetRun.class.getSimpleName());
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        TARGET_RUN_KEY = key2;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JD\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0015H\u0007J*\u0010\u0016\u001a\u00020\u000b2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0007J\u001e\u0010\u0017\u001a\u00020\u00062\b\u0010\u0018\u001a\u0004\u0018\u00010\u00062\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00060\u000fJ'\u0010\u0019\u001a\u0002H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ3\u0010\u0019\u001a\u0004\u0018\u0001H\u001a\"\b\b\u0000\u0010\u001a*\u00020\u00012\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001c2\b\u0010\u001f\u001a\u0004\u0018\u0001H\u001aH\u0000\u00a2\u0006\u0004\b\u001d\u0010 J\u0010\u0010!\u001a\u00020\t2\u0006\u0010\"\u001a\u00020#H\u0007J\u0014\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060%H\u0002J\b\u0010&\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "NODE_OPTIONS", "", "TARGET_RUN_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "createOptions", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Options;", "usePtyWithTerminalConsole", "Lcom/intellij/util/ThreeState;", "nodeOptions", "", "configureNodeOptionsCliImmediately", "", "processReaderOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "createOptionsForTestConsole", "formatNodeOptions", "prevNodeOptionsEnvValue", "getConstantTargetValue", "T", "value", "Lcom/intellij/execution/target/value/TargetValue;", "getConstantTargetValue$intellij_javascript_impl", "(Lcom/intellij/execution/target/value/TargetValue;)Ljava/lang/Object;", "defaultValue", "(Lcom/intellij/execution/target/value/TargetValue;Ljava/lang/Object;)Ljava/lang/Object;", "getTargetRun", "processHandler", "Lcom/intellij/execution/process/ProcessHandler;", "nonTtyColorEnvironmentVariables", "", "shouldEnableRemoteDevelopmentUsingTargetsApi", "intellij.javascript.impl"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final boolean shouldEnableRemoteDevelopmentUsingTargetsApi() {
            return Registry.is((String)"nodejs.remote.development.using.targets.api");
        }

        private final Map<String, String> nonTtyColorEnvironmentVariables() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"DEBUG_COLORS", (Object)"true"), TuplesKt.to((Object)"COLORTERM", (Object)"true"), TuplesKt.to((Object)"FORCE_COLOR", (Object)"true"), TuplesKt.to((Object)"npm_config_color", (Object)"always"), TuplesKt.to((Object)"MOCHA_COLORS", (Object)"1")};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @JvmStatic
        @NotNull
        public final NodeTargetRun getTargetRun(@NotNull ProcessHandler processHandler) {
            Intrinsics.checkNotNullParameter((Object)processHandler, (String)"processHandler");
            Object object = processHandler.getUserData(TARGET_RUN_KEY);
            Intrinsics.checkNotNull((Object)object);
            return (NodeTargetRun)object;
        }

        @NotNull
        public final String formatNodeOptions(@Nullable String prevNodeOptionsEnvValue, @NotNull List<String> nodeOptions) {
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            if (!(!nodeOptions.isEmpty())) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            String nodeOptionsStr2 = CollectionsKt.joinToString$default((Iterable)nodeOptions, (CharSequence)" ", null, null, (int)0, null, (Function1)formatNodeOptions.nodeOptionsStr.1.INSTANCE, (int)30, null);
            CharSequence charSequence = prevNodeOptionsEnvValue;
            return charSequence == null || charSequence.length() == 0 ? nodeOptionsStr2 : prevNodeOptionsEnvValue + " " + nodeOptionsStr2;
        }

        @NotNull
        public final <T> T getConstantTargetValue$intellij_javascript_impl(@NotNull TargetValue<T> value) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            Promise promise = value.getTargetValue();
            if (promise.getState() == Promise.State.SUCCEEDED) {
                try {
                    Object object = promise.blockingGet(0);
                    Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of com.intellij.javascript.nodejs.execution.NodeTargetRun.Companion.getConstantTargetValue");
                    return (T)object;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            throw new IllegalStateException("Unexpected promise state is " + promise.getState());
        }

        @Nullable
        public final <T> T getConstantTargetValue$intellij_javascript_impl(@NotNull TargetValue<T> value, @Nullable T defaultValue) {
            T t;
            Intrinsics.checkNotNullParameter(value, (String)"value");
            try {
                t = this.getConstantTargetValue$intellij_javascript_impl(value);
            }
            catch (Exception e) {
                t = defaultValue;
            }
            return t;
        }

        @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(shouldUsePtyForTestRunners(), runConfiguration) {  /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={"com.intellij.javascript.nodejs.execution.NodeTargetRunOptions.Companion.shouldUsePtyForTestRunners"}))
        @JvmStatic
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final Options createOptionsForTestConsole(@NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately, @NotNull RunConfigurationBase<?> runConfiguration) {
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            Intrinsics.checkNotNullParameter(runConfiguration, (String)"runConfiguration");
            return NodeTargetRunOptions.Companion.toOldOptions$intellij_javascript_impl(NodeTargetRunOptionsKt.targetRunOptions$default(NodeTargetRunOptions.Companion.shouldUsePtyForTestRunners(), runConfiguration, null, 4, null), nodeOptions);
        }

        @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(if (usePtyWithTerminalConsole == ThreeState.UNSURE) null else usePtyWithTerminalConsole.toBoolean()) { it.processReaderOptions = processReaderOptions\n it.runConfiguration = runConfiguration\n /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={}))
        @JvmStatic
        @JvmOverloads
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final Options createOptions(@NotNull ThreeState usePtyWithTerminalConsole, @NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately, @Nullable BaseOutputReader.Options processReaderOptions, @Nullable RunConfigurationBase<?> runConfiguration) {
            Intrinsics.checkNotNullParameter((Object)usePtyWithTerminalConsole, (String)"usePtyWithTerminalConsole");
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            return NodeTargetRunOptions.Companion.toOldOptions$intellij_javascript_impl(NodeTargetRunOptionsKt.targetRunOptions$default(usePtyWithTerminalConsole == ThreeState.UNSURE ? null : Boolean.valueOf(usePtyWithTerminalConsole.toBoolean()), null, (Function1)new Function1<NodeTargetRunOptions.Builder, Unit>(processReaderOptions, runConfiguration){
                final /* synthetic */ BaseOutputReader.Options $processReaderOptions;
                final /* synthetic */ RunConfigurationBase<?> $runConfiguration;
                {
                    this.$processReaderOptions = $processReaderOptions;
                    this.$runConfiguration = $runConfiguration;
                    super(1);
                }

                public final void invoke(@NotNull NodeTargetRunOptions.Builder it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    it.setProcessReaderOptions(this.$processReaderOptions);
                    it.setRunConfiguration(this.$runConfiguration);
                }
            }, 2, null), nodeOptions);
        }

        public static /* synthetic */ Options createOptions$default(Companion companion, ThreeState threeState, List list2, boolean bl, BaseOutputReader.Options options, RunConfigurationBase runConfigurationBase, int n, Object object) {
            if ((n & 4) != 0) {
                bl = true;
            }
            if ((n & 8) != 0) {
                options = null;
            }
            if ((n & 0x10) != 0) {
                runConfigurationBase = null;
            }
            return companion.createOptions(threeState, list2, bl, options, runConfigurationBase);
        }

        @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(if (usePtyWithTerminalConsole == ThreeState.UNSURE) null else usePtyWithTerminalConsole.toBoolean()) { it.processReaderOptions = processReaderOptions\n it.runConfiguration = runConfiguration\n /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={}))
        @JvmStatic
        @JvmOverloads
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final Options createOptions(@NotNull ThreeState usePtyWithTerminalConsole, @NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately, @Nullable BaseOutputReader.Options processReaderOptions) {
            Intrinsics.checkNotNullParameter((Object)usePtyWithTerminalConsole, (String)"usePtyWithTerminalConsole");
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            return com.intellij.javascript.nodejs.execution.NodeTargetRun$Companion.createOptions$default(this, usePtyWithTerminalConsole, nodeOptions, configureNodeOptionsCliImmediately, processReaderOptions, null, 16, null);
        }

        @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(if (usePtyWithTerminalConsole == ThreeState.UNSURE) null else usePtyWithTerminalConsole.toBoolean()) { it.processReaderOptions = processReaderOptions\n it.runConfiguration = runConfiguration\n /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={}))
        @JvmStatic
        @JvmOverloads
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final Options createOptions(@NotNull ThreeState usePtyWithTerminalConsole, @NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately) {
            Intrinsics.checkNotNullParameter((Object)usePtyWithTerminalConsole, (String)"usePtyWithTerminalConsole");
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            return com.intellij.javascript.nodejs.execution.NodeTargetRun$Companion.createOptions$default(this, usePtyWithTerminalConsole, nodeOptions, configureNodeOptionsCliImmediately, null, null, 24, null);
        }

        @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="targetRunOptions(if (usePtyWithTerminalConsole == ThreeState.UNSURE) null else usePtyWithTerminalConsole.toBoolean()) { it.processReaderOptions = processReaderOptions\n it.runConfiguration = runConfiguration\n /* TODO targetRun.addNodeOptions(nodeOptions) */}", imports={}))
        @JvmStatic
        @JvmOverloads
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final Options createOptions(@NotNull ThreeState usePtyWithTerminalConsole, @NotNull List<String> nodeOptions) {
            Intrinsics.checkNotNullParameter((Object)usePtyWithTerminalConsole, (String)"usePtyWithTerminalConsole");
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            return com.intellij.javascript.nodejs.execution.NodeTargetRun$Companion.createOptions$default(this, usePtyWithTerminalConsole, nodeOptions, false, null, null, 28, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0004H\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$NodeOptionValue;", "", "value", "Lcom/intellij/execution/target/value/TargetValue;", "", "passThroughEnvironmentVariableOnly", "", "(Lcom/intellij/execution/target/value/TargetValue;Z)V", "getPassThroughEnvironmentVariableOnly", "()Z", "getValue", "()Lcom/intellij/execution/target/value/TargetValue;", "toString", "intellij.javascript.impl"})
    private static final class NodeOptionValue {
        @NotNull
        private final TargetValue<String> value;
        private final boolean passThroughEnvironmentVariableOnly;

        public NodeOptionValue(@NotNull TargetValue<String> value, boolean passThroughEnvironmentVariableOnly) {
            Intrinsics.checkNotNullParameter(value, (String)"value");
            this.value = value;
            this.passThroughEnvironmentVariableOnly = passThroughEnvironmentVariableOnly;
        }

        @NotNull
        public final TargetValue<String> getValue() {
            return this.value;
        }

        public final boolean getPassThroughEnvironmentVariableOnly() {
            return this.passThroughEnvironmentVariableOnly;
        }

        @NotNull
        public String toString() {
            return this.value + ", " + (this.passThroughEnvironmentVariableOnly ? "passThroughEnvironmentVariableOnly" : "");
        }
    }

    @Deprecated(message="Use NodeTargetRunOptions instead", replaceWith=@ReplaceWith(expression="NodeTargetRunOptions", imports={}))
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\b\u0007\u0018\u00002\u00020\u0001B=\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\f\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u00a2\u0006\u0002\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Options;", "", "ptyOptions", "Lcom/intellij/execution/process/LocalPtyOptions;", "nodeOptions", "", "", "configureNodeOptionsCliImmediately", "", "processReaderOptions", "Lcom/intellij/util/io/BaseOutputReader$Options;", "runConfiguration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "(Lcom/intellij/execution/process/LocalPtyOptions;Ljava/util/List;ZLcom/intellij/util/io/BaseOutputReader$Options;Lcom/intellij/execution/configurations/RunConfigurationBase;)V", "getConfigureNodeOptionsCliImmediately", "()Z", "getNodeOptions", "()Ljava/util/List;", "getProcessReaderOptions", "()Lcom/intellij/util/io/BaseOutputReader$Options;", "getPtyOptions", "()Lcom/intellij/execution/process/LocalPtyOptions;", "getRunConfiguration", "()Lcom/intellij/execution/configurations/RunConfigurationBase;", "intellij.javascript.impl"})
    @ApiStatus.ScheduledForRemoval
    public static final class Options {
        @Nullable
        private final LocalPtyOptions ptyOptions;
        @NotNull
        private final List<String> nodeOptions;
        private final boolean configureNodeOptionsCliImmediately;
        @Nullable
        private final BaseOutputReader.Options processReaderOptions;
        @Nullable
        private final RunConfigurationBase<?> runConfiguration;

        public Options(@Nullable LocalPtyOptions ptyOptions, @NotNull List<String> nodeOptions, boolean configureNodeOptionsCliImmediately, @Nullable BaseOutputReader.Options processReaderOptions, @Nullable RunConfigurationBase<?> runConfiguration) {
            Intrinsics.checkNotNullParameter(nodeOptions, (String)"nodeOptions");
            this.ptyOptions = ptyOptions;
            this.nodeOptions = nodeOptions;
            this.configureNodeOptionsCliImmediately = configureNodeOptionsCliImmediately;
            this.processReaderOptions = processReaderOptions;
            this.runConfiguration = runConfiguration;
        }

        @Nullable
        public final LocalPtyOptions getPtyOptions() {
            return this.ptyOptions;
        }

        @NotNull
        public final List<String> getNodeOptions() {
            return this.nodeOptions;
        }

        public final boolean getConfigureNodeOptionsCliImmediately() {
            return this.configureNodeOptionsCliImmediately;
        }

        @Nullable
        public final BaseOutputReader.Options getProcessReaderOptions() {
            return this.processReaderOptions;
        }

        @Nullable
        public final RunConfigurationBase<?> getRunConfiguration() {
            return this.runConfiguration;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/nodejs/execution/NodeTargetRun$Upload;", "", "volume", "Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "relativePath", "", "(Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;Ljava/lang/String;)V", "getRelativePath", "()Ljava/lang/String;", "getVolume", "()Lcom/intellij/execution/target/TargetEnvironment$UploadableVolume;", "intellij.javascript.impl"})
    private static final class Upload {
        @NotNull
        private final TargetEnvironment.UploadableVolume volume;
        @NotNull
        private final String relativePath;

        public Upload(@NotNull TargetEnvironment.UploadableVolume volume, @NotNull String relativePath) {
            Intrinsics.checkNotNullParameter((Object)volume, (String)"volume");
            Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
            this.volume = volume;
            this.relativePath = relativePath;
        }

        @NotNull
        public final TargetEnvironment.UploadableVolume getVolume() {
            return this.volume;
        }

        @NotNull
        public final String getRelativePath() {
            return this.relativePath;
        }
    }
}

