/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.env;

import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunDialog;
import com.intellij.javascript.nodejs.env.DotEnvFileManager;
import com.intellij.javascript.nodejs.env.NodeEnvironmentEntry;
import com.intellij.javascript.nodejs.execution.AbstractNodeTargetRunProfile;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiManager;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.CollectionFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeEnvironmentVariablesProvider
implements Disposable {
    private final Project myProject;
    private final DotEnvFileManager myDotEnvManager;
    private volatile List<NodeEnvironmentEntry> myEnvironment;

    public NodeEnvironmentVariablesProvider(@NotNull Project project) {
        if (project == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDotEnvManager = DotEnvFileManager.getInstance(project);
        project.getMessageBus().connect((Disposable)this).subscribe(RunManagerListener.TOPIC, (Object)new RunManagerListener(){

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings2) {
                if (settings2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(new ChangeEvent(settings2, false));
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings2) {
                if (settings2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(new ChangeEvent(settings2, false));
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings2) {
                if (settings2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(new ChangeEvent(settings2, false));
            }

            public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings2) {
                NodeEnvironmentVariablesProvider.this.onRunConfigurationChanged(new ChangeEvent(settings2, true));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "settings";
                objectArray2[1] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "runConfigurationRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void onRunConfigurationChanged(@NotNull ChangeEvent event) {
        RunnerAndConfigurationSettings changed;
        if (event == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(1);
        }
        if ((changed = event.getSource()) != null && NodeEnvironmentVariablesProvider.getEnvironment(changed.getConfiguration()) != null) {
            this.myEnvironment = this.collectCommonEnvironment(event);
            this.invalidateIndexingHandlerCache();
        }
    }

    @NotNull
    public List<NodeEnvironmentEntry> getEnvironment(@Nullable VirtualFile contextFile) {
        List<DotEnvFileManager.EnvFileData> envFileDataList = this.myDotEnvManager.findEnvs(contextFile);
        List<NodeEnvironmentEntry> staticEnvs = this.getEnvironment();
        if (envFileDataList.isEmpty()) {
            List<NodeEnvironmentEntry> list2 = staticEnvs;
            if (list2 == null) {
                NodeEnvironmentVariablesProvider.$$$reportNull$$$0(2);
            }
            return list2;
        }
        EnvMerger envMerger = new EnvMerger();
        for (DotEnvFileManager.EnvFileData envFileData : envFileDataList) {
            envMerger.addEnvsIfAbsent(envFileData.getEnvEntries());
        }
        envMerger.addEnvsIfAbsent(staticEnvs);
        List<NodeEnvironmentEntry> list3 = envMerger.myOrderedEnvs;
        if (list3 == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(3);
        }
        return list3;
    }

    @NotNull
    private List<NodeEnvironmentEntry> getEnvironment() {
        List<NodeEnvironmentEntry> envs = this.myEnvironment;
        if (envs == null) {
            this.myEnvironment = envs = this.collectCommonEnvironment(null);
        }
        List<NodeEnvironmentEntry> list2 = envs;
        if (list2 == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    private List<NodeEnvironmentEntry> collectCommonEnvironment(@Nullable ChangeEvent event) {
        EnvMerger envMerger = new EnvMerger();
        for (RunConfiguration configuration : this.getConfigurations(event)) {
            Map<String, String> environment = NodeEnvironmentVariablesProvider.getEnvironment(configuration);
            if (environment == null) continue;
            envMerger.addEnvsIfAbsent(DotEnvFileManager.convert(null, environment));
        }
        envMerger.addEnvsIfAbsent(DotEnvFileManager.convert(null, EnvironmentUtil.getEnvironmentMap()));
        List<NodeEnvironmentEntry> list2 = envMerger.myOrderedEnvs;
        if (list2 == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(5);
        }
        return list2;
    }

    private void invalidateIndexingHandlerCache() {
        ApplicationManager.getApplication().invokeLaterOnWriteThread(() -> PsiManager.getInstance((Project)this.myProject).dropPsiCaches(), ModalityState.defaultModalityState(), this.myProject.getDisposed());
    }

    @NotNull
    private List<RunConfiguration> getConfigurations(@Nullable ChangeEvent event) {
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        RunnerAndConfigurationSettings selected = ChangeEvent.getSelected(event, runManager);
        RunConfiguration selectedConfiguration = selected != null ? selected.getConfiguration() : null;
        ArrayList<RunConfiguration> configurations = new ArrayList<RunConfiguration>(runManager.getAllConfigurationsList());
        if (selectedConfiguration != null) {
            configurations.remove(selectedConfiguration);
            configurations.add(0, selectedConfiguration);
        }
        ArrayList<RunConfiguration> arrayList = configurations;
        if (arrayList == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    public Navigatable getNavigatable(@NotNull String envVarName, @Nullable VirtualFile contextFile) {
        if (envVarName == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(7);
        }
        return contextFile != null ? this.myDotEnvManager.getNavigatable(envVarName, contextFile) : null;
    }

    public boolean navigate(@NotNull String envVarName, @Nullable VirtualFile contextFile) {
        if (envVarName == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(8);
        }
        if (contextFile != null) {
            Navigatable navigatable = this.getNavigatable(envVarName, contextFile);
            if (navigatable != null) {
                navigatable.navigate(true);
            }
            return true;
        }
        RunManager runManager = RunManager.getInstance((Project)this.myProject);
        for (RunConfiguration configuration : runManager.getAllConfigurationsList()) {
            Map<String, String> environment = NodeEnvironmentVariablesProvider.getEnvironment(configuration);
            RunnerAndConfigurationSettings settings2 = runManager.findSettings(configuration);
            if (environment == null || !environment.containsKey(envVarName) || settings2 == null || !RunDialog.editConfiguration((Project)this.myProject, (RunnerAndConfigurationSettings)settings2, (String)JavaScriptBundle.message("dialog.title.edit.run.debug.configuration", settings2.getName()))) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
    }

    @Nullable
    private static Map<String, String> getEnvironment(@NotNull RunConfiguration configuration) {
        if (configuration == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(9);
        }
        if (configuration instanceof CommonProgramRunConfigurationParameters) {
            return ((CommonProgramRunConfigurationParameters)configuration).getEnvs();
        }
        if (configuration instanceof AbstractNodeTargetRunProfile) {
            return ((AbstractNodeTargetRunProfile)configuration).getEnvData().getEnvs();
        }
        return null;
    }

    @NotNull
    public static NodeEnvironmentVariablesProvider getInstance(@NotNull Project project) {
        if (project == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(10);
        }
        NodeEnvironmentVariablesProvider nodeEnvironmentVariablesProvider = (NodeEnvironmentVariablesProvider)project.getService(NodeEnvironmentVariablesProvider.class);
        if (nodeEnvironmentVariablesProvider == null) {
            NodeEnvironmentVariablesProvider.$$$reportNull$$$0(11);
        }
        return nodeEnvironmentVariablesProvider;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envVarName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "collectCommonEnvironment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "onRunConfigurationChanged";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getNavigatable";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEnvironment";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 5, 6, 11 -> new IllegalStateException(string);
        };
    }

    private static final class ChangeEvent {
        private final RunnerAndConfigurationSettings mySource;
        private final boolean mySelectChanged;

        private ChangeEvent(@Nullable RunnerAndConfigurationSettings source, boolean selectChanged) {
            this.mySource = source;
            this.mySelectChanged = selectChanged;
        }

        @Nullable
        private RunnerAndConfigurationSettings getSource() {
            return this.mySource;
        }

        @Nullable
        private static RunnerAndConfigurationSettings getSelected(@Nullable ChangeEvent event, @NotNull RunManager runManager) {
            if (runManager == null) {
                ChangeEvent.$$$reportNull$$$0(0);
            }
            return event != null && event.mySelectChanged ? event.getSource() : runManager.getSelectedConfiguration();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runManager", "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider$ChangeEvent", "getSelected"));
        }
    }

    private static final class EnvMerger {
        private final Set<String> myEnvNames;
        private final List<NodeEnvironmentEntry> myOrderedEnvs = new ArrayList<NodeEnvironmentEntry>();

        private EnvMerger() {
            this.myEnvNames = SystemInfo.isWindows ? CollectionFactory.createCaseInsensitiveStringSet() : new HashSet();
        }

        private void addEnvsIfAbsent(@NotNull List<NodeEnvironmentEntry> entries) {
            if (entries == null) {
                EnvMerger.$$$reportNull$$$0(0);
            }
            for (NodeEnvironmentEntry entry : entries) {
                if (!this.myEnvNames.add(entry.getEnvName())) continue;
                this.myOrderedEnvs.add(entry);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entries", "com/intellij/javascript/nodejs/env/NodeEnvironmentVariablesProvider$EnvMerger", "addEnvsIfAbsent"));
        }
    }
}

