/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.documentation;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.documentation.NodeJsPackageDocumentation;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.markdown.utils.doc.DocMarkdownToHtmlConverter;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Range;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodeJsPackageDocUtil {
    private NodeJsPackageDocUtil() {
    }

    @Nullable
    public static NodeJsPackageDocumentation createByPackageDir(@NotNull Project project, @NotNull VirtualFile packageDir, boolean showReadme) {
        Holder holder;
        if (project == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(0);
        }
        if (packageDir == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(1);
        }
        if ((holder = (Holder)ReadAction.compute(() -> {
            VirtualFile packageJson2 = PackageJsonUtil.findChildPackageJsonFile(packageDir);
            if (packageJson2 != null) {
                PackageJsonData data = PackageJsonData.getOrCreate(packageJson2);
                VirtualFile markdownFile = showReadme ? NodeJsPackageDocUtil.findReadmeMarkdownFile(packageDir) : null;
                return new Holder(NodeJsPackageDocUtil.getPackageName(packageDir), data.getDescription(), markdownFile);
            }
            return null;
        })) != null) {
            String html2 = NodeJsPackageDocUtil.generateHtml(project, holder.myReadmeMd);
            return new NodeJsPackageDocumentation(holder.myPackageName, holder.myDescription, html2, packageDir);
        }
        return null;
    }

    @NotNull
    @Nls
    private static String getPackageName(@NotNull VirtualFile packageDir) {
        VirtualFile parent;
        if (packageDir == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(2);
        }
        if ((parent = packageDir.getParent()) == null || NodeModulesDirectoryManager.isNodeModulesDir(parent)) {
            String string = packageDir.getName();
            if (string == null) {
                NodeJsPackageDocUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        String compoundName = parent.getName() + "/" + packageDir.getName();
        Object object = compoundName.startsWith("@") ? compoundName : packageDir.getName();
        if (object == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(4);
        }
        return object;
    }

    @Nullable
    private static VirtualFile findReadmeMarkdownFile(@NotNull VirtualFile packageDir) {
        VirtualFile[] children;
        if (packageDir == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(5);
        }
        if ((children = packageDir.getChildren()) != null) {
            for (VirtualFile child : children) {
                String name;
                if (!child.isValid() || !(name = child.getName()).equalsIgnoreCase("readme.md") && !name.equalsIgnoreCase("readme.markdown")) continue;
                return child;
            }
        }
        return null;
    }

    @NotNull
    @NlsSafe
    private static String loadText(@NotNull VirtualFile file) throws IOException {
        Document document2;
        if (file == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(6);
        }
        if ((document2 = FileDocumentManager.getInstance().getCachedDocument(file)) != null) {
            String string = document2.getText();
            if (string == null) {
                NodeJsPackageDocUtil.$$$reportNull$$$0(7);
            }
            return string;
        }
        String string = VfsUtilCore.loadText((VirtualFile)file);
        if (string == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    @Nls
    private static String generateHtml(@NotNull Project project, @Nullable VirtualFile readmeMd) {
        if (project == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(9);
        }
        if (readmeMd == null) {
            return null;
        }
        try {
            String markdown = NodeJsPackageDocUtil.loadText(readmeMd);
            if (StringUtil.isEmptyOrSpaces((String)markdown)) {
                return null;
            }
            String processedMarkdown = NodeJsPackageDocUtil.removeUselessImageLinks(markdown);
            return (String)ReadAction.compute(() -> DocMarkdownToHtmlConverter.convert((Project)project, (String)processedMarkdown));
        }
        catch (IOException e) {
            return null;
        }
    }

    @NotNull
    @Nls
    private static String removeUselessImageLinks(@NotNull @Nls String markdown) {
        if (markdown == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(10);
        }
        List<String> lines = Arrays.asList(StringUtil.splitByLinesDontTrim((String)markdown));
        Range<Integer> uselessLines = NodeJsPackageDocUtil.findUselessLineRange(lines);
        ArrayList<String> result2 = new ArrayList<String>();
        for (int i = 0; i < lines.size(); ++i) {
            if (uselessLines != null && uselessLines.isWithin((Comparable)Integer.valueOf(i))) continue;
            String line = lines.get(i);
            String usefulLine = NodeJsPackageDocUtil.clearUselessLinks(line);
            if (!StringUtil.isEmptyOrSpaces((String)line) && StringUtil.isEmptyOrSpaces((String)usefulLine)) continue;
            result2.add(usefulLine);
        }
        String string = StringUtil.join(result2, (String)"\n");
        if (string == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Nullable
    private static Range<Integer> findUselessLineRange(@NotNull List<String> lines) {
        if (lines == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(12);
        }
        Range<Integer> range = NodeJsPackageDocUtil.findImageLinkRange(lines, 0);
        while (range != null) {
            boolean found = false;
            for (int i = ((Integer)range.getFrom()).intValue(); i <= (Integer)range.getTo(); ++i) {
                String line = lines.get(i);
                if (!NodeJsPackageDocUtil.isUselessImageLink(line, new TextRange(0, line.length()))) continue;
                found = true;
                break;
            }
            if (found) {
                return range;
            }
            range = NodeJsPackageDocUtil.findImageLinkRange(lines, (Integer)range.getTo() + 1);
        }
        return null;
    }

    @NotNull
    private static String clearUselessLinks(@NotNull String line) {
        TextRange link;
        if (line == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(13);
        }
        if ((link = NodeJsPackageDocUtil.findUselessLink(line, 0)) == null) {
            String string = line;
            if (string == null) {
                NodeJsPackageDocUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        int lastLinkEnd = 0;
        StringBuilder result2 = new StringBuilder();
        while (link != null) {
            result2.append(line, lastLinkEnd, link.getStartOffset());
            lastLinkEnd = link.getEndOffset();
            link = NodeJsPackageDocUtil.findUselessLink(line, lastLinkEnd);
        }
        result2.append(line.substring(lastLinkEnd));
        String string = result2.toString();
        if (string == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    private static TextRange findUselessLink(@NotNull String text2, int startIndex) {
        if (text2 == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(16);
        }
        TextRange link = NodeJsPackageDocUtil.findImageLink(text2, startIndex);
        while (link != null && !NodeJsPackageDocUtil.isUselessImageLink(text2, link)) {
            link = NodeJsPackageDocUtil.findImageLink(text2, link.getEndOffset());
        }
        return link;
    }

    private static boolean isUselessImageLink(@NotNull String text2, @NotNull TextRange link) {
        if (text2 == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(17);
        }
        if (link == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(18);
        }
        return true;
    }

    @Nullable
    private static TextRange findImageLink(@NotNull String text2, int startIndex) {
        int titleClosingInd;
        int mdStartInd;
        int htmlImgEndInd;
        if (text2 == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(19);
        }
        TextRange htmlImgRange = null;
        int htmlImgStartInd = text2.indexOf("<img ", startIndex);
        if (htmlImgStartInd >= 0 && (htmlImgEndInd = text2.indexOf(">", htmlImgStartInd)) != -1) {
            htmlImgRange = new TextRange(htmlImgStartInd, htmlImgEndInd + 1);
        }
        if ((mdStartInd = text2.indexOf("![", startIndex)) < 0 || htmlImgRange != null && htmlImgRange.getStartOffset() < mdStartInd) {
            return htmlImgRange;
        }
        int titleOpeningInd = mdStartInd + 1;
        if (mdStartInd > 0 && text2.charAt(mdStartInd - 1) == '[') {
            mdStartInd = titleOpeningInd = mdStartInd - 1;
        }
        if ((titleClosingInd = NodeJsPackageDocUtil.findClosingInd(text2, titleOpeningInd)) != -1) {
            if (StringUtil.isChar((CharSequence)text2, (int)(titleClosingInd + 1), (char)'(')) {
                int urlClosingInd = NodeJsPackageDocUtil.findClosingInd(text2, titleClosingInd + 1);
                if (urlClosingInd != -1) {
                    return new TextRange(mdStartInd, urlClosingInd + 1);
                }
            } else {
                return new TextRange(mdStartInd, titleClosingInd + 1);
            }
        }
        return null;
    }

    private static int findClosingInd(@NotNull String text2, int openingInd) {
        int i;
        if (text2 == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(20);
        }
        int squareBrackets = 0;
        int parentheses = 0;
        boolean empty2 = true;
        for (i = openingInd; i < text2.length() && (empty2 || squareBrackets > 0 || parentheses > 0); ++i) {
            char ch = text2.charAt(i);
            if (ch == '[') {
                ++squareBrackets;
            } else if (ch == '(') {
                ++parentheses;
            } else if (ch == ']') {
                --squareBrackets;
            } else if (ch == ')') {
                --parentheses;
            }
            if (squareBrackets < 0 || parentheses < 0) {
                return -1;
            }
            if (empty2 && squareBrackets == 0 && parentheses == 0) {
                return -1;
            }
            empty2 = false;
        }
        return !empty2 && squareBrackets == 0 && parentheses == 0 ? i - 1 : -1;
    }

    @Nullable
    private static Range<Integer> findImageLinkRange(@NotNull List<String> lines, int startInd) {
        if (lines == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(21);
        }
        int rangeStartInd = -1;
        int rangeEndInd = -1;
        for (int i = startInd; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (NodeJsPackageDocUtil.isImageLinks(line)) {
                if (rangeStartInd == -1) {
                    rangeStartInd = i;
                }
                rangeEndInd = i;
                continue;
            }
            if (rangeStartInd != -1) break;
        }
        return rangeStartInd == -1 ? null : new Range((Comparable)Integer.valueOf(rangeStartInd), (Comparable)Integer.valueOf(rangeEndInd));
    }

    private static boolean isImageLinks(@NotNull String line) {
        if (line == null) {
            NodeJsPackageDocUtil.$$$reportNull$$$0(22);
        }
        int i = 0;
        while (i < line.length()) {
            while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
                ++i;
            }
            TextRange link = NodeJsPackageDocUtil.findImageLink(line, i);
            if (link == null || link.getStartOffset() != i) break;
            i = link.getEndOffset();
        }
        while (i < line.length() && Character.isWhitespace(line.charAt(i))) {
            ++i;
        }
        return i == line.length();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 7, 8, 11, 14, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markdown";
                break;
            }
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lines";
                break;
            }
            case 13: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 16: 
            case 17: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageName";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "removeUselessImageLinks";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "clearUselessLinks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createByPackageDir";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPackageName";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 11: 
            case 14: 
            case 15: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findReadmeMarkdownFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "generateHtml";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeUselessImageLinks";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findUselessLineRange";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "clearUselessLinks";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findUselessLink";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isUselessImageLink";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findImageLink";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findClosingInd";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findImageLinkRange";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isImageLinks";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 7, 8, 11, 14, 15 -> new IllegalStateException(string);
        };
    }

    private static class Holder {
        @Nls
        private final String myPackageName;
        @Nls
        private final String myDescription;
        private final VirtualFile myReadmeMd;

        Holder(@NotNull @Nls String packageName, @Nullable @Nls String description, @Nullable VirtualFile readmeMd) {
            if (packageName == null) {
                Holder.$$$reportNull$$$0(0);
            }
            this.myPackageName = packageName;
            this.myDescription = description;
            this.myReadmeMd = readmeMd;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "com/intellij/javascript/nodejs/documentation/NodeJsPackageDocUtil$Holder", "<init>"));
        }
    }
}

