/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs;

import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.ModuleType;
import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.ResolvedModuleInfo;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.library.node_modules.NodeModulesDirectoryManager;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpDependency;
import com.intellij.javascript.nodejs.library.yarn.pnp.YarnPnpManager;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.util.PairProcessor;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public final class NodeModuleSearchUtil {
    private static final String NODE_MODULES = "node_modules";
    public static final String[] FILE_EXTENSIONS_IN_ORDER = JSFileReferencesUtil.IMPLICIT_EXTENSIONS;

    private NodeModuleSearchUtil() {
    }

    public static void findModulesWithName(@NotNull List<? super CompletionModuleInfo> modules2, @NotNull String moduleName, @Nullable VirtualFile requester, @Nullable NodeJsInterpreter interpreter2) {
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(0);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(1);
        }
        if (requester != null) {
            NodeModuleSearchUtil.findModulesWithNameFromNodeModulesDir(modules2, requester, moduleName);
        }
        NodeModuleSearchUtil.findGloballyInstalledModules(modules2, moduleName, interpreter2);
    }

    @Deprecated(forRemoval=true)
    public static void findModulesWithName(@NotNull List<? super CompletionModuleInfo> modules2, @NotNull String moduleName, @Nullable VirtualFile requester, boolean includeGloballyInstalled, @Nullable NodeJsInterpreter interpreter2) {
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(2);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(3);
        }
        NodeModuleSearchUtil.findModulesWithName(modules2, moduleName, requester, interpreter2);
    }

    public static void findModulesByNameInContentRoots(@NotNull List<? super CompletionModuleInfo> modules2, @NotNull String moduleName, @NotNull Project project) {
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(4);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(5);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(6);
        }
        ReadAction.run(() -> {
            for (VirtualFile contentRoot : ProjectRootManager.getInstance((Project)project).getContentRoots()) {
                VirtualFile nodeModulesDir = NodeModuleUtil.findChildNodeModulesDir(contentRoot);
                if (nodeModulesDir == null) continue;
                NodeModuleSearchUtil.findModuleWithNameInDirectory(modules2, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
            }
        });
    }

    public static void findGloballyInstalledModules(@NotNull List<? super CompletionModuleInfo> modules2, @NotNull String moduleName, @Nullable NodeJsInterpreter interpreter2) {
        NodeJsLocalInterpreter local;
        VirtualFile globalNodeModulesDir;
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(7);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(8);
        }
        VirtualFile virtualFile = globalNodeModulesDir = (local = NodeJsLocalInterpreter.tryCast(interpreter2)) != null ? local.getGlobalNodeModulesVirtualDir() : null;
        if (globalNodeModulesDir != null) {
            ReadAction.run(() -> NodeModuleSearchUtil.findModuleWithNameInDirectory(modules2, globalNodeModulesDir, ModuleType.GLOBAL_FOLDER, moduleName, true));
        }
    }

    private static void findModulesWithNameFromNodeModulesDir(@NotNull List<? super CompletionModuleInfo> modules2, @NotNull VirtualFile requester, @NotNull String moduleName) {
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(9);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(10);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(11);
        }
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
            NodeModuleSearchUtil.findModuleWithNameInDirectory(modules2, nodeModulesDir, ModuleType.NODE_MODULES_DIR, moduleName);
            return true;
        }));
    }

    public static boolean findModuleWithNameInDirectory(@NotNull List<? super CompletionModuleInfo> modules2, @NotNull VirtualFile dir, @NotNull ModuleType moduleType, @NotNull String moduleName) {
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(12);
        }
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(13);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(14);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(15);
        }
        return NodeModuleSearchUtil.findModuleWithNameInDirectory(modules2, dir, moduleType, moduleName, false);
    }

    public static boolean findModuleWithNameInDirectory(@NotNull List<? super CompletionModuleInfo> modules2, @NotNull VirtualFile dir, @NotNull ModuleType moduleType, @NotNull String moduleName, boolean withRefresh) {
        boolean ok;
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(16);
        }
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(17);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(18);
        }
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(19);
        }
        VirtualFile child = dir.findFileByRelativePath(moduleName);
        if (withRefresh && child == null && dir instanceof NewVirtualFile && ApplicationManager.getApplication().isDispatchThread()) {
            child = ((NewVirtualFile)dir).refreshAndFindChild(moduleName);
        }
        if (child != null && (ok = NodeModuleSearchUtil.canLoad(child))) {
            String name = child.isDirectory() ? child.getName() : child.getNameWithoutExtension();
            modules2.add(new CompletionModuleInfo(name, child, moduleType));
            return true;
        }
        return false;
    }

    @NotNull
    public static Collection<CompletionModuleInfo> collectVisibleNodeModules(@NotNull Map<String, CompletionModuleInfo> modules2, @NotNull Project project, @Nullable VirtualFile requester) {
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(20);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(21);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromNodeModulesDir(modules2, project, requester);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectYarnPnpDependencies(modules2, project, requester);
        }
        if (requester != null) {
            NodeModuleSearchUtil.collectModulesFromResourceRoots(modules2, project, requester);
        }
        Collection<CompletionModuleInfo> collection = modules2.values();
        if (collection == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(22);
        }
        return collection;
    }

    private static void collectYarnPnpDependencies(@NotNull Map<String, CompletionModuleInfo> modules2, @NotNull Project project, @NotNull VirtualFile requester) {
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(23);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(24);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(25);
        }
        PackageJsonUtil.processUpPackageJsonFiles(project, requester, (Processor<? super VirtualFile>)((Processor)packageJson2 -> {
            YarnPnpManager yarnPnpManager = YarnPnpManager.getInstance(project);
            if (yarnPnpManager.isUnderPnp((VirtualFile)packageJson2)) {
                Set<String> dependencies = PackageJsonData.getOrCreate(packageJson2).getAllDependencies();
                for (String dependency : dependencies) {
                    VirtualFile dependencyRoot;
                    if (modules2.containsKey(dependency) || (dependencyRoot = yarnPnpManager.findInstalledPackageDir((VirtualFile)packageJson2, dependency)) == null) continue;
                    modules2.put(dependency, new CompletionModuleInfo(dependency, null, ModuleType.NODE_MODULES_DIR));
                }
            }
            return true;
        }));
    }

    private static void collectModulesFromResourceRoots(@NotNull Map<String, CompletionModuleInfo> modules2, @NotNull Project project, @Nullable VirtualFile requester) {
        WebResourcesPathsConfiguration pathsConfiguration;
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(26);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(27);
        }
        if ((pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)project)) != null) {
            List directories = pathsConfiguration.getResourceDirectories();
            NodeModuleSearchUtil.collectModulesInDirectories(directories, modules2, ModuleType.RESOURCE_ROOT);
        }
        if (requester != null) {
            List<VirtualFile> resourceRoots = NodeModuleSearchUtil.getJavaResourceRoots(project, requester);
            NodeModuleSearchUtil.collectModulesInDirectories(resourceRoots, modules2, ModuleType.RESOURCE_ROOT);
        }
    }

    private static void collectModulesFromNodeModulesDir(@NotNull Map<String, CompletionModuleInfo> modules2, @NotNull Project project, @NotNull VirtualFile requester) {
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(28);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(29);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(30);
        }
        HashSet dependencies = new HashSet();
        NodeModuleSearchUtil.processUpNodeModulesDirsAndPackageJsonFiles(project, requester, true, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(nodeModulesDir, packageJsonFile) -> {
            if (packageJsonFile != null) {
                dependencies.addAll(PackageJsonData.getOrCreate(packageJsonFile).getAllDependencies());
            }
            if (nodeModulesDir != null) {
                NodeModuleSearchUtil.collectModulesInDirectory(nodeModulesDir, modules2, ModuleType.NODE_MODULES_DIR, dependencies);
            }
            return true;
        }));
    }

    private static void collectModulesInDirectories(@NotNull List<? extends VirtualFile> directories, @NotNull Map<String, CompletionModuleInfo> modules2, @NotNull ModuleType moduleType) {
        if (directories == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(31);
        }
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(32);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(33);
        }
        for (VirtualFile virtualFile : directories) {
            if (!virtualFile.isDirectory() || !virtualFile.isValid()) continue;
            NodeModuleSearchUtil.collectModulesInDirectory(virtualFile, modules2, moduleType, null);
        }
    }

    private static void collectModulesInDirectory(@NotNull VirtualFile dir, @NotNull Map<String, CompletionModuleInfo> modules2, @NotNull ModuleType moduleType, @Nullable Set<String> dependencies) {
        VirtualFile[] children;
        VirtualFile packageJson2;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(34);
        }
        if (modules2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(35);
        }
        if (moduleType == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(36);
        }
        if (NodeModulesDirectoryManager.isNodeModulesDir(dir) && (packageJson2 = NodeModuleUtil.findPackageJsonByNodeModules(dir)) != null && packageJson2.isValid()) {
            Set<String> deps = dependencies;
            if (deps == null) {
                deps = PackageJsonData.getOrCreate(packageJson2).getAllDependencies();
            }
            for (String dependency : deps) {
                VirtualFile moduleDir = dir.findFileByRelativePath(dependency);
                if (moduleDir == null || !moduleDir.isDirectory() || !moduleDir.isValid() || modules2.containsKey(dependency)) continue;
                modules2.put(dependency, new CompletionModuleInfo(dependency, moduleDir, moduleType));
            }
            return;
        }
        for (VirtualFile child : children = VfsUtil.getChildren((VirtualFile)dir)) {
            String moduleName;
            String childName = child.getName();
            if (NodeModuleSearchUtil.isScopeDir(child)) {
                for (VirtualFile grandChild : child.getChildren()) {
                    String moduleName2;
                    if (!NodeModuleSearchUtil.canLoad(grandChild) || modules2.containsKey(moduleName2 = childName + "/" + NodeModuleSearchUtil.getModuleName(grandChild))) continue;
                    modules2.put(moduleName2, new CompletionModuleInfo(moduleName2, grandChild, moduleType));
                }
                continue;
            }
            if (!NodeModuleSearchUtil.canLoad(child) || modules2.containsKey(moduleName = NodeModuleSearchUtil.getModuleName(child))) continue;
            modules2.put(moduleName, new CompletionModuleInfo(moduleName, child, moduleType));
        }
    }

    private static String getModuleName(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(37);
        }
        return fileOrDir.isDirectory() ? fileOrDir.getName() : fileOrDir.getNameWithoutExtension();
    }

    private static boolean canLoad(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(38);
        }
        if (fileOrDir.isDirectory()) {
            return NodeModuleSearchUtil.canLoadDirectory(fileOrDir);
        }
        return NodeModuleSearchUtil.canLoadFile(fileOrDir);
    }

    public static boolean canLoadFile(@NotNull VirtualFile file) {
        String ext;
        if (file == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(39);
        }
        if ((ext = file.getExtension()) == null) {
            return false;
        }
        for (String expectedExt : FILE_EXTENSIONS_IN_ORDER) {
            if (!expectedExt.endsWith(ext) || ext.length() + 1 != expectedExt.length()) continue;
            return true;
        }
        return false;
    }

    public static boolean canLoadDirectory(@NotNull VirtualFile dir) {
        VirtualFile packageJson2;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(40);
        }
        if (NodeModuleSearchUtil.isFile(packageJson2 = dir.findChild("package.json"))) {
            return true;
        }
        for (String ext : FILE_EXTENSIONS_IN_ORDER) {
            VirtualFile child = dir.findChild("index" + ext);
            if (!NodeModuleSearchUtil.isFile(child)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester, @NotNull List<? extends VirtualFile> nodePathFolders, @NotNull Project project) {
        ResolvedModuleInfo info2;
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(41);
        }
        if (nodePathFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(42);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(43);
        }
        if (requester != null && (info2 = NodeModuleSearchUtil.resolveModuleFromNodeModulesDir(requester, requiredModuleName, NodeModuleDirectorySearchProcessor.PROCESSOR)) != null) {
            return info2;
        }
        return NodeModuleSearchUtil.resolveNonPathModule(requiredModuleName, requester, nodePathFolders, project);
    }

    @Nullable
    public static ResolvedModuleInfo resolveNonPathModule(@NotNull String requiredModuleName, @Nullable VirtualFile requester, @NotNull List<? extends VirtualFile> nodePathFolders, @NotNull Project project) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(44);
        }
        if (nodePathFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(45);
        }
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(46);
        }
        ResolvedModuleInfo info2 = null;
        if (requester != null) {
            info2 = NodeModuleSearchUtil.resolveYarnModule(project, requiredModuleName, requester);
        }
        if (info2 == null) {
            info2 = NodeModuleSearchUtil.resolveFromGlobalFoldersModule(requiredModuleName, nodePathFolders);
        }
        return info2;
    }

    @Nullable
    public static ResolvedModuleInfo resolveYarnModule(@NotNull Project project, @NotNull String requiredModuleName, @NotNull VirtualFile requester) {
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(47);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(48);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(49);
        }
        return NodeModuleSearchUtil.resolveYarnModule(project, requiredModuleName, requester, NodeModuleDirectorySearchProcessor.PROCESSOR);
    }

    @Nullable
    public static ResolvedModuleInfo resolveYarnModule(@NotNull Project project, @NotNull String requiredModuleName, @NotNull VirtualFile requester, @NotNull NodeModuleDirectorySearchProcessor processor) {
        YarnPnpDependency childDependency;
        YarnPnpDependency dependency;
        String dependencyName;
        String pathInsideDependency;
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(50);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(51);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(52);
        }
        if (processor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(53);
        }
        if ((pathInsideDependency = NodeModuleSearchUtil.extractDependencyPath(requiredModuleName, dependencyName = NodeModuleSearchUtil.extractDependencyName(requiredModuleName))).isEmpty()) {
            pathInsideDependency = ".";
        }
        Ref packageJsonRef = Ref.create();
        PackageJsonUtil.processUpPackageJsonFiles(project, requester, (Processor<? super VirtualFile>)((Processor)packageJson2 -> {
            PackageJsonData data = PackageJsonData.getOrCreate(packageJson2);
            if (data.isDependencyOfAnyType(dependencyName)) {
                packageJsonRef.set(packageJson2);
                return false;
            }
            return true;
        }));
        VirtualFile dependencyRoot = null;
        VirtualFile packageJson3 = (VirtualFile)packageJsonRef.get();
        if (packageJson3 != null) {
            dependencyRoot = YarnPnpManager.getInstance(project).findInstalledPackageDir(packageJson3, dependencyName);
        }
        if (dependencyRoot == null && (dependency = YarnPnpManager.getInstance(project).findDependencyByFileOrDirectory(requester)) != null && (childDependency = dependency.findChildDependencyByName(dependencyName)) != null) {
            dependencyRoot = childDependency.resolveLocation();
        }
        if (dependencyRoot == null) {
            return null;
        }
        return processor.doResolveModule(dependencyRoot, ModuleType.NODE_MODULES_DIR, dependencyRoot, pathInsideDependency, true, true);
    }

    @NotNull
    public static String extractDependencyPath(@NotNull String requiredModuleName, String dependencyName) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(54);
        }
        return dependencyName.length() < requiredModuleName.length() ? requiredModuleName.substring(dependencyName.length() + 1) : "";
    }

    @NotNull
    public static String extractDependencyName(@NotNull String moduleName) {
        int separatorInd;
        if (moduleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(55);
        }
        if ((separatorInd = moduleName.indexOf(47)) > 0 && NodeModuleSearchUtil.isScopedPackageName(moduleName)) {
            separatorInd = moduleName.indexOf(47, separatorInd + 1);
        }
        String string = separatorInd >= 0 ? moduleName.substring(0, separatorInd) : moduleName;
        if (string == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(56);
        }
        return string;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleFromNodeModulesDir(@NotNull VirtualFile requester, @NotNull String requiredModuleName, @NotNull NodeModuleDirectorySearchProcessor processor) {
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(57);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(58);
        }
        if (processor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(59);
        }
        Ref resolveRef = Ref.create();
        NodeModuleSearchUtil.processUpNodeModulesDirs(null, requester, (Processor<? super VirtualFile>)((Processor)nodeModulesDir -> {
            ResolvedModuleInfo info2 = processor.doResolveModule(null, ModuleType.NODE_MODULES_DIR, (VirtualFile)nodeModulesDir, requiredModuleName, true, true);
            if (info2 != null) {
                resolveRef.set((Object)info2);
                return false;
            }
            return true;
        }));
        return (ResolvedModuleInfo)resolveRef.get();
    }

    @NotNull
    private static List<VirtualFile> getJavaResourceRoots(@NotNull Project project, @NotNull VirtualFile requester) {
        if (project == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(60);
        }
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(61);
        }
        if (!PlatformUtils.isIdeaUltimate()) {
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(62);
            }
            return list2;
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        Module module = index.getModuleForFile(requester, false);
        if (module == null) {
            List<VirtualFile> list3 = Collections.emptyList();
            if (list3 == null) {
                NodeModuleSearchUtil.$$$reportNull$$$0(63);
            }
            return list3;
        }
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
        List list4 = moduleRootManager.getSourceRoots((JpsModuleSourceRootType)JavaResourceRootType.RESOURCE);
        if (list4 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(64);
        }
        return list4;
    }

    public static void processUpNodeModulesDirs(@Nullable Project project, @NotNull VirtualFile requester, @NotNull Processor<? super VirtualFile> nodeModulesDirProcessor) {
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(65);
        }
        if (nodeModulesDirProcessor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(66);
        }
        NodeModuleSearchUtil.processUpNodeModulesDirsAndPackageJsonFiles(project, requester, false, (PairProcessor<? super VirtualFile, ? super VirtualFile>)((PairProcessor)(nodeModulesDir, packageJsonFile) -> nodeModulesDirProcessor.process((Object)Objects.requireNonNull(nodeModulesDir))));
    }

    private static void processUpNodeModulesDirsAndPackageJsonFiles(@Nullable Project project, @NotNull VirtualFile requester, boolean includePackageJsonFiles, @NotNull PairProcessor<? super VirtualFile, ? super VirtualFile> processor) {
        VirtualFile dir;
        if (requester == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(67);
        }
        if (processor == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(68);
        }
        VirtualFile virtualFile = dir = requester.isDirectory() ? requester : requester.getParent();
        while (dir != null && (project == null || JSLibraryUtil.getContentRootForFile(project, dir) != null)) {
            boolean continueIteration;
            VirtualFile packageJsonFile;
            VirtualFile nodeModulesDir = NodeModuleUtil.findChildNodeModulesDir(dir);
            VirtualFile virtualFile2 = packageJsonFile = includePackageJsonFiles ? PackageJsonUtil.findChildPackageJsonFile(dir) : null;
            if ((nodeModulesDir != null || packageJsonFile != null) && !(continueIteration = processor.process((Object)nodeModulesDir, (Object)packageJsonFile))) break;
            dir = dir.getParent();
        }
    }

    @Nullable
    public static ResolvedModuleInfo resolveFromGlobalFoldersModule(@NotNull String requiredModuleName, @NotNull List<? extends VirtualFile> globalFolders) {
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(69);
        }
        if (globalFolders == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(70);
        }
        for (VirtualFile virtualFile : globalFolders) {
            ResolvedModuleInfo info2;
            if (!virtualFile.isValid() || !virtualFile.isDirectory() || (info2 = NodeModuleSearchUtil.doResolveModule(null, ModuleType.GLOBAL_FOLDER, virtualFile, requiredModuleName, true, true)) == null) continue;
            return info2;
        }
        return null;
    }

    @Nullable
    public static ResolvedModuleInfo resolveModuleByExactPath(@NotNull VirtualFile baseDir, @NotNull String requiredModuleName) {
        if (baseDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(71);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(72);
        }
        return NodeModuleSearchUtil.doResolveModule(null, ModuleType.EXACT_PATH, baseDir, requiredModuleName, true, true);
    }

    @Nullable
    private static ResolvedModuleInfo doResolveModule(@Nullable VirtualFile moduleSourceRoot, @NotNull ModuleType type2, @NotNull VirtualFile baseDir, @NotNull String requiredModuleName, boolean resolveDirectory, boolean respectPackageJson) {
        if (type2 == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(73);
        }
        if (baseDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(74);
        }
        if (requiredModuleName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(75);
        }
        return NodeModuleDirectorySearchProcessor.PROCESSOR.doResolveModule(moduleSourceRoot, type2, baseDir, requiredModuleName, resolveDirectory, respectPackageJson);
    }

    @NotNull
    public static Pair<Boolean, ModuleMainFiles> findMainModuleInPackage(@NotNull VirtualFile dir) {
        VirtualFile candidate;
        VirtualFile packageJson2;
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(76);
        }
        if ((packageJson2 = PackageJsonUtil.findChildPackageJsonFile(dir)) != null) {
            PackageJsonData data = PackageJsonData.getOrCreate(packageJson2);
            VirtualFile mainModule = NodeModuleSearchUtil.findMainModuleByPath(dir, data.getMain());
            VirtualFile mainJsNextModule = NodeModuleSearchUtil.findMainModuleByPath(dir, data.getJsNextMain());
            if (mainModule != null || mainJsNextModule != null) {
                Pair pair = Pair.create((Object)true, (Object)new ModuleMainFiles(mainModule, mainJsNextModule));
                if (pair == null) {
                    NodeModuleSearchUtil.$$$reportNull$$$0(77);
                }
                return pair;
            }
        }
        if ((candidate = dir.findChild("index.js")) == null) {
            candidate = dir.findChild("index.node");
        }
        Pair pair = Pair.create((Object)false, (Object)new ModuleMainFiles(candidate, candidate));
        if (pair == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(78);
        }
        return pair;
    }

    @Nullable
    public static VirtualFile findMainModuleByPath(@NotNull VirtualFile dir, @Nullable String main) {
        if (dir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(79);
        }
        if (main != null) {
            String[] parts = (main = main.startsWith("./") ? main.substring(2) : main).split("/");
            VirtualFile file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
            if (file == null && parts.length > 0 && !parts[parts.length - 1].contains(".")) {
                String withoutExtension = parts[parts.length - 1];
                parts[parts.length - 1] = withoutExtension + ".js";
                file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                if (file == null) {
                    parts[parts.length - 1] = withoutExtension + ".node";
                    file = VfsUtil.findRelativeFile((VirtualFile)dir, (String[])parts);
                }
            }
            return file;
        }
        return null;
    }

    @Contract(value="null -> false", pure=true)
    static boolean isFile(@Nullable VirtualFile file) {
        return file != null && file.isValid() && !file.isDirectory();
    }

    @Nullable
    public static VirtualFile findAncestorNodeModulesDir(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(80);
        }
        return JSLibraryUtil.findAncestorLibraryDir(fileOrDir, NODE_MODULES);
    }

    @Nullable
    public static VirtualFile findDependencyRoot(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(81);
        }
        VirtualFile scope2 = fileOrDir;
        VirtualFile pkg = fileOrDir;
        while (scope2 != null) {
            VirtualFile parent = scope2.getParent();
            if (parent != null && parent.isDirectory() && StringUtil.equals((CharSequence)NODE_MODULES, (CharSequence)parent.getNameSequence())) {
                return NodeModuleSearchUtil.isScopeDir(scope2) ? pkg : scope2;
            }
            pkg = scope2;
            scope2 = parent;
        }
        return null;
    }

    public static boolean isScopeDir(@Nullable VirtualFile dir) {
        return dir != null && dir.isDirectory() && NodeModuleSearchUtil.isScopeDirName(dir.getNameSequence());
    }

    public static boolean isScopeDirName(@NotNull CharSequence dirName) {
        if (dirName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(82);
        }
        return StringUtil.startsWithChar((CharSequence)dirName, (char)'@');
    }

    @Contract(value="null -> false", pure=true)
    public static boolean isScopedPackageName(@Nullable String packageName) {
        return packageName != null && StringUtil.startsWithChar((CharSequence)packageName, (char)'@') && StringUtil.containsChar((String)packageName, (char)'/');
    }

    @Nullable
    public static String getScopeByPackageName(@NotNull String packageName) {
        int slashInd;
        if (packageName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(83);
        }
        if (StringUtil.startsWithChar((CharSequence)packageName, (char)'@') && (slashInd = packageName.indexOf(47, 1)) > 0) {
            return packageName.substring(0, slashInd);
        }
        return null;
    }

    @Nullable
    public static String getScopeByScopedPackageName(@NotNull String packageName) {
        int slashInd;
        if (packageName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(84);
        }
        if (StringUtil.startsWithChar((CharSequence)packageName, (char)'@') && (slashInd = packageName.indexOf(47, 1)) > 0) {
            return packageName.substring(1, slashInd);
        }
        return null;
    }

    @Nullable
    public static String getNameByScopedPackageName(@NotNull String packageName) {
        int slashInd;
        if (packageName == null) {
            NodeModuleSearchUtil.$$$reportNull$$$0(85);
        }
        if (NodeModuleSearchUtil.isScopedPackageName(packageName) && (slashInd = packageName.indexOf(47, 1)) > 0) {
            return packageName.substring(slashInd + 1);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 22, 56, 62, 63, 64, 77, 78 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 15: 
            case 19: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
            case 6: 
            case 21: 
            case 24: 
            case 27: 
            case 29: 
            case 43: 
            case 46: 
            case 47: 
            case 50: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 10: 
            case 25: 
            case 30: 
            case 49: 
            case 52: 
            case 57: 
            case 61: 
            case 65: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requester";
                break;
            }
            case 13: 
            case 17: 
            case 34: 
            case 40: 
            case 76: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 14: 
            case 18: 
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 22: 
            case 56: 
            case 62: 
            case 63: 
            case 64: 
            case 77: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/NodeModuleSearchUtil";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directories";
                break;
            }
            case 37: 
            case 38: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 41: 
            case 44: 
            case 48: 
            case 51: 
            case 54: 
            case 58: 
            case 69: 
            case 72: 
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requiredModuleName";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePathFolders";
                break;
            }
            case 53: 
            case 59: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirProcessor";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "globalFolders";
                break;
            }
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 83: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/NodeModuleSearchUtil";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "collectVisibleNodeModules";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "extractDependencyName";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaResourceRoots";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "findMainModuleInPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findModulesByNameInContentRoots";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findGloballyInstalledModules";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findModulesWithNameFromNodeModulesDir";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findModuleWithNameInDirectory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "collectVisibleNodeModules";
                break;
            }
            case 22: 
            case 56: 
            case 62: 
            case 63: 
            case 64: 
            case 77: 
            case 78: {
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "collectYarnPnpDependencies";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesFromResourceRoots";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesFromNodeModulesDir";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesInDirectories";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "collectModulesInDirectory";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getModuleName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "canLoad";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "canLoadFile";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "canLoadDirectory";
                break;
            }
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "resolveModule";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "resolveNonPathModule";
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "resolveYarnModule";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "extractDependencyPath";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "extractDependencyName";
                break;
            }
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleFromNodeModulesDir";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "getJavaResourceRoots";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processUpNodeModulesDirs";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "processUpNodeModulesDirsAndPackageJsonFiles";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "resolveFromGlobalFoldersModule";
                break;
            }
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "resolveModuleByExactPath";
                break;
            }
            case 73: 
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "doResolveModule";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findMainModuleInPackage";
                break;
            }
            case 79: {
                objectArray = objectArray;
                objectArray[2] = "findMainModuleByPath";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "findAncestorNodeModulesDir";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findDependencyRoot";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "isScopeDirName";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "getScopeByPackageName";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getScopeByScopedPackageName";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "getNameByScopedPackageName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 22, 56, 62, 63, 64, 77, 78 -> new IllegalStateException(string);
        };
    }

    public static class ModuleMainFiles {
        @Nullable
        private final VirtualFile myMain;
        @Nullable
        private final VirtualFile myJsNextMain;

        public ModuleMainFiles(@Nullable VirtualFile jsNextMain, @Nullable VirtualFile main) {
            this.myMain = main;
            this.myJsNextMain = jsNextMain;
        }

        @Nullable
        public VirtualFile getMain() {
            return this.myMain;
        }

        @Nullable
        public VirtualFile getJsNextMain() {
            return this.myJsNextMain;
        }

        @NotNull
        public Collection<VirtualFile> getFiles() {
            List list2 = StreamEx.of((Object[])new VirtualFile[]{this.myJsNextMain, this.myMain}).nonNull().toList();
            if (list2 == null) {
                ModuleMainFiles.$$$reportNull$$$0(0);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/nodejs/NodeModuleSearchUtil$ModuleMainFiles", "getFiles"));
        }
    }
}

