/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.express;

import com.intellij.javascript.microservices.express.ExpressModel;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.impl.JSReferenceExpressionImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/microservices/express/ExpressFrameworkHandler;", "Lcom/intellij/lang/javascript/index/FrameworkIndexingHandler;", "()V", "getMarkers", "", "", "elementToIndex", "Lcom/intellij/psi/PsiElement;", "hasSignificantValue", "", "node", "Lcom/intellij/lang/ASTNode;", "expression", "Lcom/intellij/lang/javascript/psi/JSLiteralExpression;", "shouldCreateStubForLiteral", "shouldProcess", "Companion", "intellij.javascript.langInjection"})
public final class ExpressFrameworkHandler
extends FrameworkIndexingHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String KEY = "Express";

    @Override
    public boolean shouldCreateStubForLiteral(@NotNull ASTNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        return this.hasSignificantValue(node);
    }

    @Override
    public boolean hasSignificantValue(@NotNull JSLiteralExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        return this.hasSignificantValue(expression.getNode());
    }

    private final boolean hasSignificantValue(ASTNode node) {
        block8: {
            block7: {
                ASTNode aSTNode = node;
                Object object = aSTNode != null ? aSTNode.getFirstChildNode() : null;
                if (object == null) {
                    return false;
                }
                ASTNode leaf = object;
                if (!Intrinsics.areEqual((Object)leaf.getElementType(), (Object)JSTokenTypes.STRING_LITERAL)) {
                    return false;
                }
                CharSequence charSequence = leaf.getChars();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getChars(...)");
                CharSequence text2 = charSequence;
                if (text2.length() < 2) break block7;
                Character c2 = StringsKt.getOrNull((CharSequence)text2, (int)1);
                char c3 = '/';
                if (c2 != null && c2.charValue() == c3) break block8;
            }
            return false;
        }
        ASTNode aSTNode = node.getTreeParent();
        Object object = aSTNode != null ? aSTNode.getTreeParent() : null;
        if (object == null) {
            return false;
        }
        ASTNode treeParent = object;
        IElementType iElementType = treeParent.getElementType();
        Intrinsics.checkNotNullExpressionValue((Object)iElementType, (String)"getElementType(...)");
        IElementType parentType = iElementType;
        if (Intrinsics.areEqual((Object)parentType, (Object)JSElementTypes.CALL_EXPRESSION)) {
            return this.shouldProcess(treeParent);
        }
        return false;
    }

    @Override
    @NotNull
    public List<String> getMarkers(@NotNull PsiElement elementToIndex) {
        Intrinsics.checkNotNullParameter((Object)elementToIndex, (String)"elementToIndex");
        return elementToIndex instanceof JSLiteralExpression && this.hasSignificantValue(((JSLiteralExpression)elementToIndex).getNode()) ? CollectionsKt.listOf((Object)KEY) : CollectionsKt.emptyList();
    }

    private final boolean shouldProcess(ASTNode node) {
        ASTNode methodExpression = node.getFirstChildNode();
        if (methodExpression.getElementType() != JSElementTypes.REFERENCE_EXPRESSION) {
            return false;
        }
        ASTNode qualifierElement = JSReferenceExpressionImpl.getQualifierNode(methodExpression);
        if (qualifierElement == null) {
            return false;
        }
        String refText = JSReferenceExpressionImpl.getReferenceName(methodExpression);
        return Intrinsics.areEqual((Object)refText, (Object)"use") || CollectionsKt.contains((Iterable)ExpressModel.INSTANCE.getMAPPING_REGISTRATION_METHODS$intellij_javascript_langInjection(), (Object)refText);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/intellij/javascript/microservices/express/ExpressFrameworkHandler$Companion;", "", "()V", "KEY", "", "intellij.javascript.langInjection"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

