/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices.client.generator;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.javascript.microservices.client.generator.FetchClientGenerator;
import com.intellij.javascript.microservices.client.generator.FetchClientGeneratorKt;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.microservices.client.generator.ClientExample;
import com.intellij.microservices.client.generator.ClientGenerator;
import com.intellij.microservices.oas.OasComponents;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasParameterIn;
import com.intellij.microservices.oas.OasProperty;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\u00042\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator;", "Lcom/intellij/microservices/client/generator/ClientGenerator;", "()V", "title", "", "getTitle", "()Ljava/lang/String;", "clientFromTemplate", "properties", "", "", "project", "Lcom/intellij/openapi/project/Project;", "generate", "Lcom/intellij/microservices/client/generator/ClientExample;", "openApiSpecification", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "generateMethodByOperation", "Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$MethodBuilder;", "operation", "Lcom/intellij/microservices/oas/OasOperation;", "path", "components", "Lcom/intellij/microservices/oas/OasComponents;", "Body", "MethodBuilder", "Parameter", "intellij.javascript.langInjection"})
@SourceDebugExtension(value={"SMAP\nFetchClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchClientGenerator.kt\ncom/intellij/javascript/microservices/client/generator/FetchClientGenerator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,176:1\n1360#2:177\n1446#2,2:178\n1549#2:180\n1620#2,3:181\n1448#2,3:184\n1549#2:188\n1620#2,3:189\n1#3:187\n*S KotlinDebug\n*F\n+ 1 FetchClientGenerator.kt\ncom/intellij/javascript/microservices/client/generator/FetchClientGenerator\n*L\n18#1:177\n18#1:178,2\n19#1:180\n19#1:181,3\n18#1:184,3\n63#1:188\n63#1:189,3\n*E\n"})
public final class FetchClientGenerator
implements ClientGenerator {
    @NotNull
    public String getTitle() {
        String string = JavaScriptBundle.message("fetch.client.generator.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ClientExample generate(@NotNull Project project, @NotNull OpenApiSpecification openApiSpecification) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        Iterable $this$flatMap$iv = openApiSpecification.getPaths();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            OasEndpointPath path2 = (OasEndpointPath)element$iv$iv;
            boolean bl = false;
            Iterable $this$map$iv = path2.getOperations();
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                OasOperation oasOperation = (OasOperation)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(this.generateMethodByOperation((OasOperation)it, path2.getPath(), openApiSpecification.getComponents()));
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List methods2 = (List)destination$iv$iv;
        FetchClientGeneratorKt.access$uniqMethodName(methods2);
        String text2 = CollectionsKt.joinToString$default((Iterable)methods2, (CharSequence)"\n\n", null, null, (int)0, null, (Function1)((Function1)new Function1<MethodBuilder, CharSequence>(this, project){
            final /* synthetic */ FetchClientGenerator this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            @NotNull
            public final CharSequence invoke(@NotNull MethodBuilder it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return FetchClientGenerator.access$clientFromTemplate(this.this$0, it.build(), this.$project);
            }
        }), (int)30, null);
        return ClientExample.Companion.fromFileExtension(text2, "js");
    }

    private final String clientFromTemplate(Map<String, ? extends Object> properties, Project project) {
        FileTemplate template;
        FileTemplate fileTemplate = FileTemplateManager.getInstance((Project)project).getCodeTemplate("JavaScriptFetch.js");
        Intrinsics.checkNotNullExpressionValue((Object)fileTemplate, (String)"getCodeTemplate(...)");
        FileTemplate $this$clientFromTemplate_u24lambda_u242 = template = fileTemplate;
        boolean bl = false;
        $this$clientFromTemplate_u24lambda_u242.setReformatCode(true);
        String string = $this$clientFromTemplate_u24lambda_u242.getText(properties);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"run(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final MethodBuilder generateMethodByOperation(OasOperation operation, String path2, OasComponents components) {
        MethodBuilder builder2;
        block12: {
            String string = operation.getMethod().getMethodName().toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toUpperCase(...)");
            String method = string;
            String methodName = FetchClientGeneratorKt.access$getNameByOperationOrPath(operation);
            builder2 = new MethodBuilder(methodName, method, null, path2, 4, null);
            for (OasParameter parameter : operation.getParameters()) {
                Parameter p = new Parameter(parameter.getName(), null, 2, null);
                switch (WhenMappings.$EnumSwitchMapping$0[parameter.getInPlace().ordinal()]) {
                    case 1: {
                        builder2.getPathParams().add(p);
                        break;
                    }
                    case 2: {
                        builder2.getQueryParams().add(p);
                        break;
                    }
                    case 3: {
                        builder2.getHeaders().add(p);
                        break;
                    }
                    case 4: {
                        builder2.getCookies().add(p);
                    }
                }
            }
            Object object = operation.getRequestBody();
            if (object == null || (object = object.getContent()) == null || (object = object.entrySet()) == null || (object = (Map.Entry)CollectionsKt.singleOrNull((Iterable)((Iterable)object))) == null) break block12;
            Object object2 = object;
            boolean bl = false;
            String contentType = (String)object2.getKey();
            OasSchema body2 = (OasSchema)object2.getValue();
            builder2.setContentType(new Parameter("Content-Type", "'" + contentType + "'"));
            OasSchema oasSchema = FetchClientGeneratorKt.access$getRealSchema(body2, components);
            if (oasSchema != null) {
                List list2;
                List list3;
                OasSchema realSchema = oasSchema;
                List list4 = realSchema.getProperties();
                if (list4 != null) {
                    void $this$mapTo$iv$iv;
                    Iterable $this$map$iv = list4;
                    boolean $i$f$map = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        OasProperty oasProperty = (OasProperty)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl2 = false;
                        collection.add(new Parameter(it.getName(), null, 2, null));
                    }
                    list3 = (List)destination$iv$iv;
                } else {
                    list3 = list2 = null;
                }
                if (list3 == null) {
                    list2 = CollectionsKt.emptyList();
                }
                List properties = list2;
                builder2.setBody(new Body(contentType, properties));
            }
        }
        return builder2;
    }

    public static final /* synthetic */ String access$clientFromTemplate(FetchClientGenerator $this, Map properties, Project project) {
        return $this.clientFromTemplate(properties, project);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\b\u0010\u0014\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Body;", "", "contentType", "", "properties", "", "Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Parameter;", "(Ljava/lang/String;Ljava/util/List;)V", "getContentType", "()Ljava/lang/String;", "getProperties", "()Ljava/util/List;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javascript.langInjection"})
    public static final class Body {
        @NotNull
        private final String contentType;
        @NotNull
        private final List<Parameter> properties;

        public Body(@NotNull String contentType, @NotNull List<Parameter> properties) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            this.contentType = contentType;
            this.properties = properties;
        }

        @NotNull
        public final String getContentType() {
            return this.contentType;
        }

        @NotNull
        public final List<Parameter> getProperties() {
            return this.properties;
        }

        @NotNull
        public String toString() {
            return Intrinsics.areEqual((Object)this.contentType, (Object)"application/json") ? "JSON.stringify(body)" : "body";
        }

        @NotNull
        public final String component1() {
            return this.contentType;
        }

        @NotNull
        public final List<Parameter> component2() {
            return this.properties;
        }

        @NotNull
        public final Body copy(@NotNull String contentType, @NotNull List<Parameter> properties) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(properties, (String)"properties");
            return new Body(contentType, properties);
        }

        public static /* synthetic */ Body copy$default(Body body2, String string, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = body2.contentType;
            }
            if ((n & 2) != 0) {
                list2 = body2.properties;
            }
            return body2.copy(string, list2);
        }

        public int hashCode() {
            int result2 = this.contentType.hashCode();
            result2 = result2 * 31 + ((Object)this.properties).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Body)) {
                return false;
            }
            Body body2 = (Body)other;
            if (!Intrinsics.areEqual((Object)this.contentType, (Object)body2.contentType)) {
                return false;
            }
            return Intrinsics.areEqual(this.properties, body2.properties);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0013\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010(\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00010)J\n\u0010*\u001a\u0004\u0018\u00010\u000fH\u0002J\u000e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0,H\u0002J\b\u0010-\u001a\u00020\u0003H\u0002J\b\u0010.\u001a\u00020\u0003H\u0002J\b\u0010/\u001a\u00020\u0003H\u0002J\b\u00100\u001a\u00020\u0003H\u0002J\t\u00101\u001a\u00020\u0003H\u00c6\u0003J\t\u00102\u001a\u00020\u0003H\u00c6\u0003J\t\u00103\u001a\u00020\u0003H\u00c6\u0003J\t\u00104\u001a\u00020\u0003H\u00c6\u0003J1\u00105\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00109\u001a\u00020:H\u00d6\u0001J\t\u0010;\u001a\u00020\u0003H\u00d6\u0001R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001b\"\u0004\b\u001f\u0010\u001dR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u001b\"\u0004\b!\u0010\u001dR\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0017R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0017R\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001b\"\u0004\b'\u0010\u001d\u00a8\u0006<"}, d2={"Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$MethodBuilder;", "", "methodName", "", "method", "url", "path", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "body", "Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Body;", "getBody", "()Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Body;", "setBody", "(Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Body;)V", "contentType", "Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Parameter;", "getContentType", "()Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Parameter;", "setContentType", "(Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Parameter;)V", "cookies", "", "getCookies", "()Ljava/util/List;", "headers", "getHeaders", "getMethod", "()Ljava/lang/String;", "setMethod", "(Ljava/lang/String;)V", "getMethodName", "setMethodName", "getPath", "setPath", "pathParams", "getPathParams", "queryParams", "getQueryParams", "getUrl", "setUrl", "build", "", "buildCookies", "buildHeaders", "", "buildMethodParams", "buildPath", "buildQuery", "buildUrl", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javascript.langInjection"})
    @SourceDebugExtension(value={"SMAP\nFetchClientGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FetchClientGenerator.kt\ncom/intellij/javascript/microservices/client/generator/FetchClientGenerator$MethodBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,176:1\n1#2:177\n1620#3,3:178\n*S KotlinDebug\n*F\n+ 1 FetchClientGenerator.kt\ncom/intellij/javascript/microservices/client/generator/FetchClientGenerator$MethodBuilder\n*L\n116#1:178,3\n*E\n"})
    public static final class MethodBuilder {
        @NotNull
        private String methodName;
        @NotNull
        private String method;
        @NotNull
        private String url;
        @NotNull
        private String path;
        @NotNull
        private final List<Parameter> queryParams;
        @NotNull
        private final List<Parameter> pathParams;
        @NotNull
        private final List<Parameter> headers;
        @NotNull
        private final List<Parameter> cookies;
        @Nullable
        private Body body;
        @Nullable
        private Parameter contentType;

        public MethodBuilder(@NotNull String methodName, @NotNull String method, @NotNull String url, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.methodName = methodName;
            this.method = method;
            this.url = url;
            this.path = path2;
            this.queryParams = new ArrayList();
            this.pathParams = new ArrayList();
            this.headers = new ArrayList();
            this.cookies = new ArrayList();
        }

        public /* synthetic */ MethodBuilder(String string, String string2, String string3, String string4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                string3 = "http://localhost";
            }
            if ((n & 8) != 0) {
                string4 = "";
            }
            this(string, string2, string3, string4);
        }

        @NotNull
        public final String getMethodName() {
            return this.methodName;
        }

        public final void setMethodName(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.methodName = string;
        }

        @NotNull
        public final String getMethod() {
            return this.method;
        }

        public final void setMethod(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.method = string;
        }

        @NotNull
        public final String getUrl() {
            return this.url;
        }

        public final void setUrl(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.url = string;
        }

        @NotNull
        public final String getPath() {
            return this.path;
        }

        public final void setPath(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.path = string;
        }

        @NotNull
        public final List<Parameter> getQueryParams() {
            return this.queryParams;
        }

        @NotNull
        public final List<Parameter> getPathParams() {
            return this.pathParams;
        }

        @NotNull
        public final List<Parameter> getHeaders() {
            return this.headers;
        }

        @NotNull
        public final List<Parameter> getCookies() {
            return this.cookies;
        }

        @Nullable
        public final Body getBody() {
            return this.body;
        }

        public final void setBody(@Nullable Body body2) {
            this.body = body2;
        }

        @Nullable
        public final Parameter getContentType() {
            return this.contentType;
        }

        public final void setContentType(@Nullable Parameter parameter) {
            this.contentType = parameter;
        }

        private final Parameter buildCookies() {
            if (this.cookies.isEmpty()) {
                return null;
            }
            String c2 = CollectionsKt.joinToString$default((Iterable)this.cookies, (CharSequence)";", null, null, (int)0, null, (Function1)buildCookies.c.1.INSTANCE, (int)30, null);
            return new Parameter("Cookie", "'" + c2 + "'");
        }

        private final List<Parameter> buildHeaders() {
            UtilKt.addIfNotNull(this.headers, (Object)this.contentType);
            UtilKt.addIfNotNull(this.headers, (Object)this.buildCookies());
            return this.headers;
        }

        private final String buildQuery() {
            if (this.queryParams.isEmpty()) {
                return "";
            }
            String query2 = CollectionsKt.joinToString$default((Iterable)this.queryParams, (CharSequence)"&", null, null, (int)0, null, (Function1)buildQuery.query.1.INSTANCE, (int)30, null);
            return "&" + query2;
        }

        private final String buildPath() {
            String path2 = StringsKt.removePrefix((String)this.path, (CharSequence)"/");
            for (Parameter parameter : this.pathParams) {
                String httpName = parameter.component1();
                String name = parameter.component2();
                path2 = StringsKt.replace$default((String)path2, (String)("{" + httpName + "}"), (String)("${" + name + "}"), (boolean)false, (int)4, null);
            }
            return path2;
        }

        private final String buildUrl() {
            return this.url + "/" + this.buildPath() + this.buildQuery();
        }

        private final String buildMethodParams() {
            Set parameters;
            block2: {
                Set set;
                Set $this$buildMethodParams_u24lambda_u240 = set = (Set)new LinkedHashSet();
                boolean bl = false;
                MethodBuilder.buildMethodParams$addAll($this$buildMethodParams_u24lambda_u240, this.pathParams);
                MethodBuilder.buildMethodParams$addAll($this$buildMethodParams_u24lambda_u240, this.queryParams);
                MethodBuilder.buildMethodParams$addAll($this$buildMethodParams_u24lambda_u240, this.headers);
                MethodBuilder.buildMethodParams$addAll($this$buildMethodParams_u24lambda_u240, this.cookies);
                parameters = set;
                Body body2 = this.body;
                if (body2 == null) break block2;
                Body body3 = body2;
                boolean bl2 = false;
                List<Parameter> properties = body3.component2();
                if (properties.isEmpty()) {
                    parameters.add("body");
                } else {
                    MethodBuilder.buildMethodParams$addAll(parameters, properties);
                }
            }
            return CollectionsKt.joinToString$default((Iterable)parameters, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
        }

        @NotNull
        public final Map<String, Object> build() {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"PARAMETERS", (Object)this.buildMethodParams()), TuplesKt.to((Object)"HEADERS", this.buildHeaders()), TuplesKt.to((Object)"BODY", (Object)this.body), TuplesKt.to((Object)"METHOD_NAME", (Object)this.methodName), TuplesKt.to((Object)"METHOD", (Object)this.method), TuplesKt.to((Object)"URL", (Object)this.buildUrl())};
            return MapsKt.mapOf((Pair[])pairArray);
        }

        @NotNull
        public final String component1() {
            return this.methodName;
        }

        @NotNull
        public final String component2() {
            return this.method;
        }

        @NotNull
        public final String component3() {
            return this.url;
        }

        @NotNull
        public final String component4() {
            return this.path;
        }

        @NotNull
        public final MethodBuilder copy(@NotNull String methodName, @NotNull String method, @NotNull String url, @NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return new MethodBuilder(methodName, method, url, path2);
        }

        public static /* synthetic */ MethodBuilder copy$default(MethodBuilder methodBuilder, String string, String string2, String string3, String string4, int n, Object object) {
            if ((n & 1) != 0) {
                string = methodBuilder.methodName;
            }
            if ((n & 2) != 0) {
                string2 = methodBuilder.method;
            }
            if ((n & 4) != 0) {
                string3 = methodBuilder.url;
            }
            if ((n & 8) != 0) {
                string4 = methodBuilder.path;
            }
            return methodBuilder.copy(string, string2, string3, string4);
        }

        @NotNull
        public String toString() {
            return "MethodBuilder(methodName=" + this.methodName + ", method=" + this.method + ", url=" + this.url + ", path=" + this.path + ")";
        }

        public int hashCode() {
            int result2 = this.methodName.hashCode();
            result2 = result2 * 31 + this.method.hashCode();
            result2 = result2 * 31 + this.url.hashCode();
            result2 = result2 * 31 + this.path.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MethodBuilder)) {
                return false;
            }
            MethodBuilder methodBuilder = (MethodBuilder)other;
            if (!Intrinsics.areEqual((Object)this.methodName, (Object)methodBuilder.methodName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.method, (Object)methodBuilder.method)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.url, (Object)methodBuilder.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.path, (Object)methodBuilder.path);
        }

        /*
         * WARNING - void declaration
         */
        private static final Set<String> buildMethodParams$addAll(Set<String> $this$buildMethodParams_u24addAll, List<Parameter> p) {
            Iterable $this$mapTo$iv = p;
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void p0;
                Parameter parameter = (Parameter)item$iv;
                Collection collection = $this$buildMethodParams_u24addAll;
                boolean bl = false;
                collection.add(p0.getName());
            }
            return (Set)((Collection)$this$buildMethodParams_u24addAll);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/microservices/client/generator/FetchClientGenerator$Parameter;", "", "httpName", "", "name", "(Ljava/lang/String;Ljava/lang/String;)V", "getHttpName", "()Ljava/lang/String;", "getName", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.javascript.langInjection"})
    public static final class Parameter {
        @NotNull
        private final String httpName;
        @NotNull
        private final String name;

        public Parameter(@NotNull String httpName, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)httpName, (String)"httpName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.httpName = httpName;
            this.name = name;
        }

        public /* synthetic */ Parameter(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                string2 = FetchClientGeneratorKt.access$toValidName(string);
            }
            this(string, string2);
        }

        @NotNull
        public final String getHttpName() {
            return this.httpName;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String component1() {
            return this.httpName;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final Parameter copy(@NotNull String httpName, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)httpName, (String)"httpName");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new Parameter(httpName, name);
        }

        public static /* synthetic */ Parameter copy$default(Parameter parameter, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameter.httpName;
            }
            if ((n & 2) != 0) {
                string2 = parameter.name;
            }
            return parameter.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "Parameter(httpName=" + this.httpName + ", name=" + this.name + ")";
        }

        public int hashCode() {
            int result2 = this.httpName.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)other;
            if (!Intrinsics.areEqual((Object)this.httpName, (Object)parameter.httpName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.name, (Object)parameter.name);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OasParameterIn.values().length];
            try {
                nArray[OasParameterIn.PATH.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.QUERY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.HEADER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OasParameterIn.COOKIE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

