/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.microservices;

import com.intellij.javascript.microservices.HttpClientIndexingHandlerKt;
import com.intellij.javascript.microservices.JsRequestBodyDetectionKt;
import com.intellij.javascript.microservices.RequestBodyDeclaration;
import com.intellij.javascript.microservices.RequestBodyParentsWalker;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.microservices.url.references.UrlPathReference;
import com.intellij.microservices.utils.ReferenceResolveUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.UtilKt;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\t"}, d2={"detectJSObjectUrl", "Lcom/intellij/javascript/microservices/RequestBodyDeclaration;", "psiElement", "Lcom/intellij/psi/PsiElement;", "detectMethodCallUrl", "findBodyDeclarations", "Lkotlin/sequences/Sequence;", "findParameterUsages", "findRequestBodyDeclaration", "intellij.javascript.langInjection"})
@SourceDebugExtension(value={"SMAP\njsRequestBodyDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 jsRequestBodyDetection.kt\ncom/intellij/javascript/microservices/JsRequestBodyDetectionKt\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,102:1\n14#2:103\n14#2:105\n1#3:104\n66#4,2:106\n*S KotlinDebug\n*F\n+ 1 jsRequestBodyDetection.kt\ncom/intellij/javascript/microservices/JsRequestBodyDetectionKt\n*L\n26#1:103\n39#1:105\n49#1:106,2\n*E\n"})
public final class JsRequestBodyDetectionKt {
    @NotNull
    public static final Sequence<RequestBodyDeclaration> findBodyDeclarations(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        return SequencesKt.ifEmpty(JsRequestBodyDetectionKt.findParameterUsages(psiElement), (Function0)((Function0)new Function0<Sequence<? extends RequestBodyDeclaration>>(psiElement){
            final /* synthetic */ PsiElement $psiElement;
            {
                this.$psiElement = $psiElement;
                super(0);
            }

            @NotNull
            public final Sequence<RequestBodyDeclaration> invoke() {
                return UtilKt.sequenceOfNotNull((Object)JsRequestBodyDetectionKt.access$findRequestBodyDeclaration(this.$psiElement));
            }
        }));
    }

    private static final Sequence<RequestBodyDeclaration> findParameterUsages(PsiElement psiElement) {
        PsiElement psiElement2;
        PsiElement param;
        block9: {
            block8: {
                PsiElement callArgument = new RequestBodyParentsWalker(psiElement).findRootSkippingStringify();
                if (!(callArgument instanceof JSExpression)) {
                    return SequencesKt.emptySequence();
                }
                PsiElement psiElement3 = ((JSExpression)callArgument).getParent();
                JSArgumentList jSArgumentList = psiElement3 instanceof JSArgumentList ? (JSArgumentList)psiElement3 : null;
                if (jSArgumentList == null) {
                    return SequencesKt.emptySequence();
                }
                JSArgumentList parent = jSArgumentList;
                JSParameterItem jSParameterItem = JSResolveUtil.findParameterForUsedArgument((JSExpression)callArgument, parent);
                PsiElement psiElement4 = jSParameterItem instanceof PsiElement ? (PsiElement)jSParameterItem : null;
                if (psiElement4 == null) {
                    return SequencesKt.emptySequence();
                }
                param = psiElement4;
                psiElement2 = param.getParent();
                if (psiElement2 == null || (psiElement2 = psiElement2.getParent()) == null) break block8;
                PsiElement $this$asSafely$iv = psiElement2;
                boolean $i$f$asSafely = false;
                PsiElement psiElement5 = $this$asSafely$iv;
                if (!(psiElement5 instanceof JSFunction)) {
                    psiElement5 = null;
                }
                if ((psiElement2 = (JSFunction)psiElement5) != null) break block9;
            }
            return SequencesKt.emptySequence();
        }
        PsiElement jsFunction = psiElement2;
        if (!HttpClientIndexingHandlerKt.isHttpCallingFunction((JSFunction)jsFunction)) {
            return SequencesKt.emptySequence();
        }
        Collection collection = ReferencesSearch.search((PsiElement)param, (SearchScope)param.getUseScope()).findAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findAll(...)");
        Collection findAll = collection;
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)findAll), (Function1)findParameterUsages.1.INSTANCE);
    }

    private static final RequestBodyDeclaration findRequestBodyDeclaration(PsiElement psiElement) {
        RequestBodyDeclaration requestBodyDeclaration;
        block1: {
            Object[] objectArray = new KFunction[]{findRequestBodyDeclaration.1.INSTANCE, findRequestBodyDeclaration.2.INSTANCE};
            for (KFunction it : (Iterable)CollectionsKt.listOf((Object[])objectArray)) {
                boolean bl = false;
                RequestBodyDeclaration requestBodyDeclaration2 = (RequestBodyDeclaration)((Function1)it).invoke((Object)psiElement);
                if (requestBodyDeclaration2 == null) continue;
                requestBodyDeclaration = requestBodyDeclaration2;
                break block1;
            }
            requestBodyDeclaration = null;
        }
        return requestBodyDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private static final RequestBodyDeclaration detectJSObjectUrl(PsiElement psiElement) {
        UrlPathReference urlPathReference2;
        RequestBodyParentsWalker parentsWalker;
        block6: {
            block5: {
                JSExpression jSExpression;
                JSObjectLiteralExpression jSObjectLiteralExpression;
                void $this$asSafely$iv;
                parentsWalker = new RequestBodyParentsWalker(psiElement);
                Object object = parentsWalker.findRootSkippingStringify();
                boolean $i$f$asSafely = false;
                Object v0 = $this$asSafely$iv;
                if (!(v0 instanceof JSObjectLiteralExpression)) {
                    v0 = null;
                }
                if ((jSObjectLiteralExpression = (JSObjectLiteralExpression)v0) == null || (object = jSObjectLiteralExpression.findProperty("url")) == null || (jSExpression = object.getValue()) == null) break block5;
                JSExpression it = jSExpression;
                boolean bl = false;
                urlPathReference2 = ReferenceResolveUtilsKt.getLastUrlPathReference((PsiElement)((PsiElement)it));
                if (urlPathReference2 != null) break block6;
            }
            return null;
        }
        UrlPathReference urlPathReference3 = urlPathReference2;
        List list2 = parentsWalker.getAdditionalSchemaContext();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return new RequestBodyDeclaration(urlPathReference3, list2);
    }

    /*
     * WARNING - void declaration
     */
    private static final RequestBodyDeclaration detectMethodCallUrl(PsiElement psiElement) {
        void $this$parentOfType_u24default$iv;
        RequestBodyParentsWalker parentsWalker = new RequestBodyParentsWalker(psiElement);
        Object[] objectArray = parentsWalker.findRootSkippingStringify();
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        JSCallExpression jSCallExpression = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, JSCallExpression.class, (boolean)true);
        Sequence sequence = jSCallExpression != null && (objectArray = jSCallExpression.getArguments()) != null ? ArraysKt.asSequence((Object[])objectArray) : null;
        if (sequence == null) {
            sequence = SequencesKt.emptySequence();
        }
        UrlPathReference urlPathReference2 = (UrlPathReference)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)sequence, (Function1)detectMethodCallUrl.urlPathReference.1.INSTANCE));
        if (urlPathReference2 == null) {
            return null;
        }
        UrlPathReference urlPathReference3 = urlPathReference2;
        List list2 = parentsWalker.getAdditionalSchemaContext();
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return new RequestBodyDeclaration(urlPathReference3, list2);
    }

    public static final /* synthetic */ RequestBodyDeclaration access$findRequestBodyDeclaration(PsiElement psiElement) {
        return JsRequestBodyDetectionKt.findRequestBodyDeclaration(psiElement);
    }

    public static final /* synthetic */ RequestBodyDeclaration access$detectJSObjectUrl(PsiElement psiElement) {
        return JsRequestBodyDetectionKt.detectJSObjectUrl(psiElement);
    }

    public static final /* synthetic */ RequestBodyDeclaration access$detectMethodCallUrl(PsiElement psiElement) {
        return JsRequestBodyDetectionKt.detectMethodCallUrl(psiElement);
    }
}

