/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.javascript.jest.JestPackage;
import com.intellij.javascript.jest.JestRunConfiguration;
import com.intellij.javascript.jest.JestRunConfigurationEditor;
import com.intellij.javascript.jest.JestRunConfigurationProducer;
import com.intellij.javascript.jest.JestRunSettings;
import com.intellij.javascript.jest.JestUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.testing.runScope.JsTestRunScopeComponent;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.PopupMenuListenerAdapter;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.text.StringKt;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.ui.UIUtil;
import com.intellij.webcore.ui.PathShortener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.ComboBoxEditor;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationEditor;", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/javascript/jest/JestRunConfiguration;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "configPathTextFieldWithBrowseButton", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "interpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "jestOptionsEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "jestPackageField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "nodeOptionsEditor", "panel", "Ljavax/swing/JPanel;", "scopeComponent", "Lcom/intellij/javascript/testing/runScope/JsTestRunScopeComponent;", "workingDirComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "applyEditorTo", "", "runConfiguration", "createEditor", "Ljavax/swing/JComponent;", "resetEditorFrom", "Companion", "intellij.javascript.impl"})
public final class JestRunConfigurationEditor
extends SettingsEditor<JestRunConfiguration> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final TextFieldWithHistoryWithBrowseButton configPathTextFieldWithBrowseButton;
    @NotNull
    private final NodeJsInterpreterField interpreterField;
    @NotNull
    private final RawCommandLineEditor nodeOptionsEditor;
    @NotNull
    private final NodePackageField jestPackageField;
    @NotNull
    private final TextFieldWithBrowseButton workingDirComponent;
    @NotNull
    private final RawCommandLineEditor jestOptionsEditor;
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;
    @NotNull
    private final JsTestRunScopeComponent scopeComponent;
    @NotNull
    private final JPanel panel;

    public JestRunConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.interpreterField = new NodeJsInterpreterField(project);
        RawCommandLineEditor rawCommandLineEditor = new RawCommandLineEditor().withMonospaced(false);
        Intrinsics.checkNotNullExpressionValue((Object)rawCommandLineEditor, (String)"withMonospaced(...)");
        this.nodeOptionsEditor = rawCommandLineEditor;
        this.workingDirComponent = JestRunConfigurationEditor.Companion.createWorkingDirComponent(project);
        JTextField jTextField = this.workingDirComponent.getTextField();
        Intrinsics.checkNotNullExpressionValue((Object)jTextField, (String)"getTextField(...)");
        this.configPathTextFieldWithBrowseButton = JestRunConfigurationEditor.Companion.createConfigurationFileTextField(project, jTextField);
        PathShortener.enablePathShortening((JTextField)((TextFieldWithHistory)this.configPathTextFieldWithBrowseButton.getChildComponent()).getTextEditor(), null);
        PathShortener.enablePathShortening((JTextField)this.workingDirComponent.getTextField(), null);
        this.jestPackageField = new NodePackageField(this.interpreterField, JestPackage.INSTANCE.getDescriptor(), () -> JestRunConfigurationEditor._init_$lambda$1(this));
        this.jestOptionsEditor = JestRunConfigurationEditor.Companion.createJestOptionsEditor();
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        int longestLabelWidth = new JLabel((String)UIUtil.removeMnemonic((String)JavaScriptBundle.message((String)"rc.environmentVariables.label", (Object[])new Object[0]))).getPreferredSize().width;
        this.scopeComponent = new JsTestRunScopeComponent(project, longestLabelWidth, true);
        JPanel jPanel = new FormBuilder().setAlignLabelOnRight(false).addLabeledComponent(JavaScriptBundle.message("jest.rc.configurationFile.label", new Object[0]), (JComponent)this.configPathTextFieldWithBrowseButton).addSeparator(8).addLabeledComponent(NodeJsInterpreterField.getLabelTextForComponent(), (JComponent)((Object)this.interpreterField), 8).addLabeledComponent(JavaScriptBundle.message("rc.nodeOptions.label", new Object[0]), (JComponent)this.nodeOptionsEditor).addLabeledComponent(JavaScriptBundle.message("jest.rc.jestPackageField.label", new Object[0]), (JComponent)((Object)this.jestPackageField)).addLabeledComponent(JavaScriptBundle.message("rc.workingDirectory.label", new Object[0]), (JComponent)this.workingDirComponent).addLabeledComponent(JavaScriptBundle.message("jest.rc.jestOptions.label", new Object[0]), (JComponent)this.jestOptionsEditor).addLabeledComponent(JavaScriptBundle.message("rc.environmentVariables.label", new Object[0]), (JComponent)this.envVarsComponent).addSeparator(8).addComponent(this.scopeComponent.getComponent()).getPanel();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"getPanel(...)");
        this.panel = jPanel;
    }

    protected void resetEditorFrom(@NotNull JestRunConfiguration runConfiguration) {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        JestRunSettings jestRunSettings = runConfiguration.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)jestRunSettings, (String)"getRunSettings(...)");
        JestRunSettings runSettings = jestRunSettings;
        this.configPathTextFieldWithBrowseButton.setTextAndAddToHistory(runSettings.getConfigFileSystemDependentPath());
        this.interpreterField.setInterpreterRef(runSettings.getInterpreterRef());
        this.nodeOptionsEditor.setText(runSettings.getNodeOptions());
        this.jestPackageField.setSelected(runConfiguration.getJestPackage());
        this.workingDirComponent.setText(runSettings.getWorkingDirSystemDependentPath());
        this.jestOptionsEditor.setText(runSettings.getJestOptions());
        this.envVarsComponent.setData(runSettings.getEnvData());
        this.scopeComponent.resetEditorFrom(runSettings.getScope());
    }

    protected void applyEditorTo(@NotNull JestRunConfiguration runConfiguration) throws ConfigurationException {
        Intrinsics.checkNotNullParameter((Object)runConfiguration, (String)"runConfiguration");
        JestRunSettings.Builder builder2 = new JestRunSettings.Builder(null, null, null, null, null, null, null, null, 255, null);
        String string = PathShortener.getAbsolutePath((JTextField)((TextFieldWithHistory)this.configPathTextFieldWithBrowseButton.getChildComponent()).getTextEditor());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        builder2.setConfigFilePath$intellij_javascript_impl(string);
        NodeJsInterpreterRef nodeJsInterpreterRef = this.interpreterField.getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        builder2.setInterpreterRef$intellij_javascript_impl(nodeJsInterpreterRef);
        String string2 = this.nodeOptionsEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        builder2.setNodeOptions(string2);
        builder2.setJestPackage$intellij_javascript_impl(this.jestPackageField.getSelected());
        String string3 = PathShortener.getAbsolutePath((JTextField)this.workingDirComponent.getTextField());
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        builder2.setWorkingDir$intellij_javascript_impl(string3);
        String string4 = this.jestOptionsEditor.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
        builder2.setJestOptions$intellij_javascript_impl(string4);
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getData(...)");
        builder2.setEnvData$intellij_javascript_impl(environmentVariablesData);
        builder2.setScope(this.scopeComponent.getScope());
        runConfiguration.setRunSettings(builder2.build());
    }

    @NotNull
    protected JComponent createEditor() {
        return this.panel;
    }

    private static final VirtualFile _init_$lambda$1(JestRunConfigurationEditor this$0) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        String string = StringKt.nullize((String)PathShortener.getAbsolutePath((JTextField)this$0.workingDirComponent.getTextField()), (boolean)true);
        if (string != null) {
            String it = string;
            boolean bl = false;
            virtualFile = LocalFileSystem.getInstance().findFileByPath(it);
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/jest/JestRunConfigurationEditor$Companion;", "", "()V", "createConfigurationFileTextField", "Lcom/intellij/ui/TextFieldWithHistoryWithBrowseButton;", "project", "Lcom/intellij/openapi/project/Project;", "workingDir", "Ljavax/swing/JTextField;", "createJestOptionsEditor", "Lcom/intellij/ui/RawCommandLineEditor;", "createWorkingDirComponent", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "inferJestConfigByWorkingDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "workingDirectory", "", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nJestRunConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JestRunConfigurationEditor.kt\ncom/intellij/javascript/jest/JestRunConfigurationEditor$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n1549#2:197\n1620#2,3:198\n*S KotlinDebug\n*F\n+ 1 JestRunConfigurationEditor.kt\ncom/intellij/javascript/jest/JestRunConfigurationEditor$Companion\n*L\n120#1:197\n120#1:198,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final RawCommandLineEditor createJestOptionsEditor() {
            RawCommandLineEditor rawCommandLineEditor;
            RawCommandLineEditor rawCommandLineEditor2 = new RawCommandLineEditor().withMonospaced(false);
            Intrinsics.checkNotNullExpressionValue((Object)rawCommandLineEditor2, (String)"withMonospaced(...)");
            RawCommandLineEditor it = rawCommandLineEditor = rawCommandLineEditor2;
            boolean bl = false;
            it.getEditorField().getEmptyText().setText(JavaScriptBundle.message("jest.rc.jestOptions.emptyText", new Object[0]));
            return rawCommandLineEditor;
        }

        private final TextFieldWithHistoryWithBrowseButton createConfigurationFileTextField(Project project, JTextField workingDir2) {
            TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = new TextFieldWithHistoryWithBrowseButton();
            JComponent jComponent = textFieldWithHistoryWithBrowseButton.getChildComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getChildComponent(...)");
            TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)jComponent;
            textFieldWithHistory.setHistorySize(-1);
            textFieldWithHistory.setMinimumAndPreferredWidth(0);
            PathShortener.enablePathShortening((JTextField)textFieldWithHistory.getTextEditor(), null);
            SwingHelper.addHistoryOnExpansion((TextFieldWithHistory)textFieldWithHistory, () -> Companion.createConfigurationFileTextField$lambda$2(project));
            SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithHistoryWithBrowseButton)textFieldWithHistoryWithBrowseButton, (String)JavaScriptBundle.message("jest.rc.configurationFile.title", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor());
            textFieldWithHistory.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(textFieldWithHistory){
                @Nullable
                private String lastAddedText;
                final /* synthetic */ TextFieldWithHistory $textFieldWithHistory;
                {
                    this.$textFieldWithHistory = $textFieldWithHistory;
                }

                public void popupMenuWillBecomeVisible(@NotNull PopupMenuEvent e) {
                    List result2;
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    String currentText = this.$textFieldWithHistory.getText();
                    if (currentText == null || Intrinsics.areEqual((Object)currentText, (Object)this.lastAddedText)) {
                        return;
                    }
                    List oldHistory = this.$textFieldWithHistory.getHistory();
                    Set newHistory = new HashSet<E>(oldHistory);
                    Collection collection = newHistory;
                    String string = this.lastAddedText;
                    TypeIntrinsics.asMutableCollection((Object)collection).remove(string);
                    this.lastAddedText = null;
                    if (!oldHistory.contains(currentText)) {
                        newHistory.add(currentText);
                        this.lastAddedText = currentText;
                    }
                    if (!Intrinsics.areEqual((Object)(result2 = CollectionsKt.sorted((Iterable)newHistory)), (Object)oldHistory)) {
                        this.$textFieldWithHistory.setHistory(result2);
                        this.$textFieldWithHistory.setSelectedItem((Object)currentText);
                    }
                }
            });
            ((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).setEditor((ComboBoxEditor)new BasicComboBoxEditor(workingDir2, project){
                final /* synthetic */ JTextField $workingDir;
                final /* synthetic */ Project $project;
                {
                    this.$workingDir = $workingDir;
                    this.$project = $project;
                }

                @NotNull
                protected JTextField createEditorComponent() {
                    JBTextField field = new JBTextField();
                    this.$workingDir.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(this.$project, this.$workingDir, field){
                        final /* synthetic */ Project $project;
                        final /* synthetic */ JTextField $workingDir;
                        final /* synthetic */ JBTextField $field;
                        {
                            this.$project = $project;
                            this.$workingDir = $workingDir;
                            this.$field = $field;
                        }

                        protected void textChanged(@NotNull DocumentEvent e) {
                            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                            ModalityState modalityState = ModalityState.current();
                            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"current(...)");
                            ModalityState modalityState2 = modalityState;
                            ApplicationManager.getApplication().executeOnPooledThread(() -> createConfigurationFileTextField.createEditorComponent.1.textChanged$lambda$3(this.$project, this.$workingDir, modalityState2, this.$field));
                        }

                        private static final void textChanged$lambda$3$lambda$2$lambda$1$lambda$0(JBTextField $field, VirtualFile $it) {
                            Intrinsics.checkNotNullParameter((Object)$field, (String)"$field");
                            Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
                            $field.getEmptyText().setText(FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)$it.getPath()), (boolean)false));
                        }

                        private static final void textChanged$lambda$3$lambda$2(Project $project, JTextField $workingDir, ModalityState $modalityState, JBTextField $field) {
                            block0: {
                                Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                                Intrinsics.checkNotNullParameter((Object)$workingDir, (String)"$workingDir");
                                Intrinsics.checkNotNullParameter((Object)$modalityState, (String)"$modalityState");
                                Intrinsics.checkNotNullParameter((Object)$field, (String)"$field");
                                String string = PathShortener.getAbsolutePath((JTextField)$workingDir);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
                                VirtualFile virtualFile = com.intellij.javascript.jest.JestRunConfigurationEditor$Companion.access$inferJestConfigByWorkingDir(JestRunConfigurationEditor.Companion, $project, string);
                                if (virtualFile == null) break block0;
                                VirtualFile it = virtualFile;
                                boolean bl = false;
                                ApplicationManager.getApplication().invokeLater(() -> createConfigurationFileTextField.createEditorComponent.1.textChanged$lambda$3$lambda$2$lambda$1$lambda$0($field, it), $modalityState);
                            }
                        }

                        private static final void textChanged$lambda$3(Project $project, JTextField $workingDir, ModalityState $modalityState, JBTextField $field) {
                            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
                            Intrinsics.checkNotNullParameter((Object)$workingDir, (String)"$workingDir");
                            Intrinsics.checkNotNullParameter((Object)$modalityState, (String)"$modalityState");
                            Intrinsics.checkNotNullParameter((Object)$field, (String)"$field");
                            ReadAction.run(() -> createConfigurationFileTextField.createEditorComponent.1.textChanged$lambda$3$lambda$2($project, $workingDir, $modalityState, $field));
                        }
                    });
                    return (JTextField)field;
                }
            });
            return textFieldWithHistoryWithBrowseButton;
        }

        private final VirtualFile inferJestConfigByWorkingDir(Project project, String workingDirectory) {
            VirtualFile guessedWorkingDir;
            if (((CharSequence)workingDirectory).length() == 0) {
                return null;
            }
            VirtualFile workingDir2 = LocalFileSystem.getInstance().findFileByPath(workingDirectory);
            if (workingDir2 == null || !workingDir2.isDirectory()) {
                return null;
            }
            RunConfigurationProducer runConfigurationProducer = RunConfigurationProducer.getInstance(JestRunConfigurationProducer.class);
            Intrinsics.checkNotNullExpressionValue((Object)runConfigurationProducer, (String)"getInstance(...)");
            JestRunConfigurationProducer producer = (JestRunConfigurationProducer)runConfigurationProducer;
            VirtualFile virtualFile = guessedWorkingDir = producer.guessWorkingDir(project, workingDir2);
            return virtualFile != null ? JestRunConfigurationProducer.Companion.findDefaultConfigFile(virtualFile) : null;
        }

        private final TextFieldWithBrowseButton createWorkingDirComponent(Project project) {
            TextFieldWithBrowseButton textFieldWithBrowseButton = new TextFieldWithBrowseButton();
            SwingHelper.installFileCompletionAndBrowseDialog((Project)project, (TextFieldWithBrowseButton)textFieldWithBrowseButton, (String)JavaScriptBundle.message("rc.workingDirectory.browseDialogTitle", new Object[0]), (FileChooserDescriptor)FileChooserDescriptorFactory.createSingleFolderDescriptor());
            return textFieldWithBrowseButton;
        }

        /*
         * WARNING - void declaration
         */
        private static final List createConfigurationFileTextField$lambda$2(Project $project) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
            List<VirtualFile> list2 = JestUtil.listPossibleConfigFilesInProject($project);
            Intrinsics.checkNotNullExpressionValue(list2, (String)"listPossibleConfigFilesInProject(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                VirtualFile virtualFile = (VirtualFile)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(FileUtil.getLocationRelativeToUserHome((String)FileUtil.toSystemDependentName((String)it.getPath()), (boolean)false));
            }
            return CollectionsKt.sorted((Iterable)((List)destination$iv$iv));
        }

        public static final /* synthetic */ VirtualFile access$inferJestConfigByWorkingDir(Companion $this, Project project, String workingDirectory) {
            return $this.inferJestConfigByWorkingDir(project, workingDirectory);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

