/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.javascript.JSRunConfigurationBuilder;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import java.util.Map;

public final class CreateRunConfigurationUtil {
    private static final String DEBUG_APPLICATION = "Debug Application";
    private static final String LOCALHOST = "http://localhost:";
    private static final String RUN_SCRIPT = "run-script";
    private static final String URI = "uri";
    private static final String JSDEBUG = "jsdebug";
    private static final String NPM = "npm";

    public static void npmConfiguration(Project project, String scriptName) {
        RunManager runManager = RunManager.getInstance((Project)project);
        VirtualFile pkg = PackageJsonUtil.findChildPackageJsonFile(project.getBaseDir());
        if (pkg != null) {
            RunnerAndConfigurationSettings startConfiguration = new NpmRunConfigurationBuilder(project).createRunConfiguration("npm " + scriptName, null, pkg.getPath(), Map.of(RUN_SCRIPT, scriptName));
            runManager.setSelectedConfiguration(startConfiguration);
        }
    }

    public static void debugConfiguration(Project project, int port) {
        RunManager runManager = RunManager.getInstance((Project)project);
        ObjectUtils.doIfNotNull((Object)JSRunConfigurationBuilder.getForName(JSDEBUG, project), builder2 -> (RunnerAndConfigurationSettings)ObjectUtils.notNull(null, () -> {
            RunnerAndConfigurationSettings settings2 = builder2.createRunConfiguration(DEBUG_APPLICATION, project.getBaseDir(), null, Map.of(URI, LOCALHOST + port));
            runManager.setSelectedConfiguration(settings2);
            return settings2;
        }));
    }
}

