/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.aqua.runners.playwright.js.duration;

import com.intellij.aqua.runners.playwright.js.duration.LineDurationInfo;
import com.intellij.aqua.runners.playwright.js.duration.TestStepDurationRenderer;
import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.LazyRangeMarkerFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.serviceContainer.AlreadyDisposedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0001\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u000e\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000bJ\u0006\u0010\u0014\u001a\u00020\u000eR\u0013\u0010\u0005\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR)\u0010\t\u001a\u001d\u0012\t\u0012\u00070\u000b\u00a2\u0006\u0002\b\u0006\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u00060\n\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "lifetime", "Lorg/jetbrains/annotations/NotNull;", "getProject", "()Lcom/intellij/openapi/project/Project;", "testFileInlays", "Ljava/util/concurrent/ConcurrentMap;", "", "Lcom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$FileInlays;", "addDurationInlay", "", "lineDurationInfo", "Lcom/intellij/aqua/runners/playwright/js/duration/LineDurationInfo;", "dispose", "removeInlaysForTestFile", "filePath", "removeInlaysForTestFiles", "FileInlays", "FileRenameAndRemoveHandler", "TestDurationInlayServiceFileListenerInstaller", "intellij.aqua.runners.playwright.js"})
@SourceDebugExtension(value={"SMAP\nTestDurationInlayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestDurationInlayService.kt\ncom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,132:1\n72#2,2:133\n1#3:135\n*S KotlinDebug\n*F\n+ 1 TestDurationInlayService.kt\ncom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService\n*L\n37#1:133,2\n37#1:135\n*E\n"})
public final class TestDurationInlayService
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final Disposable lifetime;
    @NotNull
    private final ConcurrentMap<String, FileInlays> testFileInlays;

    public TestDurationInlayService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this.lifetime = disposable;
        ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
        Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
        this.testFileInlays = concurrentMap;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    public final void addDurationInlay(@NotNull LineDurationInfo lineDurationInfo) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)lineDurationInfo, (String)"lineDurationInfo");
        ConcurrentMap<String, FileInlays> concurrentMap = this.testFileInlays;
        String key$iv = lineDurationInfo.getFilePath();
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            FileInlays default$iv = new FileInlays(this.project, this.lifetime);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrPut(...)");
        FileInlays fileInlays = (FileInlays)object;
        fileInlays.addDurationInlay(lineDurationInfo);
    }

    public final void removeInlaysForTestFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this, filePath){
            final /* synthetic */ TestDurationInlayService this$0;
            final /* synthetic */ String $filePath;
            {
                this.this$0 = $receiver;
                this.$filePath = $filePath;
                super(0);
            }

            public final void invoke() {
                block0: {
                    FileInlays fileInlays = (FileInlays)TestDurationInlayService.access$getTestFileInlays$p(this.this$0).remove(this.$filePath);
                    if (fileInlays == null) break block0;
                    FileInlays it = fileInlays;
                    boolean bl = false;
                    Disposer.dispose((Disposable)it);
                }
            }
        }), (int)1, null);
    }

    public final void removeInlaysForTestFiles() {
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ TestDurationInlayService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$forEach$iv;
                Iterable iterable = CollectionsKt.toList((Iterable)TestDurationInlayService.access$getTestFileInlays$p(this.this$0).keySet());
                TestDurationInlayService testDurationInlayService = this.this$0;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    String filePath = (String)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)filePath);
                    testDurationInlayService.removeInlaysForTestFile(filePath);
                }
            }
        }), (int)1, null);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.lifetime);
    }

    public static final /* synthetic */ ConcurrentMap access$getTestFileInlays$p(TestDurationInlayService $this) {
        return $this.testFileInlays;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u00020\u0014H\u0016J\u0010\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016R;\u0010\u0007\u001a/\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000b\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$FileInlays;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "addedInlays", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/NotNull;", "", "", "Lcom/intellij/openapi/editor/Inlay;", "Lcom/intellij/aqua/runners/playwright/js/duration/TestStepDurationRenderer;", "fileInlaysLifetime", "Lcom/intellij/openapi/util/CheckedDisposable;", "getProject", "()Lcom/intellij/openapi/project/Project;", "addDurationInlay", "", "testStepDurationInfo", "Lcom/intellij/aqua/runners/playwright/js/duration/LineDurationInfo;", "dispose", "editorReleased", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "intellij.aqua.runners.playwright.js"})
    @SourceDebugExtension(value={"SMAP\nTestDurationInlayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestDurationInlayService.kt\ncom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$FileInlays\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 5 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n*L\n1#1,132:1\n1855#2,2:133\n1855#2:139\n1856#2:143\n1#3:135\n1#3:142\n3792#4:136\n4307#4,2:137\n72#5,2:140\n*S KotlinDebug\n*F\n+ 1 TestDurationInlayService.kt\ncom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$FileInlays\n*L\n98#1:133,2\n112#1:139\n112#1:143\n121#1:142\n111#1:136\n111#1:137,2\n121#1:140,2\n*E\n"})
    private static final class FileInlays
    implements EditorFactoryListener,
    Disposable {
        @NotNull
        private final Project project;
        @NotNull
        private final CheckedDisposable fileInlaysLifetime;
        @NotNull
        private final ConcurrentMap<Editor, Map<Integer, Inlay<TestStepDurationRenderer>>> addedInlays;

        public FileInlays(@NotNull Project project, @NotNull Disposable parentDisposable) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
            this.project = project;
            CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable((Disposable)parentDisposable);
            Intrinsics.checkNotNullExpressionValue((Object)checkedDisposable, (String)"newCheckedDisposable(...)");
            this.fileInlaysLifetime = checkedDisposable;
            ConcurrentMap concurrentMap = ConcurrentCollectionFactory.createConcurrentMap();
            Intrinsics.checkNotNullExpressionValue((Object)concurrentMap, (String)"createConcurrentMap(...)");
            this.addedInlays = concurrentMap;
            Disposer.register((Disposable)parentDisposable, () -> FileInlays._init_$lambda$0(this));
            EditorFactory.getInstance().addEditorFactoryListener((EditorFactoryListener)this, (Disposable)this.fileInlaysLifetime);
        }

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        public void editorReleased(@NotNull EditorFactoryEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Map map = (Map)this.addedInlays.remove(event.getEditor());
                if (map == null) break block1;
                Map lineInlays = map;
                boolean bl = false;
                Iterable $this$forEach$iv = lineInlays.values();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Inlay it = (Inlay)element$iv;
                    boolean bl2 = false;
                    Disposer.dispose((Disposable)((Disposable)it));
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void addDurationInlay(@NotNull LineDurationInfo testStepDurationInfo) {
            void $this$forEach$iv;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            Object object;
            block11: {
                block10: {
                    Intrinsics.checkNotNullParameter((Object)testStepDurationInfo, (String)"testStepDurationInfo");
                    if (this.fileInlaysLifetime.isDisposed()) {
                        throw new AlreadyDisposedException("Failed to add test duration inlay. Inlays container already disposed.");
                    }
                    object = testStepDurationInfo.getDuration();
                    if (object == null) break block10;
                    long it = ((Number)object).longValue();
                    boolean bl = false;
                    String string = "- " + NlsMessages.formatDurationApproximate((long)it);
                    object = string;
                    if (string != null) break block11;
                }
                object = "- ...";
            }
            Object inlayText = object;
            LazyRangeMarkerFactory lineMarkerFactory = LazyRangeMarkerFactory.getInstance((Project)this.project);
            Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
            Object[] objectArray = editorArray;
            boolean $i$f$filter = false;
            void it = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (void element$iv$iv : $this$filterTo$iv$iv) {
                Editor it2 = (Editor)element$iv$iv;
                boolean bl = false;
                VirtualFile virtualFile = it2.getVirtualFile();
                if (!FileUtil.pathsEqual((String)(virtualFile != null ? virtualFile.getPath() : null), (String)testStepDurationInfo.getFilePath())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Inlay addedInlay;
                RangeMarker rangeMarker;
                Editor editor = (Editor)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)lineMarkerFactory.createRangeMarker(editor.getVirtualFile(), testStepDurationInfo.getLine() - 1, testStepDurationInfo.getColumn(), false), (String)"createRangeMarker(...)");
                int lineOffset = rangeMarker.getStartOffset();
                if (editor.getInlayModel().addAfterLineEndElement(lineOffset, true, (EditorCustomElementRenderer)new TestStepDurationRenderer((String)inlayText)) == null) continue;
                boolean bl2 = false;
                Disposer.register((Disposable)((Disposable)this.fileInlaysLifetime), (Disposable)((Disposable)addedInlay));
                ConcurrentMap<Editor, Map<Integer, Inlay<TestStepDurationRenderer>>> $this$getOrPut$iv = this.addedInlays;
                boolean $i$f$getOrPut = false;
                Object object2 = $this$getOrPut$iv.get(editor);
                if (object2 == null) {
                    boolean bl3 = false;
                    Map default$iv = new LinkedHashMap();
                    boolean bl4 = false;
                    object2 = $this$getOrPut$iv.putIfAbsent(editor, default$iv);
                    if (object2 == null) {
                        object2 = default$iv;
                    }
                }
                Intrinsics.checkNotNullExpressionValue(object2, (String)"getOrPut(...)");
                Map editorInlays = (Map)object2;
                if ((Inlay)editorInlays.remove(testStepDurationInfo.getLine()) != null) {
                    Inlay it3;
                    boolean bl5 = false;
                    Disposer.dispose((Disposable)((Disposable)it3));
                }
                Integer n = testStepDurationInfo.getLine();
                Intrinsics.checkNotNull((Object)addedInlay);
                editorInlays.put(n, addedInlay);
            }
        }

        public void dispose() {
            Disposer.dispose((Disposable)((Disposable)this.fileInlaysLifetime));
        }

        private static final void _init_$lambda$0(FileInlays this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.addedInlays.clear();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u0005\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$FileRenameAndRemoveHandler;", "Lcom/intellij/openapi/vfs/AsyncFileListener;", "(Lcom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService;)V", "prepareChange", "Lcom/intellij/openapi/vfs/AsyncFileListener$ChangeApplier;", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "intellij.aqua.runners.playwright.js"})
    @SourceDebugExtension(value={"SMAP\nTestDurationInlayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestDurationInlayService.kt\ncom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$FileRenameAndRemoveHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,132:1\n1855#2,2:133\n*S KotlinDebug\n*F\n+ 1 TestDurationInlayService.kt\ncom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$FileRenameAndRemoveHandler\n*L\n65#1:133,2\n*E\n"})
    private final class FileRenameAndRemoveHandler
    implements AsyncFileListener {
        /*
         * WARNING - void declaration
         */
        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull List<? extends VFileEvent> events) {
            void $this$forEach$iv;
            Intrinsics.checkNotNullParameter(events, (String)"events");
            Iterable iterable = events;
            TestDurationInlayService testDurationInlayService = TestDurationInlayService.this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VFileEvent it = (VFileEvent)element$iv;
                boolean bl = false;
                VFileEvent vFileEvent = it;
                if (vFileEvent instanceof VFilePropertyChangeEvent) {
                    if (!((VFilePropertyChangeEvent)it).isRename()) continue;
                    String string = ((VFilePropertyChangeEvent)it).getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    testDurationInlayService.removeInlaysForTestFile(string);
                    continue;
                }
                if (!(vFileEvent instanceof VFileDeleteEvent ? true : vFileEvent instanceof VFileMoveEvent)) continue;
                String string = it.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                testDurationInlayService.removeInlaysForTestFile(string);
            }
            return null;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0096@\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$TestDurationInlayServiceFileListenerInstaller;", "Lcom/intellij/openapi/startup/ProjectActivity;", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.aqua.runners.playwright.js"})
    @SourceDebugExtension(value={"SMAP\nTestDurationInlayService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TestDurationInlayService.kt\ncom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$TestDurationInlayServiceFileListenerInstaller\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,132:1\n31#2,2:133\n*S KotlinDebug\n*F\n+ 1 TestDurationInlayService.kt\ncom/intellij/aqua/runners/playwright/js/duration/TestDurationInlayService$TestDurationInlayServiceFileListenerInstaller\n*L\n80#1:133,2\n*E\n"})
    public static final class TestDurationInlayServiceFileListenerInstaller
    implements ProjectActivity {
        @Nullable
        public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<TestDurationInlayService> serviceClass$iv = TestDurationInlayService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            TestDurationInlayService testDurationInlayService = (TestDurationInlayService)object;
            VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)testDurationInlayService.new FileRenameAndRemoveHandler(), testDurationInlayService.lifetime);
            return Unit.INSTANCE;
        }
    }
}

