/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.StandardDiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;

public class ShowDiffWithLocalFromTableHistoryAction
implements AnActionExtensionProvider {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowDiffWithLocalFromTableHistoryAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffWithLocalFromTableHistoryAction.$$$reportNull$$$0(1);
        }
        return e.getData(VcsDataKeys.HISTORY_SESSION) != null;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffWithLocalFromTableHistoryAction.$$$reportNull$$$0(2);
        }
        VcsFileRevision[] selectedRevisions = (VcsFileRevision[])e.getData(VcsDataKeys.VCS_FILE_REVISIONS);
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        VcsHistorySession historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION);
        e.getPresentation().setVisible(true);
        e.getPresentation().setEnabled(selectedRevisions != null && selectedRevisions.length == 1 && virtualFile != null && historySession != null && historySession.getCurrentRevisionNumber() != null && historySession.isContentAvailable(selectedRevisions[0]) && e.getData(VcsDataKeys.FILE_PATH) != null && e.getData(VcsDataKeys.HISTORY_PROVIDER) != null && e.getData(CommonDataKeys.PROJECT) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            ShowDiffWithLocalFromTableHistoryAction.$$$reportNull$$$0(3);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            return;
        }
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        VcsHistorySession historySession = (VcsHistorySession)e.getData(VcsDataKeys.HISTORY_SESSION);
        if (historySession == null) {
            return;
        }
        VcsRevisionNumber currentRevisionNumber = historySession.getCurrentRevisionNumber();
        VcsFileRevision[] fileRevisions = (VcsFileRevision[])e.getData(VcsDataKeys.VCS_FILE_REVISIONS);
        if (fileRevisions == null) {
            return;
        }
        VcsFileRevision selectedRevision = fileRevisions[0];
        FilePath filePath = (FilePath)e.getData(VcsDataKeys.FILE_PATH);
        if (filePath == null) {
            return;
        }
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        if (currentRevisionNumber != null && selectedRevision != null) {
            DiffFromHistoryHandler diffHandler = (DiffFromHistoryHandler)ObjectUtils.notNull((Object)((VcsHistoryProvider)e.getRequiredData(VcsDataKeys.HISTORY_PROVIDER)).getHistoryDiffHandler(), (Object)new StandardDiffFromHistoryHandler());
            diffHandler.showDiffForTwo(project, filePath, selectedRevision, (VcsFileRevision)new CurrentRevision(virtualFile, currentRevisionNumber));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/actions/ShowDiffWithLocalFromTableHistoryAction";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/actions/ShowDiffWithLocalFromTableHistoryAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

