/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.DiffContentFactoryEx;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.DiffRequestProducerException;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.patch.BaseRevisionTextPatchEP;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.PlainSimplePatchApplier;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.patch.tool.PatchDiffRequest;
import com.intellij.openapi.vcs.changes.shelf.DiffShelvedChangesActionProvider;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryFile;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChange;
import com.intellij.openapi.vcs.changes.shelf.ShelvedWrapper;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelvedWrapperDiffRequestProducer
implements DiffRequestProducer,
ChangeDiffRequestChain.Producer {
    private final Project myProject;
    private final ShelvedWrapper myChange;

    public ShelvedWrapperDiffRequestProducer(@NotNull Project project, @NotNull ShelvedWrapper change) {
        if (project == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(0);
        }
        if (change == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myChange = change;
    }

    @NotNull
    public ShelvedWrapper getWrapper() {
        ShelvedWrapper shelvedWrapper = this.myChange;
        if (shelvedWrapper == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(2);
        }
        return shelvedWrapper;
    }

    @Nls
    @NotNull
    public String getName() {
        String string = this.myChange.getRequestName();
        if (string == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(3);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShelvedWrapperDiffRequestProducer producer = (ShelvedWrapperDiffRequestProducer)o;
        return Objects.equals(this.myChange, producer.myChange);
    }

    public int hashCode() {
        return Objects.hash(this.myChange);
    }

    @NotNull
    public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) throws DiffRequestProducerException, ProcessCanceledException {
        if (context == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(4);
        }
        if (indicator == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(5);
        }
        String title2 = this.myChange.getRequestName();
        try {
            ShelvedChange shelvedChange = this.myChange.getShelvedChange();
            if (shelvedChange != null) {
                return this.createTextShelveRequest(shelvedChange, context, title2);
            }
            ShelvedBinaryFile binaryFile = this.myChange.getBinaryFile();
            if (binaryFile != null) {
                return this.createBinaryShelveRequest(binaryFile, title2);
            }
            throw new IllegalStateException("Empty shelved wrapper: " + this.myChange);
        }
        catch (VcsException | IOException e) {
            throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.can.t.show.diff.for", (Object[])new Object[]{title2}), e);
        }
    }

    @NotNull
    private DiffRequest createTextShelveRequest(@NotNull ShelvedChange shelvedChange, @NotNull UserDataHolder context, @Nullable @Nls String title2) throws VcsException {
        String patchedContent;
        if (shelvedChange == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(6);
        }
        if (context == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(7);
        }
        DiffContentFactoryEx factory = DiffContentFactoryEx.getInstanceEx();
        DiffShelvedChangesActionProvider.PatchesPreloader preloader = DiffShelvedChangesActionProvider.PatchesPreloader.getPatchesPreloader(this.myProject, context);
        Pair<TextFilePatch, CommitContext> pair = preloader.getPatchWithContext(shelvedChange);
        TextFilePatch patch = (TextFilePatch)pair.first;
        CommitContext commitContext = (CommitContext)pair.second;
        FilePath contextFilePath = ShelvedWrapperDiffRequestProducer.getContextFilePath(shelvedChange);
        String leftTitle = DiffBundle.message((String)"merge.version.title.base", (Object[])new Object[0]);
        String rightTitle = VcsBundle.message((String)"shelve.shelved.version", (Object[])new Object[0]);
        if (patch.isDeletedFile() || patch.isNewFile()) {
            DocumentContent shelfContent = factory.create(this.myProject, patch.getSingleHunkPatchText(), contextFilePath);
            EmptyContent emptyContent = factory.createEmpty();
            DocumentContent leftContent = patch.isDeletedFile() ? shelfContent : emptyContent;
            DocumentContent rightContent = !patch.isDeletedFile() ? shelfContent : emptyContent;
            return new SimpleDiffRequest(title2, (DiffContent)leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
        }
        String path2 = (String)ObjectUtils.chooseNotNull((Object)patch.getAfterName(), (Object)patch.getBeforeName());
        String baseContents = BaseRevisionTextPatchEP.getBaseContent(this.myProject, path2, commitContext);
        if (baseContents != null && (patchedContent = PlainSimplePatchApplier.apply(baseContents, patch.getHunks())) != null) {
            DocumentContent leftContent = factory.create(this.myProject, baseContents.toString(), contextFilePath);
            DocumentContent rightContent = factory.create(this.myProject, patchedContent, contextFilePath);
            return new SimpleDiffRequest(title2, (DiffContent)leftContent, (DiffContent)rightContent, leftTitle, rightTitle);
        }
        return new PatchDiffRequest(patch, title2, leftTitle, rightTitle);
    }

    @Override
    @NotNull
    public FilePath getFilePath() {
        FilePath filePath = this.myChange.getFilePath();
        if (filePath == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(8);
        }
        return filePath;
    }

    @Override
    @NotNull
    public FileStatus getFileStatus() {
        FileStatus fileStatus = this.myChange.getFileStatus();
        if (fileStatus == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(9);
        }
        return fileStatus;
    }

    @NotNull
    private static FilePath getContextFilePath(@NotNull ShelvedChange shelvedChange) {
        Change change;
        if (shelvedChange == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(10);
        }
        if ((change = shelvedChange.getChange()).getType() == Change.Type.MOVED) {
            FilePath bPath = Objects.requireNonNull(ChangesUtil.getBeforePath((Change)change));
            FilePath aPath = Objects.requireNonNull(ChangesUtil.getAfterPath((Change)change));
            if (bPath.getVirtualFile() != null) {
                FilePath filePath = bPath;
                if (filePath == null) {
                    ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(11);
                }
                return filePath;
            }
            if (aPath.getVirtualFile() != null) {
                FilePath filePath = aPath;
                if (filePath == null) {
                    ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(12);
                }
                return filePath;
            }
            FilePath filePath = bPath;
            if (filePath == null) {
                ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(13);
            }
            return filePath;
        }
        FilePath filePath = ChangesUtil.getFilePath((Change)change);
        if (filePath == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(14);
        }
        return filePath;
    }

    @NotNull
    private SimpleDiffRequest createBinaryShelveRequest(@NotNull ShelvedBinaryFile binaryFile, @Nullable @Nls String title2) throws DiffRequestProducerException, VcsException, IOException {
        if (binaryFile == null) {
            ShelvedWrapperDiffRequestProducer.$$$reportNull$$$0(15);
        }
        DiffContentFactory factory = DiffContentFactory.getInstance();
        if (binaryFile.AFTER_PATH == null) {
            throw new DiffRequestProducerException(VcsBundle.message((String)"changes.error.content.for.0.was.removed", (Object[])new Object[]{title2}));
        }
        byte[] binaryContent = binaryFile.createBinaryContentRevision(this.myProject).getBinaryContent();
        FilePath filePath = VcsUtil.getFilePath((String)binaryFile.SHELVED_PATH, (boolean)false);
        DiffContent shelfContent = factory.createFromBytes(this.myProject, binaryContent, filePath);
        return new SimpleDiffRequest(title2, (DiffContent)factory.createEmpty(), shelfContent, null, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 8, 9, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapperDiffRequestProducer";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shelvedChange";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedWrapperDiffRequestProducer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrapper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilePath";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileStatus";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getContextFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createTextShelveRequest";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getContextFilePath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryShelveRequest";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 8, 9, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }
}

