/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.shelf;

import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentBinaryContentRevision;
import com.intellij.openapi.vcs.changes.TextRevisionNumber;
import com.intellij.openapi.vcs.changes.shelf.ShelvedBinaryContentRevision;
import com.intellij.openapi.vcs.changes.shelf.ShelvedChangeList;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ShelvedBinaryFile {
    private static final String BEFORE_PATH_FIELD_NAME = "BEFORE_PATH";
    private static final String AFTER_PATH_FIELD_NAME = "AFTER_PATH";
    private static final String SHELVED_PATH_FIELD_NAME = "SHELVED_PATH";
    public final String BEFORE_PATH;
    public final String AFTER_PATH;
    @Nullable
    public final String SHELVED_PATH;
    private Change myChange;

    public ShelvedBinaryFile(String beforePath, String afterPath, @Nullable String shelvedPath) {
        assert (beforePath != null || afterPath != null);
        this.BEFORE_PATH = ShelvedBinaryFile.convertToSystemIndependent(beforePath);
        this.AFTER_PATH = ShelvedBinaryFile.convertToSystemIndependent(afterPath);
        this.SHELVED_PATH = ShelvedBinaryFile.convertToSystemIndependent(shelvedPath);
    }

    @Nullable
    private static String convertToSystemIndependent(@Nullable String beforePath) {
        return beforePath != null ? FileUtil.toSystemIndependentName((String)beforePath) : null;
    }

    @NotNull
    public static ShelvedBinaryFile readExternal(@NotNull Element element, @NotNull PathMacroSubstitutor pathMacroSubstitutor) {
        if (element == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(0);
        }
        if (pathMacroSubstitutor == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(1);
        }
        String beforePath = null;
        String afterPath = null;
        String shelvedPath = null;
        for (Map.Entry<String, String> field : ShelvedChangeList.readFields(element).entrySet()) {
            String value = pathMacroSubstitutor.expandPath(Objects.requireNonNull(field.getValue()));
            if (field.getKey().equals(BEFORE_PATH_FIELD_NAME)) {
                beforePath = value;
                continue;
            }
            if (field.getKey().equals(AFTER_PATH_FIELD_NAME)) {
                afterPath = value;
                continue;
            }
            if (!field.getKey().equals(SHELVED_PATH_FIELD_NAME)) continue;
            shelvedPath = value;
        }
        return new ShelvedBinaryFile(beforePath, afterPath, shelvedPath);
    }

    public void writeExternal(@NotNull Element element, @Nullable PathMacroSubstitutor pathMacroSubstitutor) {
        if (element == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(2);
        }
        ShelvedChangeList.writeField(element, BEFORE_PATH_FIELD_NAME, ShelvedChangeList.collapsePath(this.BEFORE_PATH, pathMacroSubstitutor));
        ShelvedChangeList.writeField(element, AFTER_PATH_FIELD_NAME, ShelvedChangeList.collapsePath(this.AFTER_PATH, pathMacroSubstitutor));
        ShelvedChangeList.writeField(element, SHELVED_PATH_FIELD_NAME, ShelvedChangeList.collapsePath(this.SHELVED_PATH, pathMacroSubstitutor));
    }

    public FileStatus getFileStatus() {
        if (this.BEFORE_PATH == null) {
            return FileStatus.ADDED;
        }
        if (this.SHELVED_PATH == null) {
            return FileStatus.DELETED;
        }
        return FileStatus.MODIFIED;
    }

    @NotNull
    public Change createChange(@NotNull Project project) {
        if (project == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(3);
        }
        if (this.myChange == null) {
            CurrentBinaryContentRevision before = null;
            ShelvedBinaryContentRevision after = null;
            File baseDir = new File(project.getBaseDir().getPath());
            if (this.BEFORE_PATH != null) {
                FilePath file = VcsUtil.getFilePath((File)new File(baseDir, this.BEFORE_PATH), (boolean)false);
                before = new CurrentBinaryContentRevision(file){

                    public byte @Nullable [] getBinaryContent() throws VcsException {
                        return (byte[])ObjectUtils.chooseNotNull((Object)super.getBinaryContent(), (Object)ArrayUtil.EMPTY_BYTE_ARRAY);
                    }

                    @NotNull
                    public VcsRevisionNumber getRevisionNumber() {
                        return new TextRevisionNumber(VcsBundle.message((String)"local.version.title", (Object[])new Object[0]));
                    }
                };
            }
            if (this.AFTER_PATH != null) {
                after = this.createBinaryContentRevision(project);
            }
            this.myChange = new Change(before, (ContentRevision)after);
        }
        Change change = this.myChange;
        if (change == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(4);
        }
        return change;
    }

    @NotNull
    ShelvedBinaryContentRevision createBinaryContentRevision(@NotNull Project project) {
        if (project == null) {
            ShelvedBinaryFile.$$$reportNull$$$0(5);
        }
        FilePath file = VcsUtil.getFilePath((File)new File(project.getBasePath(), this.AFTER_PATH), (boolean)false);
        return new ShelvedBinaryContentRevision(file, this.SHELVED_PATH);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShelvedBinaryFile that = (ShelvedBinaryFile)o;
        if (!Objects.equals(this.AFTER_PATH, that.AFTER_PATH)) {
            return false;
        }
        if (!Objects.equals(this.BEFORE_PATH, that.BEFORE_PATH)) {
            return false;
        }
        return Objects.equals(this.SHELVED_PATH, that.SHELVED_PATH);
    }

    public int hashCode() {
        int result2 = this.BEFORE_PATH != null ? this.BEFORE_PATH.hashCode() : 0;
        result2 = 31 * result2 + (this.AFTER_PATH != null ? this.AFTER_PATH.hashCode() : 0);
        result2 = 31 * result2 + (this.SHELVED_PATH != null ? this.SHELVED_PATH.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return FileUtil.toSystemDependentName((String)(this.BEFORE_PATH == null ? this.AFTER_PATH : this.BEFORE_PATH));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMacroSubstitutor";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/shelf/ShelvedBinaryFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createChange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readExternal";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "writeExternal";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createChange";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createBinaryContentRevision";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

