/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.hardcodedPasswords.checkers;

import com.intellij.hardcodedPasswords.checkers.PasswordChecker;
import com.intellij.hardcodedPasswords.result.BaseResult;
import com.intellij.hardcodedPasswords.result.RuleResult;
import com.intellij.hardcodedPasswords.rules.Rules;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0016\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bJ$\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0018\u0010\u000f\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/hardcodedPasswords/checkers/RuleChecker;", "Lcom/intellij/hardcodedPasswords/checkers/PasswordChecker;", "Lcom/intellij/hardcodedPasswords/result/RuleResult;", "()V", "rules", "Lcom/intellij/hardcodedPasswords/rules/Rules;", "check", "string", "", "checkWithVariable", "variable", "value", "matchRule", "", "Lkotlin/text/Regex;", "matchRuleWithVariable", "intellij.hardcodedPasswords"})
public final class RuleChecker
implements PasswordChecker<RuleResult> {
    @NotNull
    private final Rules rules = new Rules();

    @Override
    @NotNull
    public RuleResult check(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return this.matchRule(string, this.rules.getRules());
    }

    @NotNull
    public final RuleResult checkWithVariable(@NotNull String variable, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        RuleResult result = this.matchRuleWithVariable(variable, value);
        return result.isFalse() ? this.check(value) : result;
    }

    private final RuleResult matchRuleWithVariable(String variable, String value) {
        String assignment = variable + " = " + value;
        RuleResult result = this.matchRule(assignment, this.rules.getRulesWithVariable());
        if (result.isTrue()) {
            return result;
        }
        RuleResult nonSpecificVariableResult = this.matchRule(assignment, this.rules.getRulesWithoutSpecificVariable());
        return new RuleResult(nonSpecificVariableResult.getResult(), nonSpecificVariableResult.getInfo(), false, 4, null);
    }

    private final RuleResult matchRule(String string, Map<String, Regex> rules2) {
        for (Map.Entry<String, Regex> entry : rules2.entrySet()) {
            String k = entry.getKey();
            Regex v = entry.getValue();
            if (!v.containsMatchIn((CharSequence)string)) continue;
            return new RuleResult(true, k, true);
        }
        return BaseResult.Companion.getEMPTY_RULE_RESULT();
    }
}

